/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.controls.VerticalFlowLayout;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.panels.MDDAdapter;
import oracle.ide.panels.MDDEvent;
import oracle.ide.panels.MDDListener;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.NodeTDialogLauncher;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.SwingUtils;
import oracle.jdevimpl.xml.CreateSupport;
import oracle.jdevimpl.xml.DeleteSupport;
import oracle.jdevimpl.xml.ReorderSupport;
import oracle.jdevimpl.xml.XmlArb;

public abstract class ModalEditor {
    private final Object _data;
    private final boolean _isCopyable;
    private final boolean _showNewDeleteButtons;
    private final boolean _showUpDownButtons;

    public ModalEditor(Object data) {
        this(data, false, false);
    }

    public ModalEditor(Copyable data) {
        this(data, false, false);
    }

    public ModalEditor(Object data, boolean showNewDeleteButtons, boolean showUpDownButtons) {
        this(data, false, showNewDeleteButtons, showUpDownButtons);
    }

    public ModalEditor(Copyable data, boolean showNewDeleteButtons, boolean showUpDownButtons) {
        this(data, true, showNewDeleteButtons, showUpDownButtons);
    }

    private ModalEditor(Object data, boolean isCopyable, boolean showNewDeleteButtons, boolean showUpDownButtons) {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        this._data = data;
        this._isCopyable = isCopyable;
        this._showNewDeleteButtons = showNewDeleteButtons;
        this._showUpDownButtons = showUpDownButtons;
    }

    public boolean showDialog() {
        return this.showDialog(SwingUtils.getMainWindow());
    }

    public boolean showDialog(Component parent) {
        return this.showDialog(parent, null);
    }

    public boolean showDialog(Component parent, String[] path) {
        String title = this.getTitle();
        MDDPanel mddPanel = this.createMDDPanel();
        Namespace namespace = new Namespace();
        String key = this.getDataKey();
        Object dataCopy = this._isCopyable ? (this._data != null ? ((Copyable)this._data).copyTo(null) : null) : this._data;
        namespace.put(key, dataCopy);
        this.scatterData(namespace);
        NodeTDialogLauncher launcher = new NodeTDialogLauncher(parent, title, (Traversable)mddPanel, namespace, null, this.getSources(namespace));
        if (path != null) {
            mddPanel.setTree1SelectionPath(path);
        }
        this.initMDDPanel(mddPanel);
        this.initNDRButtons(mddPanel);
        this.initLauncher((TDialogLauncher)launcher);
        boolean isOkResponse = launcher.showDialog();
        if (isOkResponse) {
            this.gatherData(namespace);
            this.committingChanges(namespace);
            Object editedCopy = namespace.get(key);
            if (this._isCopyable && ModelUtil.areDifferent((Object)this._data, (Object)editedCopy)) {
                ((Copyable)editedCopy).copyTo(this._data);
                if (this._data instanceof Dirtyable) {
                    ((Dirtyable)this._data).markDirty(true);
                }
                if (this._data instanceof Subject) {
                    UpdateMessage.fireStructureChanged((Subject)((Subject)this._data));
                }
            }
            return true;
        }
        return false;
    }

    protected static Navigable setHelpID(String helpID, Navigable nav) {
        nav.setHelpID(helpID);
        return nav;
    }

    protected MDDPanel createMDDPanel() {
        return new MDDPanel(this.getNavigables(), this.isUseDetailTree());
    }

    protected abstract String getTitle();

    protected abstract Navigable[] getNavigables();

    protected boolean isUseDetailTree() {
        return false;
    }

    protected boolean isShowNewDeleteButtons() {
        return this._showNewDeleteButtons;
    }

    protected boolean isShowUpDownButtons() {
        return this._showUpDownButtons;
    }

    protected Object getData() {
        return this._data;
    }

    protected abstract String getDataKey();

    protected void scatterData(Namespace ns) {
    }

    protected void gatherData(Namespace ns) {
    }

    protected int getInitialTreeExpansionDepth() {
        return 3;
    }

    protected void initMDDPanel(MDDPanel mddPanel) {
        int depth = this.getInitialTreeExpansionDepth();
        if (depth > 0) {
            mddPanel.expandTree1ToDepth(depth);
        }
    }

    protected void initLauncher(TDialogLauncher launcher) {
        launcher.setInitialSize(700, 500);
    }

    protected void committingChanges(Namespace ns) {
    }

    protected Node[] getSources(Namespace namespace) {
        return null;
    }

    private static JComponent createPanel(String mddPos, boolean transpose, boolean pad) {
        boolean horiz = "North".equals(mddPos) || "South".equals(mddPos);
        int hgap = pad ? 5 : 0;
        int vgap = pad ? 5 : 0;
        FlowLayout layout = horiz ^ transpose ? new FlowLayout(1, hgap, vgap) : new VerticalFlowLayout(1, hgap, vgap, true, false);
        JPanel panel = new JPanel();
        panel.setLayout(layout);
        return panel;
    }

    private void initNDRButtons(MDDPanel mddPanel) {
        MDDAdapter listener;
        JComponent panel;
        String NEW_DEL_BUTTONS = "South";
        String UP_DOWN_BUTTONS = "East";
        String newDelVsUpDown = "West";
        boolean transpose = false;
        int buttonCount = 0;
        JComponent upDownPanel = null;
        JComponent newDeletePanel = null;
        if (this.isShowUpDownButtons()) {
            upDownPanel = panel = ModalEditor.createPanel("East", false, true);
            listener = this.initUpDownButtons(panel);
            mddPanel.addMDDListener((MDDListener)listener);
            ++buttonCount;
        }
        if (this.isShowNewDeleteButtons()) {
            newDeletePanel = panel = ModalEditor.createPanel("South", false, true);
            listener = this.initNewDeleteButtons(panel);
            mddPanel.addMDDListener((MDDListener)listener);
            ++buttonCount;
        }
        if (buttonCount == 2) {
            // empty if block
        }
        if (upDownPanel != null) {
            mddPanel.addTreePanelComponent((Component)upDownPanel, (Object)"East");
        }
        if (newDeletePanel != null) {
            mddPanel.addTreePanelComponent((Component)newDeletePanel, (Object)"South");
        }
    }

    private MDDAdapter initUpDownButtons(JComponent panel) {
        final JButton btnUp = ModalEditor.createButton(OracleIcons.getIcon((String)"up.png"), XmlArb.getString(2));
        final JButton btnDown = ModalEditor.createButton(OracleIcons.getIcon((String)"down.png"), XmlArb.getString(3));
        panel.add(btnUp);
        panel.add(btnDown);
        class L
        extends MDDAdapter
        implements ActionListener {
            private transient TraversableContext _curTC;
            private transient Traversable _curTrav;

            L() {
            }

            public void traversableEntered(MDDEvent e) {
                this._curTC = e.getTraversableContext();
                this._curTrav = e.getTraversable();
                DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)this._curTC.getDesignTimeObject("MDDPanel.CURRENT_TREE1_NODE");
                TreeNode parentNode = curNode.getParent();
                int index = parentNode.getIndex(curNode);
                int maxIndex = parentNode.getChildCount() - 1;
                btnUp.setEnabled(index > 0 && index <= maxIndex && this._curTrav instanceof ReorderSupport);
                btnDown.setEnabled(index >= 0 && index < maxIndex && this._curTrav instanceof ReorderSupport);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source == btnUp) {
                    ((ReorderSupport)this._curTrav).moveUp(this._curTC);
                } else if (source == btnDown) {
                    ((ReorderSupport)this._curTrav).moveDown(this._curTC);
                }
            }
        }
        L l = new L();
        btnUp.addActionListener(l);
        btnDown.addActionListener(l);
        return l;
    }

    private MDDAdapter initNewDeleteButtons(JComponent panel) {
        final JButton btnNew = ModalEditor.createButton(XmlArb.getString(4));
        final JButton btnDelete = ModalEditor.createButton(XmlArb.getString(5));
        panel.add(btnNew);
        panel.add(btnDelete);
        class L
        extends MDDAdapter
        implements ActionListener {
            private transient TraversableContext _curTC;
            private transient Traversable _curTrav;

            L() {
            }

            public void traversableEntered(MDDEvent e) {
                this._curTC = e.getTraversableContext();
                this._curTrav = e.getTraversable();
                btnNew.setEnabled(this._curTrav instanceof CreateSupport);
                btnDelete.setEnabled(this._curTrav instanceof DeleteSupport);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source == btnNew) {
                    ((CreateSupport)this._curTrav).create(this._curTC);
                } else if (source == btnDelete) {
                    ((DeleteSupport)this._curTrav).delete(this._curTC);
                }
            }
        }
        L l = new L();
        btnNew.addActionListener(l);
        btnDelete.addActionListener(l);
        return l;
    }

    private static JButton createButton(String label) {
        JButton button = new JButton();
        ResourceUtils.resButton((AbstractButton)button, (String)label);
        button.setEnabled(false);
        return button;
    }

    private static JButton createButton(Icon icon, String accessibleLabel) {
        JButton button = new JButton();
        button.setIcon(icon);
        button.getAccessibleContext().setAccessibleName(accessibleLabel);
        button.setEnabled(false);
        button.setMargin(new Insets(2, 0, 2, 0));
        return button;
    }
}

