/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.xml.bind.ElementList;
import oracle.javatools.xml.bind.ElementListEvent;
import oracle.javatools.xml.bind.ElementListListener;
import oracle.jdeveloper.deploy.res.DeployArb;
import oracle.jdevimpl.deploy.common.UpdateListModel;
import oracle.jdevimpl.deploy.res.J2eeArb;
import oracle.jdevimpl.xml.ElementListPanel;
import oracle.jdevimpl.xml.XmlArb;

public abstract class MasterPanel
extends ElementListPanel {
    public static final String MASTER_LIST = "MasterPanel.masterList";
    private final L _listener = new L();
    private final UpdateListModel _listModel = new UpdateListModel();
    private final JLabel _lblList = new JLabel();
    private final JScrollPane _spMaster = new JScrollPane();
    private final JList _listMaster = new JList(this._listModel);
    private final JButton _btnAdd = new JButton();
    private final JButton _btnDelete = new JButton();
    private final boolean _showUpDownButtons;
    private final JButton _btnMoveUp;
    private final JButton _btnMoveDown;
    private final Traversable _detailPanel;
    private transient ListModelImpl _listModelImpl;
    transient int _curIndex = -1;
    protected transient Object _curData;

    protected MasterPanel(String listLabelText, String helpID) {
        this(listLabelText, helpID, false);
    }

    protected MasterPanel(String listLabelText, String helpID, boolean showUpDownButtons) {
        this._showUpDownButtons = showUpDownButtons;
        ResourceUtils.resLabel((JLabel)this._lblList, (Component)this._listMaster, (String)listLabelText);
        Dimension minDim = new Dimension(10, 10);
        this._listMaster.setMinimumSize(minDim);
        this._listMaster.setSelectionMode(0);
        this._listMaster.addListSelectionListener(this._listener);
        this._listMaster.setCellRenderer(this._listener);
        this._spMaster.setMinimumSize(minDim);
        this._spMaster.setPreferredSize(minDim);
        this._spMaster.getViewport().add((Component)this._listMaster, null);
        this.initButton(this._btnAdd, this.getAddButtonLabel());
        this.initButton(this._btnDelete, this.getDeleteButtonLabel());
        if (this._showUpDownButtons) {
            this._btnMoveUp = new JButton();
            this._btnMoveDown = new JButton();
            this.initButton(this._btnMoveUp, J2eeArb.getString(55));
            this.initButton(this._btnMoveDown, J2eeArb.getString(56));
        } else {
            this._btnMoveUp = null;
            this._btnMoveDown = null;
        }
        this._detailPanel = this.newDetailPanel();
        this.layoutComponents(0, 0);
        this.setHelpID(helpID);
    }

    protected void layoutComponents(int x, int y) {
        Insets lblInsets = new Insets(5, 5, 3, 0);
        Insets spInsets = new Insets(0, 5, 0, 5);
        Insets btnInsets = new Insets(3, 3, 5, 5);
        this.add(this._lblList, this.gbc(x + 0, y + 0, 1, 1, 0.0, 0.0, 18, 2, lblInsets));
        this.add(this._spMaster, this.gbc(x + 0, y + 1, 1, 10, 1.0, 1.0, 18, 1, spInsets));
        this.add(this._btnAdd, this.gbc(x + 1, y + 1, 1, 1, 0.0, 0.0, 18, 2, btnInsets));
        this.add(this._btnDelete, this.gbc(x + 1, y + 2, 1, 1, 0.0, 0.0, 18, 2, btnInsets));
        if (this._showUpDownButtons) {
            this.add(this._btnMoveUp, this.gbc(x + 1, y + 3, 1, 1, 0.0, 0.0, 18, 2, btnInsets));
            this.add(this._btnMoveDown, this.gbc(x + 1, y + 4, 1, 1, 0.0, 0.0, 18, 2, btnInsets));
        }
        if (this._detailPanel != null) {
            Component comp = this._detailPanel.getComponent();
            if (this.isDetailBorderDrawn() && comp instanceof JComponent) {
                ((JComponent)comp).setBorder(BorderFactory.createEtchedBorder());
            }
            this.add(comp, this.gbc(x + 0, y + 11, 2, 1, 0.0, 0.0, 18, 1, lblInsets));
        }
    }

    private void initButton(JButton button, String label) {
        ResourceUtils.resButton((AbstractButton)button, (String)label);
        button.addActionListener(this._listener);
    }

    protected String getAddButtonLabel() {
        return DeployArb.getString(43);
    }

    protected String getDeleteButtonLabel() {
        return DeployArb.getString(45);
    }

    public void setEnabled(boolean enable) {
        if (enable) {
            boolean bl = enable = !this.isReadOnly();
        }
        if (this._listMaster != null) {
            this._listMaster.removeAll();
            this._listMaster.setEnabled(enable);
        }
        if (this._btnAdd != null) {
            this._btnAdd.setEnabled(enable);
        }
        if (this._btnDelete != null) {
            this._btnDelete.setEnabled(enable);
        }
        if (this._btnMoveUp != null) {
            this._btnMoveUp.setEnabled(enable);
        }
        if (this._btnMoveDown != null) {
            this._btnMoveDown.setEnabled(enable);
        }
        super.setEnabled(enable);
    }

    @Override
    public final void onEntry(TraversableContext tc) {
        super.onEntry(tc);
        this.onEntryImpl(tc);
        this._curIndex = -1;
        this._curData = this.getSelectedMasterValue();
        this.enterDetailPanel(tc);
    }

    protected abstract void onEntryImpl(TraversableContext var1);

    @Override
    public final void onExit(TraversableContext tc) throws TraversalException {
        super.onExit(tc);
        this.exitDetailPanel(tc);
        this.onExitImpl(tc);
    }

    protected void onExitImpl(TraversableContext tc) throws TraversalException {
    }

    public String getHelpID() {
        String helpID;
        if (this._detailPanel != null && (helpID = this._detailPanel.getHelpID()) != null) {
            return helpID;
        }
        return super.getHelpID();
    }

    @Override
    protected ElementListListener newElementListListener() {
        this._listModelImpl = new ListModelImpl();
        return this._listModelImpl;
    }

    @Override
    protected final int[] getSelectedIndexes() {
        return new int[]{this._listMaster.getSelectedIndex()};
    }

    @Override
    protected final void setSelectedIndexes(int[] indexes) {
        int highestIndex;
        if (indexes != null && indexes.length > 0 && (highestIndex = this.getElementList().size() - 1) >= 0) {
            int n = indexes.length;
            for (int i = 0; i < n; ++i) {
                indexes[i] = Math.min(indexes[i], highestIndex);
            }
            this._listMaster.setSelectedIndices(indexes);
        }
    }

    @Override
    protected final void setElementList(ElementList elementList) {
        super.setElementList(elementList);
        this.setAddButtonEnabled(this.getElementList() != null);
        this._listMaster.setModel(this._listModelImpl);
    }

    protected final int getElementListSize() {
        return this._listMaster.getModel().getSize();
    }

    @Override
    protected TraversableContext newTraversableContext(TraversableContext parent, Object data) {
        TraversableContext tc = super.newTraversableContext(parent, data);
        tc.putDesignTimeObject(MASTER_LIST, (Object)this._listMaster);
        return tc;
    }

    protected abstract Traversable newDetailPanel();

    protected abstract String getDisplayName(Object var1);

    protected boolean isDetailBorderDrawn() {
        return false;
    }

    protected final void clearSelectedMaster() {
        this._listMaster.clearSelection();
    }

    protected final void setSelectedMasterIndex(int index) {
        this._listMaster.setSelectedIndex(index);
    }

    protected final Object getSelectedMasterValue() {
        Object[] values = this._listMaster.getSelectedValues();
        return values.length == 1 ? values[0] : null;
    }

    protected void enterDetailPanel(TraversableContext tc) {
        if (this._detailPanel != null) {
            this._detailPanel.onEntry(this.newTraversableContext(tc, this._curData));
        }
        this.updateButtons();
    }

    protected void exitDetailPanel(TraversableContext tc) throws TraversalException {
        if (this._detailPanel != null && this._curData != null) {
            this._detailPanel.onExit(this.newTraversableContext(tc, this._curData));
        }
    }

    protected void setAddButtonEnabled(boolean enable) {
        this._btnAdd.setEnabled(enable && !this.isReadOnly());
    }

    protected void setDeleteButtonEnabled(boolean enable) {
        this._btnDelete.setEnabled(enable && !this.isReadOnly());
    }

    protected void setListFont(Font font) {
        this._listMaster.setFont(font);
    }

    private void updateButtons() {
        boolean nonNullSelection = this.getSelectedMasterValue() != null;
        this.setDeleteButtonEnabled(nonNullSelection);
        if (this._showUpDownButtons) {
            int[] indexes = this.getSelectedIndexes();
            if (indexes.length == 1) {
                int curIndex = indexes[0];
                this._btnMoveUp.setEnabled(nonNullSelection && curIndex > 0 && !this.isReadOnly());
                this._btnMoveDown.setEnabled(nonNullSelection && curIndex < this.getElementList().size() - 1 && !this.isReadOnly());
            } else {
                this._btnMoveUp.setEnabled(false);
                this._btnMoveDown.setEnabled(false);
            }
        }
    }

    private void loadNewDetails() {
        int selectedIndex;
        int[] indexes = this.getSelectedIndexes();
        int n = selectedIndex = indexes.length == 1 ? indexes[0] : -1;
        if (selectedIndex != this._curIndex) {
            try {
                TraversableContext tc = this.getTraversableContext();
                this.exitDetailPanel(tc);
                this._curIndex = selectedIndex;
                this._curData = this.getSelectedMasterValue();
                this.enterDetailPanel(tc);
            }
            catch (TraversalException ex) {
                ex.showMessageDialog((Component)((Object)this));
                this._listMaster.setSelectedValue(this._curData, true);
            }
        }
    }

    private void handleButtonEvent(Object button) {
        TraversableContext tc = this.getTraversableContext();
        if (button == this._btnAdd) {
            try {
                this.exitDetailPanel(tc);
                this.create(tc);
            }
            catch (TraversalException ex) {
                ex.showMessageDialog((Component)((Object)this));
            }
        } else if (button == this._btnDelete) {
            try {
                this.exitDetailPanel(tc);
                this.delete(tc);
            }
            catch (TraversalException ex) {
                ex.showMessageDialog((Component)((Object)this));
            }
        } else if (this._showUpDownButtons) {
            if (button == this._btnMoveUp) {
                this.moveUp(tc);
            } else if (button == this._btnMoveDown) {
                this.moveDown(tc);
            }
        }
    }

    private class L
    extends DefaultListCellRenderer
    implements ListSelectionListener,
    ActionListener {
        private L() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String displayName;
            String string = displayName = value != null ? MasterPanel.this.getDisplayName(value) : XmlArb.getString(0);
            if (!ModelUtil.hasLength((String)displayName)) {
                displayName = XmlArb.getString(1);
            }
            return super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            MasterPanel.this.loadNewDetails();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MasterPanel.this.handleButtonEvent(e.getSource());
        }
    }

    private class ListModelImpl
    extends AbstractListModel
    implements ElementListListener {
        private ListModelImpl() {
        }

        @Override
        public Object getElementAt(int i) {
            return MasterPanel.this.getElementList().get(i);
        }

        @Override
        public int getSize() {
            ElementList list = MasterPanel.this.getElementList();
            return list != null ? list.size() : 0;
        }

        public void elementsAdded(ElementListEvent e) {
            int start = e.getStartIndex();
            this.fireIntervalAdded(this, start, e.getEndIndex());
            MasterPanel.this._listMaster.setSelectedIndex(start);
        }

        public void elementsRemoved(ElementListEvent e) {
            this.fireIntervalRemoved(this, e.getStartIndex(), e.getEndIndex());
        }

        public void elementsChanged(ElementListEvent e) {
            this.fireContentsChanged(this, e.getStartIndex(), e.getEndIndex());
        }
    }
}

