/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.NewWorkspaceCommand;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.NewWorkspacePanel;
import oracle.ide.resource.GalleryArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.PatternFilters;
import oracle.ide.wizard.Wizard;
import oracle.ideri.importexport.ImportWizard;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.resource.WizardsArb;
import oracle.jdevimpl.wizard.project.ProjectWizardLauncher;

public class ProjFromSource
extends Wizard
implements ImportWizard,
Runnable {
    public static final String COPY_FILES_KEY = "copy-files";
    public static final String PROJECT_PANEL_KEYS = "ProjFromSource.project-panel-key";
    private static final int COPY_FILES = 0;
    private static final int DELETE_FILES = 1;
    private static final String IMPORT_WIZARD_PROPERTY = "oracle.jdevimpl.wizard.project.ProjFromSource.importWizard";
    private ProgressBar _progressBar;
    private URL _copyLocation;
    private boolean _fileCopyError;
    private int _runAction;
    private Project _project;
    private ContentSet _javaContentSet;
    private URLPath _sourcePaths;

    public String getShortLabel() {
        return GalleryArb.getString((int)45);
    }

    public String getLongLabel() {
        return GalleryArb.getString((int)46);
    }

    public boolean invoke(Context context) {
        this.init();
        boolean isImportWizard = context.containsProperty(IMPORT_WIZARD_PROPERTY);
        if (context.getWorkspace() == null) {
            NewWorkspacePanel workspacePanel = new NewWorkspacePanel(false, false, true);
            if (!workspacePanel.runDialog()) {
                return false;
            }
            URL workspaceURL = workspacePanel.getFileURL();
            try {
                Workspace workspace = NewWorkspaceCommand.createEmptyWorkspace((Context)context, (URL)workspaceURL);
                context.setWorkspace(workspace);
                Ide.setActiveWorkspace((Workspace)workspace);
            }
            catch (Exception e) {
                return false;
            }
        }
        ProjectWizardLauncher launcher = new ProjectWizardLauncher(context, isImportWizard ? WizardsArb.getString(17) : WizardsArb.getString(20));
        String welcomeLabel = isImportWizard ? WizardsArb.getString(19) : WizardsArb.getString(24);
        launcher.addWelcomePage(welcomeLabel, WizardsArb.getString(25), "oracle.jdevimpl.wizard.project.ProjFromSource", "f1_idewnewprojwsourcewelcome_html");
        launcher.addPage("oracle.jdevimpl.wizard.project.ProjectLocationPanel", "f1_idewnewprojwsourcelocation_html");
        launcher.addPage("oracle.jdevimpl.wizard.project.AddSourcePanel", "f1_idewnewprojwsourceaddsource_html");
        launcher.addPage("oracle.jdevimpl.wizard.project.ProjFromSourceLibraryPanel", "f1_idewnewprojwsourcerunsettings_html");
        launcher.addFinishPage("oracle.jdevimpl.wizard.project.ProjFromSourceFinishPanel", "f1_idewnewprojwsourcesummary_html", WizardsArb.getString(373));
        launcher.setShowStepNumber(true);
        Project tempProj = new Project();
        Project defProj = Ide.getDefaultProject();
        if (defProj != null) {
            defProj.copyTo((Object)tempProj);
        }
        PathsConfiguration.getInstance((Project)tempProj).setProjectSourcePath(null);
        Namespace ns = launcher.getNamespace();
        ns.put("Project", (Object)tempProj);
        HashStructure projPanelHash = tempProj.getProperties();
        ns.put("PropertyData", (Object)projPanelHash);
        JProjectLibraries projectLibraries = JProjectLibraries.getInstance(null);
        JProjectLibraries origLibraries = JProjectLibraries.getInstance((PropertyStorage)tempProj);
        origLibraries.copyTo((Object)projectLibraries);
        ns.put("oracle.jdevimpl.config.JProjectLibraries", (Object)projectLibraries);
        this._project = launcher.runWizard();
        if (this._project != null) {
            HashStructure wizardProjectHash = this._project.getProperties();
            String[] projPanelKeys = (String[])ns.get(PROJECT_PANEL_KEYS);
            if (projPanelKeys != null && projPanelHash != null) {
                projPanelHash.copyTo(wizardProjectHash, projPanelKeys);
            }
            JavaProject projectSettings = JavaProject.getInstance((Project)this._project);
            projectSettings.setRecentPackages(Collections.EMPTY_LIST);
            projectSettings.setMostRecentPackage(projectSettings.getDefaultPackage());
            Boolean copyFiles = (Boolean)ns.get(COPY_FILES_KEY);
            if (copyFiles.booleanValue()) {
                URL projectURL = (URL)ns.find("ProjectURL");
                String projectString = URLFileSystem.getPath((URL)projectURL);
                projectString = projectString.substring(0, projectString.lastIndexOf("/") + 1);
                this._copyLocation = URLFactory.newDirURL((String)(projectString + "src/"));
                PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance((Project)tempProj, (PropertyStorage)tempProj);
                this._javaContentSet = pathsConfiguration.getJavaContentSet();
                this._sourcePaths = new URLPath(this._javaContentSet.getURLPath());
                boolean userCancelled = this.copyFilesToProject();
                if (userCancelled) {
                    return false;
                }
                URL copyLocCanonicalized = URLFileSystem.canonicalize((URL)this._copyLocation);
                PathsConfiguration wizardProjPathConfig = PathsConfiguration.getInstance((Project)this._project, (PropertyStorage)this._project);
                ContentSet projectJavaContentSet = wizardProjPathConfig.getJavaContentSet();
                projectJavaContentSet.setContentFolderURL(copyLocCanonicalized);
                URLPath urlPath = projectJavaContentSet.getURLPath();
                urlPath.setEntries(new URL[]{copyLocCanonicalized});
                projectJavaContentSet.removeAllContentSets();
            } else {
                PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance((Project)tempProj, (PropertyStorage)tempProj);
                ContentSet javaContentSet = pathsConfiguration.getJavaContentSet();
                PathsConfiguration wizardProjPathConfig = PathsConfiguration.getInstance((Project)this._project, (PropertyStorage)this._project);
                ContentSet projectContentSet = wizardProjPathConfig.getJavaContentSet();
                javaContentSet.copyTo((Object)projectContentSet);
            }
            URL outputDir = (URL)ns.find("OutputDirectory");
            if (outputDir != null) {
                projectSettings.setOutputDirectory(URLFileSystem.canonicalize((URL)outputDir));
            }
        } else {
            try {
                tempProj.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
        try {
            this._project.save();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return true;
    }

    public boolean isAvailable(Context context) {
        if (context == null) {
            return false;
        }
        return context.getWorkspace() != null;
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"project.png");
    }

    private boolean copyFilesToProject() {
        this._progressBar = new ProgressBar((Component)Ide.getMainWindow(), WizardsArb.getString(35), (Runnable)this, true);
        this._progressBar.start(WizardsArb.getString(34), null);
        this._progressBar.waitUntilDone();
        boolean userCancelled = false;
        if (this._progressBar.hasUserCancelled()) {
            int retval = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), WizardsArb.getString(36), WizardsArb.getString(37), 0);
            if (retval == 0) {
                this._runAction = 1;
                IdeUtil.runNow((Runnable)this);
            }
            userCancelled = true;
        }
        if (this._fileCopyError && !userCancelled) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), WizardsArb.getString(38), WizardsArb.getString(39), 0);
        }
        return userCancelled;
    }

    private void deleteFile(URL fileToDelete) {
        if (URLFileSystem.isDirectory((URL)fileToDelete)) {
            URL[] children = URLFileSystem.list((URL)fileToDelete);
            for (int i = 0; i < children.length; ++i) {
                this.deleteFile(children[i]);
            }
        }
        URLFileSystem.delete((URL)fileToDelete);
    }

    private void copyFile(URL fileToCopy) {
        block11: {
            if (this._progressBar.hasUserCancelled()) {
                return;
            }
            this._progressBar.sleepForUIToRepaint();
            this._progressBar.updateProgress(WizardsArb.getString(34), URLFileSystem.getPlatformPathName((URL)fileToCopy));
            if (!this.shouldHandleFile(fileToCopy)) break block11;
            if (URLFileSystem.isDirectory((URL)fileToCopy)) {
                URL[] children = URLFileSystem.list((URL)fileToCopy);
                for (int i = 0; i < children.length; ++i) {
                    this.copyFile(children[i]);
                }
            } else {
                String relativeSpec = this._javaContentSet.toRelativePath(fileToCopy);
                URL copyToURL = null;
                if (relativeSpec == null) {
                    String fname = URLFileSystem.getFileName((URL)fileToCopy);
                    copyToURL = URLFactory.newURL((URL)this._copyLocation, (String)fname);
                } else {
                    copyToURL = URLFactory.newURL((URL)this._copyLocation, (String)relativeSpec);
                }
                if (URLFileSystem.equals((URL)fileToCopy, (URL)copyToURL)) {
                    return;
                }
                if (URLFileSystem.exists((URL)copyToURL)) {
                    copyToURL = this.findNewLocationFor(fileToCopy, copyToURL);
                }
                if (copyToURL == null) {
                    return;
                }
                try {
                    URLFileSystem.copy((URL)fileToCopy, (URL)copyToURL);
                }
                catch (IOException ex) {
                    this._fileCopyError = true;
                }
            }
        }
    }

    private URL findNewLocationFor(URL fileToCopy, URL copyToURL) {
        URL fileToCopyParent = fileToCopy;
        String fileToCopyDir = null;
        URL copyToParent = copyToURL;
        String copyToParentDir = null;
        boolean searchForDifference = true;
        String newDir = null;
        while (searchForDifference) {
            if ((fileToCopyParent = URLFileSystem.getParent((URL)fileToCopyParent)) == null) {
                newDir = null;
                searchForDifference = false;
            }
            fileToCopyDir = URLFileSystem.getFileName((URL)fileToCopyParent);
            if ((copyToParent = URLFileSystem.getParent((URL)copyToParent)) == null) {
                newDir = null;
                searchForDifference = false;
            }
            if (fileToCopyDir.equals(copyToParentDir = URLFileSystem.getFileName((URL)copyToParent))) continue;
            newDir = fileToCopyDir;
            searchForDifference = false;
        }
        if (newDir != null) {
            URL parent = URLFileSystem.getParent((URL)copyToURL);
            String fname = URLFileSystem.getFileName((URL)copyToURL);
            URL newURL = URLFactory.newURL((URL)parent, (String)(newDir + "/" + fname));
            if (URLFileSystem.exists((URL)newURL)) {
                return null;
            }
            return newURL;
        }
        return null;
    }

    private boolean shouldHandleFile(URL file) {
        PatternFilters patternFilters = GlobalIgnoreList.getPatternFilters();
        return patternFilters.isIncluded(file.getPath());
    }

    @Override
    public void run() {
        if (this._runAction == 0) {
            Iterator iterator = this._javaContentSet.urlIterator(null);
            while (iterator.hasNext()) {
                this.copyFile((URL)iterator.next());
                if (!this._progressBar.hasUserCancelled()) continue;
                break;
            }
        } else {
            URL[] urls = URLFileSystem.list((URL)this._copyLocation);
            for (int i = 0; i < urls.length; ++i) {
                this.deleteFile(urls[i]);
                if (!this._progressBar.hasUserCancelled()) {
                    continue;
                }
                break;
            }
        }
        this._progressBar.setDoneStatus();
    }

    private void init() {
        this._progressBar = null;
        this._javaContentSet = null;
        this._copyLocation = null;
        this._fileCopyError = false;
        this._sourcePaths = null;
        this._runAction = 0;
        this._project = null;
    }

    public String getImportWizardName(Context context) {
        return WizardsArb.getString(18);
    }

    public Icon getImportWizardIcon(Context context) {
        return OracleIcons.getIcon((String)"project.png");
    }

    public String getImportWizardTooltipText(Context context) {
        return WizardsArb.getString(26);
    }

    public boolean invokeImportWizard(Context context, String[] params) {
        Wizard.setLegacyParams((Context)context, (String[])params);
        context.setProperty(IMPORT_WIZARD_PROPERTY, (Object)true);
        return this.invoke(context);
    }

    public boolean isAvailableAsImportWizard(Context context) {
        return true;
    }
}

