/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.style.profile;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.style.profile.CodingStylePreviewPanel;
import oracle.jdevimpl.style.profile.CodingStyleProfile;
import oracle.jdevimpl.style.resource.CodingStyleArb;

public class CodingStyleImportsPanel
extends DefaultTraversablePanel {
    private static final String HELP_TOPIC = "f1_ideideseteditcodingstyleimports_html";
    private CodingStyleProfile profile;
    private CodingStylePreviewPanel preview = new CodingStylePreviewPanel();
    private JCheckBox groupImports = new JCheckBox();
    private WholeNumberField groupDepth = new WholeNumberField(8);
    private JCheckBox useWideClassImports = new JCheckBox();
    private JCheckBox useWideStaticImports = new JCheckBox();
    private WholeNumberField importThreshold = new WholeNumberField(8);
    private WholeNumberField importMemberThreshold = new WholeNumberField(8);
    private JCheckBox innerClasses = new JCheckBox();
    private boolean loading;

    public CodingStyleImportsPanel() {
        this.setHelpID(HELP_TOPIC);
        CheckBoxListener checkBoxListener = new CheckBoxListener();
        FieldListener fieldListener = new FieldListener();
        ResourceUtils.resButton((AbstractButton)this.groupImports, (String)CodingStyleArb.getString(129));
        JLabel groupDepthLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)groupDepthLabel, (Component)this.groupDepth, (String)CodingStyleArb.getString(130));
        new ItemSelectableTracker((ItemSelectable)this.groupImports, new Component[]{groupDepthLabel, this.groupDepth});
        this.groupImports.addItemListener(checkBoxListener);
        this.groupDepth.getDocument().addDocumentListener(fieldListener);
        ResourceUtils.resButton((AbstractButton)this.useWideClassImports, (String)CodingStyleArb.getString(131));
        JLabel importThresholdLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)importThresholdLabel, (Component)this.importThreshold, (String)CodingStyleArb.getString(133));
        ResourceUtils.resButton((AbstractButton)this.useWideStaticImports, (String)CodingStyleArb.getString(132));
        JLabel importMemberThresholdLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)importMemberThresholdLabel, (Component)this.importMemberThreshold, (String)CodingStyleArb.getString(134));
        new ItemSelectableTracker((ItemSelectable)this.useWideClassImports, new Component[]{importThresholdLabel, this.importThreshold});
        new ItemSelectableTracker((ItemSelectable)this.useWideStaticImports, new Component[]{importMemberThresholdLabel, this.importMemberThreshold});
        this.useWideClassImports.addItemListener(checkBoxListener);
        this.useWideStaticImports.addItemListener(checkBoxListener);
        this.importThreshold.getDocument().addDocumentListener(fieldListener);
        this.importMemberThreshold.getDocument().addDocumentListener(fieldListener);
        ResourceUtils.resButton((AbstractButton)this.innerClasses, (String)CodingStyleArb.getString(135));
        this.innerClasses.addItemListener(checkBoxListener);
        JLabel previewLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)previewLabel, (Component)this.preview.getEditor(), (String)CodingStyleArb.getString(128));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 5, 2, 0);
        this.add(this.groupImports, gbc);
        gbc.gridwidth = -1;
        gbc.insets = new Insets(0, 29, 10, 3);
        this.add(groupDepthLabel, gbc);
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 5, 10, 0);
        this.add((Component)this.groupDepth, gbc);
        gbc.insets = new Insets(0, 5, 2, 0);
        this.add(this.useWideClassImports, gbc);
        gbc.gridwidth = -1;
        gbc.insets = new Insets(0, 29, 10, 3);
        this.add(importThresholdLabel, gbc);
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 5, 10, 0);
        this.add((Component)this.importThreshold, gbc);
        gbc.insets = new Insets(0, 5, 2, 0);
        this.add(this.useWideStaticImports, gbc);
        gbc.gridwidth = -1;
        gbc.insets = new Insets(0, 29, 10, 3);
        this.add(importMemberThresholdLabel, gbc);
        gbc.gridwidth = 0;
        gbc.insets = new Insets(0, 5, 10, 0);
        this.add((Component)this.importMemberThreshold, gbc);
        gbc.insets = new Insets(0, 5, 15, 0);
        this.add(this.innerClasses, gbc);
        gbc.insets = new Insets(0, 0, 3, 0);
        this.add(previewLabel, gbc);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add(this.preview, gbc);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEntry(TraversableContext dataContext) {
        this.profile = (CodingStyleProfile)((Object)dataContext.find("Profile"));
        this.preview.setProfile(this.profile);
        this.preview.setSampleCode(this.getSampleCode());
        this.preview.update();
        try {
            this.loading = true;
            this.groupImports.setSelected(this.profile.getGroupImports());
            this.groupDepth.setText(Integer.toString(this.profile.getGroupPackageDepth()));
            this.useWideClassImports.setSelected(this.profile.getUseWideImports());
            this.useWideStaticImports.setSelected(this.profile.getUseWideMemberImports());
            this.importThreshold.setText(Integer.toString(this.profile.getWideImportThreshold()));
            this.importMemberThreshold.setText(Integer.toString(this.profile.getWideImportMemberThreshold()));
            this.innerClasses.setSelected(this.profile.getImportInnerClasses());
        }
        finally {
            this.loading = false;
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.profile = (CodingStyleProfile)((Object)dataContext.find("Profile"));
        this.saveToProfile();
    }

    private void saveToProfile() {
        this.profile.setGroupImports(this.groupImports.isSelected());
        this.profile.setGroupPackageDepth(this.groupDepth.getValue());
        this.profile.setUseWideImports(this.useWideClassImports.isSelected());
        this.profile.setUseWideMemberImports(this.useWideStaticImports.isSelected());
        this.profile.setWideImportThreshold(this.importThreshold.getValue());
        this.profile.setWideImportMemberThreshold(this.importMemberThreshold.getValue());
        this.profile.setImportInnerClasses(this.innerClasses.isSelected());
    }

    private String getSampleCode() {
        StringBuffer buffer = new StringBuffer();
        if (this.profile != null) {
            boolean useWideClass = this.profile.getUseWideImports();
            boolean useWideStatic = this.profile.getUseWideMemberImports();
            int threshold = this.profile.getWideImportThreshold();
            int memberThreshold = this.profile.getWideImportMemberThreshold();
            if (useWideClass && threshold < 4) {
                buffer.append("import java.awt.*;");
            } else {
                buffer.append("import java.awt.Button;");
                buffer.append("import java.awt.Component;");
                buffer.append("import java.awt.Container;");
            }
            if (useWideClass && threshold < 3) {
                buffer.append("import java.awt.event.*;");
            } else {
                buffer.append("import java.awt.event.ActionEvent;");
                buffer.append("import java.awt.event.ActionListener;");
            }
            if (this.profile.getImportInnerClasses()) {
                if (useWideClass && threshold < 2) {
                    buffer.append("import java.util.*;");
                    buffer.append("import java.util.Map.Entry;");
                } else {
                    buffer.append("import java.util.Map;");
                    buffer.append("import java.util.Map.Entry;");
                }
            } else if (useWideClass && threshold < 2) {
                buffer.append("import java.util.*;");
            } else {
                buffer.append("import java.util.Map;");
            }
            if (useWideClass && threshold < 5) {
                buffer.append("import javax.swing.*;");
            } else {
                buffer.append("import javax.swing.JButton;");
                buffer.append("import javax.swing.JCheckBox;");
                buffer.append("import javax.swing.JPanel;");
                buffer.append("import javax.swing.JScrollPane;");
            }
            if (useWideStatic && memberThreshold < 2) {
                buffer.append("import static java.awt.event.ActionEvent.*;");
            } else {
                buffer.append("import static java.awt.event.ActionEvent.ACTION_PERFORMED;");
            }
            if (useWideStatic && memberThreshold < 3) {
                buffer.append("import static java.awt.event.KeyEvent.*;");
            } else {
                buffer.append("import static java.awt.event.KeyEvent.VK_LEFT;");
                buffer.append("import static java.awt.event.KeyEvent.VK_RIGHT;");
            }
            if (useWideStatic && memberThreshold < 4) {
                buffer.append("import static java.lang.Math.*;");
            } else {
                buffer.append("import static java.lang.Math.max;");
                buffer.append("import static java.lang.Math.min;");
                buffer.append("import static java.lang.Math.random;");
            }
        }
        return buffer.toString();
    }

    private void updatePreview() {
        this.saveToProfile();
        this.preview.setSampleCode(this.getSampleCode());
        this.preview.update();
    }

    private class FieldListener
    implements DocumentListener {
        private FieldListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.handleEvent();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleEvent();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.handleEvent();
        }

        private void handleEvent() {
            if (!CodingStyleImportsPanel.this.loading) {
                CodingStyleImportsPanel.this.updatePreview();
            }
        }
    }

    private class CheckBoxListener
    implements ItemListener {
        private CheckBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!CodingStyleImportsPanel.this.loading) {
                CodingStyleImportsPanel.this.updatePreview();
            }
        }
    }
}

