/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.ide.ceditor.CodeEditor;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.statement.SourceCompoundStatement;

public class SourceFormatUtilities {
    public static String reIndent(BasicEditorPane editor, String src, String oldIndent, String newIndent) {
        int oldIdLen = oldIndent.length();
        int tabSize = (Integer)editor.getProperty("tab-size");
        boolean useTab = (Boolean)editor.getProperty("use-tabs");
        StringBuffer res = new StringBuffer();
        StringTokenizer st = new StringTokenizer(src, "\n\r", true);
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.equals("\n") || line.equals("\r")) {
                res.append(line);
                continue;
            }
            line = SourceFormatUtilities.tabToSpace(line, tabSize);
            String newLine = newIndent;
            newLine = line.startsWith(oldIndent) ? newLine + line.substring(oldIdLen) : newLine + line.trim();
            if (useTab) {
                newLine = SourceFormatUtilities.spaceToTab(newLine, tabSize);
            }
            res.append(newLine);
        }
        return res.toString();
    }

    public static String tabToSpace(String s, int numtab) {
        int pDest = 0;
        StringBuffer sb = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\t') {
                sb.append(c);
                ++pDest;
                continue;
            }
            do {
                sb.append(' ');
            } while (++pDest % numtab != 0);
        }
        return sb.toString();
    }

    public static String spaceToTab(String s, int numtab) {
        StringBuffer sb = new StringBuffer(s.length());
        String tabVal = "                     ".substring(0, numtab);
        while (s.startsWith(tabVal)) {
            sb.append('\t');
            s = s.substring(numtab);
        }
        sb.append(s);
        return sb.toString();
    }

    public static String getIndentation(CodeEditor codeEditor, int offset) {
        int lineStartOffset = codeEditor.getLineStartOffset(codeEditor.getLineFromOffset(offset));
        String res = "";
        try {
            res = codeEditor.getText(lineStartOffset, offset - lineStartOffset);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (res.trim().length() != 0) {
            res = "";
        }
        return res;
    }

    public static String getIndentation(BasicEditorPane document, int offset) {
        int lineStartOffset = document.getLineStartOffset(document.getLineFromOffset(offset));
        String res = "";
        try {
            res = document.getText(lineStartOffset, offset - lineStartOffset);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (res.trim().length() != 0) {
            res = "";
        }
        return res;
    }

    public static SourceElement findPreviousElement(SourceElement el, int offs) {
        SourceElement res = null;
        int start = el.getStartOffset();
        if (offs < start) {
            return res;
        }
        res = el;
        if (offs > el.getEndOffset()) {
            return res;
        }
        Iterator it = el.getChildren(196608).iterator();
        while (it.hasNext()) {
            SourceElement resChild = SourceFormatUtilities.findPreviousElement((SourceElement)it.next(), offs);
            if (resChild == null) {
                return res;
            }
            res = resChild;
        }
        return res;
    }

    public static String getIdentFromOffset(BasicEditorPane document, int offset) {
        int lineStartOffset = document.getLineStartOffset(document.getLineFromOffset(offset));
        String res = "";
        try {
            int p;
            res = document.getText(lineStartOffset, offset - lineStartOffset);
            for (p = 0; p < res.length() && (res.charAt(p) == ' ' || res.charAt(p) == '\t'); ++p) {
            }
            res = res.substring(0, p);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return res;
    }

    static String getIdentFromPreviousElement(BasicEditorPane document, SourceElement el, int offset) {
        if (el == null) {
            return "";
        }
        int id = el.getSymbolKind();
        int indentSize = (Integer)document.getProperty("indent-size");
        String tabString = "                     ".substring(0, indentSize);
        switch (id) {
            case 13: 
            case 69: {
                return SourceFormatUtilities.getIdentFromOffset(document, el.getStartOffset());
            }
            case 63: {
                return SourceFormatUtilities.getIdentFromOffset(document, el.getStartOffset()) + " ";
            }
            case 2: 
            case 4: 
            case 29: {
                if (el.getEndOffset() <= offset) break;
                return SourceFormatUtilities.getIdentFromOffset(document, el.getEndOffset()) + tabString;
            }
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 45: {
                SourceCompoundStatement sif = (SourceCompoundStatement)el;
                if (sif.getPrimaryClause() != null && offset >= sif.getPrimaryClause().getStartOffset()) break;
                return SourceFormatUtilities.getIdentFromOffset(document, el.getStartOffset()) + tabString;
            }
        }
        return SourceFormatUtilities.getIdentFromPreviousElement(document, el.getParent(), offset);
    }

    public static String getSmartIndentation(SourceFile sourceFile, BasicEditorPane document, int offset) {
        int lineStartOffset = document.getLineStartOffset(document.getLineFromOffset(offset));
        String res = "";
        try {
            res = document.getText(lineStartOffset, offset - lineStartOffset);
            if (res == "" || res.trim().length() == 0) {
                SourceElement lstEl = SourceFormatUtilities.findPreviousElement((SourceElement)sourceFile, offset);
                res = SourceFormatUtilities.getIdentFromPreviousElement(document, lstEl, offset);
            } else {
                res = "";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return res;
    }
}

