/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.refactoring.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.jdevimpl.refactoring.util.Visitor;

public class RichBuffer
implements Transferable {
    public static final DataFlavor FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=" + RichBuffer.class.getName(), "Java Code");
    private static final DataFlavor[] _flavors = new DataFlavor[]{FLAVOR, DataFlavor.stringFlavor};
    private String _text;
    private ClassUseEntry[] _fqClassNames;

    public static RichBuffer createJotRichBuffer(SourceFile sourceFile, int from, int to) {
        URL url = sourceFile.getURL();
        TextNode textNode = (TextNode)NodeFactory.find((URL)url);
        TextBuffer textBuffer = textNode.acquireTextBuffer();
        String text = textBuffer.getString(from, to - from);
        ClassUseEntry[] fqClassNames = RichBuffer.containsImportsOrPackageDirective(sourceFile, from, to) ? new ClassUseEntry[]{} : RichBuffer.extractImports((SourceElement)sourceFile, from, to);
        RichBuffer jotRichBuffer = new RichBuffer(text, fqClassNames);
        jotRichBuffer.setText(text);
        return jotRichBuffer;
    }

    private static boolean containsImportsOrPackageDirective(SourceFile sourceFile, final int from, final int to) {
        Visitor v = new Visitor(){

            private void checkEl(SourceElement el) {
                if (from <= el.getStartOffset() && el.getEndOffset() <= to) {
                    this.setUserData(el);
                    this.cancel();
                }
            }

            @Override
            protected void whenEnterClass(SourceClass sourceClass) {
                this.skipChildren();
            }

            @Override
            protected void whenEnterImportDeclaration(SourceImport el) {
                this.checkEl((SourceElement)el);
            }

            @Override
            protected void whenEnterPackageDeclaration(SourcePackage el) {
                this.checkEl((SourceElement)el);
            }
        };
        v.visit((SourceElement)sourceFile);
        return v.getUserData() != null;
    }

    public static String[] getNecessaryImports(SourceFile sourceFile, int from, int to) {
        ClassUseEntry[] imps = RichBuffer.extractImports((SourceElement)sourceFile, from, to);
        String[] res = RichBuffer.toImportArray(imps);
        return res;
    }

    private static String[] toImportArray(ClassUseEntry[] imps) {
        String[] res = new String[imps.length];
        for (int i = 0; i < imps.length; ++i) {
            res[i] = imps[i].fqName;
        }
        return res;
    }

    private static ClassUseEntry[] extractImports(SourceElement sourceElement, final int from, final int to) {
        final HashMap foundClasses = new HashMap();
        final HashSet foundDeclarations = new HashSet();
        new Visitor(){

            private void addSourceType(SourceTypeReference sourceType) {
                JavaType resolvedType;
                SourceName nameElement = sourceType.getNameElement();
                if (nameElement != null && from <= nameElement.getStartOffset() && nameElement.getEndOffset() <= to && (resolvedType = sourceType.getResolvedType()) != null) {
                    String importName = resolvedType.getRawName();
                    ClassUseEntry cue = (ClassUseEntry)foundClasses.get(importName);
                    if (cue != null) {
                        cue.addPos(nameElement.getStartOffset() - from, nameElement.getEndOffset() - from);
                        return;
                    }
                    String packageName = resolvedType.getPackageName();
                    if (importName.indexOf(46) == -1 || !importName.equals(sourceType.getText()) || packageName.equals("")) {
                        this.addJavaType(resolvedType, (SourceElement)nameElement);
                    }
                }
            }

            private void addJavaType(JavaType resolvedType, SourceElement element) {
                String packageName;
                while (resolvedType != null && resolvedType.isArray()) {
                    resolvedType = resolvedType.getComponentType();
                }
                if (resolvedType != null && !resolvedType.isPrimitive() && !(packageName = resolvedType.getPackageName()).equals("java.lang")) {
                    String importName;
                    JavaClass jc = resolvedType.getOwningClass();
                    if (jc != null) {
                        JavaClass owner = jc.getOwningClass();
                        while (owner != null) {
                            jc = owner;
                            owner = jc.getOwningClass();
                        }
                        importName = jc.getRawName();
                    } else {
                        JavaClass mainClass;
                        importName = resolvedType.getRawName();
                        ClassUseEntry cue = (ClassUseEntry)foundClasses.get(importName);
                        if (cue != null) {
                            if (element != null) {
                                cue.addPos(element.getStartOffset() - from, element.getEndOffset() - from);
                            }
                            return;
                        }
                        JavaClass thisClass = resolvedType.getTypeErasure();
                        if (thisClass instanceof SourceClass && !(mainClass = ((SourceClass)thisClass).getOwningSourceFile().getPrimaryClass()).equals(thisClass)) {
                            return;
                        }
                    }
                    if (element != null) {
                        foundClasses.put(importName, new ClassUseEntry(importName, element.getStartOffset() - from, element.getEndOffset() - from));
                    } else {
                        foundClasses.put(importName, new ClassUseEntry(importName));
                    }
                }
            }

            @Override
            protected void whenEnterDotExpression(SourceDotExpression sourceDotExpression) {
                if (from <= sourceDotExpression.getStartOffset() && sourceDotExpression.getEndOffset() <= to) {
                    String txt = sourceDotExpression.getText();
                    JavaHasType tp = sourceDotExpression.getResolvedObject();
                    if (tp != null) {
                        if (tp.getElementKind() != 3) {
                            return;
                        }
                        JavaType jt = sourceDotExpression.getResolvedType();
                        if (jt != null && jt.getElementKind() == 3 && !jt.getQualifiedName().equals(txt)) {
                            this.addJavaType(jt, null);
                        }
                    }
                }
            }

            @Override
            protected void whenEnterName(SourceName sourceName) {
                if (from <= sourceName.getStartOffset() && sourceName.getEndOffset() <= to) {
                    SourceElement parent = sourceName.getParent();
                    String importName = null;
                    if (parent != null && parent.getSymbolKind() == 3) {
                        SourceClass sc = (SourceClass)parent;
                        importName = sc.getQualifiedName();
                    } else if (parent != null && parent.getSymbolKind() == 6) {
                        SourceMethod sm = (SourceMethod)parent;
                        JavaClass javaClass = sm.getOwningClass();
                        importName = javaClass.getQualifiedName();
                    }
                    if (importName != null) {
                        ClassUseEntry cue = (ClassUseEntry)foundClasses.get(importName);
                        if (cue != null) {
                            cue.addPos(sourceName.getStartOffset() - from, sourceName.getEndOffset() - from);
                        } else {
                            foundClasses.put(importName, new ClassUseEntry(importName, sourceName.getStartOffset() - from, sourceName.getEndOffset() - from));
                        }
                    }
                }
            }

            @Override
            protected void whenEnterSimpleNameExpression(SourceSimpleNameExpression sourceSimpleNameExpression) {
                if (from <= sourceSimpleNameExpression.getStartOffset() && sourceSimpleNameExpression.getEndOffset() <= to) {
                    String txt = sourceSimpleNameExpression.getText();
                    JavaHasType tp = sourceSimpleNameExpression.getResolvedObject();
                    if (tp != null) {
                        if (tp.getElementKind() != 3) {
                            return;
                        }
                        JavaType jt = sourceSimpleNameExpression.getResolvedType();
                        if (jt != null && jt.getElementKind() == 3) {
                            String qualifiedName = jt.getQualifiedName();
                            if (qualifiedName.equals(txt)) {
                                return;
                            }
                            ClassUseEntry cue = (ClassUseEntry)foundClasses.get(qualifiedName);
                            if (cue != null) {
                                cue.addPos(sourceSimpleNameExpression.getStartOffset() - from, sourceSimpleNameExpression.getEndOffset() - from);
                                return;
                            }
                            this.addJavaType(jt, (SourceElement)sourceSimpleNameExpression);
                        }
                    }
                }
            }

            @Override
            protected void whenEnterClass(SourceClass sourceClass) {
                SourceClassBody blk;
                int end;
                if (from <= sourceClass.getStartOffset() && (end = (blk = sourceClass.getSourceBody()) != null ? blk.getStartOffset() : sourceClass.getEndOffset()) <= to) {
                    foundDeclarations.add(sourceClass.getQualifiedName());
                }
            }

            @Override
            protected void whenEnterTypeRef(SourceTypeReference sourceType) {
                this.addSourceType(sourceType);
            }

            @Override
            protected void whenEnterAnnotation(SourceAnnotation sourceAnnotation) {
                if (from <= sourceAnnotation.getStartOffset() && to >= sourceAnnotation.getEndOffset()) {
                    JavaType javaType = sourceAnnotation.getAnnotationType();
                    SourceName nameElement = sourceAnnotation.getNameElement();
                    if (javaType != null && nameElement != null) {
                        this.addJavaType(javaType, (SourceElement)nameElement);
                    }
                }
            }
        }.visit(sourceElement);
        String[] toRemove = foundDeclarations.toArray(new String[foundDeclarations.size()]);
        for (int i = 0; i < toRemove.length; ++i) {
            String s = toRemove[i];
            foundClasses.remove(toRemove[i]);
        }
        Object[] fqClassNames = foundClasses.values().toArray(new ClassUseEntry[foundClasses.size()]);
        Arrays.sort(fqClassNames);
        return fqClassNames;
    }

    private RichBuffer(String text, ClassUseEntry[] fqClassNames) {
        this._text = text;
        this._fqClassNames = fqClassNames;
    }

    private void dump() {
        String[] fqClassNames = this.getFQClassNames();
        for (int i = 0; i < fqClassNames.length; ++i) {
            String fqClassName = fqClassNames[i];
            System.out.println("import " + fqClassName + ";");
        }
        System.out.print("\n\n");
        System.out.println(this._text);
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text;
    }

    public String getFqText(String[] classesToExpand) {
        ArrayList<ReplaceItem> toAdjust = new ArrayList<ReplaceItem>();
        for (int i = 0; i < classesToExpand.length; ++i) {
            for (int j = 0; j < this._fqClassNames.length; ++j) {
                if (!classesToExpand[i].equals(this._fqClassNames[j].fqName)) continue;
                ArrayList foundPos = this._fqClassNames[j].usedPos;
                for (int k = 0; k < foundPos.size(); ++k) {
                    TextSegment seg = (TextSegment)foundPos.get(k);
                    toAdjust.add(new ReplaceItem(classesToExpand[i], seg.start, seg.end));
                }
            }
        }
        Object[] ts = toAdjust.toArray(new ReplaceItem[toAdjust.size()]);
        Arrays.sort(ts);
        StringBuffer sb = new StringBuffer(this._text.length() * 2);
        int cpos = 0;
        for (int i = 0; i < ts.length; ++i) {
            Object ri = ts[i];
            if (cpos < ((ReplaceItem)ri).start) {
                sb.append(this._text.substring(cpos, ((ReplaceItem)ri).start));
            }
            sb.append(((ReplaceItem)ri).text);
            cpos = ((ReplaceItem)ri).end;
        }
        if (cpos < this._text.length()) {
            sb.append(this._text.substring(cpos));
        }
        return sb.toString();
    }

    public String[] getFQClassNames() {
        return RichBuffer.toImportArray(this._fqClassNames);
    }

    public String[] getMissingImports(SourceFile sourceFile) {
        String[] fqClassNames = this.getFQClassNames();
        return RichBuffer.getMissingImports(sourceFile, fqClassNames);
    }

    public static String[] getMissingImports(SourceFile sourceFile, String[] fqClassNames) {
        ArrayList<String> missingImports = new ArrayList<String>();
        List imports = sourceFile.getSourceImports();
        HashSet<String> existingImports = new HashSet<String>(imports.size());
        for (SourceImport sourceImport : imports) {
            String name = sourceImport.getName();
            existingImports.add(name);
        }
        String sourcePackage = sourceFile.getPackageName();
        for (int i = 0; i < fqClassNames.length; ++i) {
            String pkg;
            String pkgDotStar;
            int lastDot;
            String fqClassName = fqClassNames[i];
            if (existingImports.contains(fqClassName) || (lastDot = fqClassName.lastIndexOf(46)) == -1 || existingImports.contains(pkgDotStar = (pkg = fqClassName.substring(0, lastDot)) + ".*") || sourcePackage.equals(pkg)) continue;
            missingImports.add(fqClassName);
        }
        return missingImports.toArray(new String[missingImports.size()]);
    }

    public static int getAddedImports(BasicDocument document, String[] needImports, SourceFile sourceFile, HashSet toImport, HashSet conflictingImports) {
        int newImportInsertionPoint;
        List importsCo = sourceFile.getSourceImports();
        String curPack = sourceFile.getPackageName();
        JavaProvider mgr = sourceFile.getProvider();
        String[] pImport = new String[needImports.length];
        if (mgr != null) {
            for (int i = 0; i < needImports.length; ++i) {
                String s = needImports[i];
                JavaClass cls = mgr.getClass(s);
                if (cls == null) continue;
                pImport[i] = cls.getPackageName();
                if (curPack.equals(pImport[i]) || "java.lang".equals(pImport[i])) continue;
                toImport.add(s);
            }
        }
        LineMap lineMap = document.getLineMap();
        if (!importsCo.isEmpty()) {
            SourceImport[] imports = importsCo.toArray(new SourceImport[importsCo.size()]);
            for (int i = 0; i < imports.length; ++i) {
                SourceImport sourceImport = imports[i];
                String iName = sourceImport.getName();
                if (iName.endsWith("*")) {
                    String pName = iName.substring(0, iName.lastIndexOf(46));
                    for (int j = 0; j < pImport.length; ++j) {
                        if (!pName.equals(pImport[j])) continue;
                        toImport.remove(needImports[j]);
                    }
                    continue;
                }
                toImport.remove(iName);
            }
            SourceImport lastImport = imports[imports.length - 1];
            int endOffset = lastImport.getEndOffset();
            int lineFromOffset = lineMap.getLineFromOffset(endOffset);
            newImportInsertionPoint = lineMap.getLineEndOffset(lineFromOffset);
        } else {
            SourcePackage packageStatement = sourceFile.getSourcePackage();
            if (packageStatement != null) {
                int endOffset = packageStatement.getEndOffset();
                int lineFromOffset = lineMap.getLineFromOffset(endOffset);
                newImportInsertionPoint = lineMap.getLineEndOffset(lineFromOffset);
            } else {
                newImportInsertionPoint = 0;
            }
        }
        if (toImport.size() != 0) {
            HashSet<String> importedClasses = new HashSet<String>();
            RichBuffer.addAllImportedClasses(mgr, curPack, importedClasses);
            SourceImport[] imports = importsCo.toArray(new SourceImport[importsCo.size()]);
            for (int i = 0; i < imports.length; ++i) {
                SourceImport sourceImport = imports[i];
                String iName = sourceImport.getName();
                if (iName.endsWith("*")) {
                    String pName = iName.substring(0, iName.lastIndexOf(46));
                    RichBuffer.addAllImportedClasses(mgr, pName, importedClasses);
                    continue;
                }
                JavaClass cls = mgr.getClass(iName);
                if (cls == null) continue;
                importedClasses.add(cls.getName());
            }
            String[] itlist = toImport.toArray(new String[toImport.size()]);
            for (int i = 0; i < itlist.length; ++i) {
                String name = itlist[i];
                JavaClass cls = mgr.getClass(name);
                if (cls == null || !importedClasses.contains(cls.getName())) continue;
                toImport.remove(name);
                conflictingImports.add(name);
            }
        }
        return newImportInsertionPoint;
    }

    private static void addAllImportedClasses(JavaProvider mgr, String packageName, HashSet importedClasses) {
        Collection lcls = mgr.getPackage(packageName).getDeclaredClasses();
        for (JavaClass cls : lcls) {
            importedClasses.add(cls.getName());
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return _flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return FLAVOR.equals(flavor) || flavor.equals(DataFlavor.stringFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (FLAVOR.equals(flavor)) {
            return this;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this._text;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    static class ReplaceItem
    implements Comparable {
        String text;
        int start;
        int end;

        public ReplaceItem(String s, int st, int e) {
            this.text = s;
            this.start = st;
            this.end = e;
        }

        public int compareTo(Object o) {
            ReplaceItem ri = (ReplaceItem)o;
            return this.start - ri.start;
        }
    }

    static class ClassUseEntry
    implements Comparable {
        String fqName;
        ArrayList usedPos;

        public ClassUseEntry(String name, int start, int end) {
            this.fqName = name;
            this.usedPos = new ArrayList(2);
            this.addPos(start, end);
        }

        public ClassUseEntry(String name) {
            this.fqName = name;
            this.usedPos = new ArrayList(2);
        }

        void addPos(int start, int end) {
            this.usedPos.add(new TextSegment(start, end));
        }

        public int compareTo(Object o) {
            ClassUseEntry cu = (ClassUseEntry)o;
            return this.fqName.compareTo(cu.fqName);
        }
    }

    static class TextSegment {
        int start;
        int end;

        public TextSegment(int s, int e) {
            this.start = s;
            this.end = e;
        }
    }
}

