/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.TreeNode;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.ContentFilterCustomizer;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorInit;
import oracle.ide.navigator.NavigatorInitFactory;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.ide.view.View;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.dialogs.progress.ProgressPanel;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.model.NewWorkingSetPanel;
import oracle.jdevimpl.navigator.LibraryFolder;
import oracle.jdevimpl.navigator.Res;
import oracle.jdevimpl.navigator.WorkingSetsPanel;

final class WorkingSetSupport
extends NavigatorInit
implements Controller {
    private static IdeAction _addToWorkingSetAction;
    private static IdeAction _newFromSelectionAction;
    private static IdeAction _hideSelectionAction;
    private static IdeAction _unhideAction;
    private static IdeAction _unhideAllAction;
    private static IdeAction _manageWorkingSetsAction;
    private static WorkspaceCML _workspaceCML;
    private static final WorkingSetNonAction WORKING_SET_NON_ACTION;
    private static MenuToolButton _workingSetMenu;
    private static final String ACTION_WORK_SET_PREFIX = "working-set-";

    private static MenuToolButton getWorkingSetMenu() {
        if (_workingSetMenu == null) {
            _workingSetMenu = new MenuToolButton((ToggleAction)WORKING_SET_NON_ACTION);
            _workingSetMenu.setFocusable(false);
        }
        return _workingSetMenu;
    }

    static void init(ProjectNavigatorManager nav) {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(WorkingSetSupport.class.getClassLoader(), "oracle/jdevimpl/navigator/accelerators.xml");
        nav.addNavigatorInit(new NavigatorInitFactory(WorkingSetSupport.class));
        if (_workspaceCML == null) {
            _workspaceCML = new WorkspaceCML();
            nav.addContextMenuListener((ContextMenuListener)_workspaceCML, Workspace.class);
        }
    }

    WorkingSetSupport(NavigatorWindow navWin, Context context) {
        super(navWin, context);
        WorkingSetSupport.getWorkingSetMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                WorkingSetSupport.this.repopulateWorkingSetMenu((JPopupMenu)e.getSource());
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }
        });
        this.createAddToWorkingSetAction();
        Workspace workspace = context.getWorkspace();
        if (workspace != null) {
            WorkingSets workingSets = WorkingSets.getInstance((Workspace)workspace);
            String curWorkingSetName = workingSets.getCurrentWorkingSetName();
            WorkingSetSupport.updateWorkingSetsTooltip(curWorkingSetName);
        }
    }

    public void copyPreferencesTo(Context context) {
        context.setBoolean("enable-working-sets", true);
    }

    public void initToolbar(Toolbar toolbar) {
        WorkingSetSupport.getWorkingSetMenu().setAction((Action)((Object)WORKING_SET_NON_ACTION));
        toolbar.add((Component)WorkingSetSupport.getWorkingSetMenu(), 2);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        Workspace workspace = context.getWorkspace();
        String workingSetName = (String)action.getValue("Name");
        WorkingSets workingSets = WorkingSets.getInstance((Workspace)workspace);
        workingSets.setCurrentWorkingSetName(workingSetName);
        UpdateMessage.fireStructureChanged((Subject)workspace);
        this.maybeNotifyActiveProjectChanged(context, workingSets.getWorkingSet(workingSetName));
        new SaveThread(workspace).start();
        return true;
    }

    public boolean update(IdeAction action, Context context) {
        action.setEnabled(context.getWorkspace() != null);
        return true;
    }

    private void repopulateWorkingSetMenu(JPopupMenu popup) {
        WorkingSetSupport.getWorkingSetMenu().removeAllPopupItems();
        NavigatorWindow navWin = this.getNavigatorWindow();
        Context context = navWin.getContext();
        if (context != null) {
            Workspace workspace = context.getWorkspace();
            if (workspace != null) {
                WorkingSets workingSets = WorkingSets.getInstance((Workspace)workspace);
                String curWorkingSetName = workingSets.getCurrentWorkingSetName();
                WorkingSetSupport.updateWorkingSetsTooltip(curWorkingSetName);
                List workingSetNames = workingSets.getWorkingSetNames();
                Iterator iter = workingSetNames.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    String workSetName = iter.next().toString();
                    IdeAction action = this.createWorkSetToggleAction(i++, workSetName);
                    if (workSetName.equals(curWorkingSetName)) {
                        action.putValue("State", (Object)Boolean.TRUE);
                    }
                    WorkingSetSupport.getWorkingSetMenu().addPopupItem((ToggleAction)action);
                }
                if (i > 0) {
                    popup.addSeparator();
                }
            }
            IdeAction action = this.createHideSelectionAction();
            action.updateAction(context);
            WorkingSetSupport.getWorkingSetMenu().addPopupItem((ToggleAction)action);
            action = this.createUnhideAction();
            action.updateAction(context);
            WorkingSetSupport.getWorkingSetMenu().addPopupItem((ToggleAction)action);
            action = this.createUnhideAllAction();
            action.updateAction(context);
            WorkingSetSupport.getWorkingSetMenu().addPopupItem((ToggleAction)action);
            popup.addSeparator();
            action = this.createNewFromSelectionAction();
            action.updateAction(context);
            WorkingSetSupport.getWorkingSetMenu().addPopupItem((ToggleAction)action);
            action = this.createManageWorkingSetsAction();
            action.updateAction(context);
            WorkingSetSupport.getWorkingSetMenu().addPopupItem((ToggleAction)action);
        }
    }

    private void maybeNotifyActiveProjectChanged(Context context, WorkingSet workingSet) {
        Project currentProject = context.getProject();
        if (currentProject == null || !workingSet.isExcluded(currentProject)) {
            return;
        }
        boolean foundProjectNode = false;
        TNode activeProjectNode = null;
        NavigatorWindow navWin = this.getNavigatorWindow();
        TreeExplorer explorer = navWin.getTreeExplorer();
        Enumeration tNodes = explorer.getRoot().getChildTNodes();
        while (tNodes.hasMoreElements()) {
            Project p;
            TNode next = (TNode)tNodes.nextElement();
            if (!foundProjectNode && next.getData() == currentProject) {
                foundProjectNode = true;
                if (activeProjectNode == null) continue;
                break;
            }
            if (!(next.getData() instanceof Project) || !workingSet.isIncluded(p = (Project)next.getData())) continue;
            activeProjectNode = next;
            if (!foundProjectNode) continue;
            break;
        }
        if (activeProjectNode != null) {
            explorer.setSelected(activeProjectNode);
        }
    }

    private IdeAction createNewFromSelectionAction() {
        if (_newFromSelectionAction == null) {
            _newFromSelectionAction = this.createAction("working-set-new-from-selection", Res.getString(8), Res.getInteger(9), null);
            Controller newFromSelectionController = new Controller(){

                public boolean handleEvent(IdeAction action, final Context context) {
                    NewWorkingSetPanel dlg = new NewWorkingSetPanel();
                    dlg.setHelpID("f1_idednewworkingset_html");
                    final Workspace workspace = context.getWorkspace();
                    final WorkingSets workingSets = WorkingSets.getInstance((Workspace)workspace);
                    List existing = workingSets.getWorkingSetNames();
                    String defaultName = this.defaultName(context.getSelection(), existing);
                    Namespace data = new Namespace();
                    data.put("name", (Object)defaultName);
                    data.put("existing.names", (Object)existing);
                    TDialogLauncher launcher = dlg.getTDialogLauncher((Component)Ide.getMainWindow(), data);
                    boolean okay = launcher.showDialog();
                    if (okay) {
                        Project[] selectedProjects;
                        boolean selectionContainsProjects;
                        final String wsName = (String)data.find("name");
                        WorkingSet currentWorkingSet = WorkingSetSupport.getActiveWorkingSet(workspace);
                        final WorkingSet newWorkingSet = workingSets.getWorkingSet(wsName);
                        currentWorkingSet.copyTo((Object)newWorkingSet);
                        Element[] selection = context.getSelection();
                        boolean bl = selectionContainsProjects = selection != null && selection.length > 0 && selection[0] instanceof Project;
                        if (selectionContainsProjects) {
                            ArrayList<Project> list = new ArrayList<Project>(selection.length);
                            for (Element element : selection) {
                                if (!(element instanceof Project)) continue;
                                list.add((Project)element);
                            }
                            selectedProjects = list.toArray(new Project[list.size()]);
                        } else {
                            selectedProjects = new Project[]{context.getProject()};
                        }
                        WorkingSetSupport.saveWorkingSetChanges(workspace, new Runnable(){

                            @Override
                            public void run() {
                                if (!selectionContainsProjects) {
                                    CompoundPattern[] compoundPatterns = WorkingSetSupport.this.getPatternsForSelection(context);
                                    PatternFilters filters = newWorkingSet.getOrCreatePatternFilters(context.getProject());
                                    filters.setFilters(new PatternFilter[0]);
                                    WorkingSetSupport.this.doAddFilters(filters, compoundPatterns, true).run();
                                }
                                Iterator children = workspace.getChildren();
                                while (children.hasNext()) {
                                    Object next = children.next();
                                    if (!(next instanceof Project)) continue;
                                    Project project = (Project)next;
                                    boolean match = newWorkingSet.isExcluded(project);
                                    for (int i = 0; i < selectedProjects.length && !match; ++i) {
                                        match = project == selectedProjects[i];
                                    }
                                    if (match) continue;
                                    newWorkingSet.excludeProject(project);
                                }
                                workingSets.setCurrentWorkingSetName(wsName);
                            }
                        });
                        UpdateMessage.fireStructureChanged((Subject)workspace);
                        new SaveThread(workspace).start();
                    }
                    return true;
                }

                public boolean update(IdeAction action, Context context) {
                    boolean enable = WorkingSetSupport.this.canNewFromSelection(context);
                    action.setEnabled(enable);
                    return true;
                }

                private String defaultName(Element[] selection, List<String> workingSetNames) {
                    String defaultName;
                    if (selection != null && selection.length > 3) {
                        defaultName = Res.getString(10);
                    } else {
                        defaultName = Arrays.toString(selection);
                        defaultName = defaultName.substring(1, defaultName.length() - 1);
                    }
                    int i = 1;
                    String original = defaultName;
                    while (workingSetNames.contains(defaultName)) {
                        defaultName = original + i++;
                    }
                    return defaultName;
                }
            };
            _newFromSelectionAction.addController(newFromSelectionController);
        }
        return _newFromSelectionAction;
    }

    private IdeAction createUnhideAction() {
        if (_unhideAction == null) {
            _unhideAction = this.createAction("working-set-unhide-children", Res.getString(14), Res.getInteger(15), null);
            Controller unhideController = new Controller(){

                public boolean handleEvent(IdeAction action, Context context) {
                    Workspace workspace = context.getWorkspace();
                    WorkingSet activeWorkingSet = WorkingSetSupport.this.getEditableWorkingSet(workspace);
                    PatternFilters filters = activeWorkingSet.getOrCreatePatternFilters(context.getProject());
                    CompoundPattern[] compoundPatterns = WorkingSetSupport.this.getUnhidePatternsSelection(context);
                    WorkingSetSupport.saveWorkingSetChanges(workspace, WorkingSetSupport.this.doUnhide(context, filters, compoundPatterns, false));
                    UpdateMessage.fireStructureChanged((Subject)workspace);
                    return true;
                }

                public boolean update(IdeAction action, Context context) {
                    boolean enable = WorkingSetSupport.this.canUnhide(context);
                    action.setEnabled(enable);
                    return true;
                }
            };
            _unhideAction.addController(unhideController);
        }
        return _unhideAction;
    }

    private IdeAction createUnhideAllAction() {
        if (_unhideAllAction == null) {
            _unhideAllAction = this.createAction("working-set-unhide-all-children", Res.getString(17), Res.getInteger(18), null);
            Controller unhideAllController = new Controller(){

                public boolean handleEvent(IdeAction action, Context context) {
                    Workspace workspace = context.getWorkspace();
                    WorkingSet activeWorkingSet = WorkingSetSupport.this.getEditableWorkingSet(workspace);
                    PatternFilters filters = activeWorkingSet.getOrCreatePatternFilters(context.getProject());
                    CompoundPattern[] compoundPatterns = WorkingSetSupport.this.getUnhidePatternsSelection(context);
                    WorkingSetSupport.saveWorkingSetChanges(workspace, WorkingSetSupport.this.doUnhide(context, filters, compoundPatterns, true));
                    UpdateMessage.fireStructureChanged((Subject)workspace);
                    return true;
                }

                public boolean update(IdeAction action, Context context) {
                    boolean enable = WorkingSetSupport.this.canUnhide(context);
                    action.setEnabled(enable);
                    return true;
                }
            };
            _unhideAllAction.addController(unhideAllController);
        }
        return _unhideAllAction;
    }

    private IdeAction createHideSelectionAction() {
        if (_hideSelectionAction == null) {
            _hideSelectionAction = this.createAction("working-set-hide-selection", Res.getString(11), Res.getInteger(12), null);
            Controller hideSelectionController = new Controller(){

                public boolean handleEvent(IdeAction action, Context context) {
                    final Element[] selection = context.getSelection();
                    if (selection != null && selection.length > 0 && selection[0] instanceof Project) {
                        Workspace workspace = context.getWorkspace();
                        final WorkingSet activeWorkingSet = WorkingSetSupport.getActiveWorkingSet(workspace);
                        final boolean[] modified = new boolean[]{false};
                        WorkingSetSupport.saveWorkingSetChanges(workspace, new Runnable(){

                            @Override
                            public void run() {
                                for (Element elem : selection) {
                                    if (!(elem instanceof Project)) continue;
                                    Project project = (Project)elem;
                                    modified[0] = activeWorkingSet.excludeProject(project) || modified[0];
                                }
                            }
                        });
                        if (modified[0]) {
                            UpdateMessage.fireStructureChanged((Subject)workspace);
                            WorkingSetSupport.this.maybeNotifyActiveProjectChanged(context, activeWorkingSet);
                        }
                    } else {
                        Workspace workspace = context.getWorkspace();
                        WorkingSet activeWorkingSet = WorkingSetSupport.this.getEditableWorkingSet(workspace);
                        PatternFilters filters = activeWorkingSet.getOrCreatePatternFilters(context.getProject());
                        CompoundPattern[] compoundPatterns = WorkingSetSupport.this.getPatternsForSelection(context);
                        WorkingSetSupport.saveWorkingSetChanges(workspace, WorkingSetSupport.this.doAddFilters(filters, compoundPatterns, false));
                        UpdateMessage.fireStructureChanged((Subject)workspace);
                    }
                    return true;
                }

                public boolean update(IdeAction action, Context context) {
                    boolean enable = WorkingSetSupport.this.canHide(context);
                    action.setEnabled(enable);
                    return true;
                }
            };
            _hideSelectionAction.addController(hideSelectionController);
        }
        return _hideSelectionAction;
    }

    private IdeAction createAddToWorkingSetAction() {
        if (_addToWorkingSetAction == null) {
            int commandID = Ide.findOrCreateCmdID((String)"working-set-add-to-working-set");
            String text = Res.getString(21);
            String label = StringUtils.stripMnemonic((String)text);
            String category = MenuManager.getJMenu((String)"Tools").getText();
            char mnemonicKeyCode = Res.getMnemonic(22);
            _addToWorkingSetAction = IdeAction.get((int)commandID, null, (String)label, (String)category, (Integer)new Integer(mnemonicKeyCode), (ResourceBundle)Res.getInstance(), null, null, (boolean)false);
            _addToWorkingSetAction.addController((Controller)new AddToWorkingSetController());
        }
        return _addToWorkingSetAction;
    }

    private IdeAction createManageWorkingSetsAction() {
        if (_manageWorkingSetsAction == null) {
            _manageWorkingSetsAction = this.createAction("working-set-manage-working-sets", Res.getString(19), Res.getInteger(20), null);
            Controller manageWorkingSetsController = new Controller(){

                public boolean handleEvent(IdeAction action, Context context) {
                    WorkingSetSupport.showManageWorkingSetsDialog(context);
                    WorkingSetSupport.this.maybeNotifyActiveProjectChanged(context, WorkingSetSupport.getActiveWorkingSet(context.getWorkspace()));
                    return true;
                }

                public boolean update(IdeAction action, Context context) {
                    action.setEnabled(context.getWorkspace() != null);
                    return true;
                }
            };
            _manageWorkingSetsAction.addController(manageWorkingSetsController);
        }
        return _manageWorkingSetsAction;
    }

    private static void saveWorkingSetChanges(Workspace workspace, Runnable runnable) {
        workspace.applyBatchChanges(runnable);
        try {
            workspace.saveUserProperties();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private WorkingSet getEditableWorkingSet(Workspace workspace) {
        WorkingSet activeWorkingSet;
        if (workspace != null && !WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals((activeWorkingSet = WorkingSetSupport.getActiveWorkingSet(workspace)).getName())) {
            return activeWorkingSet;
        }
        return null;
    }

    private static WorkingSet getActiveWorkingSet(Workspace workspace) {
        return WorkingSets.getInstance((Workspace)workspace).getCurrentWorkingSet();
    }

    private boolean canHide(Context context) {
        return this.canHandleSelection(context, true);
    }

    private boolean canNewFromSelection(Context context) {
        return this.canHandleSelection(context, false);
    }

    private boolean canHandleSelection(Context context, boolean activeWorkingSetMustBeEditable) {
        if (context.getSelection().length == 0) {
            return false;
        }
        Project project = context.getProject();
        if (project == null) {
            return false;
        }
        Workspace workspace = context.getWorkspace();
        if (workspace == null) {
            return false;
        }
        if (activeWorkingSetMustBeEditable && this.getEditableWorkingSet(workspace) == null) {
            return false;
        }
        TNode[] nodes = ExplorerContext.getTNodes((Context)context);
        if (nodes != null) {
            URLPath srcPath = ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs();
            block0: for (int i = 0; i < nodes.length; ++i) {
                TNode ancestor;
                Element dataElement;
                TNode node = nodes[i];
                TreeNode[] pathToNode = node.getPath();
                for (int x = pathToNode.length - 1; x > 0 && !((dataElement = (ancestor = (TNode)pathToNode[x]).getData()) instanceof LibraryFolder); --x) {
                    if (dataElement instanceof Project && context.getSelection().length == 1) {
                        return true;
                    }
                    if (dataElement instanceof Locatable) {
                        URL url = ((Locatable)dataElement).getURL();
                        String pattern = srcPath.toShortestRelativePath(url);
                        if (pattern == null) continue;
                        return true;
                    }
                    if (!(dataElement instanceof RelativeDirectoryContextFolder)) continue;
                    RelativeDirectoryContextFolder df = (RelativeDirectoryContextFolder)dataElement;
                    String relPath = df.getRelativePath();
                    if (relPath == null || relPath.length() <= 0) continue block0;
                    URL url = srcPath.toQualifiedURL(relPath);
                    if (url == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canUnhide(Context context) {
        if (context.getSelection().length == 0) {
            return false;
        }
        Project project = context.getProject();
        if (project == null) {
            return false;
        }
        Workspace workspace = context.getWorkspace();
        if (workspace == null) {
            return false;
        }
        WorkingSet appWorkingSet = this.getEditableWorkingSet(workspace);
        if (appWorkingSet == null) {
            return false;
        }
        PatternFilters patternFilters = appWorkingSet.getPatternFilters(project);
        if (patternFilters == null) {
            return false;
        }
        if (!patternFilters.containsFilters()) {
            return false;
        }
        PatternFilter[] filters = patternFilters.getFilters();
        URLPath srcPath = ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs();
        TNode[] nodes = ExplorerContext.getTNodes((Context)context);
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                URL url;
                RelativeDirectoryContextFolder df;
                String relPath;
                TNode node = nodes[i];
                Element dataElement = node.getData();
                if (dataElement instanceof Project && context.getSelection().length == 1) {
                    boolean noInclude = true;
                    for (int y = 0; y < filters.length; ++y) {
                        if (filters[y].isExclude()) {
                            return true;
                        }
                        if (!noInclude || !"**".equals(filters[y].getPattern())) continue;
                        noInclude = false;
                    }
                    if (noInclude) {
                        return true;
                    }
                }
                if (!(dataElement instanceof RelativeDirectoryContextFolder) || (relPath = (df = (RelativeDirectoryContextFolder)dataElement).getRelativePath()) == null || "".equals(relPath) || (url = srcPath.toQualifiedURL(relPath)) == null) continue;
                if (!patternFilters.isIncluded(relPath)) {
                    return true;
                }
                for (int j = 0; j < filters.length; ++j) {
                    String pttrn = filters[j].getPattern();
                    if (!filters[j].isExclude() || pttrn.indexOf("**") < 0 && !pttrn.startsWith(relPath)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private CompoundPattern[] getPatternsForSelection(Context context) {
        TNode[] nodes = ExplorerContext.getTNodes((Context)context);
        if (nodes != null) {
            Project project = context.getProject();
            ArrayList<CompoundPattern> patterns = new ArrayList<CompoundPattern>();
            for (TNode node : nodes) {
                Element dataElement = node.getData();
                if (dataElement instanceof Locatable) {
                    URL url = ((Locatable)dataElement).getURL();
                    TNode parentTNode = node.getAncestorTNode(RelativeDirectoryContextFolder.class, true);
                    if (parentTNode != null) {
                        RelativeDirectoryContextFolder folder = (RelativeDirectoryContextFolder)parentTNode.getData();
                        String relPath = folder.getRelativePath();
                        if (relPath.length() > 0) {
                            String pattern = relPath + "/" + URLFileSystem.getFileName((URL)url);
                            patterns.add(new CompoundPattern(pattern));
                            continue;
                        }
                        URLPath roots = folder.getRootDirectories();
                        String pattern = roots.toShortestRelativePath(url);
                        if (pattern == null) continue;
                        patterns.add(new CompoundPattern(pattern));
                        continue;
                    }
                    NavigatorWindow navWin = this.getNavigatorWindow();
                    if (navWin == null) continue;
                    URLPath pathsToSearch = this.getRelevantSourceRoots(project, url);
                    for (URL nextURL : pathsToSearch.asList()) {
                        String pattern = new URLPath(nextURL).toRelativePath(url);
                        if (pattern == null) continue;
                        patterns.add(new CompoundPattern(pattern));
                    }
                    continue;
                }
                if (!(dataElement instanceof RelativeDirectoryContextFolder)) continue;
                RelativeDirectoryContextFolder df = (RelativeDirectoryContextFolder)dataElement;
                String relPath = df.getRelativePath();
                CompoundPattern compoundPattern = new CompoundPattern(relPath);
                patterns.add(compoundPattern);
                URLPath allRootDirs = ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs();
                List<String> subs = this.getImpliedSubPatterns(node, relPath, allRootDirs);
                if (subs.size() <= 0) continue;
                compoundPattern.addAdditionalFilter(subs);
            }
            return patterns.toArray(new CompoundPattern[patterns.size()]);
        }
        return new CompoundPattern[0];
    }

    private URLPath getRelevantSourceRoots(Project project, URL url) {
        URLPath paths = new URLPath();
        ProjectContent content = ProjectContent.getInstance((PropertyStorage)project);
        ListStructure contentSetNames = content.getContentSetList();
        Iterator iterator = contentSetNames.iterator();
        while (iterator.hasNext()) {
            String id = iterator.next().toString();
            ContentSet cs = content.getContentSet(id);
            if (cs == null || !cs.canHaveMember(url)) continue;
            for (URL path : cs.getAllRootDirs().asList()) {
                String relPath = new URLPath(path).toRelativePath(url);
                if (relPath == null || relPath.length() <= 0) continue;
                paths.add(path);
            }
        }
        return paths;
    }

    private CompoundPattern[] getUnhidePatternsSelection(Context context) {
        TNode[] nodes = ExplorerContext.getTNodes((Context)context);
        if (nodes != null) {
            Project project = context.getProject();
            URLPath projectSrcPath = ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs();
            ArrayList<CompoundPattern> patterns = new ArrayList<CompoundPattern>();
            for (TNode node : nodes) {
                RelativeDirectoryContextFolder df;
                String relPath;
                URL url;
                Element dataElement = node.getData();
                if (dataElement instanceof Project && context.getSelection().length == 1) {
                    patterns.add(new CompoundPattern("**"));
                    break;
                }
                if (!(dataElement instanceof RelativeDirectoryContextFolder) || (url = projectSrcPath.toQualifiedURL(relPath = (df = (RelativeDirectoryContextFolder)dataElement).getRelativePath())) == null) continue;
                CompoundPattern compoundPattern = new CompoundPattern(relPath);
                patterns.add(compoundPattern);
                List<String> contained = this.getImpliedSubPatterns(node, relPath, projectSrcPath);
                if (contained.size() <= 0) continue;
                compoundPattern.addAdditionalFilter(contained);
            }
            return patterns.toArray(new CompoundPattern[patterns.size()]);
        }
        return new CompoundPattern[0];
    }

    private List<String> getImpliedSubPatterns(TNode tNode, String rootPath, URLPath projectSrcPath) {
        ArrayList<String> implied = new ArrayList<String>();
        boolean shouldBreak = false;
        TNode parent = (TNode)tNode.getParent();
        Enumeration children = parent.getChildTNodes();
        while (children.hasMoreElements()) {
            RelativeDirectoryContextFolder subFolder;
            String subPath;
            URL subURL;
            TNode subnode = (TNode)children.nextElement();
            Element subDataElement = subnode.getData();
            if (subDataElement instanceof Locatable) {
                subDataElement = ((TNode)subnode.getParent()).getData();
            }
            if (!(subDataElement instanceof RelativeDirectoryContextFolder) || (subURL = projectSrcPath.toQualifiedURL(subPath = (subFolder = (RelativeDirectoryContextFolder)subDataElement).getRelativePath())) == null) continue;
            if (subPath.startsWith(rootPath) && !subPath.equals(rootPath)) {
                implied.add(subPath);
                shouldBreak = true;
                continue;
            }
            if (!shouldBreak) continue;
            break;
        }
        return implied;
    }

    private void simplifyFilters(PatternFilters filters) {
        PatternFilter[] allFilters = filters.getFilters();
        if (allFilters.length > 0 && allFilters[0].getPattern().equals("**")) {
            filters.setFilters(new PatternFilter[]{allFilters[0]});
        } else {
            int marker = allFilters.length;
            for (int i = 0; i < allFilters.length; ++i) {
                if (!"**".equals(allFilters[i].getPattern())) continue;
                marker = i + 1;
                break;
            }
            if (marker < allFilters.length) {
                PatternFilter[] simplified = new PatternFilter[marker];
                System.arraycopy(allFilters, 0, simplified, 0, marker);
                filters.setFilters(simplified);
            }
        }
    }

    private static String[] getInitialSelectionPath(Context context) {
        TNode[] nodes = ExplorerContext.getTNodes((Context)context);
        if (nodes != null && nodes.length > 0) {
            RelativeDirectoryContextFolder df;
            String relPath;
            TNode node = nodes[0];
            String fileName = null;
            Element dataElement = node.getData();
            if (dataElement instanceof Locatable) {
                URL url = ((Locatable)dataElement).getURL();
                fileName = "/" + URLFileSystem.getFileName((URL)url);
                TNode parentNode = (TNode)node.getParent();
                if (parentNode != null) {
                    dataElement = parentNode.getData();
                }
            }
            if (dataElement instanceof RelativeDirectoryContextFolder && (relPath = (df = (RelativeDirectoryContextFolder)dataElement).getRelativePath()) != null && relPath.length() > 0) {
                if (fileName != null) {
                    relPath = relPath + fileName;
                }
                return relPath.split("/");
            }
        } else {
            Node node = context.getNode();
            if (node != null) {
                URL url = node.getURL();
                String relPath = ProjectContent.getInstance((PropertyStorage)context.getProject()).getAllContents().getAllRootDirs().toShortestRelativePath(url);
                if (relPath != null && !"".equals(relPath)) {
                    return relPath.split("/");
                }
            }
        }
        return new String[0];
    }

    private Runnable doUnhide(final Context context, final PatternFilters filters, final CompoundPattern[] compoundPatterns, final boolean unhideAll) {
        return new Runnable(){

            @Override
            public void run() {
                if (compoundPatterns.length == 1 && compoundPatterns[0]._primaryFilter.equals("**")) {
                    filters.setFilters(new PatternFilter[0]);
                    filters.addInclude("**");
                    return;
                }
                WorkingSetSupport.this.simplifyFilters(filters);
                int packageDepth = this.getFlatLevel(context);
                ArrayList<PatternFilter> filterList = new ArrayList<PatternFilter>(Arrays.asList(filters.getFilters()));
                int originalSize = filterList.size();
                Iterator filterIterator = filterList.iterator();
                while (filterIterator.hasNext()) {
                    PatternFilter pf = (PatternFilter)filterIterator.next();
                    if (pf.isInclude()) continue;
                    String existingPattern = pf.getPattern();
                    for (CompoundPattern nextPattern : compoundPatterns) {
                        int pos;
                        String toUnhide = nextPattern._primaryFilter;
                        if (existingPattern.equals(toUnhide) || !existingPattern.startsWith(toUnhide)) continue;
                        if (unhideAll || packageDepth == 1) {
                            filterIterator.remove();
                            continue;
                        }
                        if (WorkingSetSupport.this.calculateDepth(existingPattern) <= packageDepth || (pos = existingPattern.indexOf("/**/")) != -1 && pos != toUnhide.length()) continue;
                        filterIterator.remove();
                    }
                }
                if (filterList.size() < originalSize) {
                    PatternFilter[] newFilters = filterList.toArray(new PatternFilter[filterList.size()]);
                    filters.setFilters(newFilters);
                }
                for (int i = 0; i < compoundPatterns.length; ++i) {
                    String includePattern = compoundPatterns[i]._primaryFilter;
                    if (WorkingSetSupport.this.calculateDepth(includePattern) < packageDepth) {
                        includePattern = includePattern + "/*";
                    }
                    filters.addInclude(includePattern, true);
                }
            }

            private int getFlatLevel(Context ctxt) {
                View view = ctxt.getView();
                if (view instanceof ContentFilterCustomizer) {
                    ContentFilterCustomizer navPrefs = (ContentFilterCustomizer)view;
                    Context tempContext = new Context();
                    navPrefs.copyPreferencesTo(tempContext);
                    return tempContext.getInt("flat-level");
                }
                String viewType = view != null ? view.getClass().getName() : "null";
                return Integer.MAX_VALUE;
            }
        };
    }

    private Runnable doAddFilters(final PatternFilters filters, final CompoundPattern[] compoundPatterns, final boolean unhide) {
        return new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < compoundPatterns.length; ++i) {
                    String pattern = compoundPatterns[i]._primaryFilter;
                    if (unhide) {
                        filters.addInclude(pattern, true);
                    } else {
                        filters.addExclude(pattern, true);
                    }
                    if (!compoundPatterns[i].hasAdditionalFilters()) continue;
                    List<String> x = compoundPatterns[i]._secondaryFilters;
                    for (String ptrn : x) {
                        if (unhide) {
                            filters.addExclude(ptrn, true);
                            continue;
                        }
                        filters.addInclude(ptrn, true);
                    }
                }
                WorkingSetSupport.this.simplifyFilters(filters);
            }
        };
    }

    private IdeAction createWorkSetToggleAction(int suffix, String workSetName) {
        IdeAction action = this.createAction(ACTION_WORK_SET_PREFIX + suffix, workSetName, null, null);
        action.addController((Controller)this);
        action.putValue("Name", (Object)workSetName);
        action.putValue("Check", (Object)Boolean.TRUE);
        action.putValue("State", (Object)Boolean.FALSE);
        return action;
    }

    private IdeAction createAction(String cmd, String name, Integer mnemonic, Icon icon) {
        int cmdID = Ide.findOrCreateCmdID((String)cmd);
        return IdeAction.get((int)cmdID, (String)cmd, (String)name, null, (Integer)mnemonic, (Icon)icon, null, (boolean)true);
    }

    private int calculateDepth(String relPath) {
        int count = 1;
        char[] characters = relPath.toCharArray();
        for (int i = 0; i < characters.length; ++i) {
            if (characters[i] != '/') continue;
            ++count;
        }
        return count;
    }

    private static void showManageWorkingSetsDialog(Context context) {
        String title;
        final Workspace workspace = Ide.getActiveWorkspace();
        final Workspace workspaceCopy = (Workspace)workspace.copyTo(null);
        WorkingSetsPanel panel = new WorkingSetsPanel();
        Namespace data = new Namespace();
        data.put("Application", (Object)workspaceCopy);
        Project selectedProject = context.getProject();
        if (selectedProject != null) {
            data.put("Project", (Object)selectedProject);
        }
        data.put("initial-selection", (Object)WorkingSetSupport.getInitialSelectionPath(context));
        ArrayList<Project> projects = new ArrayList<Project>();
        data.put("projects", projects);
        Iterator iter = workspace.getChildren();
        while (iter.hasNext()) {
            Object next = iter.next();
            if (!(next instanceof Project)) continue;
            Project project = (Project)next;
            projects.add(project);
        }
        IdeMainWindow parent = Ide.getMainWindow();
        TDialogLauncher dialogLauncher = new TDialogLauncher((Component)parent, title = Res.getString(44), (Traversable)panel, data);
        if (dialogLauncher.showDialog()) {
            workspace.applyBatchChanges(new Runnable(){

                @Override
                public void run() {
                    workspaceCopy.copyTo((Object)workspace);
                }
            });
            UpdateMessage.fireStructureChanged((Subject)workspace);
            new SaveThread(workspace).start();
        }
    }

    private static void updateWorkingSetsTooltip(String currentWorkingSetName) {
        String mask = WorkingSets.ALL_FILES_WORKING_SET_LABEL.equals(currentWorkingSetName) ? "%s %s" : "%s (%s)";
        WORKING_SET_NON_ACTION.setName(String.format(mask, Res.getString(7), currentWorkingSetName));
    }

    static {
        WORKING_SET_NON_ACTION = new WorkingSetNonAction();
        _workingSetMenu = null;
    }

    private class AddToWorkingSetController
    implements Controller {
        private AddToWorkingSetController() {
        }

        public boolean handleEvent(IdeAction action, Context context) {
            final Project project = context.getProject();
            final Workspace workspace = context.getWorkspace();
            WorkingSet activeWorkingSet = WorkingSetSupport.this.getEditableWorkingSet(workspace);
            Object element = context.getElement() instanceof Locatable ? context.getElement() : context.getNode();
            if (workspace == null || activeWorkingSet == null || !(element instanceof Locatable)) {
                return true;
            }
            if (project != null && project.containsChild(element)) {
                this.addFileToWorkingSet((Element)element, project, workspace, activeWorkingSet);
            } else {
                final IndeterminateProgressMonitor monitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), Res.getString(21), (Object)Res.getString(25), project != null ? project.getShortLabel() : "");
                monitor.setMillisToPopup(0);
                monitor.setCancellable(true);
                monitor.setCloseOnFinish(true);
                final ProgressPanel progressPanel = monitor.getPanel();
                TreeExplorer explorer = WorkingSetSupport.this.getNavigatorWindow() != null ? WorkingSetSupport.this.getNavigatorWindow().getTreeExplorer() : null;
                ExecutorService service = Executors.newSingleThreadExecutor();
                class FindOwningProject
                implements Runnable {
                    final Project[] result = new Project[1];
                    final /* synthetic */ Element val$element;
                    final /* synthetic */ WorkingSet val$activeWorkingSet;
                    final /* synthetic */ TreeExplorer val$explorer;

                    FindOwningProject() {
                        this.val$element = element;
                        this.val$activeWorkingSet = workingSet;
                        this.val$explorer = treeExplorer;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block13: {
                            monitor.start();
                            try {
                                ArrayList<Project> remaining = new ArrayList<Project>();
                                Iterator children = workspace.getChildren();
                                while (children.hasNext() && !monitor.isCanceled()) {
                                    Object child = children.next();
                                    if (child == project || !(child instanceof Project)) continue;
                                    Project nextProject = (Project)child;
                                    if (nextProject.isOpen()) {
                                        if (progressPanel != null) {
                                            progressPanel.setNote(nextProject.getShortLabel());
                                        }
                                        if (!nextProject.containsChild(this.val$element)) continue;
                                        this.result[0] = nextProject;
                                        break;
                                    }
                                    remaining.add(nextProject);
                                }
                                for (Project proj : remaining) {
                                    if (progressPanel != null) {
                                        progressPanel.setNote(proj.getShortLabel());
                                    }
                                    if (proj.containsChild(this.val$element)) {
                                        this.result[0] = proj;
                                        break;
                                    }
                                    if (!monitor.isCanceled()) continue;
                                    break;
                                }
                                if (this.result != null && this.result[0] != null) {
                                    AddToWorkingSetController.this.addFileToWorkingSet(this.val$element, this.result[0], workspace, this.val$activeWorkingSet);
                                    if (this.val$explorer != null) {
                                        class SelectInNavigator
                                        implements Runnable {
                                            SelectInNavigator() {
                                            }

                                            @Override
                                            public void run() {
                                                try {
                                                    TNode tnode;
                                                    TNode projectNode = val$explorer.searchTNodeBreadthFirst((Element)result[0], null);
                                                    if (projectNode != null && (tnode = val$explorer.findTNode(val$element, projectNode)) != null) {
                                                        val$explorer.setSelected(tnode);
                                                    }
                                                }
                                                catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                        }
                                        SwingUtilities.invokeLater(new SelectInNavigator());
                                    }
                                    break block13;
                                }
                                String message = Res.format(24, this.val$element.getShortLabel());
                                if (!monitor.isCanceled()) {
                                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)message, (String)Res.getString(21), (String)"f1_idedaddtoworkingset_html");
                                }
                                Ide.getStatusBar().setText(message);
                            }
                            catch (Exception e) {
                                try {
                                    e.printStackTrace();
                                }
                                catch (Throwable throwable) {
                                    EventQueue.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            monitor.close();
                                        }
                                    });
                                    throw throwable;
                                }
                                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                        }
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                service.submit(new FindOwningProject());
            }
            return true;
        }

        private void addFileToWorkingSet(final Element element, final Project owningProject, Workspace workspace, final WorkingSet activeWorkingSet) {
            WorkingSetSupport.saveWorkingSetChanges(workspace, new Runnable(){

                @Override
                public void run() {
                    PatternFilters patternFilters;
                    boolean added = activeWorkingSet.includeProject(owningProject);
                    if (added) {
                        patternFilters = activeWorkingSet.getOrCreatePatternFilters(owningProject);
                        patternFilters.setFilters(new PatternFilter[0]);
                    } else {
                        patternFilters = activeWorkingSet.getPatternFilters(owningProject);
                    }
                    if (patternFilters != null) {
                        URL url = ((Locatable)element).getURL();
                        for (String relPath : AddToWorkingSetController.this.getPatternFilters(url, owningProject, activeWorkingSet)) {
                            patternFilters.addInclude(relPath);
                        }
                    }
                }
            });
            Ide.getStatusBar().setText(Res.format(23, element.getShortLabel(), activeWorkingSet.getName()));
            UpdateMessage.fireStructureChanged((Subject)workspace);
            NavigatorWindow navigator = WorkingSetSupport.this.getNavigatorWindow();
            if (navigator.isVisible()) {
                TreeExplorer explorer = navigator.getTreeExplorer();
                TNode tnode = explorer.findTNode(element, null);
                explorer.setSelected(tnode);
            }
        }

        public boolean update(IdeAction action, Context context) {
            action.setEnabled(false);
            Element element = context.getElement();
            if (!(element instanceof Locatable)) {
                element = context.getNode();
            }
            if (element == null || !(element instanceof Locatable)) {
                return true;
            }
            Workspace activeWorkspace = context.getWorkspace();
            WorkingSet activeWorkingSet = WorkingSetSupport.this.getEditableWorkingSet(activeWorkspace);
            if (activeWorkspace == null || activeWorkingSet == null) {
                return true;
            }
            Project activeProject = context.getProject();
            if (activeProject == null) {
                action.setEnabled(true);
            } else if (activeProject != null && !activeProject.containsChild(element)) {
                action.setEnabled(activeProject.canAdd(element));
            } else if (activeWorkingSet.isExcluded(activeProject)) {
                action.setEnabled(true);
            } else {
                PatternFilters filters = activeWorkingSet.getPatternFilters(activeProject);
                if (filters == null || !filters.containsFilters()) {
                    action.setEnabled(true);
                } else if (filters != null) {
                    URL url = ((Locatable)element).getURL();
                    URLPath srcPath = WorkingSetSupport.this.getRelevantSourceRoots(activeProject, url);
                    for (URL nextURL : srcPath.asList()) {
                        String relPath = new URLPath(nextURL).toRelativePath(url);
                        if (relPath == null || relPath.length() <= 0 || filters.isIncluded(relPath)) continue;
                        action.setEnabled(true);
                        break;
                    }
                }
            }
            return true;
        }

        private List<String> getPatternFilters(URL url, Project project, WorkingSet activeWorkingSet) {
            PatternFilters filters = activeWorkingSet.getPatternFilters(project);
            if (filters != null) {
                URLPath srcPath = WorkingSetSupport.this.getRelevantSourceRoots(project, url);
                ArrayList<String> paths = new ArrayList<String>(srcPath.size());
                for (URL nextURL : srcPath.asList()) {
                    String relPath = new URLPath(nextURL).toRelativePath(url);
                    if (relPath == null || relPath.length() <= 0 || filters.isIncluded(relPath)) continue;
                    paths.add(relPath);
                }
                return paths;
            }
            return Collections.emptyList();
        }
    }

    private static class SaveThread
    extends Thread {
        private final Workspace _workspace;

        SaveThread(Workspace workspace) {
            this._workspace = workspace;
        }

        @Override
        public void run() {
            try {
                this._workspace.saveUserProperties();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static final class WorkspaceCML
    implements ContextMenuListener,
    Controller {
        private static final String FILTER_APPLICATION_CMD = "oracle.jdevimpl.navigator.WorkingSetSupport.FILTER_APPLICATION";
        private final int _filterApplicationID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.navigator.WorkingSetSupport.FILTER_APPLICATION");
        private final IdeAction _filterApplicationAction = IdeAction.get((int)this._filterApplicationID, (String)"oracle.jdevimpl.navigator.WorkingSetSupport.FILTER_APPLICATION", (String)Res.getString(42), (String)IdeMainWindow.ACTION_CATEGORY_APPLICATION, null, (Icon)OracleIcons.getIcon((String)"small/filter_14.png"), null, (boolean)true);
        private JMenuItem _filterApplicationMenuItem;

        WorkspaceCML() {
            this._filterApplicationAction.addController((Controller)this);
        }

        public void menuWillShow(ContextMenu contextMenu) {
            this.maybeInitMenuItems((MenuManager)contextMenu);
            contextMenu.add((Component)this._filterApplicationMenuItem, MenuConstants.SECTION_SEARCH_CTXT_MENU);
        }

        private void maybeInitMenuItems(MenuManager menuManager) {
            if (this._filterApplicationMenuItem == null) {
                this._filterApplicationMenuItem = menuManager.createMenuItem((ToggleAction)this._filterApplicationAction, MenuConstants.increment((float)MenuConstants.WEIGHT_SEARCH_SHOW_APP_OVERVIEW));
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int id;
            Workspace workspace = context.getWorkspace();
            if (workspace != null && (id = action.getCommandId()) == this._filterApplicationID) {
                WorkingSetSupport.showManageWorkingSetsDialog(context);
                return true;
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            Workspace workspace = context.getWorkspace();
            action.setEnabled(workspace != null);
            return true;
        }
    }

    private static class WorkingSetNonAction
    extends ToggleAction {
        WorkingSetNonAction() {
            super(Res.getString(7), OracleIcons.getIcon((String)"small/filter_14.png"));
            this.putValue("tinyButton", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private static class CompoundPattern {
        String _primaryFilter;
        List<String> _secondaryFilters;

        CompoundPattern(String pattern) {
            this._primaryFilter = pattern;
        }

        public void addAdditionalFilter(List<String> additionalPatterns) {
            if (this._secondaryFilters == null) {
                this._secondaryFilters = new ArrayList<String>();
            }
            this._secondaryFilters.addAll(additionalPatterns);
        }

        public boolean hasAdditionalFilters() {
            return this._secondaryFilters != null && this._secondaryFilters.size() > 0;
        }
    }
}

