/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.jdevimpl.navigator.Res;

final class WorkingSetProjectsPanel
extends DefaultTraversablePanel
implements ActionListener,
TreeCellCheckedListener {
    private final ArrayList<JTreeCellData> _treeCellData = new ArrayList();
    private final CustomJTree _tree;
    private final JCheckBox _cbHideUncheckedProjects;
    private JMutableTreeNode _root;
    private TraversableContext _tc;
    private final SearchField _searchField = new SearchField();
    private final DefaultTreeModel _savedModel;
    private WorkingSet _currentWorkingSet;
    private static final String HIDE_UNCHECKED_PROJECTS_KEY = "hide-unchecked-projects";

    public WorkingSetProjectsPanel() {
        this._tree = new CustomJTree();
        this._savedModel = (DefaultTreeModel)this._tree.getModel();
        this._tree.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this._tree.setShowsRootHandles(false);
        this._tree.setExpandsSelectedPaths(true);
        this._tree.addTreeCellCheckedListener((TreeCellCheckedListener)this);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this._tree);
        this._cbHideUncheckedProjects = new JCheckBox();
        this._cbHideUncheckedProjects.setSelected(true);
        ResourceUtils.resButton((AbstractButton)this._cbHideUncheckedProjects, (String)Res.getString(30));
        this._searchField.setStyle(SearchField.Style.FILTER);
        this._searchField.setPrompt(Res.getString(31));
        this._searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent se) {
                String text = se.isFromClear() ? "" : se.getSearchText();
                WorkingSetProjectsPanel.this.applyTreeFilter(text);
            }

            public void searchCategoryChanged(SearchEvent se) {
            }
        });
        JScrollPane sp = new JScrollPane();
        sp.getViewport().add((Component)this._tree);
        this.setLayout(new GridBagLayout());
        this.add((Component)this._searchField, this.gbc(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0)));
        this.add(sp, this.gbc(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0)));
        this.add(this._cbHideUncheckedProjects, this.gbc(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5)));
    }

    void addTreeSelectionListener(TreeSelectionListener tsl) {
        this._tree.addTreeSelectionListener(tsl);
    }

    public void onEntry(TraversableContext tc) {
        this._tc = tc;
        Workspace workspace = (Workspace)tc.find("Application");
        HashStructure userProps = workspace.getUserPropertiesOnly();
        if (userProps != null && userProps.containsKey(HIDE_UNCHECKED_PROJECTS_KEY)) {
            this._cbHideUncheckedProjects.setSelected(userProps.getBoolean(HIDE_UNCHECKED_PROJECTS_KEY));
        }
        this._cbHideUncheckedProjects.addActionListener(this);
        boolean hideUncheckedProjects = this._cbHideUncheckedProjects.isSelected();
        JTreeCellData rootCell = new JTreeCellData(workspace.getIcon(), URLFileSystem.getName((URL)workspace.getURL()), true);
        rootCell.setUserObject((Object)workspace);
        rootCell.setToolTipText(URLFileSystem.getPlatformPathName((URL)workspace.getURL()));
        this._root = new JMutableTreeNode(rootCell);
        this._currentWorkingSet = WorkingSets.getInstance((Workspace)workspace).getCurrentWorkingSet();
        int numProjects = 0;
        int numProjectsSelected = 0;
        this._treeCellData.clear();
        ArrayList projects = (ArrayList)tc.get("projects");
        for (Project project : projects) {
            boolean checked;
            ++numProjects;
            String label = project.getShortLabel();
            int lastDot = label.lastIndexOf(46);
            label = lastDot > 0 ? label.substring(0, lastDot) : label;
            JTreeCellData cell = new JTreeCellData(project.getIcon(), label, true);
            cell.setToolTipText(URLFileSystem.getPlatformPathName((URL)project.getURL()));
            cell.setUserObject((Object)project);
            if (this._currentWorkingSet.isIncluded(project)) {
                checked = true;
                ++numProjectsSelected;
            } else {
                checked = false;
            }
            if (!checked && hideUncheckedProjects) continue;
            cell.setCheckBoxState(checked);
            this._treeCellData.add(cell);
        }
        Collections.sort(this._treeCellData);
        Project selectedProject = (Project)tc.find("Project");
        int selectedRow = 0;
        for (int i = 0; i < this._treeCellData.size(); ++i) {
            JTreeCellData tcd = this._treeCellData.get(i);
            this._root.add(tcd);
            Object userObject = tcd.getUserObject();
            Project userObjectProject = (Project)userObject;
            if (selectedProject == null || !userObjectProject.getURL().equals(selectedProject.getURL())) continue;
            selectedRow = i + 1;
        }
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        model.setRoot((TreeNode)this._root);
        this._root.updateNodes();
        this._tree.setSelectionRow(selectedRow);
        this._tree.scrollRowToVisible(selectedRow);
    }

    public void onExit(TraversableContext tc) {
        this._cbHideUncheckedProjects.removeActionListener(this);
        Workspace workspace = (Workspace)tc.find("Application");
        HashStructure userProps = workspace.getUserPropertiesOnly();
        if (userProps != null) {
            userProps.putBoolean(HIDE_UNCHECKED_PROJECTS_KEY, this._cbHideUncheckedProjects.isSelected());
        }
        this._tree.setSelectionRow(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._tc != null) {
            TreePath path = this._tree.getSelectionPath();
            this.onExit(this._tc);
            this.storeSelectedProjectInContext(path, this._tc);
            this.onEntry(this._tc);
        }
    }

    private void storeSelectedProjectInContext(TreePath path, TraversableContext context) {
        if (path != null) {
            JMutableTreeNode treeNode = (JMutableTreeNode)path.getLastPathComponent();
            JTreeCellData cellData = (JTreeCellData)treeNode.getUserObject();
            Object userObject = cellData.getUserObject();
            Project project = null;
            if (userObject instanceof Project) {
                project = (Project)userObject;
            }
            context.put("Project", (Object)project);
        }
    }

    public void cellChecked(TreeCellCheckedEvent e) {
        this.cellCheckedUnchecked(e, true);
    }

    public void cellUnchecked(TreeCellCheckedEvent e) {
        this.cellCheckedUnchecked(e, false);
    }

    private void cellCheckedUnchecked(TreeCellCheckedEvent e, boolean checked) {
        JMutableTreeNode treeNode = (JMutableTreeNode)e.getSource();
        JTreeCellData cellData = (JTreeCellData)treeNode.getUserObject();
        Object userObject = cellData.getUserObject();
        if (userObject instanceof Project) {
            Project project = (Project)userObject;
            if (checked) {
                this._currentWorkingSet.includeProject(project);
            } else {
                this._currentWorkingSet.excludeProject(project);
            }
        } else if (userObject instanceof Workspace) {
            Project project;
            this._currentWorkingSet.includeAllProjects();
            Workspace workspace = (Workspace)this._tc.find("Application");
            if (workspace != null) {
                Iterator iter = workspace.getChildren();
                while (iter.hasNext()) {
                    Object childObj = iter.next();
                    if (!(childObj instanceof Project)) continue;
                    project = (Project)childObj;
                    this._currentWorkingSet.excludeProject(project);
                }
            }
            Enumeration iter = this._root.children();
            while (iter.hasMoreElements()) {
                JMutableTreeNode node = (JMutableTreeNode)iter.nextElement();
                JTreeCellData projectCellData = node.getModel();
                if (!projectCellData.getCheckBoxState().isTrue()) continue;
                project = (Project)node.getModel().getUserObject();
                this._currentWorkingSet.includeProject(project);
            }
        }
    }

    private void applyTreeFilter(String filterText) {
        TreePath selected = this._tree.getSelectionPath();
        if ((filterText == null || filterText.length() == 0) && this._savedModel != null) {
            this._tree.setModel((TreeModel)this._savedModel);
            this._root.updateNodes();
        } else {
            SearchMatcher matcher = SearchMatcher.getSubstringMatcher((CharSequence)filterText, (boolean)true);
            JMutableTreeNode root = this.cloneTree(this._root);
            WorkingSetProjectsPanel.filter(root, matcher);
            this._tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
            for (int i = 1; i < this._tree.getRowCount(); ++i) {
                TreePath path = this._tree.getPathForRow(i);
                DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (!matcher.matches((CharSequence)String.valueOf(last))) continue;
                this._tree.setSelectionRow(i);
                this._tree.scrollRowToVisible(i);
                root.updateNodes();
                return;
            }
            if (this._tree.getRowCount() > 0) {
                root.updateNodes();
            }
        }
        if (selected != null) {
            String name = String.valueOf(selected.getLastPathComponent());
            for (int i = 1; i < this._tree.getRowCount(); ++i) {
                TreePath path = this._tree.getPathForRow(i);
                DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (!name.equals(String.valueOf(last))) continue;
                this._tree.setSelectionRow(i);
                this._tree.scrollRowToVisible(i);
                break;
            }
        }
        if (this._tree.getSelectionPath() == null) {
            int count = this._tree.getRowCount();
            this._tree.setSelectionRow(count > 1 ? 1 : 0);
        }
    }

    private JMutableTreeNode cloneTree(JMutableTreeNode root) {
        if (root != null) {
            JMutableTreeNode newRoot = new JMutableTreeNode(root.getModel(), root.getAllowsChildren());
            for (int i = 0; i < root.getChildCount(); ++i) {
                JMutableTreeNode child = (JMutableTreeNode)root.getChildAt(i);
                JMutableTreeNode newChild = this.cloneTree(child);
                if (newChild == null) continue;
                newRoot.add((MutableTreeNode)newChild);
            }
            return newRoot;
        }
        return null;
    }

    private static boolean filter(JMutableTreeNode root, SearchMatcher matcher) {
        boolean matchingChildren = false;
        ArrayList<Integer> nodesToRemove = new ArrayList<Integer>();
        for (int i = 0; i < root.getChildCount(); ++i) {
            JMutableTreeNode child = (JMutableTreeNode)root.getChildAt(i);
            if (WorkingSetProjectsPanel.filter(child, matcher)) {
                matchingChildren = true;
                continue;
            }
            nodesToRemove.add(i);
        }
        int removedCount = 0;
        Iterator i$ = nodesToRemove.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            root.remove(i - removedCount++);
        }
        if (matchingChildren) {
            return true;
        }
        return matcher.matches((CharSequence)String.valueOf(root.getModel().getText()));
    }
}

