/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.explorer.ChildFilterHelper;
import oracle.ide.model.Project;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdevimpl.navigator.LibraryFolder;

final class LibraryFilter
extends ChildFilterHelper {
    LibraryFilter() {
    }

    public void initChildren(Context context, List children) {
        if (context.getBoolean("show-libs")) {
            Project project = context.getProject();
            JDK jdk = JProjectLibraries.getInstance((PropertyStorage)project).getJDK();
            if (jdk != null) {
                children.add(new LibraryFolder(context, jdk));
            }
            ArrayList libDefs = LibraryFilter.getLibraries(project);
            for (JLibrary lib : libDefs) {
                children.add(new LibraryFolder(context, lib));
            }
        }
    }

    private static ArrayList getLibraries(Project project) {
        JLibrary[] libs;
        ArrayList<JLibrary> libDefs = new ArrayList<JLibrary>();
        JProjectLibraries projLibs = JProjectLibraries.getInstance((PropertyStorage)project);
        if (projLibs != null && (libs = projLibs.getLibraries()) != null) {
            for (JLibrary lib : libs) {
                libDefs.add(lib);
            }
        }
        return libDefs;
    }
}

