/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.util.EnumSet;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Element;
import oracle.ide.model.NodeUtil;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorInit;
import oracle.ide.navigator.NavigatorInitFactory;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorManager;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;

final class GeneralSupport
extends NavigatorInit {
    private Controller _controller;

    static void init(ProjectNavigatorManager navMan) {
        navMan.addNavigatorInit(new NavigatorInitFactory(GeneralSupport.class));
    }

    protected GeneralSupport(NavigatorWindow navWin, Context context) {
        super(navWin, context);
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new Controller(){

                public boolean handleEvent(IdeAction action, Context context) {
                    GeneralSupport.reloadNodes();
                    return false;
                }

                public boolean update(IdeAction action, Context context) {
                    int cmdId = action.getCommandId();
                    if (cmdId == 21) {
                        Element sel = context.getElement();
                        boolean isWorkspaceOrProject = sel instanceof Workspace || sel instanceof Project;
                        action.setEnabled(isWorkspaceOrProject);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this._controller;
    }

    private static void reloadNodes() {
        Ide.getMainWindow().reloadNodes(Ide.getEnvironOptions().getSilentReload() ? EnumSet.of(NodeUtil.ReloadMode.SILENT_RELOAD, NodeUtil.ReloadMode.RELOAD_PROMPTED_IF_DIRTY) : EnumSet.of(NodeUtil.ReloadMode.RELOAD_PROMPTED_IF_DIRTY));
    }

    public void initToolbar(Toolbar toolbar) {
        NavigatorWindow view = this.getNavigatorWindow();
        this.addAction(35, toolbar, (View)view, OracleIcons.getIcon((String)"small/settings_14.png"));
        this.addAction(51, toolbar, (View)view, OracleIcons.getIcon((String)"small/refresh_14.png"));
    }

    private IdeAction addAction(int id, Toolbar toolbar, View view, Icon icon) {
        IdeAction action = IdeAction.find((int)id);
        if (action != null) {
            IdeAction localAction = action.newLocalAction(view);
            localAction.putValueDirectly("SmallIcon", (Object)icon);
            localAction.putValueDirectly("tinyButton", (Object)Boolean.TRUE);
            toolbar.add((ToggleAction)localAction);
            return localAction;
        }
        return null;
    }
}

