/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.explorer.ChildFilterHelper;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.jdevimpl.navigator.FileNameComparator;

final class ApplicationsFilter
extends ChildFilterHelper {
    private static final FileNameComparator _comparator = new FileNameComparator();

    ApplicationsFilter() {
    }

    public void initChildren(Context context, List children) {
        Workspaces workspacesObj = Ide.getWorkspaces();
        if (workspacesObj != null) {
            ArrayList workspaces = new ArrayList();
            Iterator iter = workspacesObj.getChildren();
            while (iter.hasNext()) {
                workspaces.add(iter.next());
            }
            Collections.sort(workspaces, _comparator);
            children.addAll(workspaces);
        }
    }

    public boolean handleChildrenAdded(Context context, List children, TNode parent, TreeExplorer tree) {
        int numAdded = 0;
        if (parent instanceof MutableTreeNode) {
            MutableTreeNode parentMTN = (MutableTreeNode)parent;
            for (Object next : children) {
                int cmp;
                TNode childTNode;
                Element childData;
                TreeNode childObj;
                int i;
                if (!(next instanceof Workspace)) continue;
                Workspace addedWorkspace = (Workspace)next;
                int n = parent.getChildCount();
                for (i = 0; !(i >= n || (childObj = parent.getChildAt(i)) instanceof TNode && (childData = (childTNode = (TNode)childObj).getData()) instanceof Workspace && (cmp = _comparator.compare(addedWorkspace, childData)) < 0); ++i) {
                }
                parentMTN.insert((MutableTreeNode)tree.createTNode((Element)addedWorkspace), i);
                ++numAdded;
            }
        }
        return numAdded > 0;
    }

    public boolean handleChildrenRemoved(Context context, List children, TNode parent, TreeExplorer tree) {
        int numRemoved = 0;
        if (parent instanceof MutableTreeNode) {
            MutableTreeNode parentMTN = (MutableTreeNode)parent;
            block0: for (int i = parent.getChildCount() - 1; i >= 0; --i) {
                TreeNode childObj = parent.getChildAt(i);
                if (!(childObj instanceof TNode)) continue;
                TNode childTNode = (TNode)childObj;
                Element childDataObj = childTNode.getData();
                Iterator iter = children.iterator();
                while (iter.hasNext()) {
                    if (childDataObj != iter.next()) continue;
                    parentMTN.remove(i);
                    ++numRemoved;
                    continue block0;
                }
            }
        }
        return numRemoved > 0;
    }
}

