/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.explorer.CellRendererAttributes;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Folder;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.navigator.ProjectNavigatorManager;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.navigator.WorkspacesWrapper;

final class ApplicationNavigatorManager
extends ProjectNavigatorManager {
    private static final String SHOW_NAVIGATOR_CMD = "Ide.APP_NAVIGATOR_CMD_ID";
    private static final String NAVIGATOR_DEFAULT_NAME = "ApplicationNavigatorName";
    private static final String NAVIGATOR_WINDOW_ID = "ApplicationNavigatorWindow";
    private Folder _rootFolder;

    ApplicationNavigatorManager() {
    }

    public void initialize() {
        super.initialize();
        Menubar menuMgr = Ide.getMenubar();
        JMenuItem navigateMenuItem = this.createNavigateMenuItem();
        JMenu navigateMenu = MenuManager.getJMenu((String)"Navigate");
        menuMgr.add((Component)navigateMenuItem, navigateMenu, MenuConstants.SECTION_NAVIGATE_SELECT);
        IdeAction showAction = this.getShowAction();
        JMenuItem navigatorMenuItem = menuMgr.createMenuItem((ToggleAction)showAction, MenuConstants.WEIGHT_VIEW_APPLICATION_NAVIGATOR + 0.001f);
        JMenu viewMenu = MenuManager.getJMenu((String)"View");
        menuMgr.add((Component)navigatorMenuItem, viewMenu, MenuConstants.SECTION_VIEW_ALPHABETIZED_VIEWS);
    }

    protected String getViewCategory() {
        return NAVIGATOR_WINDOW_ID;
    }

    protected String getAcceleratorFile() {
        return "oracle/ideimpl/navigator/an-accelerators.xml";
    }

    protected String getDefaultName() {
        return NAVIGATOR_DEFAULT_NAME;
    }

    protected IdeAction createShowNavigatorAction() {
        return IdeAction.get((int)64, (String)AddinManager.getAddinManager().getCommand(64, "oracle.ide.cmd.NotImplementedCommand"), (String)IdeArb.getString((int)160), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)IdeArb.getInteger((int)161), (ArrayResourceBundle)IdeArb.getInstance(), (int)162, null, (boolean)true);
    }

    protected DockingParam createNavigatorDockingParam() {
        DockingParam param = new DockingParam();
        ExplorerManager mgr = ExplorerManager.getExplorerManager();
        Dockable host = null;
        if (mgr != null) {
            ViewId id = mgr.getDefaultViewId();
            host = DockStation.getDockStation().findDockable(id);
        }
        param.setPosition(host, 2, 0);
        return param;
    }

    protected float getToggleToolbarMenuWeight() {
        return MenuConstants.WEIGHT_VIEW_APPLICATION_NAVIGATOR;
    }

    protected IdeAction createToggleToolbarAction() {
        return null;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_ideapplicationnavigator_html");
    }

    protected void configureNavigator(NavigatorWindow navigator) {
        super.configureNavigator(navigator);
        if (!navigator.isUsingDrawer()) {
            navigator.getGUI();
            int flag = 0;
            navigator.getTreeExplorer().getCellRendererAttributes().set(flag |= CellRendererAttributes.HIDE_FILE_EXTENSIONS);
        }
    }

    protected NavigatorWindow createNavigatorWindow() {
        return this.createNavigatorWindow(this.getRootFolder(), false, 5);
    }

    private Folder getRootFolder() {
        if (this._rootFolder == null) {
            this._rootFolder = new WorkspacesWrapper(ModelArb.getString((int)42), OracleIcons.getIcon((String)"applications.png"));
        }
        return this._rootFolder;
    }

    private JMenuItem createNavigateMenuItem() {
        IdeAction action = IdeAction.get((int)57, (String)"oracle.ide.cmd.NotImplementedCommand", (String)IdeArb.getString((int)352));
        return Ide.getMenubar().createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_NAVIGATE_SELECT_IN_NAVIGATOR);
    }
}

