/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.navigator;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.explorer.ChildFilterFactory;
import oracle.ide.explorer.ChildFilterHelper;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.ContentFilterFactory;
import oracle.ide.model.ContentSetFilter;
import oracle.ide.model.Element;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.panels.PropertiesDialog;
import oracle.ide.navigator.ContentSetSupport;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.ProjectNavigatorManager;
import oracle.ide.resource.IdeArb;
import oracle.ideimpl.IdeMenus;
import oracle.ideri.navigator.DefaultNavigatorWindow;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.controller.MenuAwareLabelUpdater;
import oracle.jdevimpl.navigator.ApplicationFilter;
import oracle.jdevimpl.navigator.ApplicationNavigatorManager;
import oracle.jdevimpl.navigator.ApplicationsFilter;
import oracle.jdevimpl.navigator.CategorySupport;
import oracle.jdevimpl.navigator.CompositeNodeSupport;
import oracle.jdevimpl.navigator.GeneralSupport;
import oracle.jdevimpl.navigator.LibraryFilter;
import oracle.jdevimpl.navigator.LibrarySupport;
import oracle.jdevimpl.navigator.Res;
import oracle.jdevimpl.navigator.WorkingSetSupport;
import oracle.jdevimpl.navigator.WorkspacesWrapper;

public final class ApplicationNavigatorAddin
implements Addin {
    private static final String ERASE_APPLICATION_CMD = "oracle.jdevimpl.navigator.ApplicationNavigatorAddin.ERASE_APPLICATION";

    public void initialize() {
        ApplicationNavigatorManager nav = new ApplicationNavigatorManager();
        NavigatorManager.setApplicationNavigatorManager((NavigatorManager)nav);
        NavigatorManager.setWorkspaceNavigatorManager((NavigatorManager)nav);
        ApplicationNavigatorAddin.initNavigator(nav, true, true, true);
        nav.addContextMenuListener(new WorkspaceCML(), Workspace.class);
        Menubar menubar = Ide.getMenubar();
        JMenu fileMenu = Menubar.getJMenu((String)"File");
        if (fileMenu != null) {
            IdeAction action = IdeActions.getFileRemoveFromDiskAction();
            JMenuItem menuItem = menubar.createMenuItem((ToggleAction)action);
            menubar.add((Component)menuItem, fileMenu, MenuConstants.SECTION_FILE_CLOSE);
        }
        KeyStrokeContextRegistry contextRegistry = Ide.getKeyStrokeContextRegistry();
        contextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/navigator/navigatoraccelerators.xml");
    }

    static final void initNavigator(ProjectNavigatorManager nav, boolean supportsWorkingSets, boolean showContentSetNames, boolean enableContentLevelFilters) {
        ContentFilterFactory projectFilterFactory = new ContentFilterFactory(Project.class);
        projectFilterFactory.addChildFilterHelper((ChildFilterHelper)new ContentSetFilter());
        projectFilterFactory.addChildFilterHelper((ChildFilterHelper)new LibraryFilter());
        nav.registerFilter(Project.class, (ChildFilterFactory)projectFilterFactory);
        try {
            ContentFilterFactory applicationFilterFactory = new ContentFilterFactory(Workspace.class);
            applicationFilterFactory.addChildFilterHelper((ChildFilterHelper)new ApplicationFilter());
            nav.registerFilter(Workspace.class, (ChildFilterFactory)applicationFilterFactory);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ContentFilterFactory applicationsFilterFactory = new ContentFilterFactory(WorkspacesWrapper.class);
        applicationsFilterFactory.addChildFilterHelper((ChildFilterHelper)new ApplicationsFilter());
        nav.registerFilter(WorkspacesWrapper.class, (ChildFilterFactory)applicationsFilterFactory);
        GeneralSupport.init(nav);
        ContentSetSupport.init((ProjectNavigatorManager)nav);
        LibrarySupport.init(nav);
        if (supportsWorkingSets) {
            WorkingSetSupport.init(nav);
        }
        if (showContentSetNames) {
            CategorySupport.init(nav);
        }
        if (enableContentLevelFilters) {
            CompositeNodeSupport.init(nav);
        }
        nav.initialize();
    }

    private static Context newWorkspaceContext(Context baseContext) {
        Context context = new Context(baseContext);
        Workspace workspace = baseContext.getWorkspace();
        context.setNode((Node)workspace);
        context.setElement((Element)workspace);
        context.setProject(null);
        return context;
    }

    private static class MenuLabelHandler
    extends MenuAwareLabelUpdater {
        MenuLabelHandler() {
            super("");
        }

        @Override
        protected String disabledMenuSpecificLabel(IdeAction action, String originalLabel) {
            return this.enabledMenuSpecificLabel(action, originalLabel);
        }

        @Override
        protected String enabledMenuSpecificLabel(IdeAction action, String originalLabel) {
            String command = action.getCommand();
            if (command.equals("oracle.jdevimpl.navigator.ApplicationNavigatorAddin.CLOSE_APPLICATION")) {
                return Res.getString(32);
            }
            if (command.equals("oracle.jdevimpl.navigator.ApplicationNavigatorAddin.RENAME_APPLICATION")) {
                return Res.getString(38);
            }
            if (command.equals(ApplicationNavigatorAddin.ERASE_APPLICATION_CMD)) {
                return Res.getString(49);
            }
            return originalLabel;
        }

        @Override
        protected boolean matchMenu(EventObject event) {
            Object source;
            if (event != null && (source = event.getSource()) instanceof JMenu) {
                JMenu jMenu;
                JMenu appMenu = IdeMenus.findJMenu((String)"APPLICATION_MENU");
                return appMenu == (jMenu = (JMenu)source);
            }
            return false;
        }
    }

    private static final class WorkspaceCML
    implements ContextMenuListener,
    Controller {
        private static final String CLOSE_APPLICATION_CMD = "oracle.jdevimpl.navigator.ApplicationNavigatorAddin.CLOSE_APPLICATION";
        private final int _closeApplicationID;
        private final IdeAction _closeApplicationAction;
        private JMenuItem _closeApplicationMenuItem;
        private final int _eraseApplicationID;
        private final IdeAction _eraseApplicationAction;
        private JMenuItem _eraseApplicationMenuItem;
        private static final String RENAME_APPLICATION_CMD = "oracle.jdevimpl.navigator.ApplicationNavigatorAddin.RENAME_APPLICATION";
        private final int _renameApplicationID;
        private final IdeAction _renameApplicationAction;
        private JMenuItem _renameApplicationMenuItem;
        private static final String APPLICATION_PROPERTIES_CMD = "oracle.jdevimpl.navigator.ApplicationNavigatorAddin.APPLICATION_PROPERTIES";
        private final int _applicationPropertiesID;
        private final IdeAction _applicationPropertiesAction;
        private JMenuItem _applicationPropertiesMenuItem;

        WorkspaceCML() {
            MenuLabelHandler labelUpdater = new MenuLabelHandler();
            String appicationCategory = Res.getString(50);
            this._closeApplicationID = Ide.findOrCreateCmdID((String)CLOSE_APPLICATION_CMD);
            this._closeApplicationAction = IdeAction.get((int)this._closeApplicationID, (String)CLOSE_APPLICATION_CMD, (String)Res.getString(33), (String)appicationCategory, (Integer)Res.getInteger(34), null, null, (boolean)false);
            this._closeApplicationAction.addController((Controller)this);
            this._closeApplicationAction.setLabelUpdater((LabelUpdater)labelUpdater);
            this._eraseApplicationID = Ide.findOrCreateCmdID((String)ApplicationNavigatorAddin.ERASE_APPLICATION_CMD);
            this._eraseApplicationAction = IdeAction.get((int)this._eraseApplicationID, (String)ApplicationNavigatorAddin.ERASE_APPLICATION_CMD, (String)Res.getString(47), (String)appicationCategory, (Integer)Res.getInteger(48), (Icon)OracleIcons.getIcon((String)"deleteApplication.png"), null, (boolean)false);
            this._eraseApplicationAction.addController((Controller)this);
            this._eraseApplicationAction.setLabelUpdater((LabelUpdater)labelUpdater);
            this._renameApplicationID = Ide.findOrCreateCmdID((String)RENAME_APPLICATION_CMD);
            this._renameApplicationAction = IdeAction.get((int)this._renameApplicationID, (String)RENAME_APPLICATION_CMD, (String)Res.getString(36), (String)appicationCategory, (Integer)Res.getInteger(37), null, null, (boolean)false);
            this._renameApplicationAction.addController((Controller)this);
            this._renameApplicationAction.setLabelUpdater((LabelUpdater)labelUpdater);
            this._applicationPropertiesID = Ide.findOrCreateCmdID((String)APPLICATION_PROPERTIES_CMD);
            this._applicationPropertiesAction = IdeAction.get((int)this._applicationPropertiesID, (String)APPLICATION_PROPERTIES_CMD, (String)Res.getString(40), (String)appicationCategory, (Integer)Res.getInteger(41), null, null, (boolean)false);
            this._applicationPropertiesAction.addController((Controller)this);
            IdeActions.getEditPropertiesAction().addController((Controller)this);
        }

        public void menuWillShow(ContextMenu contextMenu) {
            this.maybeInitMenuItems((MenuManager)contextMenu);
            contextMenu.add((Component)this._closeApplicationMenuItem, 1.0f);
            contextMenu.add((Component)this._renameApplicationMenuItem, 1.0f);
            contextMenu.add((Component)this._eraseApplicationMenuItem, 1.0f);
            PropertiesDialog applicationPropertiesDialog = PropertiesDialog.getInstance((String)"Application");
            if (applicationPropertiesDialog.hasPanel()) {
                contextMenu.add((Component)this._applicationPropertiesMenuItem, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        private void maybeInitMenuItems(MenuManager menuManager) {
            if (this._closeApplicationMenuItem == null) {
                this._closeApplicationMenuItem = menuManager.createMenuItem((ToggleAction)this._closeApplicationAction, MenuConstants.WEIGHT_FILE_CLOSE);
                this._eraseApplicationMenuItem = menuManager.createMenuItem((ToggleAction)this._eraseApplicationAction, MenuConstants.WEIGHT_FILE_CLOSE_IMPLICT);
                this._eraseApplicationMenuItem.setIcon(IdeArb.getIcon((int)103));
                this._renameApplicationMenuItem = menuManager.createMenuItem((ToggleAction)this._renameApplicationAction, MenuConstants.WEIGHT_FILE_RENAME);
                this._applicationPropertiesMenuItem = menuManager.createMenuItem((ToggleAction)this._applicationPropertiesAction, MenuConstants.WEIGHT_EDIT_PROPERTIES);
            }
        }

        public boolean handleEvent(IdeAction action, Context context) {
            Workspace workspace = context.getWorkspace();
            if (workspace == null) {
                workspace = Ide.getActiveWorkspace();
            }
            if (workspace == null) {
                return false;
            }
            int id = action.getCommandId();
            if (id == this._closeApplicationID) {
                try {
                    IdeActions.getFileCloseAction().performAction(ApplicationNavigatorAddin.newWorkspaceContext(context));
                }
                catch (Exception e) {}
            } else if (id == this._eraseApplicationID) {
                IdeAction eraseAction = IdeActions.getFileRemoveFromDiskAction();
                try {
                    Context contextForRemoval = ApplicationNavigatorAddin.newWorkspaceContext(context);
                    eraseAction.performAction(contextForRemoval);
                }
                catch (Exception e) {}
            } else if (id == this._renameApplicationID) {
                IdeAction renameAction = IdeActions.getFileRenameAction();
                try {
                    Context contextForRename = ApplicationNavigatorAddin.newWorkspaceContext(context);
                    renameAction.performAction(contextForRename);
                }
                catch (Exception e) {}
            } else if (id == this._applicationPropertiesID || id == 56 && context.getView() instanceof DefaultNavigatorWindow && context.getWorkspace() != null && context.getNode() instanceof Workspace) {
                PropertiesDialog dialog = PropertiesDialog.getInstance((String)"Application");
                Context contextForDialog = ApplicationNavigatorAddin.newWorkspaceContext(context);
                dialog.showDialog(contextForDialog, (HashStructureNode)workspace);
            } else {
                return false;
            }
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            int id = action.getCommandId();
            if (id == this._closeApplicationID || id == this._eraseApplicationID || id == this._renameApplicationID || id == this._applicationPropertiesID) {
                Workspace workspace = context.getWorkspace();
                action.setEnabled(workspace != null);
            } else if (id == 56 && context.getView() instanceof DefaultNavigatorWindow && context.getWorkspace() != null && context.getNode() instanceof Workspace) {
                action.setEnabled(true);
            } else {
                return false;
            }
            return true;
        }
    }
}

