/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc.audit.transform;

import java.util.List;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.doc.SourceDocBlockTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTagName;
import oracle.jdeveloper.audit.java.JavaTransformContext;
import oracle.jdeveloper.audit.service.Localizer;
import oracle.jdevimpl.javadoc.audit.transform.AbstractDocFix;

public class TagSpellingFix
extends AbstractDocFix {
    public static final String PROPERTY_CORRECTION = "Correction";

    public TagSpellingFix(Localizer localizer) {
        super("tag-correct-spelling", localizer);
    }

    public void apply(JavaTransformContext context, SourceDocTag construct) {
        SourceElement parent = construct.getParent();
        if (parent instanceof SourceDocComment) {
            String tagName = (String)context.getParameter(PROPERTY_CORRECTION);
            String tagText = construct.getArgumentText();
            SourceFactory factory = context.getSourceFactory();
            SourceDocTagName name = factory.createDocTagName(tagName);
            SourceDocDescription desc = factory.createDocDescription(factory.createDocTextFragment(tagText));
            SourceDocBlockTag renamedTag = factory.createDocBlockTag(name, desc);
            SourceDocComment comment = (SourceDocComment)parent;
            List existingTags = comment.getBlockTags();
            int index = existingTags.indexOf(construct);
            existingTags.add(index, renamedTag);
            construct.removeSelf();
        }
    }
}

