/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javadoc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.javadoc.JavadocSettings;
import oracle.jdeveloper.javadoc.TagDescriptor;
import oracle.jdevimpl.javadoc.JavadocArb;

public class JavadocOptionsPanel
extends DefaultTraversablePanel {
    private JButton _addButton;
    private JButton _downButton;
    private JButton _removeButton;
    private JButton _upButton;
    private JCheckBox _hasFieldScope;
    private JCheckBox _hasMethodScope;
    private JCheckBox _hasClassScope;
    private JCheckBox _isRequired;
    private JLabel _templateLabel;
    private JLabel _listLabel;
    private JWrappedLabel _previewLabel;
    private JLabel _previewItemLabel;
    private JLabel _usageLabel;
    private JLabel _tagNameLabel;
    private JLabel _tagPropertiesLabel;
    private JList _tagList;
    private JScrollPane _scroller;
    private JTextField _templateText;
    private JTextField _tagNameText;
    private JLabel _feedbackLabel;
    private TagDescriptor _selectedTD;
    private TagListModel _listModel;
    private boolean _listIsUpdating;
    private boolean _modelIsUpdating;

    public JavadocOptionsPanel() {
        this.setHelpID("f1_jed_javadoc_prefs_html");
        this.initializeComponent();
        this.addListeners();
    }

    public void onEntry(TraversableContext tc) {
        JavadocSettings options = this.findOptions(tc);
        this.loadSettingsFrom(options);
        this._tagList.setSelectedIndex(0);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        JavadocSettings options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private JavadocSettings findOptions(TraversableContext tc) {
        JavadocSettings options = (JavadocSettings)tc.find("JavadocSettings");
        return options;
    }

    void loadSettingsFrom(JavadocSettings options) {
        ArrayList tags = (ArrayList)options.getTagList();
        this._listModel = new TagListModel(tags);
        this._tagList.setModel(this._listModel);
    }

    void saveSettingsTo(JavadocSettings options) throws TraversalException {
        ListModel model = this._tagList.getModel();
        int size = model.getSize();
        ArrayList<TagDescriptor> tags = new ArrayList<TagDescriptor>(size);
        for (int i = 0; i < size; ++i) {
            TagDescriptor tagDescriptor = (TagDescriptor)model.getElementAt(i);
            if (tagDescriptor.getName().length() <= 1) continue;
            tags.add(tagDescriptor);
        }
        options.setTagList(tags);
    }

    private void addListeners() {
        InteractionListener _interactionListener = new InteractionListener();
        this._tagList.addListSelectionListener(_interactionListener);
        this._tagNameText.getDocument().addDocumentListener(_interactionListener);
        this._templateText.getDocument().addDocumentListener(_interactionListener);
        this._hasMethodScope.addItemListener(_interactionListener);
        this._hasFieldScope.addItemListener(_interactionListener);
        this._hasClassScope.addItemListener(_interactionListener);
        this._isRequired.addItemListener(_interactionListener);
        this._addButton.addActionListener(_interactionListener);
        this._removeButton.addActionListener(_interactionListener);
        this._upButton.addActionListener(_interactionListener);
        this._downButton.addActionListener(_interactionListener);
    }

    private void initializeComponent() {
        this._listLabel = new JLabel();
        this._tagList = new JList();
        this._tagList.setSelectionMode(0);
        ResourceUtils.resLabel((JLabel)this._listLabel, (Component)this._tagList, (String)JavadocArb.getString(48));
        this._scroller = new JScrollPane();
        this._scroller.getViewport().add(this._tagList);
        this._tagPropertiesLabel = new JLabel(JavadocArb.getString(49));
        this._tagNameLabel = new JLabel();
        this._tagNameText = new JTextField();
        ResourceUtils.resLabel((JLabel)this._tagNameLabel, (Component)this._tagNameText, (String)JavadocArb.getString(50));
        this._feedbackLabel = new JLabel();
        this._feedbackLabel.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this._templateText = new JTextField();
        this._templateLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._templateLabel, (Component)this._templateText, (String)JavadocArb.getString(51));
        this._previewLabel = new JWrappedLabel();
        this._previewItemLabel = new JLabel(JavadocArb.getString(46));
        this._isRequired = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._isRequired, (String)JavadocArb.getString(55));
        this._usageLabel = new JLabel(JavadocArb.getString(47));
        this._hasMethodScope = new JCheckBox();
        this._hasFieldScope = new JCheckBox();
        this._hasClassScope = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._hasMethodScope, (String)JavadocArb.getString(53));
        ResourceUtils.resButton((AbstractButton)this._hasFieldScope, (String)JavadocArb.getString(52));
        ResourceUtils.resButton((AbstractButton)this._hasClassScope, (String)JavadocArb.getString(54));
        this._addButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._addButton, (String)JavadocArb.getString(56));
        this._removeButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._removeButton, (String)JavadocArb.getString(57));
        JavadocOptionsPanel.ensureSameWidth(new JButton[]{this._addButton, this._removeButton});
        this._upButton = JavadocOptionsPanel.createIconicButton(OracleIcons.getIcon((String)"up.png"), JavadocArb.getString(58));
        this._upButton.setToolTipText(JavadocArb.getString(58));
        this._downButton = JavadocOptionsPanel.createIconicButton(OracleIcons.getIcon((String)"down.png"), JavadocArb.getString(59));
        this._downButton.setToolTipText(JavadocArb.getString(59));
        JPanel tagListPanel = new JPanel(new GridBagLayout());
        tagListPanel.add((Component)this._listLabel, new GridBagConstraints(0, -1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        tagListPanel.add((Component)this._scroller, new GridBagConstraints(0, -1, 2, 2, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        tagListPanel.add((Component)this._addButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        tagListPanel.add((Component)this._removeButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 5, 0, 0), 0, 0));
        tagListPanel.add((Component)this._upButton, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 0), 0, 0));
        tagListPanel.add((Component)this._downButton, new GridBagConstraints(2, -1, 1, 1, 0.0, 1.0, 11, 2, new Insets(0, 5, 5, 0), 0, 0));
        JPanel tagPropertiesPanel = new JPanel(new GridBagLayout());
        tagPropertiesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        tagPropertiesPanel.add((Component)this._tagNameLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._tagNameText, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._feedbackLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 5, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._usageLabel, new GridBagConstraints(1, 2, 1, 4, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._hasFieldScope, new GridBagConstraints(2, 2, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._hasMethodScope, new GridBagConstraints(2, 3, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._hasClassScope, new GridBagConstraints(2, 4, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._isRequired, new GridBagConstraints(2, 5, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._templateLabel, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._templateText, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._previewItemLabel, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        tagPropertiesPanel.add((Component)this._previewLabel, new GridBagConstraints(1, 8, 2, 1, 1.0, 1.0, 18, 1, new Insets(2, 0, 0, 0), 0, 0));
        JPanel propPanel = new JPanel(new BorderLayout(0, 2));
        propPanel.add((Component)this._tagPropertiesLabel, "North");
        propPanel.add((Component)tagPropertiesPanel, "Center");
        this.setLayout(new BorderLayout(5, 5));
        this.add(tagListPanel, "West");
        this.add(propPanel, "Center");
    }

    protected void updateNameAndTemplate() {
        String name = this._tagNameText.getText().trim();
        if (!name.startsWith("@")) {
            name = "@" + name;
        }
        if (this._selectedTD.isCustom()) {
            boolean tagIsDuplicate = false;
            if ("@exception".equals(name)) {
                this._feedbackLabel.setText(JavadocArb.format(62, name));
                tagIsDuplicate = true;
            } else {
                for (int i = 0; i < (this._listModel != null ? this._listModel.getSize() : 0); ++i) {
                    TagDescriptor descriptor = (TagDescriptor)this._listModel.getElementAt(i);
                    if (descriptor == this._selectedTD || !descriptor.getName().equals(name)) continue;
                    this._feedbackLabel.setText(JavadocArb.format(61, name));
                    tagIsDuplicate = true;
                    break;
                }
            }
            if (tagIsDuplicate) {
                this._feedbackLabel.setVisible(true);
                this._tagNameText.setText(this._selectedTD.getName());
                return;
            }
        }
        this._feedbackLabel.setVisible(false);
        this._selectedTD.setName(name);
        String template = this._templateText.getText();
        this._selectedTD.setTemplate(template);
        this._previewLabel.setText(name + " " + template);
    }

    private static void ensureSameWidth(JButton[] buttons) {
        int i;
        if (buttons.length < 2) {
            return;
        }
        Dimension d = buttons[0].getPreferredSize();
        int width = d.width;
        for (i = 1; i < buttons.length; ++i) {
            width = Math.max(width, buttons[i].getPreferredSize().width);
        }
        for (i = 0; i < buttons.length; ++i) {
            buttons[i].setPreferredSize(new Dimension(width, d.height));
        }
    }

    private static JButton createIconicButton(Icon icon, String accessibleLabel) {
        JButton button = new JButton();
        button.setIcon(icon);
        button.getAccessibleContext().setAccessibleName(accessibleLabel);
        button.setEnabled(false);
        button.setMargin(new Insets(2, 0, 2, 0));
        return button;
    }

    private static final class TagListModel
    extends DefaultListModel {
        private ArrayList _dataList;

        TagListModel(List data) {
            this._dataList = (ArrayList)data;
        }

        public void add(int index, Object element) {
            this._dataList.add(index, element);
            this.fireIntervalAdded(this, index, index);
        }

        public void addElement(Object element) {
            int index = this._dataList.size();
            this.add(index, element);
        }

        @Override
        public int indexOf(Object elem) {
            return this._dataList.indexOf(elem);
        }

        public void moveUp(Object obj) {
            int i = this._dataList.indexOf(obj);
            TagDescriptor td = (TagDescriptor)obj;
            this.removeElement(td);
            this.add(--i, td);
        }

        public void moveDown(Object obj) {
            int i = this._dataList.indexOf(obj);
            TagDescriptor td = (TagDescriptor)obj;
            if (this.removeElement(td)) {
                this.add(++i, td);
            }
        }

        @Override
        public boolean removeElement(Object obj) {
            int i = this._dataList.indexOf(obj);
            if (i >= 0) {
                this.removeElementAt(i);
                return true;
            }
            return false;
        }

        @Override
        public void removeElementAt(int index) {
            int elementCount = this._dataList.size();
            if (index >= 0 && index <= elementCount) {
                this._dataList.remove(index);
                this.fireIntervalRemoved(this, index, index);
            }
        }

        @Override
        public Object getElementAt(int index) {
            return this._dataList.get(index);
        }

        @Override
        public int getSize() {
            return this._dataList.size();
        }
    }

    private final class InteractionListener
    implements ActionListener,
    DocumentListener,
    ItemListener,
    ListSelectionListener {
        private InteractionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == JavadocOptionsPanel.this._addButton) {
                String newTag = JavadocArb.getString(60);
                TagDescriptor td = new TagDescriptor(newTag, 15, 1);
                JavadocOptionsPanel.this._modelIsUpdating = true;
                JavadocOptionsPanel.this._listModel.addElement(td);
                JavadocOptionsPanel.this._modelIsUpdating = false;
                JavadocOptionsPanel.this._tagList.setSelectedValue(td, true);
                JavadocOptionsPanel.this._tagNameText.requestFocus();
            } else if (o == JavadocOptionsPanel.this._removeButton) {
                int index = JavadocOptionsPanel.this._tagList.getSelectedIndex();
                JavadocOptionsPanel.this._modelIsUpdating = true;
                JavadocOptionsPanel.this._listModel.removeElement(JavadocOptionsPanel.this._tagList.getSelectedValue());
                JavadocOptionsPanel.this._modelIsUpdating = false;
                int elementCount = JavadocOptionsPanel.this._listModel.getSize();
                if (index == 0 || index < elementCount) {
                    JavadocOptionsPanel.this._tagList.setSelectedIndex(index);
                } else if (index >= elementCount) {
                    JavadocOptionsPanel.this._tagList.setSelectedIndex(elementCount - 1);
                }
            } else if (o == JavadocOptionsPanel.this._upButton) {
                TagDescriptor td = (TagDescriptor)JavadocOptionsPanel.this._tagList.getSelectedValue();
                JavadocOptionsPanel.this._modelIsUpdating = true;
                JavadocOptionsPanel.this._listModel.moveUp(td);
                JavadocOptionsPanel.this._modelIsUpdating = false;
                JavadocOptionsPanel.this._tagList.setSelectedIndex(JavadocOptionsPanel.this._listModel.indexOf(td));
            } else if (o == JavadocOptionsPanel.this._downButton) {
                TagDescriptor td = (TagDescriptor)JavadocOptionsPanel.this._tagList.getSelectedValue();
                JavadocOptionsPanel.this._modelIsUpdating = true;
                JavadocOptionsPanel.this._listModel.moveDown(td);
                JavadocOptionsPanel.this._modelIsUpdating = false;
                JavadocOptionsPanel.this._tagList.setSelectedIndex(JavadocOptionsPanel.this._listModel.indexOf(td));
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.upateName(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.upateName(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.upateName(e);
        }

        private void upateName(DocumentEvent de) {
            if (!JavadocOptionsPanel.this._listIsUpdating) {
                JavadocOptionsPanel.this.updateNameAndTemplate();
                JavadocOptionsPanel.this._tagList.setSelectedValue(JavadocOptionsPanel.this._selectedTD, true);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (JavadocOptionsPanel.this._listIsUpdating) {
                return;
            }
            JCheckBox cb = (JCheckBox)e.getSource();
            boolean selected = cb.isSelected();
            if (cb == JavadocOptionsPanel.this._hasFieldScope) {
                if (selected) {
                    JavadocOptionsPanel.this._selectedTD.setScope(2);
                } else {
                    JavadocOptionsPanel.this._selectedTD.unsetScope(2);
                }
            } else if (cb == JavadocOptionsPanel.this._hasMethodScope) {
                if (selected) {
                    JavadocOptionsPanel.this._selectedTD.setScope(4);
                    JavadocOptionsPanel.this._selectedTD.setScope(8);
                } else {
                    JavadocOptionsPanel.this._selectedTD.unsetScope(4);
                    JavadocOptionsPanel.this._selectedTD.unsetScope(8);
                }
            } else if (cb == JavadocOptionsPanel.this._hasClassScope) {
                if (selected) {
                    JavadocOptionsPanel.this._selectedTD.setScope(1);
                } else {
                    JavadocOptionsPanel.this._selectedTD.unsetScope(1);
                }
            } else if (cb == JavadocOptionsPanel.this._isRequired) {
                JavadocOptionsPanel.this._selectedTD.setRequired(selected);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || JavadocOptionsPanel.this._modelIsUpdating) {
                return;
            }
            JavadocOptionsPanel.this._listIsUpdating = true;
            JavadocOptionsPanel.this._selectedTD = (TagDescriptor)JavadocOptionsPanel.this._tagList.getSelectedValue();
            if (JavadocOptionsPanel.this._selectedTD != null) {
                String name = JavadocOptionsPanel.this._selectedTD.getName();
                if (name.startsWith("@")) {
                    name = name.substring(1);
                }
                JavadocOptionsPanel.this._tagNameText.setText(name);
                JavadocOptionsPanel.this._templateText.setText(JavadocOptionsPanel.this._selectedTD.getTemplate());
                JavadocOptionsPanel.this.updateNameAndTemplate();
                JavadocOptionsPanel.this._hasFieldScope.setSelected((JavadocOptionsPanel.this._selectedTD.getScope() & 2) > 0);
                JavadocOptionsPanel.this._hasMethodScope.setSelected((JavadocOptionsPanel.this._selectedTD.getScope() & 4) > 0);
                JavadocOptionsPanel.this._hasClassScope.setSelected((JavadocOptionsPanel.this._selectedTD.getScope() & 1) > 0);
                JavadocOptionsPanel.this._isRequired.setSelected(JavadocOptionsPanel.this._selectedTD.isRequired());
                boolean enable = JavadocOptionsPanel.this._selectedTD.isCustom();
                JavadocOptionsPanel.this._tagNameText.setEnabled(enable);
                JavadocOptionsPanel.this._hasFieldScope.setEnabled(enable);
                JavadocOptionsPanel.this._hasMethodScope.setEnabled(enable);
                JavadocOptionsPanel.this._hasMethodScope.setEnabled(enable);
                JavadocOptionsPanel.this._hasClassScope.setEnabled(enable);
                JavadocOptionsPanel.this._removeButton.setEnabled(enable);
                enable = JavadocOptionsPanel.this._selectedTD.isCustom() || JavadocOptionsPanel.this._selectedTD.isAllowsTemplate();
                JavadocOptionsPanel.this._templateText.setEnabled(enable);
                JavadocOptionsPanel.this._templateLabel.setEnabled(enable);
            }
            JavadocOptionsPanel.this._upButton.setEnabled(JavadocOptionsPanel.this._listModel.indexOf(JavadocOptionsPanel.this._selectedTD) > 0);
            JavadocOptionsPanel.this._downButton.setEnabled(JavadocOptionsPanel.this._listModel.indexOf(JavadocOptionsPanel.this._selectedTD) < JavadocOptionsPanel.this._listModel.getSize() - 1);
            JavadocOptionsPanel.this._listIsUpdating = false;
        }
    }
}

