/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.util;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.util.MakeWritableHelper;
import oracle.jdeveloper.util.Helpers;

public class JavaCommandSupport {
    private final Map<SourceFile, SourceTransaction> _transactions = new HashMap<SourceFile, SourceTransaction>();
    private final Set<Node> _affectedNodes = new HashSet<Node>();
    private HashMap _caretPositionings;

    public final void repositionCaret(CodeEditor codeEditor, SourceElement sourceElement, boolean afterElement) {
        CaretPositioning caretPositioning = new CaretPositioning(codeEditor, sourceElement, afterElement);
        if (this._caretPositionings == null) {
            this._caretPositionings = new HashMap(1);
        }
        this._caretPositionings.put(codeEditor, caretPositioning);
    }

    public final void addAffectedURL(URL url) {
        this._affectedNodes.add(NodeFactory.findOrCreateOrFail((URL)url));
    }

    public final SourceTransaction beginTransaction(SourceElement sourceElement) {
        SourceFile sourceFile = sourceElement.getOwningSourceFile();
        SourceTransaction sourceTransaction = this._transactions.get(sourceFile);
        if (sourceTransaction == null) {
            TextBuffer textBuffer = sourceFile.getTextBuffer();
            textBuffer.setReadOnly(false);
            sourceTransaction = sourceFile.beginTransaction();
            this._transactions.put(sourceFile, sourceTransaction);
            URL url = sourceFile.getURL();
            this.addAffectedURL(url);
        }
        return sourceTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean commit(Context context, String transactionName) {
        boolean ret = false;
        Command command = this.createCommand(context, transactionName);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        try {
            ret = commandProcessor.invoke(command) == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            FeedbackManager.reportException((Throwable)e);
        }
        finally {
            if (!ret) {
                for (Node node : this._affectedNodes) {
                    TextNode textNode;
                    TextBuffer textBuffer;
                    if (!node.isReadOnly() || !(node instanceof TextNode) || (textBuffer = (textNode = (TextNode)node).acquireTextBuffer()).isReadOnly()) continue;
                    textBuffer.setReadOnly(true);
                }
                this.abort();
            }
        }
        return ret;
    }

    public final void abort() {
        Collection<SourceTransaction> sourceTransactions = this._transactions.values();
        for (SourceTransaction sourceTransaction : sourceTransactions) {
            sourceTransaction.abort();
        }
        this._affectedNodes.clear();
        this._transactions.clear();
    }

    protected Command createCommand(Context context, String transactionName) {
        return new BaseCommand(context, transactionName, this){

            @Override
            protected void fireBeforeCommandEvent() {
            }

            @Override
            protected void fireAfterCommandEvent() {
            }

            @Override
            protected void fireBeforeUndoEvent() {
            }

            @Override
            protected void fireAfterUndoEvent() {
            }

            @Override
            protected Collection<URL> createdUrls() {
                return null;
            }

            @Override
            protected Collection<URL> deletedUrls() {
                return null;
            }

            @Override
            protected boolean isDeletedFile(URL url) {
                return false;
            }

            @Override
            protected boolean isCreatedFile(URL url) {
                return false;
            }

            @Override
            protected void openFiles(Collection<URL> files) {
            }

            @Override
            protected void createTodos() {
            }
        };
    }

    private static class CaretPositioning {
        private CodeEditor _codeEditor;
        private SourceElement _element;
        private boolean _after;

        public CaretPositioning(CodeEditor codeEditor, SourceElement element, boolean after) {
            this._codeEditor = codeEditor;
            this._element = element;
            this._after = after;
        }

        public void repositionCaret() {
            int offset = this._after ? this._element.getEndOffset() : this._element.getStartOffset();
            this._codeEditor.setCaretPosition(offset);
        }
    }

    protected static abstract class BaseCommand
    extends Command {
        private Node[] _affectedNodes;
        private JavaCommandSupport _pendingCommand;
        private UndoableEdit[] _undoableEdits;
        private Map<URL, String> _createdFiles;
        private Map<URL, String> _deletedFiles;
        private int _caretPositionBefore = -1;
        private int _caretPositionAfter = -1;
        private WeakReference _codeEditorReference;
        private boolean _isDone = false;

        public BaseCommand(Context context, String name, JavaCommandSupport commandSupport) {
            super(-1, 3, name);
            this.setContext(context);
            Set affectedNodes = commandSupport._affectedNodes;
            this._affectedNodes = affectedNodes.toArray(new Node[affectedNodes.size()]);
            this._pendingCommand = commandSupport;
        }

        protected final Map<URL, String> createdFiles() {
            return Collections.unmodifiableMap(this._createdFiles);
        }

        protected final JavaCommandSupport pendingCommand() {
            return this._pendingCommand;
        }

        protected abstract void fireBeforeCommandEvent();

        protected abstract void fireAfterCommandEvent();

        protected abstract void fireBeforeUndoEvent();

        protected abstract void fireAfterUndoEvent();

        protected abstract Collection<URL> createdUrls();

        protected abstract Collection<URL> deletedUrls();

        protected abstract boolean isDeletedFile(URL var1);

        protected abstract boolean isCreatedFile(URL var1);

        protected abstract void openFiles(Collection<URL> var1);

        protected abstract void createTodos();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int doit() throws Exception {
            int ret = 1;
            if (this.prepareFiles()) {
                CacheSupport cacheSupport = this.beginCacheUse();
                try {
                    this.fireBeforeCommandEvent();
                    if (this._pendingCommand == null) {
                        this.redo();
                    } else {
                        CodeEditor codeEditor;
                        SourceElement highlightedElement = null;
                        Context context = this.getContext();
                        View view = context.getView();
                        if (view instanceof CodeEditor && view.isVisible()) {
                            Element[] selected;
                            codeEditor = (CodeEditor)view;
                            this._caretPositionBefore = codeEditor.getCaretPosition();
                            int start = codeEditor.getSelectionStart();
                            int end = codeEditor.getSelectionEnd();
                            if (end > start && (selected = codeEditor.getSelection()).length == 1 && selected[0].getData() != null && selected[0].getData() instanceof SourceElement) {
                                highlightedElement = (SourceElement)selected[0].getData();
                                this._pendingCommand.repositionCaret(codeEditor, highlightedElement, false);
                            }
                            this._codeEditorReference = new WeakReference<CodeEditor>(codeEditor);
                        } else {
                            codeEditor = null;
                        }
                        HashMap caretPositionings = this._pendingCommand._caretPositionings;
                        this.commitTransactions();
                        if (this._createdFiles != null) {
                            this.openFiles(this._createdFiles.keySet());
                        }
                        if (caretPositionings != null) {
                            Collection positionings = caretPositionings.values();
                            for (CaretPositioning caretPositioning : positionings) {
                                caretPositioning.repositionCaret();
                            }
                        }
                        if (codeEditor != null) {
                            this._caretPositionAfter = codeEditor.getCaretPosition();
                            if (highlightedElement != null) {
                                codeEditor.setSelectionEnd(highlightedElement.getEndOffset());
                            }
                        }
                    }
                    this.deleteURLs(this._deletedFiles);
                    this._isDone = true;
                    ret = 0;
                }
                finally {
                    this.saveAffectedNodes();
                    cacheSupport.endCacheUse();
                }
                if (ret == 0) {
                    this.fireAfterCommandEvent();
                }
            }
            return ret;
        }

        private void redo() throws IllegalAccessException, InstantiationException, IOException {
            CodeEditor codeEditor;
            if (this._createdFiles != null) {
                for (Map.Entry<URL, String> entry : this._createdFiles.entrySet()) {
                    this.createNode(entry.getKey(), entry.getValue());
                }
            }
            for (int i = 0; i < this._undoableEdits.length; ++i) {
                UndoableEdit undoableEdit = this._undoableEdits[i];
                undoableEdit.redo();
            }
            if (this._caretPositionAfter >= 0 && this._codeEditorReference != null && (codeEditor = (CodeEditor)this._codeEditorReference.get()) != null) {
                codeEditor.setCaretPosition(this._caretPositionAfter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int undo() throws Exception {
            int ret = 1;
            if (this.prepareFiles()) {
                CacheSupport cacheSupport = this.beginCacheUse();
                this.fireBeforeUndoEvent();
                try {
                    CodeEditor codeEditor;
                    if (this._deletedFiles != null) {
                        for (Map.Entry<URL, String> entry : this._deletedFiles.entrySet()) {
                            this.createNode(entry.getKey(), entry.getValue());
                        }
                    }
                    for (int i = 0; i < this._undoableEdits.length; ++i) {
                        UndoableEdit undoableEdit = this._undoableEdits[i];
                        undoableEdit.undo();
                    }
                    this.deleteURLs(this._createdFiles);
                    if (this._caretPositionBefore >= 0 && this._codeEditorReference != null && (codeEditor = (CodeEditor)this._codeEditorReference.get()) != null) {
                        codeEditor.setCaretPosition(this._caretPositionBefore);
                    }
                    ret = 0;
                    this._isDone = false;
                }
                finally {
                    this.saveAffectedNodes();
                    cacheSupport.endCacheUse();
                }
                if (ret == 0) {
                    this.fireAfterUndoEvent();
                }
            }
            return ret;
        }

        private boolean prepareFiles() {
            URL[] urls = new URL[this._affectedNodes.length];
            for (int i = 0; i < this._affectedNodes.length; ++i) {
                URL url;
                Node node = this._affectedNodes[i];
                urls[i] = url = node.getURL();
                Helpers.removeClasses(this.getContext().getProject(), url);
            }
            return MakeWritableHelper.makeWritable(urls);
        }

        private void deleteURLs(Map urls) throws IOException {
            if (urls != null) {
                for (URL url : urls.keySet()) {
                    Node node = NodeFactory.find((URL)url);
                    if (node != null) {
                        node.delete();
                        continue;
                    }
                    URLFileSystem.delete((URL)url);
                }
            }
        }

        public Node[] getAffectedNodes() {
            ArrayList<Object> ret;
            Collection<URL> excludeUrls;
            if (this._pendingCommand == null) {
                Map<URL, String> excludedMap = this._isDone ? this._deletedFiles : this._createdFiles;
                excludeUrls = excludedMap == null ? null : excludedMap.keySet();
            } else {
                excludeUrls = this.createdUrls();
            }
            if (excludeUrls != null) {
                ret = new ArrayList(this._affectedNodes.length);
                for (int i = 0; i < this._affectedNodes.length; ++i) {
                    Node affectedNode = this._affectedNodes[i];
                    URL url = affectedNode.getURL();
                    if (excludeUrls.contains(url)) continue;
                    ret.add(affectedNode);
                }
            } else {
                ret = new ArrayList<Node>(Arrays.asList(this._affectedNodes));
            }
            Node contextNode = this.context.getNode();
            ret.remove(contextNode);
            return ret.toArray(new Node[ret.size()]);
        }

        private CacheSupport beginCacheUse() {
            Context context = this.getContext();
            Project project = context.getProject();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            CacheSupport cacheSupport = javaManager.getCacheSupport();
            cacheSupport.beginCacheUse();
            return cacheSupport;
        }

        private void commitTransactions() {
            Map transactions = this._pendingCommand._transactions;
            Collection<URL> deletedURLs = this.deletedUrls();
            if (deletedURLs != null) {
                for (URL deletedURL : deletedURLs) {
                    this.addFileDeletion(deletedURL);
                }
            }
            ArrayList<UndoableEdit> undoableEdits = new ArrayList<UndoableEdit>();
            for (Map.Entry entry : transactions.entrySet()) {
                SourceFile sourceFile = (SourceFile)entry.getKey();
                URL url = sourceFile.getURL();
                if (this.isDeletedFile(url)) continue;
                SourceTransaction sourceTransaction = (SourceTransaction)entry.getValue();
                try {
                    UndoableEdit undoableEdit = sourceTransaction.commit();
                    if (this.isCreatedFile(url)) {
                        this.addFileCreation(sourceFile);
                        Node node = NodeFactory.find((URL)url);
                        node.save();
                        continue;
                    }
                    if (undoableEdit == null) continue;
                    undoableEdits.add(undoableEdit);
                }
                catch (Exception e) {
                    System.out.println("Failed to commit " + URLFileSystem.getPlatformPathName((URL)url));
                    e.printStackTrace();
                }
            }
            this.createTodos();
            this._pendingCommand = null;
            this._undoableEdits = undoableEdits.toArray(new UndoableEdit[undoableEdits.size()]);
        }

        private void addFileCreation(SourceFile sourceFile) {
            URL url = sourceFile.getURL();
            String text = sourceFile.getText();
            if (this._createdFiles == null) {
                this._createdFiles = new HashMap<URL, String>(1);
                this._createdFiles.put(url, text);
            }
        }

        private void addFileDeletion(URL url) {
            try {
                TextNode node = (TextNode)NodeFactory.findOrCreate((URL)url);
                TextBuffer textBuffer = node.acquireTextBuffer();
                String text = textBuffer.getString(0, textBuffer.getLength());
                if (this._deletedFiles == null) {
                    this._deletedFiles = new HashMap<URL, String>(1);
                    this._deletedFiles.put(url, text);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void createNode(URL url, String text) throws IllegalAccessException, InstantiationException, IOException {
            char[] chars = text.toCharArray();
            TextNode node = (TextNode)NodeFactory.findOrCreate((URL)url);
            TextBuffer textBuffer = node.acquireTextBuffer();
            textBuffer.beginEdit();
            textBuffer.removeToEnd(0);
            textBuffer.append(chars);
            textBuffer.endEdit();
            node.releaseTextBuffer();
            node.save();
        }

        private void saveAffectedNodes() throws IOException {
            for (int i = 0; i < this._affectedNodes.length; ++i) {
                Node node = this._affectedNodes[i];
                node.save();
            }
        }
    }
}

