/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.TooltipDataItem;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdevimpl.java.JavaArb;

final class ParameterDataItem
extends TooltipDataItem
implements Comparable {
    private JavaMethod javaMethod;
    private SourceMethod sourceMethod;
    private String[] parameters;
    private String parameterSignature;
    private String displayText;
    private int argumentIndex;

    ParameterDataItem(JavaMethod javaMethod, SourceMethod sourceMethod, int inArgumentIndex) {
        this.javaMethod = javaMethod;
        this.sourceMethod = sourceMethod;
        this.displayText = null;
        this.argumentIndex = inArgumentIndex;
        this.buildParametersAndSignature();
    }

    int getParameterCount() {
        JavaClass enclosing = this.javaMethod.getOwningClass();
        int count = this.parameters.length;
        if (!this.javaMethod.isConstructor()) {
            return count;
        }
        boolean ignoreFirstParameter = !enclosing.isStatic() && enclosing.getOwningClass() != null;
        return ignoreFirstParameter ? count - 1 : count;
    }

    String getParameter(int index) {
        JavaClass enclosing = this.javaMethod.getOwningClass();
        if (!this.javaMethod.isConstructor()) {
            return this.parameters[index];
        }
        boolean ignoreFirstParameter = !enclosing.isStatic() && enclosing.getOwningClass() != null;
        return this.parameters[ignoreFirstParameter ? index + 1 : index];
    }

    int getArgumentIndex() {
        return this.argumentIndex;
    }

    String getParameterSignature() {
        return this.parameterSignature;
    }

    private void buildParametersAndSignature() {
        Collection javaMethodParameters = this.javaMethod.getParameters();
        int numParameters = javaMethodParameters.size();
        Iterator iter = javaMethodParameters.iterator();
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i < numParameters; ++i) {
            JavaVariable param = (JavaVariable)iter.next();
            JavaType type = param.getResolvedType();
            String itemType = null;
            if (type != null) {
                if (i == numParameters - 1 && this.javaMethod.isVarargs() && type.isArray() && type.getBaseComponentType() != null) {
                    itemType = type.getBaseComponentType().getUnqualifiedName() + "...";
                }
                if (itemType == null) {
                    itemType = type.getUnqualifiedName();
                }
            } else {
                itemType = "<unknown>";
            }
            types.add(itemType);
        }
        ArrayList<String> paramNames = new ArrayList<String>();
        if (this.sourceMethod != null) {
            Collection sourceMethodParameters = this.sourceMethod.getParameters();
            iter = sourceMethodParameters.iterator();
            numParameters = sourceMethodParameters.size();
            for (int i = 0; i < numParameters; ++i) {
                JavaVariable param = (JavaVariable)iter.next();
                paramNames.add(param.getName());
            }
        }
        this.parameters = new String[numParameters];
        StringBuilder signatureBuf = new StringBuilder();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < types.size(); ++i) {
            String name;
            buffer.setLength(0);
            String type = (String)types.get(i);
            buffer.append(type);
            if (i > 0) {
                signatureBuf.append(", ");
            }
            signatureBuf.append(type);
            if (i < paramNames.size() && (name = (String)paramNames.get(i)) != null && name.length() > 0) {
                buffer.append(" ");
                buffer.append(name);
            }
            this.parameters[i] = buffer.toString();
        }
        this.parameterSignature = signatureBuf.toString();
    }

    public String getDisplayText() {
        if (this.displayText == null) {
            int numParameters = this.getParameterCount();
            if (numParameters == 0) {
                this.displayText = JavaArb.getString(39);
            } else {
                StringBuffer buffer = new StringBuffer();
                String comma = "";
                for (int i = 0; i < numParameters; ++i) {
                    buffer.append(comma);
                    comma = ", ";
                    buffer.append(this.getParameter(i));
                }
                this.displayText = buffer.toString();
            }
        }
        return this.displayText;
    }

    public boolean isDeprecated() {
        return this.javaMethod.isDeprecated();
    }

    public String toString() {
        return this.getDisplayText();
    }

    public int compareTo(Object object) {
        ParameterDataItem item2 = (ParameterDataItem)object;
        String name1 = this.getDisplayText();
        String name2 = item2.getDisplayText();
        return ListDataItem.compareInsensitive((String)name1, (String)name2);
    }
}

