/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.insight.JavaInsightOptions;

public final class JavaInsightOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkbox_boldDeclaredMembers;
    private JCheckBox checkbox_italicLocalVariables;
    private JCheckBox checkbox_showTopLevelPackages;
    private JCheckBox checkbox_showImportedClasses;
    private JCheckBox checkbox_showObjectMethods;
    private JCheckBox checkbox_showOverloadedMethods;
    private JCheckBox checkbox_showDeprecated;
    private JCheckBox checkbox_strikethruDeprecated;
    private JCheckBox checkbox_autoImport;
    private JCheckBox checkbox_showDefiningClass;
    private JCheckBox checkbox_showAccessIcons;
    private JCheckBox checkbox_insertParameters;

    public JavaInsightOptionsPanel() {
        this.setHelpID("f1_idedidesetjavainsight_html");
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        JavaInsightOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        JavaInsightOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private JavaInsightOptions findOptions(TraversableContext tc) {
        JavaInsightOptions options = (JavaInsightOptions)tc.find("JavaInsightOptions");
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        JavaInsightOptions options = this.findOptions(tc);
        JavaInsightOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(JavaInsightOptions options) {
    }

    void loadSettingsFrom(JavaInsightOptions options) {
        boolean boldDeclaredMembers = options.getBoldDeclaredMembers();
        boolean italicLocalVariables = options.getItalicLocalVariables();
        boolean showTopLevelPackages = options.getShowTopLevelPackages();
        boolean showImportedClasses = options.getShowImportedClasses();
        boolean showObjectMethods = options.getShowObjectMethods();
        boolean showOverloadedMethods = options.getShowOverloadedMethods();
        boolean showDeprecated = options.getShowDeprecated();
        boolean strikethruDeprecated = options.getStrikethruDeprecated();
        boolean autoImport = options.getAutoImport();
        boolean showDefiningClass = options.getShowDefiningClass();
        boolean showAccessIcons = options.getShowAccessIcons();
        boolean insertParameterValues = options.getInsertParameterValues();
        this.checkbox_boldDeclaredMembers.setSelected(boldDeclaredMembers);
        this.checkbox_italicLocalVariables.setSelected(italicLocalVariables);
        this.checkbox_showTopLevelPackages.setSelected(showTopLevelPackages);
        this.checkbox_showImportedClasses.setSelected(showImportedClasses);
        this.checkbox_showObjectMethods.setSelected(showObjectMethods);
        this.checkbox_showOverloadedMethods.setSelected(showOverloadedMethods);
        this.checkbox_showDeprecated.setSelected(showDeprecated);
        this.checkbox_strikethruDeprecated.setSelected(strikethruDeprecated);
        this.checkbox_autoImport.setSelected(autoImport);
        this.checkbox_showDefiningClass.setSelected(showDefiningClass);
        this.checkbox_showAccessIcons.setSelected(showAccessIcons);
        this.checkbox_insertParameters.setSelected(insertParameterValues);
    }

    void saveSettingsTo(JavaInsightOptions options) throws TraversalException {
        boolean boldDeclaredMembers = this.checkbox_boldDeclaredMembers.isSelected();
        boolean italicLocalVariables = this.checkbox_italicLocalVariables.isSelected();
        boolean showTopLevelPackages = this.checkbox_showTopLevelPackages.isSelected();
        boolean showImportedClasses = this.checkbox_showImportedClasses.isSelected();
        boolean showObjectMethods = this.checkbox_showObjectMethods.isSelected();
        boolean showOverloadedMethods = this.checkbox_showOverloadedMethods.isSelected();
        boolean showDeprecated = this.checkbox_showDeprecated.isSelected();
        boolean strikethruDeprecated = this.checkbox_strikethruDeprecated.isSelected();
        boolean autoImport = this.checkbox_autoImport.isSelected();
        boolean showDefiningClass = this.checkbox_showDefiningClass.isSelected();
        boolean showAccessIcons = this.checkbox_showAccessIcons.isSelected();
        boolean insertParameterValues = this.checkbox_insertParameters.isSelected();
        options.setBoldDeclaredMembers(boldDeclaredMembers);
        options.setItalicLocalVariables(italicLocalVariables);
        options.setShowTopLevelPackages(showTopLevelPackages);
        options.setShowImportedClasses(showImportedClasses);
        options.setShowObjectMethods(showObjectMethods);
        options.setShowOverloadedMethods(showOverloadedMethods);
        options.setShowDeprecated(showDeprecated);
        options.setStrikethruDeprecated(strikethruDeprecated);
        options.setAutoImport(autoImport);
        options.setShowDefiningClass(showDefiningClass);
        options.setShowAccessIcons(showAccessIcons);
        options.setInsertParameterValues(insertParameterValues);
    }

    private void initializeComponent() {
        String boldDeclaredMembersText = JavaArb.getString(144);
        this.checkbox_boldDeclaredMembers = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_boldDeclaredMembers, (String)boldDeclaredMembersText);
        String italicLocalVariablesText = JavaArb.getString(145);
        this.checkbox_italicLocalVariables = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_italicLocalVariables, (String)italicLocalVariablesText);
        String showTopLevelPackagesText = JavaArb.getString(146);
        this.checkbox_showTopLevelPackages = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showTopLevelPackages, (String)showTopLevelPackagesText);
        String showImportedClassesText = JavaArb.getString(147);
        this.checkbox_showImportedClasses = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showImportedClasses, (String)showImportedClassesText);
        String showObjectMethodsText = JavaArb.getString(148);
        this.checkbox_showObjectMethods = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showObjectMethods, (String)showObjectMethodsText);
        String showOverloadedMethodsText = JavaArb.getString(149);
        this.checkbox_showOverloadedMethods = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showOverloadedMethods, (String)showOverloadedMethodsText);
        String showDefiningClassText = JavaArb.getString(150);
        this.checkbox_showDefiningClass = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showDefiningClass, (String)showDefiningClassText);
        String showDeprecatedText = JavaArb.getString(152);
        this.checkbox_showDeprecated = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showDeprecated, (String)showDeprecatedText);
        String strikethruDeprecatedText = JavaArb.getString(153);
        this.checkbox_strikethruDeprecated = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_strikethruDeprecated, (String)strikethruDeprecatedText);
        String autoImportText = JavaArb.getString(151);
        this.checkbox_autoImport = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoImport, (String)autoImportText);
        Component[] dependents = new Component[]{this.checkbox_strikethruDeprecated};
        ItemSelectableTracker tracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_showDeprecated, dependents);
        String showAccessIconsText = JavaArb.getString(154);
        this.checkbox_showAccessIcons = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showAccessIcons, (String)showAccessIconsText);
        String showInsertParamsText = JavaArb.getString(155);
        this.checkbox_insertParameters = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_insertParameters, (String)showInsertParamsText);
        JPanel panel_member = new JPanel((LayoutManager)new MigLayout("insets 0 5 2 5, fillx, wrap 1"));
        String memberBorderText = JavaArb.getString(143);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(memberBorderText);
        panel_member.setBorder(titledBorder);
        panel_member.add(this.checkbox_boldDeclaredMembers);
        panel_member.add(this.checkbox_italicLocalVariables);
        panel_member.add(this.checkbox_showTopLevelPackages);
        panel_member.add(this.checkbox_showImportedClasses);
        panel_member.add(this.checkbox_showObjectMethods);
        panel_member.add(this.checkbox_showOverloadedMethods);
        panel_member.add(this.checkbox_showDefiningClass);
        this.setLayout((LayoutManager)new MigLayout("fillx, wrap 1"));
        this.add(panel_member, "gapbottom 8px, growx");
        this.add(this.checkbox_showDeprecated);
        this.add(this.checkbox_strikethruDeprecated, "gapleft 18px");
        this.add(this.checkbox_autoImport);
        this.add(this.checkbox_showAccessIcons);
        this.add(this.checkbox_insertParameters);
    }
}

