/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.List;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Project;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.java.SourceFileReducer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceInterfacesClause;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceSuperclassClause;
import oracle.javatools.parser.java.v2.model.SourceThrowsClause;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceCompoundStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSimpleStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.VariableNaming;
import oracle.jdeveloper.model.JavaSourceNode;

public class InsightContextProvider {
    private Object _data;

    public Object getData() {
        return this._data;
    }

    private static boolean isCompleteElement(TextBuffer buffer, SourceElement sourceElement) {
        List children;
        boolean ret = true;
        if (sourceElement instanceof SourceSimpleStatement || sourceElement instanceof SourcePackage || sourceElement instanceof SourceImport) {
            int endOffset = sourceElement.getEndOffset();
            char lastChar = buffer.getChar(endOffset - 1);
            if (lastChar != ';') {
                ret = false;
            }
        } else if (sourceElement instanceof SourceCompoundStatement) {
            SourceCompoundStatement sourceCompoundStatement = (SourceCompoundStatement)sourceElement;
            SourceStatement primaryClause = sourceCompoundStatement.getPrimaryClause();
            if (primaryClause == null) {
                ret = false;
            }
        } else if (sourceElement instanceof SourceVariableDeclaration) {
            SourceElement parent;
            int endOffset = sourceElement.getEndOffset();
            char lastChar = buffer.getChar(endOffset - 1);
            if (lastChar != ';' && !((parent = sourceElement.getParent()) instanceof SourceForStatement)) {
                ret = false;
            }
        } else if (sourceElement instanceof SourceSuperclassClause || sourceElement instanceof SourceInterfacesClause || sourceElement instanceof SourceThrowsClause) {
            List children2 = sourceElement.getChildren();
            if (children2.isEmpty()) {
                ret = false;
            }
        } else if (sourceElement instanceof SourceFormalParameter && (children = sourceElement.getChildren()).size() < 2) {
            ret = false;
        }
        return ret;
    }

    private static LexerToken getKeyword(TextBuffer textBuffer, SourceElement sourceElement, int keyword) {
        int token;
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setTextBuffer((ReadTextBuffer)textBuffer);
        int startOffset = sourceElement.getStartOffset();
        javaLexer.setPosition(startOffset);
        LexerToken lexerToken = javaLexer.createLexerToken();
        do {
            if ((token = javaLexer.lex(lexerToken)) != 0) continue;
            return null;
        } while (token != keyword);
        return lexerToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InsightType getType(Context context) {
        InsightType ret = null;
        Project project = context.getProject();
        if (project != null) {
            JavaSourceNode node = (JavaSourceNode)context.getNode();
            CodeEditor codeEditor = (CodeEditor)context.getView();
            int offset = codeEditor.getCaretPosition();
            TextBuffer textBuffer = node.acquireTextBuffer();
            try {
                SourceFileReducer sourceFileReducer = new SourceFileReducer();
                textBuffer = sourceFileReducer.reduce(textBuffer, new Integer[]{offset});
                List adjustedOffsets = sourceFileReducer.getAdjustedOffsets();
                offset = (Integer)adjustedOffsets.get(0);
                JavaManager javaManager = JavaManager.getInstance((Project)project);
                SourceFile sourceFile = javaManager.getSourceFile(textBuffer);
                ret = this.getType(textBuffer, (SourceElement)sourceFile, offset);
            }
            finally {
                node.releaseTextBuffer();
            }
        }
        return ret;
    }

    InsightType getType(TextBuffer textBuffer, SourceElement sourceElement, int offset) {
        InsightType ret;
        InsightType ret2;
        int startOffset;
        int childPos;
        List children = sourceElement.getChildren();
        int size = children.size();
        SourceElement child = null;
        for (childPos = size - 1; childPos >= 0 && offset <= (startOffset = (child = (SourceElement)children.get(childPos)).getStartOffset()); --childPos) {
        }
        if (childPos >= 0 && (ret2 = this.getType(textBuffer, child, offset)) != null) {
            return ret2;
        }
        boolean isInside = false;
        int endOffset = sourceElement.getEndOffset();
        if (offset <= endOffset) {
            isInside = true;
        } else if (!InsightContextProvider.isCompleteElement(textBuffer, sourceElement)) {
            isInside = true;
        }
        if (isInside && (ret = this.getTypeAt(textBuffer, sourceElement, offset)) != null) {
            return ret;
        }
        return null;
    }

    private InsightType getTypeAt(TextBuffer textBuffer, SourceElement sourceElement, int offset) {
        this._data = null;
        int symbolKind = sourceElement.getSymbolKind();
        switch (symbolKind) {
            case 52: {
                return InsightType.UNKNOWN;
            }
            case 2: {
                return InsightType.CODE_USAGE;
            }
            case 30: {
                LexerToken keyword = InsightContextProvider.getKeyword(textBuffer, sourceElement, 98);
                int endOffset = keyword.getEndOffset();
                if (offset <= endOffset) break;
                return InsightType.LABEL;
            }
            case 21: {
                LexerToken keyword = InsightContextProvider.getKeyword(textBuffer, sourceElement, 125);
                int endOffset = keyword.getEndOffset();
                if (offset <= endOffset) break;
                return InsightType.PACKAGE;
            }
            case 14: {
                LexerToken keyword = InsightContextProvider.getKeyword(textBuffer, sourceElement, 118);
                int endOffset = keyword.getEndOffset();
                if (offset <= endOffset) break;
                return InsightType.IMPORT;
            }
            case 1: {
                SourceAnnotation sourceAnnotation = (SourceAnnotation)sourceElement;
                SourceListExpression argumentList = sourceAnnotation.getArgumentList();
                if (argumentList != null) {
                    int startOffset = argumentList.getStartOffset();
                    if (startOffset < 0) {
                        startOffset = sourceAnnotation.getStartOffset();
                        if (offset <= startOffset) break;
                        return InsightType.ANNOTATION;
                    }
                    if (offset <= startOffset) break;
                    this._data = sourceAnnotation;
                    return InsightType.ANNOTATION_PARM;
                }
                int startOffset = sourceAnnotation.getStartOffset();
                if (offset <= startOffset) break;
                return InsightType.ANNOTATION;
            }
            case 22: {
                return InsightType.EXTENDS;
            }
            case 15: {
                return InsightType.IMPLEMENTS;
            }
            case 24: {
                return InsightType.THROWS;
            }
            case 43: {
                return InsightType.THROW;
            }
            case 55: {
                return InsightType.NEW;
            }
            case 67: {
                return InsightType.DOC_TAG;
            }
            case 68: {
                SourceDocTextFragment sourceDocTextFragment = (SourceDocTextFragment)sourceElement;
                String text = sourceDocTextFragment.getDocText();
                if (text.startsWith("@")) {
                    return InsightType.DOC_TAG;
                }
                return InsightType.DOC_TEXT;
            }
            case 65: {
                return InsightType.INLINE_DOC_TAG;
            }
            case 3: {
                SourceClass sourceClass = (SourceClass)sourceElement;
                this._data = sourceClass;
                return InsightType.CLASS_CLAUSE;
            }
            case 4: {
                return InsightType.CLASS_BODY;
            }
            case 17: {
                int endOffset;
                int startOffset;
                SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)sourceElement;
                SourceName nameElement = sourceLocalVariable.getNameElement();
                if (nameElement == null || offset < (startOffset = nameElement.getStartOffset()) || offset > (endOffset = nameElement.getEndOffset())) break;
                SourceTypeReference sourceType = sourceLocalVariable.getSourceType();
                if (sourceType != null) {
                    String name = sourceType.getName();
                    this._data = VariableNaming.suggestNamesFromCamelWord(name, VariableNaming.VARIABLE_FORMATER);
                }
                return InsightType.VARIABLE_NAME;
            }
            case 36: {
                List statementChildren;
                SourceElement parent = sourceElement.getParent();
                if (parent.getSymbolKind() != 2 || (statementChildren = sourceElement.getChildren()).size() != 1) break;
                SourceElement statementFirstChild = (SourceElement)statementChildren.get(0);
                switch (statementFirstChild.getSymbolKind()) {
                    case 57: {
                        int childEndOffset = statementFirstChild.getEndOffset();
                        if (offset <= childEndOffset) break;
                        SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)statementFirstChild;
                        String name = sourceSimpleNameExpression.getName();
                        this._data = VariableNaming.suggestNamesFromCamelWord(name, VariableNaming.VARIABLE_FORMATER);
                        return InsightType.VARIABLE_NAME;
                    }
                }
                break;
            }
            case 13: {
                int endOffset;
                SourceElement firstChild;
                List children = sourceElement.getChildren();
                if (children.size() <= 0 || !((firstChild = (SourceElement)children.get(0)) instanceof SourceTypeReference) || (endOffset = firstChild.getEndOffset()) >= offset) break;
                SourceTypeReference typeReference = (SourceTypeReference)firstChild;
                String name = typeReference.getName();
                this._data = VariableNaming.suggestNamesFromCamelWord(name, VariableNaming.PARAMETER_FORMATER);
                return InsightType.VARIABLE_NAME;
            }
            case 10: {
                int endOffset;
                SourceFieldVariable sourceFieldVariable = (SourceFieldVariable)sourceElement;
                SourceName nameElement = sourceFieldVariable.getNameElement();
                if (nameElement == null || (endOffset = nameElement.getEndOffset()) >= offset) break;
                String name = nameElement.getName();
                this._data = VariableNaming.suggestNamesFromCamelWord(name, VariableNaming.FIELD_FORMATER);
                break;
            }
            case 9: {
                int endOffset;
                SourceFieldDeclaration sourceFieldDeclaration = (SourceFieldDeclaration)sourceElement;
                SourceTypeReference sourceTypeReference = sourceFieldDeclaration.getSourceType();
                if (sourceTypeReference == null || (endOffset = sourceTypeReference.getEndOffset()) >= offset || !this.isInVariableName(textBuffer, endOffset, offset)) break;
                String name = sourceTypeReference.getName();
                this._data = VariableNaming.suggestNamesFromCamelWord(name, VariableNaming.FIELD_FORMATER);
                return InsightType.VARIABLE_NAME;
            }
        }
        return null;
    }

    private boolean isInVariableName(TextBuffer textBuffer, int from, int to) {
        boolean ret = true;
        int braceDepth = 0;
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer((ReadTextBuffer)textBuffer);
        lexer.setPosition(from);
        LexerToken lexerToken = lexer.createLexerToken();
        while (true) {
            int token = lexer.lex(lexerToken);
            if (lexerToken.getStartOffset() > to) break;
            switch (token) {
                case 0: {
                    break;
                }
                case 39: {
                    if (braceDepth != 0) break;
                    ret = true;
                    break;
                }
                case 33: {
                    if (braceDepth != 0) break;
                    ret = false;
                    break;
                }
                case 49: {
                    ++braceDepth;
                    break;
                }
                case 70: {
                    --braceDepth;
                }
            }
        }
        return ret;
    }

    public static enum InsightType {
        LABEL,
        PACKAGE,
        IMPORT,
        ANNOTATION,
        ANNOTATION_PARM,
        EXTENDS,
        IMPLEMENTS,
        THROWS,
        THROW,
        NEW,
        DOC_TAG,
        INLINE_DOC_TAG,
        DOC_TEXT,
        CLASS_CLAUSE,
        CLASS_BODY,
        CODE_USAGE,
        VARIABLE_NAME,
        UNKNOWN;

    }
}

