/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaTokens;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.util.filter.AnnotationFilter;
import oracle.javatools.parser.java.v2.util.filter.AssignableFilter;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.javatools.parser.java.v2.util.filter.OrFilter;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.insight.AutoImportInsightData;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightDataItem;
import oracle.jdevimpl.java.insight.PackageFilter;
import oracle.jdevimpl.java.insight.TypeFilter;
import oracle.jdevimpl.java.util.ExpressionFinder;
import oracle.jdevimpl.java.util.FoundSymbol;

final class ClassInsightData
extends AutoImportInsightData
implements JavaTokens {
    FoundSymbol dotNewPrefix;
    private static final EditDescriptor classDescriptor;
    private String namePrefix;
    private int showMode;
    private static final int SHOW_EXTENDIBLE_CLASSES = 1;
    private static final int SHOW_EXTENDIBLE_INTERFACES = 2;
    private static final int SHOW_ALL_INTERFACES = 3;
    private static final int SHOW_THROWABLES = 4;
    private static final int SHOW_ANNOTATIONS = 5;
    private static final int SHOW_NEW = 6;
    private static final int SHOW_TYPES = 7;
    private static final int SHOW_EVERYTHING = 8;

    @Override
    int getAnalysisStartOffset(ReadTextBuffer textBuffer, int caretOffset) {
        String afterDot;
        ExpressionFinder finder = this.helper.getFinder();
        FoundSymbol foundSymbol = finder.determinePrimaryPrefix(caretOffset, this.getPrimaryPrefixFilter());
        int identifierStart = ClassInsightData.getIdentifierStart(textBuffer, caretOffset);
        if (foundSymbol == null) {
            return identifierStart;
        }
        if (foundSymbol.string.endsWith(".") && (afterDot = textBuffer.getString(foundSymbol.endOffset, identifierStart - foundSymbol.endOffset)).trim().equals("new") && Character.isWhitespace(textBuffer.getChar(identifierStart - 1))) {
            this.dotNewPrefix = foundSymbol;
            return identifierStart;
        }
        String tmp = ClassInsightData.removeInitialNew(foundSymbol.string);
        int difference = foundSymbol.string.length() - tmp.length();
        return foundSymbol.startOffset + difference;
    }

    @Override
    EditDescriptor getEditDescriptor() {
        return classDescriptor;
    }

    @Override
    String identifySelf() {
        return "Class";
    }

    ClassInsightData(InsightContext insight, int definingToken, JavaFilter filter) {
        super(insight);
        this.setResultFilter(filter);
        this.determineContext(definingToken);
        this.fillInitialData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean complete(Object selectedObject) {
        AbstractInsight insight;
        boolean isPackage;
        int offsetAdjustment;
        int caretToStartOffset;
        int endOffset;
        int startOffset;
        TextBuffer textBuffer;
        BasicDocument document;
        int cursorAdjustment;
        boolean newTypeAddParameters;
        boolean completingNewType;
        boolean retriggerInsight;
        String classSuffix;
        String className;
        InsightDataItem item;
        block28: {
            block27: {
                item = (InsightDataItem)((Object)selectedObject);
                className = item.getName();
                classSuffix = "";
                retriggerInsight = false;
                completingNewType = false;
                newTypeAddParameters = false;
                cursorAdjustment = 0;
                document = this.helper.getDocument();
                textBuffer = this.helper.getTextBuffer();
                int caretOffset = this.helper.getCaretPosition();
                startOffset = this.getNameStartOffset((ReadTextBuffer)textBuffer, caretOffset);
                endOffset = this.getNameEndOffset((ReadTextBuffer)textBuffer, caretOffset);
                caretToStartOffset = caretOffset - startOffset;
                offsetAdjustment = this.helper.getCaretPositionAdjustment();
                boolean bl = isPackage = item.getItemType() == 9;
                if (!isPackage) break block27;
                classSuffix = ".";
                retriggerInsight = true;
                if (textBuffer.getLength() <= endOffset || textBuffer.getChar(endOffset) != '.') break block28;
                ++endOffset;
                break block28;
            }
            if (this.showMode == 6) {
                boolean addSuffix = true;
                for (int checkOffset = endOffset; checkOffset < textBuffer.getLength(); ++checkOffset) {
                    char c = textBuffer.getChar(checkOffset);
                    if (Character.isWhitespace(c)) {
                        continue;
                    }
                    if (c != '(' && c != '<') break;
                    addSuffix = false;
                    break;
                }
                if (addSuffix && this.getResultFilter() instanceof AssignableFilter) {
                    JavaType itemClassType;
                    JavaType targetType = ((AssignableFilter)this.getResultFilter()).getTarget();
                    if (item.getItemType() == 3 && targetType.isAssignableFrom(itemClassType = (JavaType)item.getUnderlyingItem())) {
                        Collection typeArguments;
                        classSuffix = "();";
                        completingNewType = true;
                        cursorAdjustment = -2;
                        if (itemClassType.isInterface() || itemClassType.isAbstract()) {
                            classSuffix = "()";
                            cursorAdjustment = -1;
                        }
                        if ((typeArguments = targetType.getActualTypeArguments()) != null && typeArguments.size() > 0) {
                            StringBuffer buf = new StringBuffer("<");
                            Iterator typeArgIter = typeArguments.iterator();
                            while (typeArgIter.hasNext()) {
                                if (buf.length() > 1) {
                                    buf.append(", ");
                                }
                                JavaType javaType = (JavaType)typeArgIter.next();
                                buf.append(javaType.getName());
                            }
                            buf.append(">");
                            buf.append(classSuffix);
                            classSuffix = buf.toString();
                        }
                        Collection constructors = itemClassType.getDeclaredConstructors();
                        for (JavaMethod constructor : constructors) {
                            if (constructor.getParameters().size() <= 0) continue;
                            newTypeAddParameters = true;
                            break;
                        }
                    }
                }
            }
        }
        document.writeLock();
        try {
            JavaType javaType;
            BasicEditorPane editor = this.helper.getEditorPane();
            editor.beginEdit(classDescriptor);
            try {
                String currentText = textBuffer.getString(startOffset, endOffset - startOffset);
                String replacementText = className + classSuffix;
                if (replacementText.startsWith(currentText)) {
                    int insertionPoint = editor.getCaretPosition() - caretToStartOffset;
                    document.insertString(startOffset + offsetAdjustment + currentText.length(), replacementText.substring(currentText.length()), null);
                    editor.setCaretPosition(insertionPoint + replacementText.length());
                } else {
                    document.remove(startOffset + offsetAdjustment, endOffset - startOffset);
                    document.insertString(startOffset + offsetAdjustment, replacementText, null);
                }
                if (completingNewType && newTypeAddParameters) {
                    editor.setCaretPosition(editor.getCaretPosition() + cursorAdjustment);
                }
            }
            catch (BadLocationException e) {
                System.err.println("Exception occurred in completion: " + e);
                e.printStackTrace();
            }
            finally {
                editor.endEdit();
            }
            if (!isPackage && this.namePrefix.length() > 0) {
                this.autoImport(this.namePrefix + className);
            } else if (this.namePrefix.length() == 0 && item.getItemType() == 3 && !(javaType = (JavaType)item.getUnderlyingItem()).isMemberClass()) {
                this.addImport(javaType.getQualifiedName());
            }
        }
        finally {
            document.writeUnlock();
        }
        if (completingNewType && newTypeAddParameters && (insight = this.helper.getInsight(2)) != null) {
            insight.restartPopupTimer();
        }
        return retriggerInsight;
    }

    @Override
    void fillInitialDataImpl() {
        this.namePrefix = this.findCurrentPrefix();
        this.fillDataList();
    }

    @Override
    void updateDataImpl() {
        String newPrefix = this.findCurrentPrefix();
        if (!newPrefix.startsWith(this.namePrefix)) {
            this.clearData();
            return;
        }
        if (!this.namePrefix.equals(newPrefix)) {
            this.namePrefix = newPrefix;
            this.fillDataList();
        }
    }

    @Override
    protected Object[] getMatchingDataImpl() {
        Object[] data = super.getMatchingDataImpl();
        if (this.showMode == 5) {
            ArrayList<Object> annotations = new ArrayList<Object>();
            ArrayList<Object> anythingElse = new ArrayList<Object>();
            for (Object object : data) {
                InsightDataItem item;
                JavaElement javaElement;
                if (object instanceof InsightDataItem && (javaElement = (item = (InsightDataItem)((Object)object)).getUnderlyingItem()) instanceof JavaType && ((JavaType)javaElement).isAnnotation()) {
                    annotations.add(object);
                    continue;
                }
                anythingElse.add(object);
            }
            annotations.addAll(anythingElse);
            data = annotations.toArray(new Object[annotations.size()]);
            annotations.clear();
            anythingElse.clear();
        }
        return data;
    }

    @Override
    public Object getDefault() {
        if (this.showMode == 5) {
            Object[] data = this.getMatchingData();
            String prefix = this.getCurrentPrefix().toLowerCase();
            if (prefix.length() == 0) {
                if (data.length > 0) {
                    return data[0];
                }
            } else {
                for (Object object : data) {
                    InsightDataItem item;
                    if (!(object instanceof InsightDataItem) || !(item = (InsightDataItem)((Object)object)).getName().toLowerCase().startsWith(prefix)) continue;
                    return item;
                }
            }
        }
        return super.getDefault();
    }

    private void determineContext(int definingToken) {
        block0 : switch (definingToken) {
            case 110: {
                ExpressionFinder finder = this.helper.getFinder();
                int caretPosition = this.helper.getCaretPosition();
                String[] returnedName = new String[1];
                int tokenPrecedingExtends = finder.tokenPrecedingExtends(caretPosition, returnedName);
                switch (tokenPrecedingExtends) {
                    case 103: {
                        this.showMode = 1;
                        break block0;
                    }
                    case 121: {
                        this.showMode = 2;
                        break block0;
                    }
                }
                this.showMode = 7;
                break;
            }
            case 117: {
                this.showMode = 3;
                break;
            }
            case 137: 
            case 138: {
                this.showMode = 4;
                break;
            }
            case 124: {
                this.showMode = 6;
                break;
            }
            case 79: {
                this.showMode = 5;
                break;
            }
            default: {
                throw new RuntimeException("Should not be reachable");
            }
        }
    }

    private void fillDataList() {
        int startOffset;
        int endOffset = startOffset = this.analysisStartOffset;
        if (this.namePrefix.length() > 0) {
            endOffset += this.namePrefix.length() - 1;
        }
        CallerContext.InputOptions options = new CallerContext.InputOptions();
        options.input = (byte)-122;
        if (this.option(1)) {
            options.squash = (byte)(options.squash | 0x10);
        }
        if (this.option(16)) {
            options.squash = (byte)(options.squash | 0x20);
        }
        switch (this.showMode) {
            case 4: {
                JavaClass throwable = this.provider.getClassByVMName("java/lang/Throwable");
                if (throwable == null) break;
                options.filter = new AssignableFilter((JavaType)throwable);
                break;
            }
            case 1: {
                options.squash = (byte)(options.squash | 0x40);
                options.filter = new TypeFilter(true, false, true);
                break;
            }
            case 2: {
                options.squash = (byte)(options.squash | 0x40);
                options.filter = new TypeFilter(false, true, true);
                break;
            }
            case 3: {
                options.filter = new TypeFilter(false, true, false);
                break;
            }
            case 5: {
                int caretPosition = this.helper.getCaretPosition();
                SourceFile file = this.helper.getSourceFile();
                SourceElement element = file.getElementAt(caretPosition);
                if (element.getSymbolKind() == 1) {
                    element = element.getParent();
                }
                if (element instanceof SourceMember) {
                    SourceMember thing = (SourceMember)element;
                    options.filter = new AnnotationFilter((SourceHasModifiers)thing);
                } else {
                    int symKind = element.getSymbolKind();
                    switch (symKind) {
                        case 12: 
                        case 13: 
                        case 17: 
                        case 18: 
                        case 21: {
                            options.filter = new AnnotationFilter(symKind);
                        }
                    }
                }
                if (options.filter != null) break;
                options.filter = new AnnotationFilter();
                break;
            }
            case 6: {
                JavaType javaType;
                JavaHasType javaHasType;
                if (this.dotNewPrefix == null) break;
                JavaFilter resultFilter = this.getResultFilter();
                if (resultFilter != null) {
                    if (!(resultFilter instanceof AssignableFilter)) break;
                    AssignableFilter assignableFilter = (AssignableFilter)resultFilter;
                    this.setResultFilter((JavaFilter)new AssignableFilter(assignableFilter.getTarget(), 2));
                    break;
                }
                String prefixName = this.dotNewPrefix.string;
                if (prefixName.endsWith(".")) {
                    prefixName = prefixName.substring(0, prefixName.length() - 1);
                }
                if ((javaHasType = this.callerContext.resolveAmbiguousName(prefixName)) != null && (javaType = javaHasType.getResolvedType()) != null) {
                    options.filter = new DotNewFilter(javaType);
                }
                options.input = (byte)(options.input & 0xFFFFFFFD);
                break;
            }
            case 7: {
                options.filter = new TypeFilter(false, false, false);
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw new RuntimeException("Not a showMode");
            }
        }
        if (options.filter != null) {
            PackageFilter pf = new PackageFilter();
            OrFilter or = new OrFilter((JavaFilter)pf, options.filter);
            options.filter = or;
        }
        this.fillDataListHelper(startOffset, endOffset, false, options);
    }

    static {
        String editName = JavaArb.getString(51);
        classDescriptor = new EditDescriptor(editName);
    }

    private class DotNewFilter
    implements JavaFilter {
        private JavaType classType;
        private Collection memberClasses;

        DotNewFilter(JavaType classType) {
            this.classType = classType;
        }

        public boolean accepts(JavaElement element) {
            if (this.memberClasses == null) {
                this.memberClasses = this.classType.getClasses();
                if (this.memberClasses == null) {
                    this.memberClasses = new ArrayList(0);
                }
            }
            for (JavaClass memberClass : this.memberClasses) {
                if (!memberClass.equals(element)) continue;
                return true;
            }
            return false;
        }
    }
}

