/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.insight;

import java.util.ArrayList;
import javax.swing.ListModel;
import javax.swing.text.BadLocationException;
import oracle.ide.model.Project;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.insight.InsightInputFilter;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.ReadOnlyListModel;
import oracle.javatools.editor.insight.SortedInsightInputFilter;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.util.filter.JavaFilter;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.compiler.CompilerOptionManager;
import oracle.jdevimpl.java.insight.InsightContext;
import oracle.jdevimpl.java.insight.InsightDataItem;
import oracle.jdevimpl.java.insight.JavaInsightOptions;
import oracle.jdevimpl.java.util.ExpressionFinder;
import oracle.jdevimpl.java.util.FoundSymbol;

abstract class AbstractCompletionInsightData
implements ListInsightData,
JavaConstants,
CallerContext.Constants {
    private static final int verboseValue = 0;
    static final int VERBOSE_MEMBER = 256;
    static final int VERBOSE_CLASS = 128;
    static final int VERBOSE_IMPORT = 64;
    static final int VERBOSE_PACKAGE = 32;
    static final int VERBOSE_LABEL = 16;
    static final int VERBOSE_ABSTRACT = 2;
    static final int VERBOSE_DETECT = 1;
    private InsightDataItem[] _insightDataItems;
    protected static final int OPTION_HIDE_DEPRECATED = 1;
    protected static final int OPTION_STRIKE_THRU_DEPRECATED = 2;
    protected static final int OPTION_SHOW_ACCESS_ICONS = 4;
    protected static final int OPTION_HIDE_OBJECT_DOT_STATIC = 8;
    protected static final int OPTION_HIDE_HIDDEN = 16;
    private static boolean suppressHidden = Boolean.getBoolean("insight.suppresshidden");
    private String _insertSuffix;
    final InsightContext helper;
    JavaProvider provider;
    CallerContext callerContext;
    ReadOnlyListModel listModel;
    InsightDataItem[] dataList;
    InsightDataItem[] filterDataList;
    String currentPrefix;
    Object[] matchingDataList;
    int analysisStartOffset;
    int optionsMask = 0;
    private JavaFilter resultFilter;
    static final InsightDataItem[] kEmptyDataList = new InsightDataItem[0];

    static boolean verboseOutput(int filter) {
        return (0 & filter) == filter;
    }

    static boolean getSuppressHidden() {
        return suppressHidden;
    }

    static void setSuppressHidden(boolean newValue) {
        suppressHidden = newValue;
    }

    void setInsertSuffix(String insertSuffix) {
        this._insertSuffix = insertSuffix;
    }

    void verbosePrintln(String msg) {
        if (AbstractCompletionInsightData.verboseOutput(2)) {
            System.out.print("AbstractInsight (");
            System.out.print(this.identifySelf());
            System.out.print("): ");
            System.out.println(msg);
        }
    }

    abstract EditDescriptor getEditDescriptor();

    abstract String identifySelf();

    abstract void fillInitialDataImpl();

    abstract void updateDataImpl();

    int getNameStartOffset(ReadTextBuffer textBuffer, int caretOffset) {
        return AbstractCompletionInsightData.getIdentifierStart(textBuffer, caretOffset);
    }

    int getNameEndOffset(ReadTextBuffer textBuffer, int caretOffset) {
        return AbstractCompletionInsightData.getIdentifierEnd(textBuffer, caretOffset);
    }

    int getAnalysisStartOffset(ReadTextBuffer textBuffer, int caretOffset) {
        ExpressionFinder finder = this.helper.getFinder();
        FoundSymbol foundSymbol = finder.determinePrimaryPrefix(caretOffset, this.getPrimaryPrefixFilter());
        if (foundSymbol == null) {
            return AbstractCompletionInsightData.getIdentifierStart(textBuffer, caretOffset);
        }
        return foundSymbol.startOffset;
    }

    int getPrimaryPrefixFilter() {
        return 0;
    }

    protected CodingStyleOptions getCodingStyleOptions() {
        CodingStyleManager csm = CodingStyleManager.getCodingStyleManager();
        if (csm != null) {
            return csm.getCodingStyleOptions();
        }
        return null;
    }

    protected void retrieveOptions(JavaInsightOptions options) {
        Project project;
        if (!options.getShowDeprecated()) {
            this.optionsMask |= 1;
        } else if (options.getStrikethruDeprecated()) {
            this.optionsMask |= 2;
        }
        if (options.getShowAccessIcons()) {
            this.optionsMask |= 4;
        }
        if (suppressHidden) {
            this.optionsMask |= 0x10;
        }
        if ((project = this.helper.getProject()) != null) {
            try {
                CompilerOptionManager optionManager = CompilerOptionManager.getInstance((PropertyStorage)project);
                if (optionManager.isShowObjectDotStaticWarnings()) {
                    this.optionsMask |= 8;
                }
            }
            catch (AssertionError e) {
                ((Throwable)((Object)e)).printStackTrace();
            }
        }
    }

    AbstractCompletionInsightData(InsightContext helper) {
        this.helper = helper;
        JavaInsightOptions options = helper.getJavaInsightOptions();
        this.retrieveOptions(options);
        this.provider = helper.getProvider();
        this.callerContext = helper.getCallerContext();
    }

    public ListModel getListModel() {
        return this.buildListModel();
    }

    protected InsightInputFilter getInputFilter() {
        return SortedInsightInputFilter.INSTANCE;
    }

    private ReadOnlyListModel buildListModel() {
        this._insightDataItems = (InsightDataItem[])this.getData();
        this.listModel = new ReadOnlyListModel((Object[])this._insightDataItems);
        return this.listModel;
    }

    public Object[] getData() {
        JavaFilter filter = this.getResultFilter();
        if (filter == null) {
            return this.dataList;
        }
        if (this.filterDataList == null) {
            int dataSize = this.dataList.length;
            ArrayList<InsightDataItem> filteredList = new ArrayList<InsightDataItem>(dataSize);
            for (int i = 0; i < dataSize; ++i) {
                JavaElement result = this.dataList[i].getUnderlyingItem();
                if (!filter.accepts(result)) continue;
                filteredList.add(this.dataList[i]);
            }
            int filterCount = filteredList.size();
            this.filterDataList = filteredList.toArray(new InsightDataItem[filterCount]);
        }
        return this.filterDataList;
    }

    public Object[] getMatchingData() {
        if (this.matchingDataList == null) {
            this.matchingDataList = this.getMatchingDataImpl();
        }
        return this.matchingDataList;
    }

    protected Object[] getMatchingDataImpl() {
        String prefix = this.getCurrentPrefix();
        this.buildListModel();
        InsightInputFilter inputFilter = this.getInputFilter();
        return inputFilter.getMatchingData((ListDataItem[])this._insightDataItems, prefix);
    }

    public int getMatchingDataCount() {
        Object[] matchingData = this.getMatchingData();
        return matchingData == null ? 0 : matchingData.length;
    }

    public Object getDefault() {
        String prefix = this.getCurrentPrefix();
        this.buildListModel();
        InsightInputFilter inputFilter = this.getInputFilter();
        ListDataItem ret = inputFilter.findClosestDataItem((ListDataItem[])this._insightDataItems, prefix);
        return ret;
    }

    protected String getCurrentPrefix() {
        if (this.currentPrefix == null) {
            TextBuffer textBuffer = this.helper.getTextBuffer();
            int caretOffset = this.helper.getCaretPosition();
            int prefixStart = this.getNameStartOffset((ReadTextBuffer)textBuffer, caretOffset);
            int prefixLength = caretOffset - prefixStart;
            this.currentPrefix = textBuffer.getString(prefixStart, prefixLength);
        }
        return this.currentPrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean complete(Object selectedObject) {
        InsightDataItem item = (InsightDataItem)((Object)selectedObject);
        String itemName = item.getName();
        String insertedText = this._insertSuffix == null ? itemName : itemName + this._insertSuffix;
        BasicDocument document = this.helper.getDocument();
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int caretOffset = this.helper.getCaretPosition();
        int offsetAdjustment = this.helper.getCaretPositionAdjustment();
        int startOffset = this.getNameStartOffset((ReadTextBuffer)textBuffer, caretOffset);
        int endOffset = this.getNameEndOffset((ReadTextBuffer)textBuffer, caretOffset);
        BasicEditorPane editor = this.helper.getEditorPane();
        editor.beginEdit(this.getEditDescriptor());
        try {
            document.remove(startOffset + offsetAdjustment, endOffset - startOffset);
            document.insertString(startOffset + offsetAdjustment, insertedText, null);
        }
        catch (BadLocationException e) {
            System.err.println("Exception occurred in completion: " + e);
            e.printStackTrace();
        }
        finally {
            editor.endEdit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partialComplete() {
        int caretToStartOffset;
        String userText;
        String userPrefix;
        int endOffset;
        int startOffset;
        BasicDocument document = this.helper.getDocument();
        TextBuffer textBuffer = this.helper.getTextBuffer();
        document.readLock();
        try {
            int caretOffset = this.helper.getCaretPosition();
            startOffset = this.getNameStartOffset((ReadTextBuffer)textBuffer, caretOffset);
            endOffset = this.getNameEndOffset((ReadTextBuffer)textBuffer, caretOffset);
            int prefixLength = caretOffset - startOffset;
            userPrefix = textBuffer.getString(startOffset, prefixLength);
            userText = textBuffer.getString(startOffset, endOffset - startOffset);
            caretToStartOffset = caretOffset - startOffset;
        }
        finally {
            document.readUnlock();
        }
        this.buildListModel();
        InsightInputFilter inputFilter = this.getInputFilter();
        String commonPrefix = inputFilter.findCommonPrefix((ListDataItem[])this._insightDataItems, userPrefix);
        if (commonPrefix == null || commonPrefix.length() == 0) {
            return;
        }
        if (!this.isExactCommonPrefix(commonPrefix)) {
            return;
        }
        if (this.prefixNotSuitable(commonPrefix.trim())) {
            return;
        }
        if (userText.length() > 0 && !commonPrefix.startsWith(userText)) {
            return;
        }
        int offsetAdjustment = this.helper.getCaretPositionAdjustment();
        BasicEditorPane editor = this.helper.getEditorPane();
        BasicDocument newDocument = this.helper.getDocument();
        TextBuffer newTextBuffer = this.helper.getTextBuffer();
        editor.beginEdit(this.getEditDescriptor());
        try {
            String currentUserText = null;
            try {
                currentUserText = newTextBuffer.getString(startOffset, endOffset - startOffset);
                if (!userText.equals(currentUserText)) {
                    return;
                }
            }
            catch (IndexOutOfBoundsException ex) {
                return;
            }
            int insertionPoint = editor.getCaretPosition() - caretToStartOffset;
            newDocument.insertString(startOffset + offsetAdjustment + currentUserText.length(), commonPrefix.substring(currentUserText.length()), null);
            editor.setCaretPosition(insertionPoint + commonPrefix.length());
        }
        catch (BadLocationException e) {
            System.err.println("Exception occurred in partial completion: " + e);
            e.printStackTrace();
        }
        finally {
            editor.endEdit();
        }
    }

    private boolean isExactCommonPrefix(String commonPrefix) {
        if (this._insightDataItems != null) {
            String lowerCommonPrefix = commonPrefix.toLowerCase();
            for (InsightDataItem item : this._insightDataItems) {
                String name = item.getName();
                if (!name.toLowerCase().startsWith(lowerCommonPrefix) || name.startsWith(commonPrefix)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean prefixNotSuitable(String commonPrefix) {
        int quoteCount = 0;
        int singleCount = 0;
        int curlyCount = 0;
        int bracketCount = 0;
        int parenCount = 0;
        block11: for (int index = 0; index < commonPrefix.length(); ++index) {
            char c = commonPrefix.charAt(index);
            switch (c) {
                case '\\': {
                    ++index;
                    continue block11;
                }
                case '{': {
                    if (quoteCount != 0 || singleCount != 0) continue block11;
                    ++curlyCount;
                    continue block11;
                }
                case '}': {
                    if (quoteCount != 0 || singleCount != 0) continue block11;
                    --curlyCount;
                    continue block11;
                }
                case '\"': {
                    if (quoteCount == 0) {
                        ++quoteCount;
                        continue block11;
                    }
                    --quoteCount;
                    continue block11;
                }
                case '\'': {
                    if (singleCount == 0) {
                        ++singleCount;
                        continue block11;
                    }
                    --singleCount;
                    continue block11;
                }
                case '[': {
                    if (quoteCount != 0 || singleCount != 0) continue block11;
                    ++bracketCount;
                    continue block11;
                }
                case ']': {
                    if (quoteCount != 0 || singleCount != 0) continue block11;
                    --bracketCount;
                    continue block11;
                }
                case '(': {
                    if (quoteCount != 0 || singleCount != 0) continue block11;
                    ++parenCount;
                    continue block11;
                }
                case ')': {
                    if (quoteCount != 0 || singleCount != 0) continue block11;
                    --parenCount;
                    continue block11;
                }
            }
        }
        return curlyCount != 0 || quoteCount != 0 || singleCount != 0 || bracketCount != 0 || parenCount != 0;
    }

    void clearData() {
        this.dataList = kEmptyDataList;
        this.matchingDataList = null;
        this.listModel = null;
        this.filterDataList = null;
        this.currentPrefix = null;
    }

    private void clearFilterData() {
        this.listModel = null;
        this.matchingDataList = null;
        this.filterDataList = null;
    }

    private void updateDataListForAccessIcons() {
        if (this.option(4)) {
            int numItems = this.dataList.length;
            for (int i = 0; i < numItems; ++i) {
                this.dataList[i].setShowAccessIcon();
            }
        }
    }

    final void fillInitialData() {
        this.verbosePrintln("fillInitialData");
        this.clearData();
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int caretOffset = this.helper.getCaretPosition();
        this.analysisStartOffset = this.getAnalysisStartOffset((ReadTextBuffer)textBuffer, caretOffset);
        this.fillInitialDataImpl();
        this.updateDataListForAccessIcons();
    }

    public final void updateData() {
        this.verbosePrintln("updateData");
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int caretOffset = this.helper.getCaretPosition();
        int newAnalysisStartOffset = this.getAnalysisStartOffset((ReadTextBuffer)textBuffer, caretOffset);
        if (newAnalysisStartOffset != this.analysisStartOffset) {
            this.clearData();
            return;
        }
        this.verbosePrintln("updateDataImpl");
        this.updateDataImpl();
        this.currentPrefix = null;
        this.matchingDataList = null;
        this.updateDataListForAccessIcons();
    }

    void fillDataListHelper(CallerContext.InputOptions options) {
        this.fillDataListHelper(0, 0, false, options);
    }

    void fillDataListHelper(int startOffset, int endOffset, boolean expression, CallerContext.InputOptions options) {
        this.clearData();
        this.dataList = this.fillDataListHelperImpl(startOffset, endOffset, expression, options);
        if (this.dataList == null || this.dataList.length == 0) {
            this.dataList = kEmptyDataList;
            this.errorEmpty(null);
        }
    }

    protected InsightDataItem[] fillDataListHelperImpl(int startOffset, int endOffset, boolean expression, CallerContext.InputOptions options) {
        CallerContext.Output output;
        InsightDataItem[] insightDataItemArray;
        JavaPackage packagePrimary = null;
        JavaHasType primary = null;
        if (startOffset != endOffset) {
            SourceFactory factory;
            SourceExpression e;
            TextBuffer textBuffer = this.helper.getTextBuffer();
            String inputText = textBuffer.getString(startOffset, endOffset - startOffset);
            SourceElement scope = this.callerContext.getSourceScope();
            SourceFile file = scope.getOwningSourceFile();
            if (file == null) {
                CommonUtilities.panic((String)"No SourceFile instance");
            }
            if ((e = (factory = file.getFactory()).createExpression(inputText)) != null) {
                e.setContext(this.callerContext);
                primary = e.getResolvedObject();
                if (primary == null) {
                    if (CommonUtilities.isValidQualifiedName((String)inputText)) {
                        packagePrimary = this.provider.getPackage(inputText);
                    } else {
                        this.errorSemantic("Could not determine lhs context.");
                        return null;
                    }
                }
            }
        }
        if ((insightDataItemArray = this.createInsightDataItems(output = packagePrimary != null ? this.callerContext.listNames(packagePrimary, options) : this.callerContext.listNames(primary, options), packagePrimary, primary)) == null || insightDataItemArray.length == 0) {
            return null;
        }
        return insightDataItemArray;
    }

    protected InsightDataItem[] createInsightDataItems(CallerContext.Output output, JavaPackage packagePrimary, JavaHasType hasTypePrimary) {
        ArrayList list = output.all;
        int count = list.size();
        InsightDataItem[] outArray = new InsightDataItem[count];
        int i = 0;
        for (JavaElement javaElement : list) {
            outArray[i++] = new InsightDataItem(javaElement);
        }
        return outArray;
    }

    void errorParsing() {
    }

    void errorSemantic(String message) {
    }

    void errorEmpty(String target) {
    }

    protected String findCurrentPrefix() {
        TextBuffer textBuffer = this.helper.getTextBuffer();
        int caretOffset = this.helper.getCaretPosition();
        int prefixStart = this.analysisStartOffset;
        int prefixEnd = AbstractCompletionInsightData.getIdentifierStart((ReadTextBuffer)textBuffer, caretOffset);
        if (prefixEnd == prefixStart) {
            return "";
        }
        while (Character.isWhitespace(textBuffer.getChar(prefixEnd - 1))) {
            --prefixEnd;
        }
        int prefixLength = prefixEnd - prefixStart;
        return textBuffer.getString(prefixStart, prefixLength);
    }

    protected static int getIdentifierStart(ReadTextBuffer textBuffer, int offset) {
        char c;
        int checkPos;
        for (checkPos = offset - 1; checkPos >= 0 && Character.isJavaIdentifierPart(c = textBuffer.getChar(checkPos)); --checkPos) {
        }
        return checkPos + 1;
    }

    protected static int getIdentifierEnd(ReadTextBuffer textBuffer, int offset) {
        char c;
        int checkPos;
        int bufferLength = textBuffer.getLength();
        for (checkPos = offset; checkPos < bufferLength && Character.isJavaIdentifierPart(c = textBuffer.getChar(checkPos)); ++checkPos) {
        }
        return checkPos;
    }

    protected static String removeInitialNew(String src) {
        int checkPos;
        if (!src.startsWith("new")) {
            return src;
        }
        if (!Character.isWhitespace(src.charAt(3))) {
            return src;
        }
        int srcLength = src.length();
        for (checkPos = 4; checkPos < srcLength && Character.isWhitespace(src.charAt(checkPos)); ++checkPos) {
        }
        return src.substring(checkPos);
    }

    JavaFilter getResultFilter() {
        return this.resultFilter;
    }

    void setResultFilter(JavaFilter filter) {
        if (this.resultFilter != null) {
            this.clearFilterData();
        }
        this.resultFilter = filter;
    }

    protected final boolean option(int option) {
        return (this.optionsMask & option) != 0;
    }
}

