/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.net.URL;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.imports.ImportAssistPlugin;

public class SmartImportComparator
implements Comparator {
    private Set<String> currentImportedPackages = new HashSet<String>();
    private String currentPackage;
    private Context context;
    private String enteredText;

    public SmartImportComparator(SourceFile currentFile, Context context, String enteredText) {
        for (SourceImport anImport : currentFile.getSourceImports()) {
            this.currentImportedPackages.add(ImportAssistPlugin.getPackageName(anImport.getName()));
        }
        this.currentPackage = currentFile.getPackageName();
        this.context = context;
        this.enteredText = enteredText;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null & o2 != null) {
            return 1;
        }
        if (o1 != null && o2 == null) {
            return -1;
        }
        return this.compare(o1.toString(), o2.toString());
    }

    private int compare(String o1, String o2) {
        String package1 = ImportAssistPlugin.getPackageName(o1);
        String package2 = ImportAssistPlugin.getPackageName(o2);
        String class1 = ImportAssistPlugin.getClassName(o1);
        String class2 = ImportAssistPlugin.getClassName(o2);
        if (this.isMatchOfEntered(class1)) {
            if (!this.isMatchOfEntered(class2)) {
                return -1;
            }
        } else if (this.isMatchOfEntered(class2)) {
            return 1;
        }
        if (this.isInSubPackage(package1)) {
            return this.isInSubPackage(package2) ? String.CASE_INSENSITIVE_ORDER.compare(o1, o2) : -1;
        }
        if (this.isInSubPackage(package2)) {
            return 1;
        }
        if (this.isInSuperPackage(package1)) {
            return this.isInSuperPackage(package2) ? String.CASE_INSENSITIVE_ORDER.compare(o1, o2) : -1;
        }
        if (this.isInSuperPackage(package2)) {
            return 1;
        }
        if (this.isInImports(package1)) {
            return this.isInImports(package2) ? String.CASE_INSENSITIVE_ORDER.compare(o1, o2) : -1;
        }
        if (this.isInImports(package2)) {
            return 1;
        }
        if (this.isInProject(o1)) {
            return this.isInProject(o2) ? String.CASE_INSENSITIVE_ORDER.compare(o1, o2) : -1;
        }
        if (this.isInProject(o2)) {
            return 1;
        }
        return String.CASE_INSENSITIVE_ORDER.compare(o1, o2);
    }

    private boolean isMatchOfEntered(String className) {
        return className.equals(this.enteredText);
    }

    private boolean isInSubPackage(String packageName) {
        return packageName.startsWith(this.currentPackage);
    }

    private boolean isInSuperPackage(String packageName) {
        return this.currentPackage.startsWith(packageName);
    }

    private boolean isInImports(String packageName) {
        return this.currentImportedPackages.contains(packageName);
    }

    private boolean isInProject(String className) {
        JavaManager jman = JavaManager.getInstance((Project)this.context.getProject());
        JavaClass jClass = jman.getClass(className);
        if (jClass != null) {
            URL url = jClass.getURL();
            return JavaManager.isDefinedIn((Project)this.context.getProject(), (URL)url);
        }
        return false;
    }
}

