/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.imports.AutoImportExceptionsDialog;
import oracle.jdevimpl.java.imports.JavaImportOptions;

public final class JavaImportOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener,
ChangeListener {
    private JCheckBox checkbox_sortOnOrganize;
    private JCheckBox checkbox_moveCaret;
    private JCheckBox checkbox_autoImportUnambiguous;
    private JButton button_autoImportExceptions;
    private JCheckBox checkbox_assistEnablePopup;
    private JSlider slider_assistPopupDelay;
    private JLabel label_assistPopupDelayText;
    private NumberFormat numberFormatter;
    private List exceptionList = new LinkedList();

    public JavaImportOptionsPanel() {
        this.setHelpID("f1_idedidesetimports_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        JavaImportOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        JavaImportOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private JavaImportOptions findOptions(TraversableContext tc) {
        JavaImportOptions options = (JavaImportOptions)tc.find("JavaImportOptions");
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        JavaImportOptions options = this.findOptions(tc);
        JavaImportOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(JavaImportOptions options) {
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        float value = (float)this.slider_assistPopupDelay.getValue() / 10.0f;
        String valueStr = JavaArb.format(250, this.numberFormatter.format(value));
        this.slider_assistPopupDelay.setToolTipText(valueStr);
        this.label_assistPopupDelayText.setText(valueStr);
    }

    void loadSettingsFrom(JavaImportOptions options) {
        this.checkbox_sortOnOrganize.setSelected(options.getSortOnOrganize());
        this.checkbox_moveCaret.setSelected(options.getMoveCaret());
        this.checkbox_autoImportUnambiguous.setSelected(options.getAutoImport());
        boolean enablePopup = options.getAssistEnablePopup();
        int popupDelay = options.getAssistPopupDelay();
        this.checkbox_assistEnablePopup.setSelected(enablePopup);
        this.slider_assistPopupDelay.setValue(popupDelay / 100);
        this.exceptionList = options.getAutoImportExceptionList();
    }

    void saveSettingsTo(JavaImportOptions options) throws TraversalException {
        options.setSortOnOrganize(this.checkbox_sortOnOrganize.isSelected());
        options.setMoveCaret(this.checkbox_moveCaret.isSelected());
        options.setAutoImport(this.checkbox_autoImportUnambiguous.isSelected());
        int popupDelay = this.slider_assistPopupDelay.getValue() * 100;
        boolean enablePopup = this.checkbox_assistEnablePopup.isSelected();
        options.setAssistEnablePopup(enablePopup);
        options.setAssistPopupDelay(popupDelay);
        options.setAutoImportExceptionList(this.exceptionList);
    }

    private void initializeComponent() {
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(1);
        this.numberFormatter.setMaximumFractionDigits(1);
        String sortOnOrganizeText = JavaArb.getString(219);
        this.checkbox_sortOnOrganize = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_sortOnOrganize, (String)sortOnOrganizeText);
        String moveCaretText = JavaArb.getString(220);
        this.checkbox_moveCaret = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_moveCaret, (String)moveCaretText);
        String autoImportText = JavaArb.getString(221);
        this.checkbox_autoImportUnambiguous = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoImportUnambiguous, (String)autoImportText);
        this.button_autoImportExceptions = new JButton();
        ResourceUtils.resButton((AbstractButton)this.button_autoImportExceptions, (String)JavaArb.getString(222));
        this.button_autoImportExceptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JavaImportOptionsPanel.this.editAutoExceptions();
            }
        });
        JPanel autoImportPanel = new JPanel(new FlowLayout(3, 0, 0));
        autoImportPanel.add(this.checkbox_autoImportUnambiguous);
        autoImportPanel.add(Box.createHorizontalStrut(8));
        autoImportPanel.add(this.button_autoImportExceptions);
        String enablePopupText = JavaArb.getString(223);
        this.checkbox_assistEnablePopup = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_assistEnablePopup, (String)enablePopupText);
        String sliderText = JavaArb.getString(224);
        JLabel label_assistPopupDelay = new JLabel();
        this.slider_assistPopupDelay = new JSlider(5, 50, 25);
        this.slider_assistPopupDelay.addChangeListener(this);
        this.label_assistPopupDelayText = new JLabel();
        ResourceUtils.resLabel((JLabel)label_assistPopupDelay, (Component)this.slider_assistPopupDelay, (String)sliderText);
        String startScale = JavaArb.getString(225);
        String endScale = JavaArb.getString(226);
        JLabel label_minValue = new JLabel(startScale);
        JLabel label_maxValue = new JLabel(endScale);
        this.slider_assistPopupDelay.setPaintLabels(false);
        this.slider_assistPopupDelay.setPaintTicks(true);
        this.slider_assistPopupDelay.setMajorTickSpacing(5);
        this.slider_assistPopupDelay.setMinorTickSpacing(1);
        this.slider_assistPopupDelay.setSnapToTicks(true);
        Component[] completionDependents = new Component[]{this.slider_assistPopupDelay, this.checkbox_autoImportUnambiguous, label_assistPopupDelay, this.label_assistPopupDelayText, label_minValue, label_maxValue};
        new ItemSelectableTracker((ItemSelectable)this.checkbox_assistEnablePopup, completionDependents);
        this.checkbox_autoImportUnambiguous.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("enabled")) {
                    JavaImportOptionsPanel.this.button_autoImportExceptions.setEnabled(JavaImportOptionsPanel.this.checkbox_autoImportUnambiguous.isEnabled() && JavaImportOptionsPanel.this.checkbox_autoImportUnambiguous.isSelected());
                }
            }
        });
        new ItemSelectableTracker((ItemSelectable)this.checkbox_autoImportUnambiguous, new Component[]{this.button_autoImportExceptions});
        Insets defaultInsets = new Insets(0, 0, 5, 5);
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        Insets indentedInsets = new Insets(0, 18, 5, 5);
        Insets indentedHeaderInsets = new Insets(0, 18, 7, 5);
        JPanel panel_imports = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_imports.add((Component)this.checkbox_sortOnOrganize, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        panel_imports.add((Component)this.checkbox_moveCaret, constraints);
        constraints = new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0);
        panel_imports.add((Component)this.checkbox_assistEnablePopup, constraints);
        constraints = new GridBagConstraints(0, 4, 0, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        panel_imports.add((Component)autoImportPanel, constraints);
        JPanel panel_popup = new JPanel(new GridBagLayout());
        constraints = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, indentedHeaderInsets, 0, 0);
        panel_popup.add((Component)label_assistPopupDelay, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, indentedInsets, 0, 0);
        panel_popup.add((Component)label_minValue, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, emptyInsets, 0, 0);
        panel_popup.add((Component)this.slider_assistPopupDelay, constraints);
        constraints = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, defaultInsets, 0, 0);
        panel_popup.add((Component)label_maxValue, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, indentedInsets, 0, 0);
        panel_popup.add((Component)this.label_assistPopupDelayText, constraints);
        constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, emptyInsets, 0, 0);
        this.add(panel_imports, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, emptyInsets, 0, 0);
        this.add(panel_popup, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, emptyInsets, 0, 0);
        this.add(Box.createGlue(), constraints);
    }

    private void editAutoExceptions() {
        AutoImportExceptionsDialog exDialog = new AutoImportExceptionsDialog(this.exceptionList);
        exDialog.pack();
        exDialog.setLocationRelativeTo((Component)Ide.getMainWindow());
        exDialog.setVisible(true);
        if (!exDialog.isCancelled()) {
            this.exceptionList = exDialog.getExceptionList();
        }
    }
}

