/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.imports.JavaImportOptions;

public final class ImportUtilities2 {
    protected static final EditDescriptor sortImportsDescriptor;
    protected static final EditDescriptor widenImportsDescriptor;
    protected static final EditDescriptor narrowImportsDescriptor;
    protected static final EditDescriptor removeUnusedImportsDescriptor;

    public static void insertImport(String fqName, boolean isStatic, SourceFile sourceFile, TextBuffer textBuffer) {
        ImportLine[] originalImports = ImportUtilities2.getImports(sourceFile, textBuffer);
        ImportLine[] imports = ImportUtilities2.insertImport(fqName, isStatic, sourceFile, originalImports, textBuffer);
        ImportUtilities2.disposeImports(imports, textBuffer);
    }

    public static void insertImports(String[] fqNames, SourceFile sourceFile, TextBuffer textBuffer) {
        ImportLine[] imports = ImportUtilities2.getImports(sourceFile, textBuffer);
        int count = fqNames.length;
        for (int i = 0; i < count; ++i) {
            imports = ImportUtilities2.insertImport(fqNames[i], false, sourceFile, imports, textBuffer);
        }
        ImportUtilities2.disposeImports(imports, textBuffer);
    }

    protected static ImportLine[] insertImport(String fqName, boolean isStatic, SourceFile sourceFile, ImportLine[] imports, TextBuffer textBuffer) {
        String importPackage;
        String packageName = ImportUtilities2.getPackageName(sourceFile);
        if (packageName.equals(importPackage = ImportUtilities2.getPackageFor(fqName))) {
            return imports;
        }
        if (importPackage.equals("java.lang")) {
            return imports;
        }
        int count = imports.length;
        String importText = ImportUtilities2.getImportText(fqName, isStatic);
        LineMap lineMap = textBuffer.getLineMap();
        if (count == 0) {
            int packageLine;
            int packageLineEnd;
            int packageEnd = 0;
            SourcePackage sourcePackage = sourceFile.getSourcePackage();
            if (sourcePackage != null && ImportUtilities2.isWhitespace(textBuffer, packageEnd = sourcePackage.getEndOffset(), packageLineEnd = lineMap.getLineEndOffset(packageLine = lineMap.getLineFromOffset(packageEnd)))) {
                packageEnd = packageLineEnd;
            }
            ImportLine insertImportLine = ImportUtilities2.createAndInsertImport(importText, fqName, textBuffer, packageEnd);
            if (packageEnd != 0) {
                ImportUtilities2.insertEmptyLine(textBuffer, packageEnd);
            }
            return new ImportLine[]{insertImportLine};
        }
        ImportLine beforeImportLine = null;
        ImportLine afterImportLine = null;
        int insertIndex = 0;
        for (int i = 0; i < count; ++i) {
            ImportLine checkImportLine = imports[i];
            String checkFQName = checkImportLine._fqName;
            int compare = fqName.compareToIgnoreCase(checkFQName);
            if (compare < 0) {
                afterImportLine = checkImportLine;
                break;
            }
            if (compare <= 0) {
                return imports;
            }
            beforeImportLine = checkImportLine;
            insertIndex = i + 1;
        }
        int insertOffset = beforeImportLine != null ? beforeImportLine._end.getOffset() : afterImportLine._start.getOffset();
        ImportLine insertImportLine = ImportUtilities2.createAndInsertImport(importText, fqName, textBuffer, insertOffset);
        ArrayList<ImportLine> importList = new ArrayList<ImportLine>(Arrays.asList(imports));
        importList.add(insertIndex, insertImportLine);
        ArrayList<ImportLine> groupList = new ArrayList<ImportLine>();
        groupList.add(beforeImportLine);
        groupList.add(insertImportLine);
        groupList.add(afterImportLine);
        groupList.remove(null);
        int groupCount = groupList.size();
        ImportLine[] groupImports = groupList.toArray(new ImportLine[groupCount]);
        lineMap = textBuffer.getLineMap();
        int startLine = lineMap.getLineFromOffset(groupImports[0]._start.getOffset());
        int endLine = lineMap.getLineFromOffset(groupImports[groupCount - 1]._end.getOffset());
        ImportUtilities2.removeEmptyLines(textBuffer, startLine, endLine);
        JavaImportOptions groupOptions = ImportUtilities2.getImportOptions();
        ImportUtilities2.groupImports(groupImports, textBuffer, groupOptions);
        int remaining = importList.size();
        return importList.toArray(new ImportLine[remaining]);
    }

    public static void narrowImports(BasicEditorPane editor, Context context) {
        new NarrowOperation().performOperation(editor, context);
    }

    public static void widenImports(BasicEditorPane editor, Context context) {
        new WidenOperation().performOperation(editor, context);
    }

    public static void removeUnusedImports(BasicEditorPane editor, Context context) {
        new RemoveUnusedOperation().performOperation(editor, context);
    }

    public static void sortImports(BasicEditorPane editor, Context context) {
        new SortOperation().performOperation(editor, context);
    }

    protected static ImportLine[] narrowImports(ImportLine[] imports, TextBuffer textBuffer) {
        ImportLine[] originalImports = imports;
        imports = ImportUtilities2.removeUnusedImports(imports, textBuffer);
        int count = imports.length;
        ArrayList<ImportLine> importList = new ArrayList<ImportLine>(count);
        for (int i = 0; i < count; ++i) {
            ImportLine importLine = imports[i];
            SourceImport sourceImport = importLine._import;
            if (sourceImport == null) {
                importList.add(importLine);
                continue;
            }
            if (ImportUtilities2.isNarrowImport(importLine)) {
                importList.add(importLine);
                continue;
            }
            ArrayList<String> elementList = new ArrayList<String>();
            for (Object element : sourceImport.getImportedElements()) {
                JavaHasType importedType;
                JavaType resolvedType;
                if (!(element instanceof JavaHasType) || (resolvedType = (importedType = (JavaHasType)element).getResolvedType()) == null) continue;
                String resolvedName = resolvedType.getQualifiedName();
                elementList.add(resolvedName);
            }
            Collections.sort(elementList, String.CASE_INSENSITIVE_ORDER);
            boolean isStatic = sourceImport.isStatic();
            int insertOffset = importLine._start.getOffset();
            OffsetMark insertPosition = textBuffer.addOffsetMark(insertOffset, true);
            if (elementList.size() == 0) {
                importList.add(importLine);
            } else {
                ImportUtilities2.removeImport(importLine, textBuffer);
                ImportUtilities2.disposeImport(importLine, textBuffer);
                for (String resolvedName : elementList) {
                    String importText = ImportUtilities2.getImportText(resolvedName, isStatic);
                    ImportLine resolvedImport = ImportUtilities2.createAndInsertImport(importText, resolvedName, textBuffer, insertPosition.getOffset());
                    importList.add(resolvedImport);
                }
            }
            textBuffer.removeOffsetMark(insertPosition);
        }
        int remaining = importList.size();
        return importList.toArray(new ImportLine[remaining]);
    }

    protected static ImportLine[] widenImports(JavaClassLocator classLocator, SourceFile sourceFile, ImportLine[] imports, TextBuffer textBuffer) {
        String packageName = ImportUtilities2.getPackageName(sourceFile);
        List packageList = ImportUtilities2.getPackageList(imports);
        packageList.remove("java.lang");
        packageList.remove(packageName);
        Collection packageClasses = classLocator.getClassesInPackage(packageName);
        HashMap<String, Collection> packageToClassesMap = new HashMap<String, Collection>();
        for (String packageToAdd : packageList) {
            Collection classes = classLocator.getClassesInPackage(packageToAdd);
            packageToClassesMap.put(packageToAdd, classes);
        }
        packageToClassesMap.put("java.lang", classLocator.getClassesInPackage("java.lang"));
        ImportLine[] wideImports = ImportUtilities2.getWideImports(imports);
        List widePackageList = ImportUtilities2.getPackageList(wideImports);
        ArrayList widePackageToAddList = new ArrayList(packageList);
        widePackageToAddList.removeAll(widePackageList);
        int count = imports.length;
        ArrayList<ImportLine> importList = new ArrayList<ImportLine>(count);
        ArrayList wideImportsToInclude = new ArrayList(packageList);
        for (int i = 0; i < count; ++i) {
            ImportLine importLine = imports[i];
            if (ImportUtilities2.isStatic(importLine)) {
                importList.add(importLine);
                continue;
            }
            String importPackage = ImportUtilities2.getPackageFor(importLine._fqName);
            if (importPackage.equals(packageName)) {
                ImportUtilities2.removeImport(importLine, textBuffer);
                ImportUtilities2.disposeImport(importLine, textBuffer);
                continue;
            }
            String importClass = ImportUtilities2.getClassFor(importLine._fqName);
            if (packageClasses.contains(importClass)) {
                importList.add(importLine);
                continue;
            }
            if (ImportUtilities2.isWideImport(importLine)) {
                importList.add(importLine);
                continue;
            }
            int packageCount = 0;
            for (Collection classes : packageToClassesMap.values()) {
                if (!classes.contains(importClass)) continue;
                ++packageCount;
            }
            int wideOffset = importLine._end.getOffset();
            if (packageCount <= 1) {
                wideOffset = importLine._start.getOffset();
                ImportUtilities2.removeImport(importLine, textBuffer);
                ImportUtilities2.disposeImport(importLine, textBuffer);
            } else {
                importList.add(importLine);
            }
            if (importPackage.length() == 0 || !wideImportsToInclude.contains(importPackage)) continue;
            String fqName = importPackage + ".*";
            String textLine = ImportUtilities2.getImportText(fqName, false);
            ImportLine wideImportLine = ImportUtilities2.createAndInsertImport(textLine, fqName, textBuffer, wideOffset);
            importList.add(wideImportLine);
            wideImportsToInclude.remove(importPackage);
        }
        int remaining = importList.size();
        return importList.toArray(new ImportLine[remaining]);
    }

    protected static ImportLine[] removeUnusedImports(ImportLine[] imports, TextBuffer textBuffer) {
        int count = imports.length;
        ArrayList<ImportLine> importList = new ArrayList<ImportLine>(count);
        for (int i = 0; i < count; ++i) {
            ImportLine importLine = imports[i];
            SourceImport sourceImport = importLine._import;
            if (sourceImport == null) {
                importList.add(importLine);
                continue;
            }
            if (sourceImport.isUsed()) {
                importList.add(importLine);
                continue;
            }
            ImportUtilities2.removeImport(importLine, textBuffer);
            ImportUtilities2.disposeImport(importLine, textBuffer);
        }
        int remaining = importList.size();
        return importList.toArray(new ImportLine[remaining]);
    }

    protected static ImportLine[] sortAndGroupImports(ImportLine[] imports, TextBuffer textBuffer, JavaImportOptions groupOptions) {
        ImportLine[] sortedImports = ImportUtilities2.sortImports(imports, textBuffer);
        ImportUtilities2.groupImports(sortedImports, textBuffer, groupOptions);
        return sortedImports;
    }

    protected static void removeImport(ImportLine importLine, TextBuffer textBuffer) {
        int importStart = importLine._start.getOffset();
        int importEnd = importLine._end.getOffset();
        textBuffer.remove(importStart, importEnd - importStart);
    }

    protected static ImportLine[] sortImports(ImportLine[] imports, TextBuffer textBuffer) {
        if (imports == null || imports.length == 0) {
            return imports;
        }
        int count = imports.length;
        Object[] sortedOriginals = new ImportLine[count];
        System.arraycopy(imports, 0, sortedOriginals, 0, count);
        Arrays.sort(sortedOriginals);
        for (int i = 0; i < count; ++i) {
            ImportUtilities2.removeImport(imports[i], textBuffer);
        }
        int importBlockStart = imports[0]._start.getOffset();
        int importBlockEnd = imports[count - 1]._end.getOffset();
        LineMap lineMap = textBuffer.getLineMap();
        int lineBlockStart = lineMap.getLineFromOffset(importBlockStart);
        int lineBlockEnd = lineMap.getLineFromOffset(importBlockEnd);
        ImportUtilities2.removeEmptyLines(textBuffer, lineBlockStart, lineBlockEnd);
        ImportLine[] sortedImports = new ImportLine[count];
        OffsetMark insertPosition = textBuffer.addOffsetMark(importBlockStart, true);
        for (int i = 0; i < count; ++i) {
            Object originalImport = sortedOriginals[i];
            sortedImports[i] = ImportUtilities2.createAndInsertImport(((ImportLine)originalImport)._textLine, ((ImportLine)originalImport)._fqName, textBuffer, insertPosition.getOffset());
        }
        textBuffer.removeOffsetMark(insertPosition);
        ImportUtilities2.disposeImports(imports, textBuffer);
        return sortedImports;
    }

    protected static void removeEmptyLines(TextBuffer textBuffer, int startLine, int endLine) {
        LineMap lineMap = textBuffer.getLineMap();
        for (int line = endLine - 1; line >= startLine; --line) {
            if (!ImportUtilities2.isEmptyLine(textBuffer, line)) continue;
            int lineStart = lineMap.getLineStartOffset(line);
            int lineEnd = lineMap.getLineEndOffset(line);
            textBuffer.remove(lineStart, lineEnd - lineStart);
        }
    }

    protected static ImportLine[] getImports(SourceFile sourceFile, TextBuffer textBuffer) {
        if (sourceFile != null) {
            ArrayList<ImportLine> importList = new ArrayList<ImportLine>();
            for (SourceImport sourceImport : sourceFile.getSourceImports()) {
                ImportLine importLine = ImportUtilities2.getImport(sourceImport, textBuffer);
                importList.add(importLine);
            }
            int count = importList.size();
            return importList.toArray(new ImportLine[count]);
        }
        return new ImportLine[0];
    }

    protected static ImportLine getImport(SourceImport sourceImport, TextBuffer textBuffer) {
        int endLine;
        int startOffset = sourceImport.getStartOffset();
        int endOffset = sourceImport.getEndOffset();
        String fqName = sourceImport.getName();
        String textLine = textBuffer.getString(startOffset, endOffset - startOffset);
        ImportLine importLine = new ImportLine();
        importLine._sourceLine = importLine._textLine = textLine;
        importLine._fqName = fqName;
        importLine._import = sourceImport;
        LineMap lineMap = textBuffer.getLineMap();
        int lineEndOffset = lineMap.getLineEndOffset(endLine = lineMap.getLineFromOffset(endOffset));
        if (ImportUtilities2.isWhitespace(textBuffer, endOffset, lineEndOffset)) {
            endOffset = lineEndOffset;
            importLine._sourceLine = textBuffer.getString(startOffset, endOffset - startOffset);
        }
        importLine._start = textBuffer.addOffsetMark(startOffset, true);
        importLine._end = textBuffer.addOffsetMark(endOffset, false);
        return importLine;
    }

    protected static ImportLine createAndInsertImport(String textLine, String fqName, TextBuffer textBuffer, int insertOffset) {
        ImportLine importInserted = new ImportLine();
        importInserted._fqName = fqName;
        importInserted._sourceLine = textLine + "\n";
        importInserted._textLine = textLine;
        int length = importInserted._sourceLine.length();
        textBuffer.insert(insertOffset, importInserted._sourceLine.toCharArray());
        importInserted._start = textBuffer.addOffsetMark(insertOffset, true);
        importInserted._end = textBuffer.addOffsetMark(insertOffset + length, false);
        return importInserted;
    }

    protected static void groupImports(ImportLine[] imports, TextBuffer textBuffer, JavaImportOptions groupOptions) {
        CodingStyleManager csm = CodingStyleManager.getCodingStyleManager();
        CodingStyleOptions styleOptions = csm.getCodingStyleOptions();
        if (styleOptions.getGroupImports()) {
            int pairs = imports.length - 1;
            for (int i = 0; i < pairs; ++i) {
                ImportLine import1 = imports[i];
                ImportLine import2 = imports[i + 1];
                if (ImportUtilities2.isGrouped(import1, import2, groupOptions)) continue;
                int startImport2 = import2._start.getOffset();
                LineMap lineMap = textBuffer.getLineMap();
                int lineImport2 = lineMap.getLineFromOffset(startImport2);
                int insertOffset = lineMap.getLineStartOffset(lineImport2);
                ImportUtilities2.insertEmptyLine(textBuffer, insertOffset);
            }
        }
    }

    protected static boolean isGrouped(ImportLine import1, ImportLine import2, JavaImportOptions groupOptions) {
        int sharedDepth;
        String package2;
        String package1 = ImportUtilities2.getPackageFor(import1._fqName);
        if (package1.equals(package2 = ImportUtilities2.getPackageFor(import2._fqName))) {
            return true;
        }
        CodingStyleManager csm = CodingStyleManager.getCodingStyleManager();
        CodingStyleOptions styleOptions = csm.getCodingStyleOptions();
        int depth = styleOptions.getGroupPackageDepth();
        if (depth > 0 && (sharedDepth = ImportUtilities2.getSharedPackageDepth(package1, package2)) >= depth) {
            return true;
        }
        return import2._fqName.startsWith(import1._fqName);
    }

    protected static boolean isEmptyLine(TextBuffer textBuffer, int line) {
        LineMap lineMap = textBuffer.getLineMap();
        int lineStart = lineMap.getLineStartOffset(line);
        int lineEnd = lineMap.getLineEndOffset(line);
        return ImportUtilities2.isWhitespace(textBuffer, lineStart, lineEnd);
    }

    protected static boolean isWhitespace(TextBuffer textBuffer, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = textBuffer.getChar(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    protected static boolean isCommentLine(TextBuffer textBuffer, int line) {
        LineMap lineMap = textBuffer.getLineMap();
        int lineStart = lineMap.getLineStartOffset(line);
        JavaLexer lexer = new JavaLexer(3);
        lexer.setRecognizeSQLJ(true);
        lexer.setSkipComments(false);
        lexer.setTextBuffer((ReadTextBuffer)textBuffer);
        lexer.setPosition(lineStart);
        LexerToken lexerToken = lexer.createLexerToken();
        int token = lexer.lex(lexerToken);
        switch (token) {
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    protected static void disposeImports(ImportLine[] imports, TextBuffer textBuffer) {
        int count = imports.length;
        for (int i = 0; i < count; ++i) {
            ImportUtilities2.disposeImport(imports[i], textBuffer);
        }
    }

    protected static void disposeImport(ImportLine importLine, TextBuffer textBuffer) {
        textBuffer.removeOffsetMark(importLine._start);
        textBuffer.removeOffsetMark(importLine._end);
    }

    protected static boolean isWideImport(ImportLine importLine) {
        return importLine._fqName.endsWith(".*");
    }

    protected static boolean isNarrowImport(ImportLine importLine) {
        return !ImportUtilities2.isWideImport(importLine);
    }

    protected static boolean isStatic(ImportLine importLine) {
        if (importLine._import != null) {
            return importLine._import.isStatic();
        }
        return importLine._textLine.indexOf(" static ") != -1;
    }

    protected static String getImportText(String fqName, boolean isStatic) {
        String importText = "import " + (isStatic ? "static " : "") + fqName + ";";
        return importText;
    }

    protected static void insertEmptyLine(TextBuffer textBuffer, int offset) {
        textBuffer.insert(offset, "\n".toCharArray());
    }

    protected static List getPackageList(ImportLine[] imports) {
        ArrayList<String> packageList = new ArrayList<String>();
        for (ImportLine importLine : imports) {
            String packageName;
            if (ImportUtilities2.isStatic(importLine) || (packageName = ImportUtilities2.getPackageFor(importLine._fqName)).length() <= 0 || packageList.indexOf(packageName) != -1) continue;
            packageList.add(packageName);
        }
        return packageList;
    }

    protected static ImportLine[] getNarrowImports(ImportLine[] imports) {
        ArrayList<ImportLine> narrowList = new ArrayList<ImportLine>();
        for (ImportLine importLine : imports) {
            if (!ImportUtilities2.isNarrowImport(importLine)) continue;
            narrowList.add(importLine);
        }
        int remaining = narrowList.size();
        return narrowList.toArray(new ImportLine[remaining]);
    }

    protected static ImportLine[] getWideImports(ImportLine[] imports) {
        ArrayList<ImportLine> wideList = new ArrayList<ImportLine>();
        for (ImportLine importLine : imports) {
            if (!ImportUtilities2.isWideImport(importLine)) continue;
            wideList.add(importLine);
        }
        int remaining = wideList.size();
        return wideList.toArray(new ImportLine[remaining]);
    }

    protected static String getPackageFor(String importName) {
        int lastDot = importName.lastIndexOf(46);
        if (lastDot != -1) {
            return importName.substring(0, lastDot);
        }
        return "";
    }

    protected static String getClassFor(String importName) {
        int lastDot = importName.lastIndexOf(46);
        if (lastDot != -1) {
            return importName.substring(lastDot + 1);
        }
        return importName;
    }

    protected static int getSharedPackageDepth(String package1, String package2) {
        int dot2;
        int subend2;
        int length2;
        int dot1;
        int subend1;
        int length1;
        int start1 = 0;
        int end1 = package1.length();
        int start2 = 0;
        int end2 = package2.length();
        int depth = 0;
        while (start1 < end1 && start2 < end2 && (length1 = (subend1 = (dot1 = package1.indexOf(46, start1)) != -1 ? dot1 : end1) - start1) == (length2 = (subend2 = (dot2 = package2.indexOf(46, start2)) != -1 ? dot2 : end2) - start2) && package1.regionMatches(start1, package2, start2, length1)) {
            ++depth;
            start1 = dot1 != -1 ? dot1 + 1 : end1;
            start2 = dot2 != -1 ? dot2 + 1 : end2;
        }
        return depth;
    }

    protected static JavaManager getJavaManager(Context context) {
        Project p = context.getProject();
        if (p == null) {
            p = Ide.getActiveProject();
        }
        if (p == null) {
            p = Ide.getDefaultProject();
        }
        JavaManager javaManager = JavaManager.getJavaManager((Project)p);
        return javaManager;
    }

    protected static TextBuffer getTextBuffer(Context context) {
        JavaSourceNode node = ImportUtilities2.getJavaSourceNode(context);
        if (node != null) {
            return node.acquireTextBuffer();
        }
        return null;
    }

    protected static JavaSourceNode getJavaSourceNode(Context context) {
        Node node = context.getNode();
        if (node instanceof JavaSourceNode) {
            return (JavaSourceNode)node;
        }
        return null;
    }

    protected static SourceFile getParseTree(Context context) {
        JavaSourceNode node = ImportUtilities2.getJavaSourceNode(context);
        if (node != null) {
            JavaManager javaManager = ImportUtilities2.getJavaManager(context);
            return ImportUtilities2.getParseTree(javaManager, node);
        }
        return null;
    }

    protected static SourceFile getCompiledParseTree(Context context) {
        JavaSourceNode node = ImportUtilities2.getJavaSourceNode(context);
        if (node != null) {
            JavaManager javaManager = ImportUtilities2.getJavaManager(context);
            return ImportUtilities2.getCompiledParseTree(javaManager, node);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SourceFile getParseTree(TextBuffer textBuffer) {
        SourceFile sourceFile = null;
        textBuffer.readLock();
        try {
            sourceFile = JavaParser.parse((ReadTextBuffer)textBuffer);
            if (sourceFile != null) {
                sourceFile.pinTextBuffer(textBuffer);
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return sourceFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SourceFile getParseTree(JavaManager javaManager, JavaSourceNode javaNode) {
        TextBuffer textBuffer = javaNode.acquireTextBuffer();
        URL url = javaNode.getURL();
        SourceFile sourceFile = null;
        textBuffer.readLock();
        try {
            sourceFile = ImportUtilities2.getParseTree(textBuffer);
            if (sourceFile != null) {
                sourceFile.setURL(url);
                sourceFile.setProvider((JavaProvider)javaManager);
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return sourceFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SourceFile getCompiledParseTree(JavaManager javaManager, JavaSourceNode javaNode) {
        SourceFile sourceFile;
        block6: {
            TextBuffer textBuffer = javaNode.acquireTextBuffer();
            sourceFile = null;
            textBuffer.readLock();
            try {
                sourceFile = ImportUtilities2.getParseTree(javaManager, javaNode);
                if (sourceFile == null) break block6;
                CacheSupport cacheSupport = javaManager.getCacheSupport();
                try {
                    cacheSupport.beginCacheUse();
                    sourceFile.compile();
                }
                finally {
                    cacheSupport.endCacheUse();
                }
            }
            finally {
                textBuffer.readUnlock();
            }
        }
        return sourceFile;
    }

    protected static String getPackageName(SourceFile sourceFile) {
        String packageName = sourceFile.getPackageName();
        if (packageName == null) {
            return "";
        }
        return packageName;
    }

    protected static JavaImportOptions getImportOptions() {
        ClientSetting settings = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        JavaImportOptions options = (JavaImportOptions)settings.getData("JavaImportOptions");
        return options;
    }

    static {
        String editName = JavaArb.getString(156);
        sortImportsDescriptor = new EditDescriptor(editName);
        editName = JavaArb.getString(157);
        widenImportsDescriptor = new EditDescriptor(editName);
        editName = JavaArb.getString(158);
        narrowImportsDescriptor = new EditDescriptor(editName);
        editName = "DEAD";
        removeUnusedImportsDescriptor = new EditDescriptor(editName);
    }

    protected static class ImportLine
    implements Comparable {
        protected String _sourceLine;
        protected String _textLine;
        protected String _fqName;
        protected SourceImport _import;
        protected OffsetMark _start;
        protected OffsetMark _end;

        protected ImportLine() {
        }

        public int compareTo(Object o) {
            ImportLine other = (ImportLine)o;
            return this._fqName.compareToIgnoreCase(other._fqName);
        }

        public String toString() {
            return this._textLine;
        }
    }

    protected static abstract class ImportOperation {
        protected ImportOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void performOperation(BasicEditorPane editor, Context context) {
            editor.beginEdit(this.getDescriptor());
            try {
                TextBuffer textBuffer = ImportUtilities2.getTextBuffer(context);
                SourceFile sourceFile = this.buildParseTree(context);
                ImportLine[] imports = ImportUtilities2.getImports(sourceFile, textBuffer);
                int startOffset = -1;
                if (imports.length > 0) {
                    startOffset = imports[0]._start.getOffset();
                }
                JavaImportOptions options = ImportUtilities2.getImportOptions();
                ImportLine[] organizedImports = this.performOperationImpl(sourceFile, imports, textBuffer, options);
                if (this.shouldSort(options)) {
                    ImportLine[] sortedImports = ImportUtilities2.sortAndGroupImports(organizedImports, textBuffer, options);
                    ImportUtilities2.disposeImports(sortedImports, textBuffer);
                } else {
                    ImportUtilities2.disposeImports(organizedImports, textBuffer);
                }
                if (startOffset != -1 && options.getMoveCaret()) {
                    editor.setCaretPositionCenter(startOffset);
                }
            }
            finally {
                editor.endEdit();
            }
        }

        protected SourceFile buildParseTree(Context context) {
            return this.needsCompile() ? ImportUtilities2.getCompiledParseTree(context) : ImportUtilities2.getParseTree(context);
        }

        protected boolean needsCompile() {
            return true;
        }

        protected boolean shouldSort(JavaImportOptions options) {
            return options.getSortOnOrganize();
        }

        protected ImportLine[] performOperationImpl(SourceFile sourceFile, ImportLine[] imports, TextBuffer textBuffer, JavaImportOptions options) {
            return imports;
        }

        protected abstract EditDescriptor getDescriptor();
    }

    protected static class SortOperation
    extends ImportOperation {
        protected SortOperation() {
        }

        @Override
        protected boolean needsCompile() {
            return false;
        }

        @Override
        protected boolean shouldSort(JavaImportOptions options) {
            return true;
        }

        @Override
        protected EditDescriptor getDescriptor() {
            return sortImportsDescriptor;
        }
    }

    protected static class RemoveUnusedOperation
    extends ImportOperation {
        protected RemoveUnusedOperation() {
        }

        @Override
        protected ImportLine[] performOperationImpl(SourceFile sourceFile, ImportLine[] imports, TextBuffer textBuffer, JavaImportOptions options) {
            return ImportUtilities2.removeUnusedImports(imports, textBuffer);
        }

        @Override
        protected EditDescriptor getDescriptor() {
            return removeUnusedImportsDescriptor;
        }
    }

    protected static class WidenOperation
    extends ImportOperation {
        protected WidenOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ImportLine[] performOperationImpl(SourceFile sourceFile, ImportLine[] imports, TextBuffer textBuffer, JavaImportOptions options) {
            JavaManager javaManager = (JavaManager)sourceFile.getProvider();
            JavaClassLocator classLocator = javaManager.getJavaClassLocator();
            CacheSupport cacheSupport = javaManager.getCacheSupport();
            cacheSupport.beginCacheUse();
            try {
                ImportLine[] importLineArray = ImportUtilities2.widenImports(classLocator, sourceFile, imports, textBuffer);
                return importLineArray;
            }
            finally {
                cacheSupport.endCacheUse();
            }
        }

        @Override
        protected EditDescriptor getDescriptor() {
            return widenImportsDescriptor;
        }
    }

    protected static class NarrowOperation
    extends ImportOperation {
        protected NarrowOperation() {
        }

        @Override
        protected ImportLine[] performOperationImpl(SourceFile sourceFile, ImportLine[] imports, TextBuffer textBuffer, JavaImportOptions options) {
            return ImportUtilities2.narrowImports(imports, textBuffer);
        }

        @Override
        protected EditDescriptor getDescriptor() {
            return narrowImportsDescriptor;
        }
    }
}

