/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.java.Context2ParserHelper;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.editing.JavaImplOverPlugin;
import oracle.jdevimpl.java.editing.NavigationEntry;
import oracle.jdevimpl.java.imports.ImportAssistPlugin;
import oracle.jdevimpl.java.imports.JavaNavigationUtilities;

public final class ImportController
implements Controller,
ContextMenuListener,
CodeMenuConstants,
DynamicMenuListener {
    private static final int COMPLETE_STATEMENT_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.CompleteStatement");
    private static final int EXPAND_SELECTION_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.ExpandSelection");
    private static final int NARROW_SELECTION_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.NarrowSelection");
    private static final int GOTO_NEXT_METHOD_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoNextMethod");
    private static final int GOTO_PREV_METHOD_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoPreviousMethod");
    private static final int GOTO_NEXT_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoNextField");
    private static final int GOTO_PREV_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoPreviousField");
    private static final int GOTO_NEXT_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoNextClass");
    private static final int GOTO_PREV_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoPreviousClass");
    private static final int GOTO_NEXT_MEMBER_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoNextMember");
    private static final int GOTO_PREV_MEMBER_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoPreviousMember");
    static final int IMPORT_ASSISTANCE_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.ImportAssistance");
    private static final int GOTO_IMPLEMENTED_METHOD_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoImplementedMethod");
    private static final int GOTO_OVERRIDDEN_METHOD_CMD_ID = Ide.findOrCreateCmdID((String)"ojji.GotoOverriddenMethod");
    private JComponent[] dynamicItems;

    public ImportController() {
        ContextMenu contextMenu = CodeEditorGutter.getGutterContextMenu();
        if (contextMenu != null) {
            contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        this.initializeActions();
        this.initializeDynamicActions();
        Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)this);
        KeyStrokeContextRegistry registry = Ide.getKeyStrokeContextRegistry();
        registry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/java/imports/accelerators.xml");
    }

    public void shutdown() {
        EditorManager editorManager = EditorManager.getEditorManager();
        ContextMenu contextMenu = editorManager.getContextMenu();
        if (contextMenu != null) {
            contextMenu.removeContextMenuListener((ContextMenuListener)this);
        }
        if ((contextMenu = CodeEditorGutter.getGutterContextMenu()) != null) {
            contextMenu.removeContextMenuListener((ContextMenuListener)this);
        }
        Ide.getMainWindow().removeDynamicMenuListener((DynamicMenuListener)this);
    }

    private void initializeActions() {
        String label = JavaArb.getString(176);
        IdeAction res = IdeAction.get((int)COMPLETE_STATEMENT_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), (String)CATEGORY_CODE_MENU, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (ArrayResourceBundle)JavaArb.getInstance(), (int)177, null, (boolean)true);
        res.addController((Controller)this);
        String name = JavaArb.getString(178);
        int mnemonic = StringUtils.getMnemonicKeyCode((String)name);
        name = StringUtils.stripMnemonic((String)name);
        IdeAction res2 = IdeAction.get((int)EXPAND_SELECTION_CMD_ID, null, (String)name, (String)CATEGORY_CODE_MENU, (Integer)new Integer(mnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)179, null, (boolean)true);
        res2.addController((Controller)this);
        name = JavaArb.getString(180);
        mnemonic = StringUtils.getMnemonicKeyCode((String)name);
        name = StringUtils.stripMnemonic((String)name);
        res2 = IdeAction.get((int)NARROW_SELECTION_CMD_ID, null, (String)name, (String)CATEGORY_CODE_MENU, (Integer)new Integer(mnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)181, null, (boolean)true);
        res2.addController((Controller)this);
        name = JavaArb.getString(185);
        mnemonic = StringUtils.getMnemonicKeyCode((String)name);
        name = StringUtils.stripMnemonic((String)name);
        res2 = IdeAction.get((int)GOTO_NEXT_METHOD_CMD_ID, null, (String)name, (String)"Navigate", (Integer)new Integer(mnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)193, null, (boolean)true);
        res2.addController((Controller)this);
        name = JavaArb.getString(186);
        mnemonic = StringUtils.getMnemonicKeyCode((String)name);
        name = StringUtils.stripMnemonic((String)name);
        res2 = IdeAction.get((int)GOTO_PREV_METHOD_CMD_ID, null, (String)name, (String)"Navigate", (Integer)new Integer(mnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)194, null, (boolean)true);
        res2.addController((Controller)this);
        name = JavaArb.getString(187);
        mnemonic = StringUtils.getMnemonicKeyCode((String)name);
        name = StringUtils.stripMnemonic((String)name);
        res2 = IdeAction.get((int)GOTO_NEXT_FIELD_CMD_ID, null, (String)name, (String)"Navigate", (Integer)new Integer(mnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)195, null, (boolean)true);
        res2.addController((Controller)this);
        name = JavaArb.getString(188);
        mnemonic = StringUtils.getMnemonicKeyCode((String)name);
        name = StringUtils.stripMnemonic((String)name);
        res2 = IdeAction.get((int)GOTO_PREV_FIELD_CMD_ID, null, (String)name, (String)"Navigate", (Integer)new Integer(mnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)196, null, (boolean)true);
        res2.addController((Controller)this);
        name = JavaArb.getString(189);
        mnemonic = StringUtils.getMnemonicKeyCode((String)name);
        name = StringUtils.stripMnemonic((String)name);
        res2 = IdeAction.get((int)GOTO_NEXT_CLASS_CMD_ID, null, (String)name, (String)"Navigate", (Integer)new Integer(mnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)197, null, (boolean)true);
        res2.addController((Controller)this);
        name = JavaArb.getString(190);
        mnemonic = StringUtils.getMnemonicKeyCode((String)name);
        name = StringUtils.stripMnemonic((String)name);
        res2 = IdeAction.get((int)GOTO_PREV_CLASS_CMD_ID, null, (String)name, (String)"Navigate", (Integer)new Integer(mnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)198, null, (boolean)true);
        res2.addController((Controller)this);
        String name2 = JavaArb.getString(191);
        int mnemonic2 = StringUtils.getMnemonicKeyCode((String)name2);
        name2 = StringUtils.stripMnemonic((String)name2);
        IdeAction res3 = IdeAction.get((int)GOTO_NEXT_MEMBER_CMD_ID, null, (String)name2, (String)"Navigate", (Integer)new Integer(mnemonic2), (ArrayResourceBundle)JavaArb.getInstance(), (int)199, null, (boolean)true);
        res3.addController((Controller)this);
        IdeAction gotoNextMemberAction = res3;
        String name3 = JavaArb.getString(192);
        int mnemonic3 = StringUtils.getMnemonicKeyCode((String)name3);
        name3 = StringUtils.stripMnemonic((String)name3);
        IdeAction res4 = IdeAction.get((int)GOTO_PREV_MEMBER_CMD_ID, null, (String)name3, (String)"Navigate", (Integer)new Integer(mnemonic3), (ArrayResourceBundle)JavaArb.getInstance(), (int)200, null, (boolean)true);
        res4.addController((Controller)this);
        IdeAction gotoPreviousMemberAction = res4;
        name3 = JavaArb.getString(166);
        mnemonic3 = StringUtils.getMnemonicKeyCode((String)name3);
        name3 = StringUtils.stripMnemonic((String)name3);
        res4 = IdeAction.get((int)IMPORT_ASSISTANCE_CMD_ID, null, (String)name3, (String)CATEGORY_CODE_MENU, (Integer)new Integer(mnemonic3), (ArrayResourceBundle)JavaArb.getInstance(), (int)167, null, (boolean)true);
        res4.addController((Controller)this);
        name3 = JavaArb.getString(348);
        mnemonic3 = StringUtils.getMnemonicKeyCode((String)name3);
        name3 = StringUtils.stripMnemonic((String)name3);
        res4 = IdeAction.get((int)GOTO_IMPLEMENTED_METHOD_CMD_ID, null, (String)name3, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(mnemonic3), (ArrayResourceBundle)JavaArb.getInstance(), (int)349, null, (boolean)true);
        res4.addController((Controller)this);
        name3 = JavaArb.getString(350);
        mnemonic3 = StringUtils.getMnemonicKeyCode((String)name3);
        name3 = StringUtils.stripMnemonic((String)name3);
        res4 = IdeAction.get((int)GOTO_OVERRIDDEN_METHOD_CMD_ID, null, (String)name3, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(mnemonic3), (ArrayResourceBundle)JavaArb.getInstance(), (int)351, null, (boolean)true);
        res4.addController((Controller)this);
        Menubar ideMenuManager = Ide.getMenubar();
        JMenu navigateMenu = MenuManager.getJMenu((String)"Navigate");
        JMenuItem gotoNextMethodMenuItem = ideMenuManager.createMenuItem((ToggleAction)gotoNextMemberAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_GO_TO_NEXT_MEMBER);
        ideMenuManager.add((Component)gotoNextMethodMenuItem, navigateMenu, JDeveloperMenuConstants.SECTION_NAVIGATE_GOTO_MEMBER);
        JMenuItem gotoPreviousMethodMenuItem = ideMenuManager.createMenuItem((ToggleAction)gotoPreviousMemberAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_GO_TO_PREVIOUS_MEMBER);
        ideMenuManager.add((Component)gotoPreviousMethodMenuItem, navigateMenu, JDeveloperMenuConstants.SECTION_NAVIGATE_GOTO_MEMBER);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        Node node = context.getNode();
        CodeEditor codeEditor = null;
        CodeEditorGutter gutter = null;
        BasicEditorPane editorPane = null;
        if (node instanceof JavaSourceNode) {
            View view = context.getView();
            if (view instanceof CodeEditor) {
                codeEditor = (CodeEditor)view;
                editorPane = codeEditor.getFocusedEditorPane();
            } else if (view instanceof CodeEditorGutter.GutterView) {
                gutter = (CodeEditorGutter)view.getGUI();
                codeEditor = gutter.getCodeEditor();
                editorPane = codeEditor.getFocusedEditorPane();
            }
        }
        if (commandId == IMPORT_ASSISTANCE_CMD_ID) {
            if (editorPane != null && editorPane.isEditable()) {
                ImportAssistPlugin.invokeImportAssistance(editorPane);
            }
            return true;
        }
        if (commandId == COMPLETE_STATEMENT_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.expandStatement(editorPane, context);
            }
            return true;
        }
        if (commandId == EXPAND_SELECTION_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.expandSelection(editorPane, context);
            }
            return true;
        }
        if (commandId == NARROW_SELECTION_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.narrowSelection(editorPane, context);
            }
            return true;
        }
        if (commandId == GOTO_NEXT_METHOD_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.navigateTo(editorPane, context, 0);
            }
            return true;
        }
        if (commandId == GOTO_PREV_METHOD_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.navigateTo(editorPane, context, 1);
            }
            return true;
        }
        if (commandId == GOTO_NEXT_FIELD_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.navigateTo(editorPane, context, 2);
            }
            return true;
        }
        if (commandId == GOTO_PREV_FIELD_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.navigateTo(editorPane, context, 3);
            }
            return true;
        }
        if (commandId == GOTO_NEXT_CLASS_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.navigateTo(editorPane, context, 4);
            }
            return true;
        }
        if (commandId == GOTO_PREV_CLASS_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.navigateTo(editorPane, context, 5);
            }
            return true;
        }
        if (commandId == GOTO_NEXT_MEMBER_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.navigateTo(editorPane, context, 6);
            }
            return true;
        }
        if (commandId == GOTO_PREV_MEMBER_CMD_ID) {
            if (editorPane != null) {
                JavaNavigationUtilities.navigateTo(editorPane, context, 7);
            }
            return true;
        }
        if (commandId == GOTO_IMPLEMENTED_METHOD_CMD_ID || commandId == GOTO_OVERRIDDEN_METHOD_CMD_ID) {
            boolean isImpl = commandId == GOTO_IMPLEMENTED_METHOD_CMD_ID;
            JavaImplOverPlugin.ImplOverItem item = this.getImplOverItem(isImpl, context, codeEditor, gutter, editorPane);
            if (item != null) {
                item.gotoImplOverItem();
            }
            return true;
        }
        return false;
    }

    private JavaImplOverPlugin.ImplOverItem getImplOverItem(boolean isImpl, Context context, CodeEditor codeEditor, CodeEditorGutter gutter, BasicEditorPane editor) {
        if (editor != null) {
            int line = -1;
            if (gutter != null) {
                line = CodeEditorGutter.getLineForContext((Context)context);
            } else if (codeEditor != null) {
                int caretOffset = editor.getCaretPosition();
                line = editor.getLineFromOffset(caretOffset) + 1;
            }
            if (line != -1) {
                return JavaImplOverPlugin.getImplOverItem(editor, line, isImpl);
            }
        }
        return null;
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        View view = context.getView();
        CodeEditor codeEditor = null;
        CodeEditorGutter gutter = null;
        BasicEditorPane editorPane = null;
        if (view instanceof CodeEditor) {
            codeEditor = (CodeEditor)view;
        } else if (view instanceof CodeEditorGutter.GutterView) {
            gutter = (CodeEditorGutter)view.getGUI();
            codeEditor = gutter.getCodeEditor();
        }
        if (codeEditor != null) {
            editorPane = codeEditor.getFocusedEditorPane();
        }
        if (commandId == IMPORT_ASSISTANCE_CMD_ID) {
            Node node;
            action.setEnabled(false);
            boolean enable = false;
            if (editorPane != null && (node = context.getNode()) instanceof JavaSourceNode) {
                enable = editorPane.isEditable();
            }
            action.setEnabled(enable);
            return true;
        }
        if (commandId == GOTO_NEXT_METHOD_CMD_ID || commandId == GOTO_NEXT_FIELD_CMD_ID || commandId == GOTO_PREV_FIELD_CMD_ID || commandId == GOTO_NEXT_CLASS_CMD_ID || commandId == GOTO_PREV_CLASS_CMD_ID || commandId == GOTO_NEXT_MEMBER_CMD_ID || commandId == GOTO_PREV_METHOD_CMD_ID || commandId == GOTO_NEXT_METHOD_CMD_ID) {
            if (view instanceof CodeEditor && context.getNode() instanceof JavaSourceNode) {
                action.setEnabled(true);
                return true;
            }
            action.setEnabled(false);
            return true;
        }
        if (commandId == EXPAND_SELECTION_CMD_ID || commandId == NARROW_SELECTION_CMD_ID || commandId == COMPLETE_STATEMENT_CMD_ID) {
            if (view instanceof CodeEditor && context.getNode() instanceof JavaSourceNode) {
                Context2ParserHelper helper = Context2ParserHelper.createHelper(context);
                if (helper.getSourceFile() == null) {
                    action.setEnabled(false);
                } else {
                    action.setEnabled(true);
                }
                return true;
            }
            action.setEnabled(false);
            return true;
        }
        if (commandId == GOTO_IMPLEMENTED_METHOD_CMD_ID || commandId == GOTO_OVERRIDDEN_METHOD_CMD_ID) {
            boolean enable = false;
            if (editorPane != null) {
                boolean isImpl = commandId == GOTO_IMPLEMENTED_METHOD_CMD_ID;
                JavaImplOverPlugin.ImplOverItem item = this.getImplOverItem(isImpl, context, codeEditor, gutter, editorPane);
                enable = item != null;
            }
            action.setEnabled(enable);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        View view = context.getView();
        if (view instanceof CodeEditorGutter.GutterView) {
            CodeEditorGutter gutter = (CodeEditorGutter)view.getGUI();
            CodeEditor codeEditor = gutter.getCodeEditor();
            BasicEditorPane editorPane = codeEditor.getFocusedEditorPane();
            if (CodeEditorGutter.isMarkDroppingDown((Context)context)) {
                GutterMark mark = CodeEditorGutter.getMarkForContext((Context)context);
                String columnName = mark.getGutterColumn().getColumnName();
                if ("implements-overrides-column2".equals(columnName)) {
                    List userData = (List)mark.getUserData();
                    for (NavigationEntry navigationEntry : userData) {
                        ToggleAction gotoSourceAction = navigationEntry.createGotoSourceAction();
                        JMenuItem menuItem = popup.createMenuItem(gotoSourceAction);
                        popup.add((Component)menuItem);
                    }
                } else if ("implements-overrides-column".equals(columnName) && mark.getUserData() instanceof List) {
                    List list = (List)mark.getUserData();
                    for (int i = 0; i < list.size(); ++i) {
                        JavaImplOverPlugin.ImplOverItem item = (JavaImplOverPlugin.ImplOverItem)list.get(i);
                        JMenuItem menuItem = popup.createMenuItem(item.createGotoSourceAction());
                        popup.add((Component)menuItem);
                    }
                }
            } else {
                JavaImplOverPlugin.ImplOverItem overItem;
                JavaImplOverPlugin.ImplOverItem implItem = this.getImplOverItem(true, context, codeEditor, gutter, editorPane);
                if (implItem != null) {
                    JMenuItem gotoImplementedMenuItem = popup.createMenuItem((ToggleAction)IdeAction.find((int)GOTO_IMPLEMENTED_METHOD_CMD_ID));
                    popup.add((Component)gotoImplementedMenuItem, 1.0f);
                }
                if ((overItem = this.getImplOverItem(false, context, codeEditor, gutter, editorPane)) != null) {
                    JMenuItem gotoOverriddenMenuItem = popup.createMenuItem((ToggleAction)IdeAction.find((int)GOTO_OVERRIDDEN_METHOD_CMD_ID));
                    popup.add((Component)gotoOverriddenMenuItem, 1.0f);
                }
            }
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        View view = context.getView();
        if (view instanceof CodeEditorGutter.GutterView && CodeEditorGutter.isMarkDroppingDown((Context)context)) {
            GutterMark mark = CodeEditorGutter.getMarkForContext((Context)context);
            if (mark.getUserData() instanceof List) {
                List list = (List)mark.getUserData();
                JavaImplOverPlugin.ImplOverItem item = (JavaImplOverPlugin.ImplOverItem)list.get(0);
                item.gotoImplOverItem();
            }
            return true;
        }
        return false;
    }

    private void initializeDynamicActions() {
        Menubar ideMenuManager = Ide.getMenubar();
        ArrayList<JMenuItem> dynamicList = new ArrayList<JMenuItem>();
        JMenuItem completeStatementItem = ideMenuManager.createMenuItem((ToggleAction)IdeAction.find((int)COMPLETE_STATEMENT_CMD_ID), 125.0f);
        dynamicList.add(completeStatementItem);
        JMenuItem expandItem = ideMenuManager.createMenuItem((ToggleAction)IdeAction.find((int)EXPAND_SELECTION_CMD_ID), 540.0f);
        dynamicList.add(expandItem);
        JMenuItem narrowItem = ideMenuManager.createMenuItem((ToggleAction)IdeAction.find((int)NARROW_SELECTION_CMD_ID), 540.0f);
        dynamicList.add(narrowItem);
        int size = dynamicList.size();
        this.dynamicItems = dynamicList.toArray(new JMenuItem[size]);
    }

    public JComponent[] gatherDynamicActions(Context context) {
        Node node;
        View view = context.getView();
        if (view instanceof CodeEditor && (node = context.getNode()) instanceof JavaSourceNode) {
            return this.dynamicItems;
        }
        return new JComponent[0];
    }
}

