/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.imports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.list.EmptyListTextLayer;
import oracle.jdevimpl.java.JavaArb;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;

public class AutoImportExceptionsDialog
extends JEWTDialog {
    private JList list;
    private JTextField addField;

    public AutoImportExceptionsDialog(List exceptionList) {
        super((Frame)Ide.getMainWindow(), JavaArb.getString(227), 7);
        this.init(exceptionList);
        HelpUtils.setHelpID((JComponent)((JComponent)this.getContent()), (String)"f1_idedidesetimportexceptions_html");
    }

    private void init(List exceptionList) {
        this.list = new JList(new ExceptionModel(exceptionList));
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Window w;
                if (e.getClickCount() == 2 && AutoImportExceptionsDialog.this.list.getSelectedIndex() != -1 && (w = SwingUtilities.windowForComponent(AutoImportExceptionsDialog.this.list)) instanceof JEWTDialog) {
                    ((JEWTDialog)w).closeDialog(false);
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.list);
        JXLayer jxLayer = new JXLayer((Component)sp, (LayerUI)new EmptyListTextLayer(this.list, JavaArb.getString(228)));
        ControlBar cb = new ControlBar();
        final JButton removeButton = new JButton(OracleIcons.getIcon((String)"delete.png"));
        removeButton.setToolTipText(JavaArb.getString(231));
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                removeButton.setEnabled(AutoImportExceptionsDialog.this.list.getSelectedIndex() != -1);
            }
        });
        cb.add((Component)removeButton);
        ComponentWithTitlebar titleComp = new ComponentWithTitlebar((JComponent)jxLayer, null, cb);
        String inst = JavaArb.getString(229);
        MultiLineLabel label = new MultiLineLabel(WordWrapper.getTextWrapper(), StringUtils.stripMnemonic((String)inst));
        label.setPreferredRows(2);
        JPanel addPanel = new JPanel(new BorderLayout(8, 0));
        this.addField = new JTextField();
        String enterInput = "Enter";
        this.addField.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), enterInput);
        this.addField.getActionMap().put(enterInput, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoImportExceptionsDialog.this.addException();
            }
        });
        JButton addButton = new JButton(OracleIcons.getIcon((String)"add.png"));
        addButton.setToolTipText(JavaArb.getString(230));
        ControlBar addCb = new ControlBar();
        addCb.add((Component)addButton);
        addPanel.add((Component)this.addField, "Center");
        addPanel.add((Component)addCb, "After");
        JPanel p = new JPanel(new BorderLayout(5, 5));
        p.add((Component)label, "North");
        p.add((Component)titleComp);
        p.add((Component)addPanel, "South");
        this.setContent(p);
        this.setResizable(true);
        this.setPreferredSize(300, 400);
        this.setMinimumSize(300, 300);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoImportExceptionsDialog.this.addException();
            }
        });
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoImportExceptionsDialog.this.removeException();
            }
        });
        if (this.list.getModel().getSize() > 0) {
            this.setInitialFocus(this.list);
            this.list.setSelectedIndex(0);
        } else {
            this.setInitialFocus(this.addField);
        }
        removeButton.setEnabled(this.list.getSelectedIndex() != -1);
    }

    private void addException() {
        if (this.addField.getText().length() > 0) {
            ((ExceptionModel)this.list.getModel()).add(this.addField.getText());
        }
    }

    private void removeException() {
        int index = this.list.getSelectedIndex();
        if (index != -1) {
            ((ExceptionModel)this.list.getModel()).remove(index);
        }
    }

    List getExceptionList() {
        return new LinkedList(((ExceptionModel)this.list.getModel()).exceptionList);
    }

    private class ExceptionModel
    implements ListModel {
        Collection<ListDataListener> listeners = new LinkedList<ListDataListener>();
        List exceptionList;

        public ExceptionModel(List exceptionList) {
            this.exceptionList = new LinkedList(exceptionList);
            Collections.sort(this.exceptionList);
        }

        @Override
        public int getSize() {
            return this.exceptionList.size();
        }

        public Object getElementAt(int index) {
            return this.exceptionList.get(index);
        }

        public void add(Object exception) {
            if (!this.exceptionList.contains(exception)) {
                this.exceptionList.add(exception);
            }
            Collections.sort(this.exceptionList);
            ListDataEvent e = new ListDataEvent(AutoImportExceptionsDialog.this.list, 1, 0, this.exceptionList.size() - 1);
            for (ListDataListener l : this.listeners) {
                l.intervalAdded(e);
            }
            AutoImportExceptionsDialog.this.list.setSelectedIndex(this.exceptionList.indexOf(exception));
        }

        public void remove(int index) {
            this.exceptionList.remove(index);
            ListDataEvent e = new ListDataEvent(AutoImportExceptionsDialog.this.list, 2, index, index);
            for (ListDataListener l : this.listeners) {
                l.intervalRemoved(e);
            }
            if (this.exceptionList.size() > 0) {
                AutoImportExceptionsDialog.this.list.setSelectedIndex(Math.min(this.exceptionList.size() - 1, index));
            }
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            if (this.listeners.contains(l)) {
                this.listeners.remove(l);
            }
        }
    }
}

