/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public final class SideBySideIcon
implements Icon {
    private Icon leftIcon;
    private Icon rightIcon;
    private int padding;
    private static final int DEFAULT_PADDING = 2;

    public SideBySideIcon(Icon leftIcon, Icon rightIcon) {
        this(leftIcon, rightIcon, 2);
    }

    public SideBySideIcon(Icon leftIcon, Icon rightIcon, int padding) {
        this.leftIcon = leftIcon;
        this.rightIcon = rightIcon;
        this.padding = padding;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int x, int y) {
        int maxHeight = this.getIconHeight();
        if (this.leftIcon != null) {
            int yAdjust1 = (maxHeight - this.leftIcon.getIconHeight()) / 2;
            this.leftIcon.paintIcon(component, graphics, x, y + yAdjust1);
            x += this.getMiddlePadding() + this.leftIcon.getIconWidth();
        }
        if (this.rightIcon != null) {
            int yAdjust2 = (maxHeight - this.rightIcon.getIconHeight()) / 2;
            this.rightIcon.paintIcon(component, graphics, x, y + yAdjust2);
        }
    }

    private int getMiddlePadding() {
        boolean skipPadding = this.leftIcon == null || this.rightIcon == null;
        return skipPadding ? 0 : this.padding;
    }

    @Override
    public int getIconWidth() {
        int width = this.getMiddlePadding();
        if (this.leftIcon != null) {
            width += this.leftIcon.getIconWidth();
        }
        if (this.rightIcon != null) {
            width += this.rightIcon.getIconWidth();
        }
        return width;
    }

    @Override
    public int getIconHeight() {
        int height = 0;
        if (this.leftIcon != null) {
            height = this.leftIcon.getIconHeight();
        }
        if (this.rightIcon != null) {
            height = Math.max(height, this.rightIcon.getIconHeight());
        }
        return height;
    }
}

