/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.lang.reflect.Modifier;
import javax.swing.Icon;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.JavaCodeElement;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;
import oracle.jdevimpl.java.explorer.OverlayedIcon;
import oracle.jdevimpl.java.explorer.SideBySideIcon;

public abstract class ModifierElement
extends JavaCodeElement {
    protected int modifiers;

    ModifierElement(SourceHasModifiers symbol, JavaExplorerOptions options) {
        super((SourceElement)symbol);
        this.setModifiers(ModifierElement.getModifiers(symbol));
        if (options.getShowAccessIcons()) {
            int modifiers = this.getModifiers();
            Icon accessIcon = Modifier.isPublic(modifiers) ? JavaArb.getIcon(60) : (Modifier.isProtected(modifiers) ? JavaArb.getIcon(61) : (Modifier.isPrivate(modifiers) ? JavaArb.getIcon(62) : JavaArb.getIcon(63)));
            if (Modifier.isStatic(modifiers)) {
                Icon staticIcon = JavaArb.getIcon(64);
                accessIcon = new OverlayedIcon(staticIcon, accessIcon);
            }
            if (Modifier.isFinal(modifiers)) {
                Icon finalIcon = JavaArb.getIcon(65);
                accessIcon = new OverlayedIcon(finalIcon, accessIcon);
            } else if (Modifier.isAbstract(modifiers)) {
                Icon abstractIcon = JavaArb.getIcon(66);
                accessIcon = new OverlayedIcon(abstractIcon, accessIcon);
            }
            SideBySideIcon sidedIcon = new SideBySideIcon(this.getIcon(), accessIcon, 1);
            this.setIcon(sidedIcon);
        }
    }

    protected static int getModifiers(SourceHasModifiers symbol) {
        return symbol.getModifiers();
    }

    private static String getModifierText(int modifiers) {
        return Modifier.toString(modifiers);
    }

    public int getModifiers() {
        return this.modifiers;
    }

    protected void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }
}

