/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.io.PrintWriter;
import javax.swing.Icon;
import oracle.ide.util.FastStringWriter;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;
import oracle.jdevimpl.java.explorer.ModifierElement;
import oracle.jdevimpl.java.explorer.PeekProvider;

public class MethodElement
extends ModifierElement
implements PeekProvider {
    private int methodStartOffset = -1;
    private int methodEndOffset = -1;
    private static boolean _editorPeek = false;

    public MethodElement(SourceMethod symbol, JavaExplorerOptions options) {
        super((SourceHasModifiers)symbol, options);
        this.methodStartOffset = symbol.getStartOffset();
        this.methodEndOffset = symbol.getEndOffset();
    }

    @Override
    protected String getDisplayText(SourceElement symbol) {
        FastStringWriter buffer = MethodElement.allocFastStringBuffer();
        symbol.print((PrintWriter)buffer, 1);
        SourceTypeReference type = ((SourceMethod)symbol).getSourceReturnType();
        if (type != null) {
            buffer.print(" : ");
            MethodElement.print((SourceElement)type, (PrintWriter)buffer);
        }
        String result = buffer.toString();
        MethodElement.freeFastStringBuffer(buffer);
        return result;
    }

    @Override
    protected String getTooltipText(SourceElement symbol) {
        FastStringWriter buffer = MethodElement.allocFastStringBuffer();
        symbol.print((PrintWriter)buffer, 2);
        String tooltipText = buffer.toString();
        MethodElement.freeFastStringBuffer(buffer);
        String pattern = JavaArb.getString(70);
        tooltipText = MethodElement.format(pattern, tooltipText);
        if (_editorPeek) {
            String peekHint = JavaArb.getString(85);
            tooltipText = tooltipText + peekHint;
        }
        return tooltipText;
    }

    @Override
    protected Icon getIcon(SourceElement symbol) {
        return OracleIcons.getIcon((String)"method.png");
    }

    public int getMethodStartOffset() {
        return this.methodStartOffset;
    }

    public int getMethodEndOffset() {
        return this.methodEndOffset;
    }

    @Override
    public int getPeekStartOffset() {
        return this.methodStartOffset;
    }

    @Override
    public int getPeekEndOffset() {
        return this.methodEndOffset;
    }

    static {
        String peekProp = System.getProperty("ide.gutter.peek");
        if (peekProp != null && peekProp.equalsIgnoreCase("true")) {
            _editorPeek = true;
        }
    }
}

