/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.ide.peek.Peekable;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.ideimpl.explorer.CustomTree;
import oracle.ideimpl.explorer.ExplorerNode;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.browse.JavaBrowseSupport2;
import oracle.jdevimpl.java.explorer.ClassElement;
import oracle.jdevimpl.java.explorer.CodeElement;
import oracle.jdevimpl.java.explorer.CodeExplorer;
import oracle.jdevimpl.java.explorer.ExtendsElement;
import oracle.jdevimpl.java.explorer.ImplementsElement;
import oracle.jdevimpl.java.explorer.ImportElement;
import oracle.jdevimpl.java.explorer.JavaCodeElement;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;
import oracle.jdevimpl.java.explorer.JavaRootFolder;
import oracle.jdevimpl.java.explorer.LeafElement;
import oracle.jdevimpl.java.explorer.MethodElement;
import oracle.jdevimpl.java.explorer.PeekProvider;
import oracle.jdevimpl.java.util.JavaCodePeek;

public class JavaExplorer
extends CodeExplorer {
    private static IdeAction gotoClassAction;
    private static JMenuItem gotoClassMenuItem;
    private static IdeAction browseHierarchyAction;
    private static JMenuItem browseHierarchyMenuItem;
    private static IdeAction sortLocationAction;
    private static IdeAction sortAlphaAction;
    private static IdeAction sortTypeAction;
    private static IdeAction sortAccessAction;
    private static final String SORT_GROUP_NAME = "JavaExplorerSortGroup";
    public static int SORT_LOCATION_CMD_ID;
    public static int SORT_ALPHA_CMD_ID;
    public static int SORT_TYPE_CMD_ID;
    public static int SORT_ACCESS_CMD_ID;
    private static IdeAction showMethodsAction;
    private static IdeAction showFieldsAction;
    private static IdeAction showStaticsAction;
    private static IdeAction showPublicOnlyAction;
    private static IdeAction syncAction;
    public static int SHOW_METHODS_CMD_ID;
    public static int SHOW_FIELDS_CMD_ID;
    public static int SHOW_STATICS_CMD_ID;
    public static int SHOW_PUBLIC_ONLY_CMD_ID;
    public static int SYNC_CMD_ID;
    private IdeAction[] localSortActions;
    private IdeAction localShowMethodsAction;
    private IdeAction localShowFieldsAction;
    private IdeAction localShowStaticsAction;
    private IdeAction localShowPublicOnlyAction;
    private IdeAction localSyncAction;
    private List localButtons;

    public JavaExplorer() {
        this.initializeJavaActions();
    }

    private static void initializeToolbarActions() {
        SORT_LOCATION_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerSortLocation");
        sortLocationAction = IdeAction.get((int)SORT_LOCATION_CMD_ID, null, (String)JavaArb.getString(86), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)91, null, (boolean)true);
        SORT_ALPHA_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerSortAlpha");
        sortAlphaAction = IdeAction.get((int)SORT_ALPHA_CMD_ID, null, (String)JavaArb.getString(87), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)92, null, (boolean)true);
        SORT_TYPE_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerSortType");
        sortTypeAction = IdeAction.get((int)SORT_TYPE_CMD_ID, null, (String)JavaArb.getString(88), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)93, null, (boolean)true);
        SORT_ACCESS_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerSortAccess");
        sortAccessAction = IdeAction.get((int)SORT_ACCESS_CMD_ID, null, (String)JavaArb.getString(89), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)94, null, (boolean)true);
        sortLocationAction.setState(false);
        sortAlphaAction.setState(false);
        sortTypeAction.setState(false);
        sortAccessAction.setState(false);
        sortLocationAction.putValue("Radio", (Object)Boolean.TRUE);
        sortAlphaAction.putValue("Radio", (Object)Boolean.TRUE);
        sortTypeAction.putValue("Radio", (Object)Boolean.TRUE);
        sortAccessAction.putValue("Radio", (Object)Boolean.TRUE);
        sortLocationAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
        sortAlphaAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
        sortTypeAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
        sortAccessAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
        SHOW_METHODS_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerShowMethods");
        showMethodsAction = IdeAction.get((int)SHOW_METHODS_CMD_ID, null, (String)JavaArb.getString(96), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (Icon)OracleIcons.getIcon((String)"method.png"), null, (boolean)true);
        SHOW_FIELDS_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerShowFields");
        showFieldsAction = IdeAction.get((int)SHOW_FIELDS_CMD_ID, null, (String)JavaArb.getString(97), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (Icon)OracleIcons.getIcon((String)"field.png"), null, (boolean)true);
        SHOW_STATICS_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerShowStatics");
        showStaticsAction = IdeAction.get((int)SHOW_STATICS_CMD_ID, null, (String)JavaArb.getString(98), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)105, null, (boolean)true);
        SHOW_PUBLIC_ONLY_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerShowPublicOnly");
        showPublicOnlyAction = IdeAction.get((int)SHOW_PUBLIC_ONLY_CMD_ID, null, (String)JavaArb.getString(99), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)106, null, (boolean)true);
        SYNC_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerSync");
        syncAction = IdeAction.get((int)SYNC_CMD_ID, null, (String)JavaArb.getString(90), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (Icon)OracleIcons.getIcon((String)"update.png"), null, (boolean)true);
    }

    private synchronized void initializeJavaActions() {
        if (gotoClassMenuItem == null) {
            String gotoClassName = JavaArb.getString(234);
            int gotoClassMnemonic = StringUtils.getMnemonicKeyCode((String)gotoClassName);
            gotoClassName = StringUtils.stripMnemonic((String)gotoClassName);
            gotoClassAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojje.GotoClass"), null, (String)gotoClassName, (String)IdeMainWindow.ACTION_CATEGORY_SEARCH, (Integer)new Integer(gotoClassMnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)235, null, (boolean)false);
            gotoClassMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)gotoClassAction);
            String browseHierarchyName = JavaArb.getString(367);
            int browseHierarchyMnemonic = StringUtils.getMnemonicKeyCode((String)browseHierarchyName);
            browseHierarchyAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojje.BrowseHierarchy"), null, (String)browseHierarchyName, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(browseHierarchyMnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)368, null, (boolean)false);
            browseHierarchyAction.addController((Controller)this);
            browseHierarchyMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)browseHierarchyAction);
            JavaExplorer.initializeToolbarActions();
        }
    }

    protected CustomTree createCustomTree() {
        return new PeekableCustomTree();
    }

    @Override
    protected String getAccessibleTitle(String nodeName) {
        String title = JavaArb.format(58, nodeName);
        return title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SourceFile parse(TextBuffer buffer) {
        SourceFile root;
        buffer.readLock();
        try {
            root = JavaParser.parse((ReadTextBuffer)buffer);
        }
        finally {
            buffer.readUnlock();
        }
        return root;
    }

    private SourceFile getRootSymbol(Node source) {
        SourceFile rootSymbol = null;
        Project projectToUse = this.project;
        if (projectToUse == null) {
            projectToUse = Ide.getDefaultProject();
        }
        if (projectToUse != null) {
            JavaManager jm = JavaManager.getJavaManager((Project)projectToUse);
            rootSymbol = jm.getSourceFile(source.getURL());
        }
        if (rootSymbol == null) {
            TextNode textNode = (TextNode)source;
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            rootSymbol = JavaExplorer.parse(textBuffer);
        }
        return rootSymbol;
    }

    private static JavaExplorerOptions getOptions() {
        ClientSetting settings = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        JavaExplorerOptions options = (JavaExplorerOptions)settings.getData("JavaExplorerOptions");
        if (options == null) {
            options = new JavaExplorerOptions();
        }
        return options;
    }

    @Override
    protected LeafElement buildElementTreeImpl(Node node) {
        SourceFile rootSymbol = this.getRootSymbol(node);
        JavaRootFolder newRootElement = new JavaRootFolder(rootSymbol, JavaExplorer.getOptions());
        return newRootElement;
    }

    private void updateToolbarActions() {
        JavaExplorerOptions options = JavaExplorer.getOptions();
        int sortType = options.getSortOrder();
        int commandId = SORT_LOCATION_CMD_ID;
        switch (sortType) {
            case 1: {
                commandId = SORT_ALPHA_CMD_ID;
                break;
            }
            case 2: {
                commandId = SORT_TYPE_CMD_ID;
                break;
            }
            case 3: {
                commandId = SORT_ACCESS_CMD_ID;
            }
        }
        if (this.localSortActions != null) {
            int numActions = this.localSortActions.length;
            for (int i = 0; i < numActions; ++i) {
                if (this.localSortActions[i].getCommandId() != commandId) continue;
                this.localSortActions[i].setState(true);
                break;
            }
        }
        int showFilter = options.getShowFilter();
        int hideFilter = options.getHideFilter();
        if (this.localShowMethodsAction != null) {
            int METHOD_FLAGS = 160;
            boolean methodsShowing = (showFilter & METHOD_FLAGS) == METHOD_FLAGS;
            this.localShowMethodsAction.setState(methodsShowing);
        }
        if (this.localShowFieldsAction != null) {
            int FIELD_FLAGS = 64;
            boolean fieldsShowing = (showFilter & FIELD_FLAGS) == FIELD_FLAGS;
            this.localShowFieldsAction.setState(fieldsShowing);
        }
        if (this.localShowStaticsAction != null) {
            int STATIC_FLAGS = 64;
            boolean staticsShowing = (hideFilter & STATIC_FLAGS) != STATIC_FLAGS;
            this.localShowStaticsAction.setState(staticsShowing);
        }
        if (this.localShowPublicOnlyAction != null) {
            int PUBLIC_FLAGS = 1;
            int NON_PUBLIC_FLAGS = 14;
            boolean publicShowing = (hideFilter & PUBLIC_FLAGS) != PUBLIC_FLAGS;
            boolean nonPublicHidden = (hideFilter & NON_PUBLIC_FLAGS) == NON_PUBLIC_FLAGS;
            this.localShowPublicOnlyAction.setState(publicShowing && nonPublicHidden);
        }
        if (this.localSyncAction != null) {
            this.localSyncAction.setState(options.getSync());
        }
    }

    private void addToolbarItems() {
        Toolbar toolbar = this.owner().getToolbar();
        if (toolbar != null) {
            if (this.localButtons == null) {
                this.localButtons = new ArrayList();
                IdeAction[] sortActions = IdeAction.findGroup((String)SORT_GROUP_NAME);
                int numActions = sortActions.length;
                this.localSortActions = new IdeAction[numActions];
                for (int i = 0; i < numActions; ++i) {
                    this.localSortActions[i] = sortActions[i].newLocalAction((View)this);
                }
                this.addSeparator(toolbar);
                this.localButtons.add(toolbar.addMenuButton((ToggleAction[])this.localSortActions));
                this.localShowMethodsAction = showMethodsAction.newLocalAction((View)this);
                this.localShowFieldsAction = showFieldsAction.newLocalAction((View)this);
                this.localShowStaticsAction = showStaticsAction.newLocalAction((View)this);
                this.localShowPublicOnlyAction = showPublicOnlyAction.newLocalAction((View)this);
                this.localSyncAction = syncAction.newLocalAction((View)this);
                this.localButtons.add(toolbar.addToggleButton((ToggleAction)this.localShowMethodsAction));
                this.localButtons.add(toolbar.addToggleButton((ToggleAction)this.localShowFieldsAction));
                this.localButtons.add(toolbar.addToggleButton((ToggleAction)this.localShowStaticsAction));
                this.localButtons.add(toolbar.addToggleButton((ToggleAction)this.localShowPublicOnlyAction));
                this.localButtons.add(toolbar.addToggleButton((ToggleAction)this.localSyncAction));
            } else {
                this.addSeparator(toolbar);
                int numButtons = this.localButtons.size();
                for (int i = 0; i < numButtons; ++i) {
                    toolbar.add((Component)this.localButtons.get(i));
                }
            }
        }
    }

    private void addSeparator(Toolbar toolbar) {
        int count = toolbar.getComponentCount();
        if (count > 0) {
            Component c = toolbar.getComponentAtIndex(count - 1);
            if (!(c instanceof JToolBar.Separator)) {
                toolbar.addSeparator();
            }
        } else {
            toolbar.addSeparator();
        }
    }

    private void hideToolbarItems() {
        Toolbar toolbar = this.owner().getToolbar();
        if (toolbar != null && this.localButtons != null) {
            int numButtons = this.localButtons.size();
            for (int i = 0; i < numButtons; ++i) {
                toolbar.remove((Component)this.localButtons.get(i));
            }
        }
    }

    private void removeToolbarItems() {
        this.hideToolbarItems();
        if (this.localButtons != null) {
            int count = this.localButtons.size();
            for (int i = 0; i < count; ++i) {
                Object o = this.localButtons.get(i);
                if (!(o instanceof AbstractButton)) continue;
                ((AbstractButton)o).setAction(null);
            }
            this.localButtons = null;
        }
        this.localSortActions = null;
        this.localShowMethodsAction = null;
        this.localShowFieldsAction = null;
        this.localShowStaticsAction = null;
        this.localShowPublicOnlyAction = null;
        this.localSyncAction = null;
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.updateSelection(context.getSelection());
    }

    @Override
    protected void buildElementTree(Node node) {
        super.buildElementTree(node);
        if (this.getContext() != null) {
            this.updateSelection(this.getContext().getSelection());
        }
    }

    @Override
    public void stateChanged(int state) {
        super.stateChanged(state);
        switch (state) {
            case 0: {
                this.addToolbarItems();
                this.updateToolbarActions();
                break;
            }
            case 1: {
                this.hideToolbarItems();
                break;
            }
            case 2: {
                this.removeToolbarItems();
            }
        }
    }

    @Override
    public void menuWillShow(ContextMenu contextMenu) {
        super.menuWillShow(contextMenu);
        Context context = contextMenu.getContext();
        Element element = context.getElement();
        if (element == null) {
            return;
        }
        if (element instanceof CodeElement) {
            boolean isExtends = element instanceof ExtendsElement || element instanceof ImplementsElement;
            boolean isImport = element instanceof ImportElement;
            boolean isClass = element instanceof ClassElement;
            if (isExtends || isImport) {
                JavaCodeElement javaElement = (JavaCodeElement)element;
                String symbolName = javaElement.getSymbolName();
                if (symbolName.endsWith("*")) {
                    return;
                }
                String gotoClassName = JavaArb.format(234, symbolName);
                gotoClassName = StringUtils.stripMnemonic((String)gotoClassName);
                gotoClassAction.putValue("Name", (Object)gotoClassName);
                gotoClassAction.addController((Controller)this);
                gotoClassAction.setEnabled(true);
                contextMenu.add((Component)gotoClassMenuItem, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
            }
            if ((isClass || isExtends || isImport) && JavaBrowseSupport2.canBrowseHierarchy()) {
                browseHierarchyAction.setEnabled(true);
                contextMenu.add((Component)browseHierarchyMenuItem, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
            }
        }
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (action == gotoClassAction) {
            Element element = context.getElement();
            if (element instanceof CodeElement) {
                CodeElement codeElement = (CodeElement)element;
                int offset = codeElement.getEndOffset();
                try {
                    JavaBrowseSupport2.performBrowseSymbolAtOffset(context, offset);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return true;
        }
        if (action == browseHierarchyAction) {
            Element element = context.getElement();
            if (element instanceof CodeElement) {
                CodeElement codeElement = (CodeElement)element;
                int offset = codeElement.getEndOffset();
                try {
                    JavaBrowseSupport2.performBrowseHierarchyAtOffset(context, offset);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return true;
        }
        if (commandId == SORT_LOCATION_CMD_ID || commandId == SORT_ALPHA_CMD_ID || commandId == SORT_TYPE_CMD_ID || commandId == SORT_ACCESS_CMD_ID) {
            int sortOrder = 0;
            if (commandId == SORT_ALPHA_CMD_ID) {
                sortOrder = 1;
            } else if (commandId == SORT_TYPE_CMD_ID) {
                sortOrder = 2;
            } else if (commandId == SORT_ACCESS_CMD_ID) {
                sortOrder = 3;
            }
            JavaExplorerOptions options = JavaExplorer.getOptions();
            options.setSortOrder(sortOrder);
            this.modifyOptions(options);
            return true;
        }
        if (commandId == SHOW_METHODS_CMD_ID || commandId == SHOW_FIELDS_CMD_ID) {
            int flag;
            JavaExplorerOptions options = JavaExplorer.getOptions();
            int showFilter = options.getShowFilter();
            boolean state = action.getState();
            int n = flag = commandId == SHOW_FIELDS_CMD_ID ? 64 : 160;
            showFilter = state ? (showFilter |= flag) : (showFilter &= ~flag);
            options.setShowFilter(showFilter);
            this.modifyOptions(options);
            return true;
        }
        if (commandId == SHOW_STATICS_CMD_ID) {
            JavaExplorerOptions options = JavaExplorer.getOptions();
            int hideFilter = options.getHideFilter();
            boolean state = action.getState();
            int flag = 64;
            hideFilter = state ? (hideFilter &= ~flag) : (hideFilter |= flag);
            options.setHideFilter(hideFilter);
            this.modifyOptions(options);
            return true;
        }
        if (commandId == SHOW_PUBLIC_ONLY_CMD_ID) {
            JavaExplorerOptions options = JavaExplorer.getOptions();
            int hideFilter = options.getHideFilter();
            boolean state = action.getState();
            int publicFlags = 1;
            int nonPublicFlags = 14;
            if (state) {
                hideFilter &= ~publicFlags;
                hideFilter |= nonPublicFlags;
            } else {
                hideFilter &= ~nonPublicFlags;
            }
            options.setHideFilter(hideFilter);
            this.modifyOptions(options);
            return true;
        }
        if (commandId == SYNC_CMD_ID) {
            JavaExplorerOptions options = JavaExplorer.getOptions();
            boolean sync = action.getState();
            options.setSync(sync);
            this.modifyOptions(options);
            if (sync && this.getContext() != null) {
                this.updateSelection(this.getContext().getSelection());
            }
            return true;
        }
        return super.handleEvent(action, context);
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (action == gotoClassAction) {
            return true;
        }
        if (action == browseHierarchyAction) {
            return true;
        }
        if (commandId == SORT_LOCATION_CMD_ID || commandId == SORT_ALPHA_CMD_ID || commandId == SORT_TYPE_CMD_ID || commandId == SORT_ACCESS_CMD_ID || commandId == SHOW_METHODS_CMD_ID || commandId == SHOW_FIELDS_CMD_ID || commandId == SHOW_STATICS_CMD_ID || commandId == SHOW_PUBLIC_ONLY_CMD_ID) {
            return true;
        }
        return super.update(action, context);
    }

    protected static void notifyOptionsChanged() {
        Runnable notifier = new Runnable(){

            @Override
            public void run() {
                CodeExplorer.firePropertyChange("JavaExplorerOptions");
            }
        };
        IdeUtil.invokeAfterRepaint((Runnable)notifier);
    }

    private void modifyOptions(JavaExplorerOptions options) {
        if (options != null) {
            ClientSetting settings = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
            settings.putData("JavaExplorerOptions", (Copyable)options);
        }
        JavaExplorer.notifyOptionsChanged();
    }

    @Override
    protected void propertyChange(String propertyName) {
        if (propertyName.equals("JavaExplorerOptions")) {
            this.scheduleRebuild();
            Runnable updateToolbarItems = new Runnable(){

                @Override
                public void run() {
                    JavaExplorer.this.updateToolbarActions();
                }
            };
            SwingUtilities.invokeLater(updateToolbarItems);
        }
    }

    private void updateSelection(Element[] sel) {
        if (!JavaExplorer.getOptions().getSync()) {
            return;
        }
        if (sel == null || sel.length == 0) {
            this.tree.clearSelection();
        } else {
            Element first = sel[0];
            SourceElement sourceElem = this.getElementToSelect(first);
            if (sourceElem != null) {
                this.visitToSelect(sourceElem, new TreePath(this.tree.getModel().getRoot()));
            }
        }
    }

    private SourceElement getElementToSelect(Object obj) {
        if (obj instanceof Element) {
            obj = ((Element)obj).getData();
        }
        if (obj instanceof SourceMethod) {
            return (SourceMethod)obj;
        }
        if (obj instanceof SourceImport) {
            return (SourceImport)obj;
        }
        if (obj instanceof SourcePackage) {
            return (SourcePackage)obj;
        }
        if (obj instanceof SourceClass) {
            return (SourceClass)obj;
        }
        if (obj instanceof SourceMemberVariable) {
            return (SourceMemberVariable)obj;
        }
        if (obj instanceof SourceTypeReference) {
            return (SourceTypeReference)obj;
        }
        if (obj instanceof SourceElement && ((SourceElement)obj).getParent() != null) {
            return this.getElementToSelect(((SourceElement)obj).getParent());
        }
        return null;
    }

    private boolean visitToSelect(SourceElement selElement, TreePath path) {
        Object node = path.getLastPathComponent();
        if (node instanceof ExplorerNode) {
            Object containedObject = ((ExplorerNode)node).getUserObject();
            if (selElement instanceof SourceMethod && containedObject instanceof MethodElement) {
                MethodElement methodElem = (MethodElement)containedObject;
                if (methodElem.getMethodStartOffset() == selElement.getStartOffset()) {
                    this.tree.setSelectionPath(path);
                    this.tree.makeVisible(path);
                    this.tree.scrollPathToVisible(path);
                    return true;
                }
            } else if ((selElement instanceof SourceClass || selElement instanceof SourceImport || selElement instanceof SourceMemberVariable || selElement instanceof SourcePackage || selElement instanceof SourceTypeReference) && containedObject instanceof JavaCodeElement) {
                JavaCodeElement elem = (JavaCodeElement)containedObject;
                int startOffset = JavaCodeElement.getStartOffset(selElement);
                if (elem.getStartOffset() == startOffset) {
                    this.tree.setSelectionPath(path);
                    this.tree.makeVisible(path);
                    this.tree.scrollPathToVisible(path);
                    return true;
                }
            }
        }
        int childrenLen = this.tree.getModel().getChildCount(node);
        for (int i = 0; i < childrenLen; ++i) {
            Object child = this.tree.getModel().getChild(node, i);
            TreePath childPath = path.pathByAddingChild(child);
            boolean success = this.visitToSelect(selElement, childPath);
            if (!success) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CodePeek showEditorPeek(Point p) {
        CustomTree tree = this.getTree(null);
        if (!tree.getVisibleRect().contains(p)) {
            return null;
        }
        TreePath path = tree.getPathForLocation(p.x, p.y);
        if (path != null) {
            Object obj = ((ExplorerNode)path.getLastPathComponent()).getUserObject();
            Icon icon = null;
            int sOff = 0;
            int eOff = 0;
            String labelText = null;
            if (obj instanceof PeekProvider) {
                PeekProvider pp = (PeekProvider)obj;
                sOff = pp.getPeekStartOffset();
                eOff = pp.getPeekEndOffset();
                icon = pp.getIcon();
                labelText = pp.getLongLabel();
                tree.getExpansionTip().hidePopup();
                if (sOff != eOff) {
                    URL url;
                    Rectangle rowBounds = tree.getRowBounds(tree.getRowForLocation(p.x, p.y));
                    Rectangle visibleRect = tree.getVisibleRect();
                    Rectangle visibleBounds = visibleRect.intersection(rowBounds);
                    JavaManager jm = JavaManager.getInstance((Project)this.project);
                    SourceFile sf = jm.getSourceFile(url = this.node.getURL());
                    if (sf != null) {
                        TextBuffer tb = sf.getTextBuffer();
                        tb.readLock();
                        try {
                            String text = tb.getString(sOff, eOff - sOff);
                            CodePeek peek = JavaCodePeek.createCodePeek((JComponent)tree, url.getFile(), text, labelText, visibleBounds);
                            peek.setLabelIcon(icon);
                            JavaCodePeek.showPeek(peek);
                            tree.setToolTipText(null);
                            CodePeek codePeek = peek;
                            return codePeek;
                        }
                        finally {
                            tb.readUnlock();
                        }
                    }
                }
            }
        }
        return null;
    }

    private class PeekableCustomTree
    extends CustomTree
    implements Peekable {
        private PeekableCustomTree() {
        }

        public Peek peek(Point p) {
            SwingUtilities.convertPointFromScreen(p, (Component)((Object)this));
            return JavaExplorer.this.showEditorPeek(p);
        }
    }
}

