/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.util.ArrayList;
import java.util.Collections;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.FolderElement;
import oracle.jdevimpl.java.explorer.ImportElement;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;
import oracle.jdevimpl.java.explorer.LeafElement;
import oracle.jdevimpl.java.explorer.LeafElementComparator;

public final class ImportFolder
extends FolderElement {
    ImportFolder(SourceImport[] symbols, JavaExplorerOptions options) {
        boolean sortChildren;
        String text = JavaArb.getString(72);
        this.setDisplayText(text);
        this.setTooltipText(text);
        this.setIcon(OracleIcons.getIcon((String)"folder.png"));
        int numSymbols = symbols != null ? symbols.length : 0;
        ArrayList<ImportElement> childList = new ArrayList<ImportElement>();
        for (int i = 0; i < numSymbols; ++i) {
            SourceImport importSymbol = symbols[i];
            if (importSymbol == null) continue;
            childList.add(new ImportElement(importSymbol));
        }
        boolean bl = sortChildren = options.getSortOrder() != 0;
        if (sortChildren) {
            Collections.sort(childList, new LeafElementComparator());
        }
        numSymbols = childList.size();
        LeafElement[] importElements = childList.toArray(new LeafElement[numSymbols]);
        this.setChildren(importElements);
        int expansionOptions = options.getExpandedFolders();
        boolean expandedByDefault = (expansionOptions & 2) != 0;
        this.setExpandedDefault(expandedByDefault);
    }
}

