/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.io.PrintWriter;
import javax.swing.Icon;
import oracle.ide.util.FastStringWriter;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;
import oracle.jdevimpl.java.explorer.ModifierElement;
import oracle.jdevimpl.java.explorer.PeekProvider;

public class FieldElement
extends ModifierElement
implements PeekProvider {
    private int peekStartOff;
    private int peekEndOff;

    public FieldElement(SourceMemberVariable variable, JavaExplorerOptions options) {
        super((SourceHasModifiers)variable, options);
        SourceMemberVariable se = variable.getParent() == null ? variable : variable.getParent();
        this.peekStartOff = se.getStartOffset();
        this.peekEndOff = se.getEndOffset();
    }

    @Override
    protected String getTooltipText(SourceElement symbol) {
        FastStringWriter buffer = FieldElement.allocFastStringBuffer();
        symbol.print((PrintWriter)buffer, 0);
        String tooltipText = buffer.toString();
        FieldElement.freeFastStringBuffer(buffer);
        String pattern = JavaArb.getString(69);
        return FieldElement.format(pattern, tooltipText);
    }

    @Override
    protected String getDisplayText(SourceElement symbol) {
        SourceMemberVariable variable = (SourceMemberVariable)symbol;
        FastStringWriter buffer = FieldElement.allocFastStringBuffer();
        FieldElement.print((SourceElement)variable.getNameElement(), (PrintWriter)buffer);
        SourceTypeReference type = variable.getSourceType();
        if (type != null) {
            buffer.print(" : ");
            FieldElement.print((SourceElement)type, (PrintWriter)buffer);
        }
        String result = buffer.toString();
        FieldElement.freeFastStringBuffer(buffer);
        return result;
    }

    @Override
    protected Icon getIcon(SourceElement symbol) {
        return OracleIcons.getIcon((String)"field.png");
    }

    @Override
    public int getPeekStartOffset() {
        return this.peekStartOff;
    }

    @Override
    public int getPeekEndOffset() {
        return this.peekEndOff;
    }
}

