/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.ideimpl.explorer.BaseTreeExplorer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.WeakPropertyChangeSupport;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.CodeElement;
import oracle.jdevimpl.java.explorer.ExpansionTracker;
import oracle.jdevimpl.java.explorer.JavaCodeElement;
import oracle.jdevimpl.java.explorer.LeafElement;

public abstract class CodeExplorer
extends BaseTreeExplorer
implements ContextMenuListener,
Controller,
Observer,
PropertyChangeListener {
    protected LeafElement rootElement = this.getEmptyRootElement();
    protected Node node = null;
    protected Project project;
    protected TextBuffer textBuffer;
    protected boolean isObserving = false;
    protected ExpansionTracker tracker;
    private static IdeAction gotoSourceAction;
    private static JMenuItem gotoSourceMenuItem;
    private boolean rebuildScheduled = false;
    private static WeakPropertyChangeSupport changeSupport;

    public CodeExplorer() {
        CodeExplorer.initializeActions();
        CodeExplorer.addPropertyChangeListener(this);
    }

    protected LeafElement getEmptyRootElement() {
        return new LeafElement("", "", null);
    }

    private static void initializeActions() {
        if (gotoSourceAction == null) {
            String gotoSourceName = JavaArb.getString(232);
            int gotoSourceMnemonic = StringUtils.getMnemonicKeyCode((String)gotoSourceName);
            gotoSourceName = StringUtils.stripMnemonic((String)gotoSourceName);
            gotoSourceAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojje.GotoSource"), null, (String)gotoSourceName, (String)IdeMainWindow.ACTION_CATEGORY_SEARCH, (Integer)new Integer(gotoSourceMnemonic), (ArrayResourceBundle)JavaArb.getInstance(), (int)233, null, (boolean)false);
            gotoSourceMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)gotoSourceAction);
        }
    }

    public void setContext(Context context) {
        super.setContext(context);
        if (context != null && context.getNode() != null) {
            Node node = context.getNode();
            String nodeName = node.getShortLabel();
            String title = this.getAccessibleTitle(nodeName);
            if (this.tree != null) {
                AccessibleUtils.updateAccessibleName((Accessible)this.tree, (String)title, (boolean)true);
            }
        }
    }

    protected abstract String getAccessibleTitle(String var1);

    public synchronized Element annotate(Context context) {
        if (context == null || context.getNode() == null) {
            this.rootElement = this.getEmptyRootElement();
            this.node = null;
            this.project = null;
        }
        if (context.getNode() == this.node && context.getProject() == this.project) {
            return this.rootElement;
        }
        this.stopObserving();
        this.node = context.getNode();
        this.project = context.getProject();
        if (this.tracker != null) {
            this.tracker.clearExpansionState();
        }
        this.rootElement = this.getEmptyRootElement();
        this.scheduleRebuild();
        return this.rootElement;
    }

    public void stateChanged(int state) {
        View owner = this.owner();
        ContextMenu menu = owner != null ? owner.getContextMenu() : null;
        switch (state) {
            case 0: {
                if (!this.isObserving()) {
                    this.startObserving();
                }
                this.scheduleRebuild();
                if (menu == null) break;
                menu.addContextMenuListener((ContextMenuListener)this);
                break;
            }
            case 2: {
                CodeExplorer.removePropertyChangeListener(this);
            }
            case 1: {
                if (menu != null) {
                    menu.removeContextMenuListener((ContextMenuListener)this);
                }
                this.stopObserving();
            }
        }
    }

    private boolean isObserving() {
        return this.isObserving;
    }

    private void startObserving() {
        if (!this.isObserving && this.node != null) {
            if (this.node instanceof TextNode) {
                this.textBuffer = ((TextNode)this.node).acquireTextBuffer();
            }
            this.node.attach((Observer)this);
            this.isObserving = true;
        }
    }

    private void stopObserving() {
        if (this.isObserving && this.node != null) {
            this.node.detach((Observer)this);
            this.isObserving = false;
            if (this.node instanceof TextNode) {
                ((TextNode)this.node).releaseTextBuffer();
                this.textBuffer = null;
            }
        }
    }

    public void update(Object observed, UpdateMessage change) {
        int messageID;
        if (this.isObserving() && this.node != null && observed == this.node && (messageID = change.getMessageID()) != UpdateMessage.CHILD_REMOVED && messageID != UpdateMessage.CHILD_ADDED && messageID != UpdateMessage.PROPERTY_SET && messageID != UpdateMessage.OBJECT_RENAMED && messageID != UpdateMessage.CHILD_RENAMED && messageID != UpdateMessage.OBJECT_OPENED && messageID != UpdateMessage.OBJECT_CLOSED && messageID != UpdateMessage.OBJECT_CLOSING && messageID != UpdateMessage.ATTRIBUTE_CHANGED) {
            this.scheduleRebuild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleRebuild() {
        CodeExplorer codeExplorer = this;
        synchronized (codeExplorer) {
            if (this.rebuildScheduled) {
                return;
            }
            this.rebuildScheduled = true;
        }
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CodeExplorer.this.buildElementTree(CodeExplorer.this.node);
                }
                finally {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        CodeExplorer.this.rebuildScheduled = false;
                    }
                }
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    protected void buildElementTree(Node node) {
        if (this.tracker == null) {
            this.tracker = new ExpansionTracker((JTree)this.tree);
        }
        this.tracker.stopTracking();
        Object expansionState = this.tracker.getExpansionState();
        this.tracker.clearExpansionState();
        TreePath[] selPaths = this.tree.getSelectionPaths();
        int[] selRows = this.tree.getSelectionRows();
        this.rootElement = this.buildElementTreeImpl(node);
        this.setRoot(this.rootElement);
        TNode rootNode = this.getRoot();
        this.populateNodes(rootNode);
        this.tracker.expandDefaultExpansion();
        this.tracker.startTracking();
        this.tracker.restoreExpansion(expansionState);
        this._reselectPaths(selRows, selPaths);
    }

    private void _reselectPaths(int[] selRows, TreePath[] selPaths) {
        if (selRows != null && selPaths != null && selRows.length > 0 && selRows.length == selPaths.length) {
            for (int i = 0; i < selRows.length; ++i) {
                TreePath tp = this.tree.getPathForRow(selRows[i]);
                if (tp == null || tp.getLastPathComponent() == null) continue;
                Element obj1 = ((TNode)tp.getLastPathComponent()).getData();
                Element obj2 = ((TNode)selPaths[i].getLastPathComponent()).getData();
                if (!(obj1 instanceof JavaCodeElement) || !(obj2 instanceof JavaCodeElement)) continue;
                JavaCodeElement jce1 = (JavaCodeElement)obj1;
                JavaCodeElement jce2 = (JavaCodeElement)obj2;
                if (!jce1.getSymbolName().equals(jce2.getSymbolName())) continue;
                this.tree.addSelectionRow(selRows[i]);
            }
        }
    }

    protected abstract LeafElement buildElementTreeImpl(Node var1);

    protected void populateNodes(TNode node) {
        this.addChildren(node);
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            TNode child = (TNode)node.getChildAt(i);
            if (child.isLeaf()) continue;
            this.populateNodes(child);
        }
    }

    public void menuWillShow(ContextMenu contextMenu) {
        CodeElement codeElement;
        Context context = contextMenu.getContext();
        Element element = context.getElement();
        if (element == null) {
            return;
        }
        if (element instanceof CodeElement && (codeElement = (CodeElement)element).getStartOffset() != -1) {
            gotoSourceAction.addController((Controller)this);
            gotoSourceAction.setEnabled(true);
            contextMenu.add((Component)gotoSourceMenuItem, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        Element element;
        if (context != null && context.getView() == this.owner() && (element = context.getElement()) instanceof CodeElement) {
            CodeElement codeElement = (CodeElement)element;
            int startOffset = codeElement.getStartOffset();
            int endOffset = codeElement.getEndOffset();
            if (startOffset != -1 && endOffset != -1) {
                Context ourContext = this.getContext();
                Context editorContext = new Context(ourContext);
                Node nodeElement = editorContext.getNode();
                editorContext.setElement((Element)nodeElement);
                editorContext.setSelection(new Element[]{nodeElement});
                editorContext.setEvent(null);
                NavigationManager mgr = NavigationManager.getNavigationManager();
                OffsetNavigationPoint point = new OffsetNavigationPoint(editorContext, startOffset, endOffset - startOffset);
                try {
                    if (mgr != null) {
                        mgr.navigateTo((NavigationPoint)point);
                    } else {
                        point.navigate();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    public Controller getController() {
        return this;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (action == gotoSourceAction) {
            this.handleDefaultAction(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        return action == gotoSourceAction;
    }

    protected static void addPropertyChangeListener(PropertyChangeListener listener) {
        changeSupport.addPropertyChangeListener(listener);
    }

    protected static void removePropertyChangeListener(PropertyChangeListener listener) {
        changeSupport.removePropertyChangeListener(listener);
    }

    public static void firePropertyChange(String propertyName) {
        changeSupport.firePropertyChange(propertyName, (Object)Boolean.TRUE, (Object)Boolean.FALSE);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.propertyChange(event.getPropertyName());
    }

    protected void propertyChange(String propertyName) {
    }

    static {
        changeSupport = new WeakPropertyChangeSupport(CodeExplorer.class);
    }
}

