/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Comparator;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.config.ClientSetting;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.JavaParserPlugin;
import oracle.jdevimpl.java.editing.JavaUnderlinesOptions;

public final class JavaUnderlinesPlugin
implements EditorPlugin,
JavaConstants,
JavaParserPlugin.HelperClient {
    private BasicEditorPane editor;
    private HighlightLayer highlightLayer;
    protected static final String PROPERTY_UNDERLINES = "java-underlines";
    protected static final String CLASS_SEPARATOR_STYLE = "java-class-separator-style";
    protected static final String MEMBER_SEPARATOR_STYLE = "java-member-separator-style";
    private static HighlightStyle classStyle;
    private static HighlightStyle memberStyle;
    private static final Comparator MEMBER_SYMBOL_COMPARATOR;

    @Override
    public void notifyCompileScheduled() {
    }

    @Override
    public void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
    }

    @Override
    public void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
        this.performHighlights(changeId, sourceFile);
    }

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        JavaParserPlugin.attachHelperClient(editor, this);
    }

    public void deinstall(BasicEditorPane editor) {
        JavaParserPlugin.detachHelperClient(editor, this);
        if (this.highlightLayer != null) {
            editor.destroyHighlightLayer(this.highlightLayer);
            this.highlightLayer = null;
        }
        this.editor = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("highlight-registry") || propertyName.equals("highlight-changed")) {
            // empty if block
        }
    }

    private TextBuffer getTextBuffer() {
        return this.getDocument().getTextBuffer();
    }

    private BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    public static JavaUnderlinesOptions getOptions() {
        ClientSetting settings = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        JavaUnderlinesOptions options = (JavaUnderlinesOptions)settings.getData("JavaUnderlinesOptions");
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performHighlights(int changeId, SourceFile sourceFile) {
        TextBuffer textBuffer = this.getTextBuffer();
        textBuffer.readLock();
        try {
            int bufferId = textBuffer.getChangeId();
            if (changeId != bufferId) {
                return;
            }
            this.clearHighlights();
            this.addSeparators(sourceFile);
        }
        finally {
            textBuffer.readUnlock();
        }
    }

    private void clearHighlights() {
        if (this.highlightLayer != null) {
            this.highlightLayer.removeAllHighlights();
        }
    }

    private HighlightLayer getHighlightLayer() {
        if (this.highlightLayer == null) {
            this.highlightLayer = this.editor.createHighlightLayer();
        }
        return this.highlightLayer;
    }

    private void addSeparators(SourceFile sourceFile) {
        JavaUnderlinesOptions javaUnderlinesOptions = JavaUnderlinesPlugin.getOptions();
        if (javaUnderlinesOptions == null) {
            return;
        }
        boolean useClassSeparators = javaUnderlinesOptions.getShowClassSeparators();
        boolean useMemberSeparators = javaUnderlinesOptions.getShowMemberSeparators();
        if (!useClassSeparators && !useMemberSeparators) {
            return;
        }
        if (sourceFile != null) {
            HighlightLayer layer = this.getHighlightLayer();
            SourceClass[] classes = sourceFile.getSourceClasses().toArray(SourceClass.EMPTY_ARRAY);
            int numClasses = classes != null ? classes.length : 0;
            int[] classOffsets = new int[numClasses];
            for (int i = 0; i < numClasses; ++i) {
                SourceClass classSymbol = classes[i];
                if (useMemberSeparators && classSymbol != null) {
                    this.addSeparators(classSymbol);
                }
                classOffsets[i] = JavaUnderlinesPlugin.getStartOffset((SourceElement)classSymbol);
            }
            if (!useClassSeparators) {
                return;
            }
            Arrays.sort(classOffsets);
            TextBuffer textBuffer = this.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            boolean isFirst = true;
            int lastOffset = -1;
            for (int i = 0; i < numClasses; ++i) {
                if (classOffsets[i] == -1) continue;
                if (isFirst) {
                    isFirst = false;
                    continue;
                }
                if (lastOffset == classOffsets[i]) continue;
                lastOffset = classOffsets[i];
                int startOffset = classOffsets[i];
                int line = lineMap.getLineFromOffset(startOffset) - 1;
                if (line <= 0) continue;
                layer.addLineHighlight(classStyle, line);
            }
        }
    }

    private void addSeparators(SourceClass classSymbol) {
        JavaUnderlinesOptions javaUnderlinesOptions = JavaUnderlinesPlugin.getOptions();
        if (javaUnderlinesOptions == null) {
            return;
        }
        boolean skipAdjacent = javaUnderlinesOptions.getSkipAdjacentFields();
        if (classSymbol != null) {
            HighlightLayer layer = this.getHighlightLayer();
            SourceMember[] members = classSymbol.getSourceMembers().toArray(SourceMember.EMPTY_ARRAY);
            int numMembers = members.length;
            for (int i = 0; i < numMembers; ++i) {
                SourceMember memberSymbol = members[i];
                if (memberSymbol == null || memberSymbol.getSymbolKind() != 3) continue;
                this.addSeparators((SourceClass)memberSymbol);
            }
            Arrays.sort(members, MEMBER_SYMBOL_COMPARATOR);
            TextBuffer textBuffer = this.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            boolean isFirst = true;
            SourceMember lastMember = null;
            for (int i = 0; i < numMembers; ++i) {
                int currentOffset;
                SourceMember member = members[i];
                if (member == null || (currentOffset = JavaUnderlinesPlugin.getStartOffset((SourceElement)member)) == -1) continue;
                if (isFirst) {
                    isFirst = false;
                    lastMember = member;
                    continue;
                }
                if (member instanceof SourceFieldDeclaration && lastMember instanceof SourceFieldDeclaration && skipAdjacent) {
                    lastMember = member;
                    continue;
                }
                int line = lineMap.getLineFromOffset(currentOffset) - 1;
                if (line > 0) {
                    layer.addLineHighlight(memberStyle, line);
                }
                lastMember = member;
            }
        }
    }

    private static int getStartOffset(SourceElement symbol) {
        if (symbol != null) {
            return symbol.getStartOffset();
        }
        return -1;
    }

    public static void registerHighlights() {
        String name = JavaArb.getString(110);
        classStyle = CodeEditor.createHighlightStyle((String)CLASS_SEPARATOR_STYLE, (String)name, (int)50, null, null, (int)0, (int)5, (Color)Color.LIGHT_GRAY);
        name = JavaArb.getString(109);
        memberStyle = CodeEditor.createHighlightStyle((String)MEMBER_SEPARATOR_STYLE, (String)name, (int)50, null, null, (int)0, (int)9, (Color)Color.LIGHT_GRAY);
    }

    static {
        MEMBER_SYMBOL_COMPARATOR = new Comparator(){

            public int compare(Object o1, Object o2) {
                SourceMember m1 = (SourceMember)o1;
                SourceMember m2 = (SourceMember)o2;
                int offset1 = JavaUnderlinesPlugin.getStartOffset((SourceElement)m1);
                int offset2 = JavaUnderlinesPlugin.getStartOffset((SourceElement)m2);
                return offset1 - offset2;
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }
        };
        JavaUnderlinesPlugin.registerHighlights();
    }
}

