/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.Color;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.UIManager;
import oracle.ide.ceditor.ScrollTipPlugin;
import oracle.ide.ceditor.ScrollTipRenderer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.CodeExpansionEvent;
import oracle.javatools.editor.folding.CodeExpansionListener;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.ui.simplestyle.StyledLabel;
import oracle.javatools.ui.simplestyle.StyledTextAttribute;
import oracle.javatools.ui.simplestyle.StyledTextModel;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaParserPlugin;

public class JavaScrollTipPlugin
extends ScrollTipPlugin
implements CodeExpansionListener,
JavaParserPlugin.HelperClient {
    private List<ScrollInfo> infoList = new LinkedList<ScrollInfo>();
    private CodeFoldingMargin foldingMargin;
    private volatile NameFetcherThread nameFetcherThread;
    private static StyledTextAttribute BOLD_ATTR = new StyledTextAttribute(UIManager.getFont("Label.font").deriveFont(1), null);
    private static StyledTextAttribute NORMAL_ATTR = new StyledTextAttribute(UIManager.getFont("Label.font"), null);

    public void install(BasicEditorPane editor) {
        super.install(editor);
        this.setRenderer(new JavaScrollTipRenderer());
        JavaParserPlugin.attachHelperClient(editor, this);
        Object obj = editor.getProperty("code-folding-margin");
        if (obj != null) {
            this.foldingMargin = (CodeFoldingMargin)obj;
            this.foldingMargin.addCodeExpansionListener((CodeExpansionListener)this);
        }
    }

    public void deinstall(BasicEditorPane editor) {
        super.deinstall(editor);
        JavaParserPlugin.detachHelperClient(editor, this);
        if (this.foldingMargin != null) {
            this.foldingMargin.removeCodeExpansionListener((CodeExpansionListener)this);
        }
    }

    @Override
    public void notifyCompileScheduled() {
        this.infoList.clear();
    }

    @Override
    public void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
    }

    public void addClassMethods(SourceClass sourceClass, String indent) throws InterruptedException {
        ScrollInfo info;
        StyledTextModel model;
        SourceMethod sourceMethod;
        for (JavaMethod method : sourceClass.getDeclaredConstructors()) {
            sourceMethod = (SourceMethod)method.getSourceElement();
            if (sourceMethod == null) continue;
            model = new StyledTextModel(indent + JavaScrollTipPlugin.getMethodName((JavaMethod)sourceMethod), BOLD_ATTR);
            model.addText(JavaScrollTipPlugin.getParams((JavaMethod)sourceMethod) + JavaScrollTipPlugin.getReturn((JavaMethod)sourceMethod), NORMAL_ATTR);
            info = new ScrollInfo(model, sourceMethod.getStartOffset(), sourceMethod.getEndOffset());
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.infoList.add(info);
        }
        for (JavaMethod method : sourceClass.getDeclaredMethods()) {
            sourceMethod = (SourceMethod)method.getSourceElement();
            if (sourceMethod == null) continue;
            model = new StyledTextModel(indent + JavaScrollTipPlugin.getMethodName((JavaMethod)sourceMethod), BOLD_ATTR);
            model.addText(JavaScrollTipPlugin.getParams((JavaMethod)sourceMethod) + JavaScrollTipPlugin.getReturn((JavaMethod)sourceMethod), NORMAL_ATTR);
            info = new ScrollInfo(model, sourceMethod.getStartOffset(), sourceMethod.getEndOffset());
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.infoList.add(info);
        }
        List classes = sourceClass.getSourceClasses();
        for (SourceClass aClass : classes) {
            model = new StyledTextModel(indent + "class ", NORMAL_ATTR);
            model.addText(aClass.getName(), BOLD_ATTR);
            info = new ScrollInfo(model, aClass.getSourceBody().getStartOffset(), aClass.getSourceBody().getEndOffset());
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.infoList.add(info);
            this.addClassMethods(aClass, indent + "    ");
        }
    }

    @Override
    public void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
        if (this.nameFetcherThread != null) {
            this.tryFetchInterrupt();
        } else {
            this.startFetcherThread(sourceFile);
        }
    }

    private void tryFetchInterrupt() {
        try {
            this.nameFetcherThread.interrupt();
        }
        catch (NullPointerException npe) {
            this.updateInfoVisibility();
        }
    }

    private synchronized void startFetcherThread(SourceFile sourceFile) {
        if (this.nameFetcherThread != null) {
            return;
        }
        this.infoList.clear();
        this.nameFetcherThread = new NameFetcherThread(sourceFile);
        this.nameFetcherThread.start();
    }

    public static String getMethodName(JavaMethod javaMethod) {
        return javaMethod.isConstructor() ? javaMethod.getOwningClass().getName() : javaMethod.getName();
    }

    public static String getParams(JavaMethod javaMethod) {
        StringBuffer sb = new StringBuffer("(");
        if (javaMethod.getParameterTypes().length > 0) {
            for (JavaType paramType : javaMethod.getParameterTypes()) {
                if (paramType == null) continue;
                sb.append(paramType.getName());
                sb.append(", ");
            }
            if (sb.length() > 5) {
                sb.delete(sb.length() - 2, sb.length());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getReturn(JavaMethod javaMethod) {
        return javaMethod.getReturnType() != null ? " : " + javaMethod.getReturnType().getName() : " : void";
    }

    private void updateInfoVisibility() {
        if (this.foldingMargin != null) {
            try {
                for (ScrollInfo info : this.infoList) {
                    info.visible = this.foldingMargin.getModel() == null ? true : this.foldingMargin.getLargestCollapsedBlock(this.foldingMargin.getModel(), this.foldingMargin.getModel().getRoot(), info.startOffset) == null;
                }
            }
            catch (ConcurrentModificationException cme) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void codeExpanded(CodeExpansionEvent event) {
        if (this.nameFetcherThread == null) {
            this.updateInfoVisibility();
        } else {
            this.tryFetchInterrupt();
        }
    }

    public void codeCollapsed(CodeExpansionEvent event) {
        if (this.nameFetcherThread == null) {
            this.updateInfoVisibility();
        } else {
            this.tryFetchInterrupt();
        }
    }

    private class NameFetcherThread
    extends Thread {
        private SourceFile sourceFile;

        public NameFetcherThread(SourceFile sourceFile) {
            super("Scroll-Name-fetcher");
            this.sourceFile = sourceFile;
        }

        @Override
        public void run() {
            try {
                SourceClass sourceClass = this.sourceFile.getSourcePrimaryClass();
                if (sourceClass != null) {
                    JavaScrollTipPlugin.this.addClassMethods(sourceClass, "");
                }
                JavaScrollTipPlugin.this.updateInfoVisibility();
            }
            catch (InterruptedException e) {
                JavaScrollTipPlugin.this.nameFetcherThread = null;
                JavaScrollTipPlugin.this.startFetcherThread(this.sourceFile);
                return;
            }
            JavaScrollTipPlugin.this.nameFetcherThread = null;
        }
    }

    private class ScrollInfo {
        StyledTextModel model;
        int startOffset;
        int endOffset;
        boolean visible = true;

        ScrollInfo(StyledTextModel model, int sOff, int eOff) {
            this.model = model;
            this.startOffset = sOff;
            this.endOffset = eOff;
        }
    }

    private class JavaScrollTipRenderer
    extends JList
    implements ScrollTipRenderer {
        private StyledLabel label = new StyledLabel();

        public JavaScrollTipRenderer() {
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY, 1));
            this.setOpaque(true);
        }

        public JComponent getRenderer(BasicEditorPane editor, int startOffset, int endOffset) {
            StyledTextModel styleModel = new StyledTextModel();
            boolean firstMethod = true;
            int i = 0;
            for (int j = 0; j < JavaScrollTipPlugin.this.infoList.size(); ++j) {
                try {
                    ScrollInfo info = (ScrollInfo)JavaScrollTipPlugin.this.infoList.get(j);
                    if (!info.visible || info.endOffset < startOffset || info.startOffset > endOffset) continue;
                    ++i;
                    if (!firstMethod) {
                        styleModel.addLineBreak();
                    }
                    firstMethod = false;
                    styleModel.append(info.model);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    return null;
                }
            }
            if (firstMethod) {
                return null;
            }
            this.label.setStyleModel(styleModel);
            return this.label;
        }
    }
}

