/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.javatools.util.MultiMap;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.JavaParserPlugin;
import oracle.jdevimpl.java.editing.ImplOverCache;
import oracle.jdevimpl.java.editing.NavigationEntry;

public final class JavaImplOverPlugin2
implements EditorPlugin,
JavaParserPlugin.HelperClient,
GutterColumnListener,
ActiveViewListener {
    private static final String PLUGIN_KEY = JavaImplOverPlugin2.class.getName();
    public static final String COLUMN_NAME = "implements-overrides-column2";
    private BasicEditorPane editor;
    private GutterColumn column;
    private UpdaterTask updTask = null;
    private ImplOverCache _cache = null;
    private static AsyncScheduler updScheduler = new AsyncScheduler("ImplementsOverrideGutterUpdater", 30000);
    private static final int NAVIGATE_HIERARCHY_CMD_ID = Ide.findOrCreateCmdID((String)"JavaImplOverPlugin2.NAVIGATE_HIERARCHY_CMD_ID");

    @Override
    public void notifyCompileScheduled() {
        this.cancelUpdater();
    }

    @Override
    public void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
    }

    @Override
    public void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int changeId, int elapsedDelay) {
        this.scheduleUpdater(javaManager, sourceFile);
    }

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        editor.putProperty(PLUGIN_KEY, (Object)this);
        CodeEditorGutter gutter = CodeEditor.getCodeEditor((BasicEditorPane)editor).getGutter();
        this.column = gutter.createGutterColumn(COLUMN_NAME, (GutterColumnListener)this);
        Icon icon1 = JavaArb.getIcon(31);
        Icon icon2 = JavaArb.getIcon(32);
        Icon icon3 = JavaArb.getIcon(33);
        int width = Math.max(icon1.getIconWidth(), Math.max(icon2.getIconWidth(), icon3.getIconWidth()));
        this.column.setReservedWidth(width);
        this.column.setLayoutConstraint("breakpoint", 1);
        JavaParserPlugin.attachHelperClient(editor, this);
        IdeMainWindow mainWindow = Ide.getMainWindow();
        if (mainWindow != null) {
            mainWindow.addActiveViewListener((ActiveViewListener)this);
        }
    }

    public void deinstall(BasicEditorPane editor) {
        this.cancelUpdater();
        JavaParserPlugin.detachHelperClient(editor, this);
        CodeEditorGutter gutter = CodeEditor.getCodeEditor((BasicEditorPane)editor).getGutter();
        if (gutter != null) {
            gutter.removeGutterColumn(this.column);
        }
        this.column = null;
        editor.putProperty(PLUGIN_KEY, null);
        this.editor = null;
        IdeMainWindow mainWindow = Ide.getMainWindow();
        if (mainWindow != null) {
            mainWindow.removeActiveViewListener((ActiveViewListener)this);
        }
    }

    private void clearGutterColumns() {
        if (this.column != null) {
            this.column.removeAllGutterMarks();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdater(JavaManager javaManager, SourceFile sourceFile) {
        UpdaterTask task = new UpdaterTask(javaManager, sourceFile);
        JavaImplOverPlugin2 javaImplOverPlugin2 = this;
        synchronized (javaImplOverPlugin2) {
            if (this.updTask != null) {
                updScheduler.cancelTask((AsyncTask)this.updTask);
            }
            this.updTask = task;
        }
        updScheduler.scheduleTask((AsyncTask)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelUpdater() {
        UpdaterTask pendingTask;
        JavaImplOverPlugin2 javaImplOverPlugin2 = this;
        synchronized (javaImplOverPlugin2) {
            pendingTask = this.updTask;
            this.updTask = null;
        }
        if (pendingTask != null) {
            updScheduler.cancelTask((AsyncTask)pendingTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishUpdater(UpdaterTask task) {
        JavaImplOverPlugin2 javaImplOverPlugin2 = this;
        synchronized (javaImplOverPlugin2) {
            if (this.updTask == task) {
                this.updTask = null;
            }
        }
    }

    private synchronized ImplOverCache getCache(Project project, SourceFile updSourceFile) {
        ImplOverCache ret;
        URL projectUrl = project.getURL();
        URL url = updSourceFile.getURL();
        ImplOverCache cache = this._cache;
        if (cache != null && cache.isCacheFor(projectUrl, url, updSourceFile)) {
            ret = cache;
        } else {
            this._cache = ret = new ImplOverCache(projectUrl, url, updSourceFile);
        }
        return ret;
    }

    private void clearCache() {
        this._cache = null;
    }

    public void activeViewChanged(ActiveViewEvent e) {
        this.clearCache();
    }

    public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
    }

    public void markRemoved(GutterMark gutterMark, int deletedLine) {
    }

    public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
        this._markClicked(gutterMark);
    }

    private void _markClicked(GutterMark gutterMark) {
        List navigationEntries = (List)gutterMark.getUserData();
        if (navigationEntries.size() == 1) {
            NavigationEntry navigationEntry = (NavigationEntry)navigationEntries.get(0);
            navigationEntry.navigate();
        }
    }

    public String getMarkToolTip(GutterMark gutterMark, MouseEvent event) {
        StringBuilder buffer = new StringBuilder("<html>");
        List navigationEntries = (List)gutterMark.getUserData();
        for (int i = 0; i < navigationEntries.size(); ++i) {
            NavigationEntry navigationEntry = (NavigationEntry)navigationEntries.get(i);
            String tooltip = navigationEntry.getTooltip();
            if (i > 0) {
                buffer.append("<br>");
            }
            buffer.append(tooltip);
        }
        return buffer.toString();
    }

    public static MultiMap<Integer, NavigationEntry> testFile(Project project, JavaManager javaManager, SourceFile sourceFile) {
        JavaImplOverPlugin2 plugin;
        MultiMap ret = null;
        JavaImplOverPlugin2 javaImplOverPlugin2 = plugin = new JavaImplOverPlugin2();
        javaImplOverPlugin2.getClass();
        UpdaterTask updaterTask = javaImplOverPlugin2.new UpdaterTask(javaManager, sourceFile);
        try {
            ret = updaterTask.processFile(project, sourceFile);
        }
        catch (AsyncTask.CancelledException e) {
            e.printStackTrace();
        }
        catch (CancellationException e) {
            e.printStackTrace();
        }
        return ret;
    }

    static {
        String commandName = JavaArb.getString(182);
        IdeAction navigateAction = IdeAction.get((int)NAVIGATE_HIERARCHY_CMD_ID, null, (String)commandName, (String)CodeMenuConstants.CATEGORY_CODE_MENU, null, null, null, (boolean)true);
        JavaNavigationController controller = new JavaNavigationController();
        navigateAction.addController((Controller)controller);
        KeyStrokeContextRegistry registry = Ide.getKeyStrokeContextRegistry();
        registry.addAcceleratorDefinitionFile(JavaImplOverPlugin2.class.getClassLoader(), "oracle/jdevimpl/java/editing/accelerators.xml");
    }

    private static final class JavaNavigationController
    implements Controller {
        private JavaNavigationController() {
        }

        public boolean update(IdeAction action, Context context) {
            return action.getCommandId() == NAVIGATE_HIERARCHY_CMD_ID;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            if (!(context.getNode() instanceof JavaSourceNode)) {
                return false;
            }
            int cmdId = action.getCommandId();
            if (cmdId == NAVIGATE_HIERARCHY_CMD_ID) {
                this.navigate(context);
                return true;
            }
            return false;
        }

        private void navigate(Context context) {
            int line;
            CodeEditor editor;
            GutterColumn column;
            GutterMark[] marks;
            View view;
            if (context != null && (view = context.getView()) instanceof CodeEditor && (marks = (column = (editor = (CodeEditor)view).getGutter().lookupGutterColumn(JavaImplOverPlugin2.COLUMN_NAME)).lookupGutterMarks(line = editor.getCaretLine())) != null && marks.length > 0) {
                List navigationEntries = (List)marks[0].getUserData();
                if (navigationEntries.size() == 1) {
                    ((NavigationEntry)navigationEntries.get(0)).navigate();
                } else if (navigationEntries.size() > 1) {
                    MouseEvent eventToUse = new MouseEvent((Component)editor.getGutter(), 1, System.currentTimeMillis(), 0, 0, 0, 1, true, 1);
                    editor.getGutter().showMarkDropdownMenu(eventToUse, marks[0], line);
                }
            }
        }
    }

    private final class UpdaterTask
    extends AsyncTask {
        private boolean updCancelled = false;
        private JavaManager updJavaManager;
        private SourceFile updSourceFile;

        private UpdaterTask(JavaManager javaManager, SourceFile sourceFile) {
            this.updJavaManager = javaManager;
            this.updSourceFile = sourceFile;
        }

        protected void requestCancelImpl() {
            this.updCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.updCancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object runImpl() throws AsyncTask.CancelledException {
            try {
                this.bailIfCancelled();
                Context context = CodeEditor.getContext((BasicEditorPane)JavaImplOverPlugin2.this.editor);
                if (context == null) {
                    Object var2_2 = null;
                    return var2_2;
                }
                Project project = context.getProject();
                if (project == null) {
                    Object var3_4 = null;
                    return var3_4;
                }
                Node node = context.getNode();
                if (node == null) {
                    Object var4_6 = null;
                    return var4_6;
                }
                final MultiMap items = new MultiMap();
                CacheSupport cacheSupport = this.updJavaManager.getCacheSupport();
                try {
                    cacheSupport.beginCacheUse();
                    TextBuffer textBuffer = this.updSourceFile.getTextBuffer();
                    LineMap lineMap = textBuffer.getLineMap();
                    List sourceClasses = SourceElementAsList.asList((SourceElement)this.updSourceFile, (int)3);
                    ImplOverCache cache = JavaImplOverPlugin2.this.getCache(project, this.updSourceFile);
                    for (int i = 0; i < sourceClasses.size(); ++i) {
                        this.bailIfCancelled();
                        SourceClass sourceClass = (SourceClass)sourceClasses.get(i);
                        this.processClass(cache, project, sourceClass, lineMap, (MultiMap<Integer, NavigationEntry>)items);
                    }
                }
                finally {
                    cacheSupport.endCacheUse();
                }
                this.bailIfCancelled();
                Runnable gutterSetter = new Runnable(){

                    @Override
                    public void run() {
                        if (UpdaterTask.this.isCancelledImpl() || JavaImplOverPlugin2.this.column == null) {
                            return;
                        }
                        JavaImplOverPlugin2.this.clearGutterColumns();
                        Set lines = items.keySet();
                        for (Integer line : lines) {
                            Collection navigationEntries = items.get((Object)line);
                            int options = 1;
                            if (navigationEntries.size() > 1) {
                                options |= 0x10000;
                            }
                            boolean goesUp = false;
                            boolean goesDown = false;
                            for (NavigationEntry navigationEntry : navigationEntries) {
                                switch (navigationEntry.getNavigationType()) {
                                    case EXTENDING_CLASS: 
                                    case OVERRIDDEN_METHOD: {
                                        goesDown = true;
                                        break;
                                    }
                                    case EXTENDS_CLASS: 
                                    case OVERRIDES_METHOD: {
                                        goesUp = true;
                                    }
                                }
                            }
                            int iconId = goesUp ? (goesDown ? 33 : 31) : 32;
                            Icon icon = JavaArb.getIcon(iconId);
                            GutterMark mark = JavaImplOverPlugin2.this.column.addGutterMark(line + 1, icon, null, 3000, options);
                            if (mark == null) continue;
                            mark.setUserData((Object)navigationEntries);
                        }
                    }
                };
                SwingUtilities.invokeLater(gutterSetter);
                Object var7_10 = null;
                return var7_10;
            }
            finally {
                JavaImplOverPlugin2.this.finishUpdater(this);
                this.updSourceFile = null;
            }
        }

        private void processClass(ImplOverCache cache, Project project, SourceClass sourceClass, LineMap lineMap, MultiMap<Integer, NavigationEntry> items) throws AsyncTask.CancelledException {
            boolean isInterface = sourceClass.isInterface();
            Collection declaredMethods = sourceClass.getDeclaredMethods();
            ArrayList<JavaMethod> overridingMethods = new ArrayList<JavaMethod>();
            Iterator itDeclaredMethods = declaredMethods.iterator();
            while (itDeclaredMethods.hasNext()) {
                this.bailIfCancelled();
                JavaMethod javaMethod = (JavaMethod)itDeclaredMethods.next();
                if (javaMethod.isPrivate() || javaMethod.isStatic()) continue;
                overridingMethods.add(javaMethod);
            }
            List<List<JavaMethod>> overriddenMethods = cache.getSuperMethods(this.updJavaManager, (JavaClass)sourceClass, overridingMethods);
            for (int overridingMethodIndex = 0; overridingMethodIndex < overridingMethods.size(); ++overridingMethodIndex) {
                this.bailIfCancelled();
                JavaMethod javaMethod = (JavaMethod)overridingMethods.get(overridingMethodIndex);
                SourceMethod sourceMethod = (SourceMethod)javaMethod.getSourceElement();
                if (sourceMethod == null) continue;
                SourceName name = sourceMethod.getNameElement();
                int startOffset = name != null ? name.getStartOffset() : sourceMethod.getStartOffset();
                int methodLine = lineMap.getLineFromOffset(startOffset);
                List<JavaMethod> superMethods = overriddenMethods.get(overridingMethodIndex);
                for (int i = 0; i < superMethods.size(); ++i) {
                    JavaMethod superMethod = superMethods.get(i);
                    JavaClass owningClass = superMethod.getOwningClass();
                    String superQualifiedName = owningClass.getQualifiedName();
                    int formatId = owningClass.isInterface() ? 344 : 346;
                    String tooltip = MessageFormat.format(JavaArb.getString(formatId), superQualifiedName);
                    SourceMethod sourceSuperMethod = (SourceMethod)superMethod.getSourceElement();
                    if (sourceSuperMethod == null) continue;
                    NavigationEntry navigationEntry = new NavigationEntry(NavigationEntry.NavigationType.OVERRIDES_METHOD, tooltip, project, (SourceElement)sourceSuperMethod);
                    items.add((Object)methodLine, (Object)navigationEntry);
                }
                List<JavaMethod> subMethods = cache.getSubMethods(project, this.updJavaManager, javaMethod);
                for (int i = 0; i < subMethods.size(); ++i) {
                    JavaMethod subMethod = subMethods.get(i);
                    JavaClass owningClass = subMethod.getOwningClass();
                    SourceElement subSourceMethod = subMethod.getSourceElement();
                    if (subSourceMethod == null) continue;
                    String subQualifiedName = owningClass.getQualifiedName();
                    int formatId = isInterface ? 345 : 347;
                    String tooltip = MessageFormat.format(JavaArb.getString(formatId), subQualifiedName);
                    NavigationEntry navigationEntry = new NavigationEntry(NavigationEntry.NavigationType.OVERRIDDEN_METHOD, tooltip, project, subSourceMethod);
                    items.add((Object)methodLine, (Object)navigationEntry);
                }
            }
            SourceName nameElement = sourceClass.getNameElement();
            int line = -1;
            List<String> subClassNames = cache.getSubClassNames(project, (JavaClass)sourceClass);
            for (String subClassName : subClassNames) {
                this.bailIfCancelled();
                SourceClass subSourceClass = this.updJavaManager.getSourceClass(subClassName);
                if (subSourceClass == null) continue;
                SourceName subNameElement = subSourceClass.getNameElement();
                int formatId = isInterface && !subSourceClass.isInterface() ? 341 : 343;
                String format = JavaArb.getString(formatId);
                String tooltip = MessageFormat.format(format, subSourceClass.getQualifiedName());
                NavigationEntry navigationEntry = new NavigationEntry(NavigationEntry.NavigationType.EXTENDING_CLASS, tooltip, project, (SourceElement)subNameElement);
                if (line == -1) {
                    int startOffset = nameElement == null ? sourceClass.getStartOffset() : nameElement.getStartOffset();
                    line = lineMap.getLineFromOffset(startOffset);
                }
                items.add((Object)line, (Object)navigationEntry);
            }
            List<String> superClassNames = cache.getSuperClassNames(this.updJavaManager, (JavaClass)sourceClass);
            for (String superClassName : superClassNames) {
                SourceClass superSourceClass;
                if ("java.lang.Object".equals(superClassName) && (!sourceClass.isAnonymous() || superClassNames.size() != 1) || (superSourceClass = this.updJavaManager.getSourceClass(superClassName)) == null) continue;
                SourceName superNameElement = superSourceClass.getNameElement();
                int formatId = superSourceClass.isInterface() ? 340 : 342;
                String format = JavaArb.getString(formatId);
                String tooltip = MessageFormat.format(format, superSourceClass.getQualifiedName());
                NavigationEntry navigationEntry = new NavigationEntry(NavigationEntry.NavigationType.EXTENDS_CLASS, tooltip, project, (SourceElement)superNameElement);
                if (line == -1) {
                    int startOffset = nameElement == null ? sourceClass.getStartOffset() : nameElement.getStartOffset();
                    line = lineMap.getLineFromOffset(startOffset);
                }
                items.add((Object)line, (Object)navigationEntry);
            }
        }

        private MultiMap<Integer, NavigationEntry> processFile(Project project, SourceFile sourceFile) throws AsyncTask.CancelledException {
            List sourceClasses = SourceElementAsList.asList((SourceElement)sourceFile, (int)3);
            ImplOverCache cache = JavaImplOverPlugin2.this.getCache(project, this.updSourceFile);
            TextBuffer textBuffer = sourceFile.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            MultiMap entries = new MultiMap();
            for (SourceClass sourceClass : sourceClasses) {
                this.bailIfCancelled();
                this.processClass(cache, project, sourceClass, lineMap, (MultiMap<Integer, NavigationEntry>)entries);
            }
            return entries;
        }
    }
}

