/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.util.MultiMap;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.util.SourceElementAsList;

class ImplOverCache {
    private final URL _cachedForProject;
    private final URL _cachedForUrl;
    private final int _fileHash;
    private final MultiMap<String, String> _superHierachy = new MultiMap();
    private final MultiMap<String, String> _subHierachy = new MultiMap();
    private final MultiMap<String, String[]> _superMethods = new MultiMap();
    private final MultiMap<String, String> _subMethods = new MultiMap();

    public ImplOverCache(URL cacheForProject, URL cacheForUrl, SourceFile sourceFile) {
        this._cachedForProject = cacheForProject;
        this._cachedForUrl = cacheForUrl;
        this._fileHash = ImplOverCache.getHash((SourceElement)sourceFile);
    }

    public boolean isCacheFor(URL cacheForProject, URL cacheForUrl, SourceFile sourceFile) {
        return URLFileSystem.equals((URL)cacheForUrl, (URL)this._cachedForUrl) && URLFileSystem.equals((URL)cacheForProject, (URL)this._cachedForProject) && this._fileHash == ImplOverCache.getHash((SourceElement)sourceFile);
    }

    private static int getHash(SourceElement sourceElement) {
        switch (sourceElement.getSymbolKind()) {
            case 14: 
            case 21: {
                SourceHasName sourceHasName = (SourceHasName)sourceElement;
                String name = sourceHasName.getName();
                return name.hashCode();
            }
            case 3: {
                SourceClass sourceClass = (SourceClass)sourceElement;
                String className = sourceClass.getName();
                int hash = className.hashCode();
                hash = 31 * hash + sourceClass.getModifiers();
                SourceTypeReference sourceSuperclass = sourceClass.getSourceSuperclass();
                if (sourceSuperclass != null) {
                    String superName = sourceSuperclass.getName();
                    hash = 31 * hash + superName.hashCode();
                }
                List interfaces = sourceClass.getSourceInterfaces();
                for (int i = 0; i < interfaces.size(); ++i) {
                    SourceTypeReference sourceTypeReference = (SourceTypeReference)interfaces.get(i);
                    String name = sourceTypeReference.getName();
                    hash = 31 * hash + name.hashCode();
                }
                SourceClassBody sourceBody = sourceClass.getSourceBody();
                if (sourceBody != null) {
                    hash = 31 * hash + ImplOverCache.getHash((SourceElement)sourceBody);
                }
                return hash;
            }
            case 19: {
                SourceMethod sourceMethod = (SourceMethod)sourceElement;
                String methodName = sourceMethod.getName();
                int hash = methodName.hashCode();
                hash = 31 * hash + sourceMethod.getModifiers();
                List sourceParameters = sourceMethod.getSourceParameters();
                for (int i = 0; i < sourceParameters.size(); ++i) {
                    SourceVariable sourceVariable = (SourceVariable)sourceParameters.get(i);
                    String text = sourceVariable.getText();
                    hash = hash * 31 + text.hashCode();
                }
                return hash;
            }
        }
        int signature = 0;
        List children = sourceElement.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            SourceElement childElement = (SourceElement)children.get(i);
            int classHash = ImplOverCache.getHash(childElement);
            if (classHash == 0) continue;
            signature = signature * 31 + classHash;
        }
        return signature;
    }

    private ArrayList<JavaMethod> superIdentifiersToMethods(JavaManager javaManager, List<String[]> identifiers) {
        ArrayList<JavaMethod> ret = new ArrayList<JavaMethod>(identifiers.size());
        block0: for (int i = 0; i < identifiers.size(); ++i) {
            String[] idents = identifiers.get(i);
            JavaElement javaElement = CommonUtilities.locateByUniqueIdentifier((String)idents[0], (JavaProvider)javaManager);
            if (!(javaElement instanceof JavaClass)) continue;
            Collection methods = ((JavaClass)javaElement).getMethods(idents[1]);
            for (JavaMethod superMethod : methods) {
                if (!this.getTypeErasedUniqueIdentifier(superMethod.getUniqueIdentifier()).equals(idents[2])) continue;
                ret.add(superMethod);
                continue block0;
            }
        }
        return ret;
    }

    private ArrayList<JavaMethod> subIdentifiersToMethods(JavaManager javaManager, List<String> identifiers) {
        ArrayList<JavaMethod> ret = new ArrayList<JavaMethod>(identifiers.size());
        for (int i = 0; i < identifiers.size(); ++i) {
            String identifier = identifiers.get(i);
            JavaElement javaElement = CommonUtilities.locateByUniqueIdentifier((String)identifier, (JavaProvider)javaManager);
            if (!(javaElement instanceof JavaMethod)) continue;
            ret.add((JavaMethod)javaElement);
        }
        return ret;
    }

    public List<String> getSuperClassNames(JavaManager javaManager, String qualifiedName) {
        JavaClass javaClass = javaManager.getClass(qualifiedName);
        if (javaClass != null) {
            return this.getSuperClassNames(javaManager, javaClass);
        }
        return Collections.emptyList();
    }

    public List<String> getSuperClassNames(JavaManager javaManager, JavaClass javaClass) {
        ArrayList<String> ret = Collections.emptyList();
        String uniqueIdentifier = javaClass.toString();
        ArrayList<String> superHierarchy = (ArrayList<String>)this._superHierachy.get((Object)uniqueIdentifier);
        if (superHierarchy == null) {
            JavaClass superTypeErasure;
            JavaType superclass = javaClass.getSuperclass();
            Collection interfaces = javaClass.getInterfaces();
            ret = new ArrayList<String>(1 + interfaces.size());
            if (superclass != null && (superTypeErasure = superclass.getTypeErasure()) != null) {
                String superQualifiedName = superTypeErasure.getQualifiedName();
                ret.add(superQualifiedName);
            }
            for (JavaType interfaceType : interfaces) {
                JavaClass erasedInterface = interfaceType.getTypeErasure();
                String superQualifiedName = erasedInterface.getQualifiedName();
                ret.add(superQualifiedName);
            }
            this._superHierachy.put((Object)uniqueIdentifier, ret);
        } else {
            ret = superHierarchy;
        }
        return Collections.unmodifiableList(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSubClassNames(Project project, JavaClass javaClass) {
        JavaClass typeErasure;
        String thisQualifiedName;
        ArrayList<String> ret = Collections.emptyList();
        if (javaClass != null && (thisQualifiedName = (typeErasure = javaClass.getTypeErasure()).getQualifiedName()) != null) {
            ArrayList<String> subHierachy = (ArrayList<String>)this._subHierachy.get((Object)thisQualifiedName);
            if (subHierachy == null) {
                String thisName = typeErasure.getName();
                if (thisName != null) {
                    IndexManager manager = IndexManager.getIndexManager();
                    Index index = manager.getIndex(project);
                    try {
                        QueryCriteria criteria = new QueryCriteria();
                        criteria.put((Object)"java.extends.or.implements", (Object)thisName);
                        try {
                            URL[] results = (URL[])index.query(criteria).get();
                            ret = new ArrayList<String>();
                            if (results.length > 0) {
                                JavaManager javaManager = JavaManager.getInstance((Project)project);
                                boolean isInterface = javaClass.isInterface();
                                for (int i = 0; i < results.length; ++i) {
                                    URL result = results[i];
                                    SourceFile sourceFile = javaManager.getSourceFile(result);
                                    List sourceClasses = SourceElementAsList.asList((SourceElement)sourceFile, (int)3);
                                    for (int j = 0; j < sourceClasses.size(); ++j) {
                                        String qualifiedName;
                                        JavaClass erasedSubType;
                                        JavaType resolvedType;
                                        String superClassName;
                                        SourceClass sourceClass = (SourceClass)sourceClasses.get(j);
                                        if (isInterface) {
                                            List sourceInterfaces = sourceClass.getSourceInterfaces();
                                            for (int k = 0; k < sourceInterfaces.size(); ++k) {
                                                String qualifiedName2;
                                                JavaClass erasedSuperType;
                                                JavaType resolvedType2;
                                                SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceInterfaces.get(k);
                                                String superInterfaceName = sourceTypeReference.getName();
                                                if (superInterfaceName == null || !superInterfaceName.endsWith(thisName) || (resolvedType2 = sourceTypeReference.getResolvedType()) == null || !(erasedSuperType = resolvedType2.getTypeErasure()).equals(typeErasure) || (qualifiedName2 = sourceClass.getTypeErasure().getQualifiedName()) == null) continue;
                                                ret.add(qualifiedName2);
                                            }
                                            continue;
                                        }
                                        SourceTypeReference sourceTypeReference = sourceClass.getSourceSuperclass();
                                        if (sourceTypeReference == null || (superClassName = sourceTypeReference.getName()) == null || !superClassName.endsWith(thisName) || (resolvedType = sourceTypeReference.getResolvedType()) == null || !(erasedSubType = resolvedType.getTypeErasure()).equals(typeErasure) || (qualifiedName = sourceClass.getTypeErasure().getQualifiedName()) == null) continue;
                                        ret.add(qualifiedName);
                                    }
                                }
                            }
                            this._subHierachy.put((Object)thisQualifiedName, ret);
                        }
                        catch (RejectedExecutionException e) {
                        }
                        catch (ExecutionException e) {
                            e.printStackTrace();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    finally {
                        index.release();
                    }
                }
            } else {
                ret = subHierachy;
            }
        }
        return Collections.unmodifiableList(ret);
    }

    private void getMethods(HashSet processed, List<JavaMethod> overridingMethods, List<List<JavaMethod>> overriddenMethods, JavaType typeIn, boolean checkIfErasedType, boolean eraseTypes, boolean addMethods) {
        if (typeIn == null) {
            return;
        }
        if (processed.contains(typeIn)) {
            return;
        }
        processed.add(typeIn);
        if (checkIfErasedType) {
            if (typeIn.hasTypeParameters() && !typeIn.hasActualTypeArguments()) {
                eraseTypes = true;
            } else if (!typeIn.hasTypeParameters()) {
                eraseTypes = false;
            }
        }
        ArrayList<JavaMethod> methodsToOverrideClone = new ArrayList<JavaMethod>(overridingMethods);
        if (addMethods) {
            Object type = eraseTypes ? typeIn.getTypeErasure() : typeIn;
            block0: for (int methodIndex = 0; methodIndex < methodsToOverrideClone.size(); ++methodIndex) {
                JavaMethod overMethod = (JavaMethod)methodsToOverrideClone.get(methodIndex);
                if (overMethod == null) continue;
                List<JavaMethod> currentOverriddenMethods = overriddenMethods.get(methodIndex);
                Collection declaredMethods = type.getDeclaredMethods();
                for (JavaMethod declMethod : declaredMethods) {
                    if (!ImplOverCache.isMatchingMethod(overMethod, declMethod)) continue;
                    if (type.isInterface()) {
                        if (currentOverriddenMethods.size() == 0 || !currentOverriddenMethods.get(0).getOwningClass().isInterface()) {
                            currentOverriddenMethods.add(declMethod);
                        }
                    } else if (currentOverriddenMethods.size() == 0 || currentOverriddenMethods.get(0).getOwningClass().isInterface()) {
                        currentOverriddenMethods.add(0, declMethod);
                    }
                    if (currentOverriddenMethods.size() != 2) continue block0;
                    methodsToOverrideClone.set(methodIndex, null);
                    continue block0;
                }
            }
        }
        Collection interfaces = typeIn.getInterfaces();
        for (JavaType oneInterface : interfaces) {
            this.getMethods(processed, methodsToOverrideClone, overriddenMethods, oneInterface, true, eraseTypes, true);
        }
        JavaType superType = typeIn.getSuperclass();
        this.getMethods(processed, methodsToOverrideClone, overriddenMethods, superType, true, eraseTypes, true);
    }

    public List<List<JavaMethod>> getSuperMethods(JavaManager javaManager, JavaClass owningClass, List<JavaMethod> javaMethods) {
        int size = javaMethods.size();
        ArrayList<List<JavaMethod>> finishedList = new ArrayList<List<JavaMethod>>(size);
        ArrayList<JavaMethod> unFinishedList = new ArrayList<JavaMethod>(size);
        boolean notFinished = false;
        for (JavaMethod javaMethod : javaMethods) {
            String uniqueIdentifier = javaMethod.toString();
            List superIdentifiers = (List)this._superMethods.get((Object)uniqueIdentifier);
            ArrayList ret = new ArrayList();
            if (superIdentifiers == null) {
                unFinishedList.add(javaMethod);
                notFinished = true;
                finishedList.add(new ArrayList(2));
                continue;
            }
            finishedList.add(this.superIdentifiersToMethods(javaManager, superIdentifiers));
            unFinishedList.add(null);
        }
        if (notFinished) {
            HashSet processed = new HashSet();
            this.getMethods(processed, unFinishedList, finishedList, (JavaType)owningClass, false, false, false);
            for (int i = 0; i < unFinishedList.size(); ++i) {
                JavaMethod unfinishedMethod = (JavaMethod)unFinishedList.get(i);
                if (unfinishedMethod == null) continue;
                String uniqueIdentifier = unfinishedMethod.toString();
                List finishedMethods = (List)finishedList.get(i);
                ArrayList<String[]> superIdentifiers = new ArrayList<String[]>(2);
                for (JavaMethod finishedMethod : finishedMethods) {
                    superIdentifiers.add(this.createUniqueIdentifiers(finishedMethod));
                }
                this._superMethods.put((Object)uniqueIdentifier, superIdentifiers);
            }
        }
        return finishedList;
    }

    private String[] createUniqueIdentifiers(JavaMethod method) {
        return new String[]{method.getOwningClass().getUniqueIdentifier(), method.getName(), this.getTypeErasedUniqueIdentifier(method.getUniqueIdentifier())};
    }

    private String getTypeErasedUniqueIdentifier(String uniqueIdentifier) {
        StringBuilder buf = new StringBuilder();
        int genericsDepth = 0;
        for (int pointer = 0; pointer < uniqueIdentifier.length(); ++pointer) {
            char c = uniqueIdentifier.charAt(pointer);
            if (c == '<') {
                ++genericsDepth;
                continue;
            }
            if (c == '>') {
                --genericsDepth;
                continue;
            }
            if (genericsDepth != 0) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public List<JavaMethod> getSuperMethods(JavaManager javaManager, JavaMethod javaMethod) {
        String uniqueIdentifier = javaMethod.toString();
        ArrayList<String[]> superIdentifiers = (ArrayList<String[]>)this._superMethods.get((Object)uniqueIdentifier);
        ArrayList<Object> ret = new ArrayList();
        if (superIdentifiers == null) {
            JavaClass owningClass = javaMethod.getOwningClass();
            HashSet processed = new HashSet();
            ArrayList<JavaMethod> javaMethods = new ArrayList<JavaMethod>(1);
            javaMethods.add(javaMethod);
            ArrayList<List<JavaMethod>> rets = new ArrayList<List<JavaMethod>>(1);
            rets.add(ret);
            this.getMethods(processed, javaMethods, rets, (JavaType)owningClass, false, false, false);
            superIdentifiers = new ArrayList<String[]>(ret.size());
            for (JavaMethod javaMethod2 : ret) {
                superIdentifiers.add(this.createUniqueIdentifiers(javaMethod2));
            }
            this._superMethods.put((Object)uniqueIdentifier, superIdentifiers);
        } else {
            ret = this.superIdentifiersToMethods(javaManager, (List<String[]>)superIdentifiers);
        }
        return Collections.unmodifiableList(ret);
    }

    public List<JavaMethod> getSubMethods(Project project, JavaManager javaManager, JavaMethod javaMethod) {
        ArrayList<Object> ret;
        String uniqueIdentifier = javaMethod.getUniqueIdentifier();
        ArrayList<String> subIdentifiers = (ArrayList<String>)this._subMethods.get((Object)uniqueIdentifier);
        if (subIdentifiers == null) {
            JavaClass owningClass = javaMethod.getOwningClass();
            JavaClass typeErasure = owningClass.getTypeErasure();
            ret = new ArrayList(1);
            this.getSubMethods(project, javaManager, javaMethod, typeErasure, ret);
            subIdentifiers = new ArrayList<String>(ret.size());
            for (int i = 0; i < ret.size(); ++i) {
                JavaMethod method = (JavaMethod)ret.get(i);
                String subUniqueIdentifier = method.getUniqueIdentifier();
                subIdentifiers.add(subUniqueIdentifier);
            }
            this._subMethods.put((Object)uniqueIdentifier, subIdentifiers);
        } else {
            ret = this.subIdentifiersToMethods(javaManager, (List<String>)subIdentifiers);
        }
        return Collections.unmodifiableList(ret);
    }

    private void getSubMethods(Project project, JavaManager javaManager, JavaMethod javaMethod, JavaClass javaClass, List<JavaMethod> subMethods) {
        ArrayList<String> subClassNames = new ArrayList<String>(this.getSubClassNames(project, javaClass));
        while (!subClassNames.isEmpty()) {
            for (int i = subClassNames.size() - 1; i >= 0; --i) {
                String subClassName = (String)subClassNames.get(i);
                JavaClass subJavaClass = javaManager.getClass(subClassName);
                JavaMethod subMethod = this.getSubMethod(javaMethod, subJavaClass);
                if (subMethod == null) continue;
                subMethods.add(subMethod);
                subClassNames.remove(i);
            }
            ArrayList<String> newSubList = new ArrayList<String>(subClassNames.size());
            for (int i = 0; i < subClassNames.size(); ++i) {
                String subClassName = (String)subClassNames.get(i);
                JavaClass subClass = javaManager.getClass(subClassName);
                ArrayList<String> newSubClassNames = new ArrayList<String>(this.getSubClassNames(project, subClass));
                newSubList.addAll(newSubClassNames);
            }
            subClassNames = newSubList;
        }
    }

    private JavaMethod getSubMethod(JavaMethod javaMethod, JavaClass javaClass) {
        String methodName = javaMethod.getName();
        Collection declaredMethods = javaClass.getDeclaredMethods(methodName);
        for (JavaMethod declaredMethod : declaredMethods) {
            if (!ImplOverCache.isMatchingMethod(declaredMethod, javaMethod)) continue;
            return declaredMethod;
        }
        return null;
    }

    private static boolean isMatchingMethod(JavaMethod subMethod, JavaMethod superMethod) {
        return subMethod.hasSubsignatureOf(superMethod) && !superMethod.isFinal() && !subMethod.isPrivate() && !subMethod.isStatic() && !superMethod.isPrivate() && !superMethod.isStatic() && (!subMethod.isPackagePrivate() && !superMethod.isPackagePrivate() || ImplOverCache.packagesMatch(subMethod, superMethod));
    }

    private static boolean packagesMatch(JavaMethod method1, JavaMethod method2) {
        JavaClass class1 = method1.getOwningClass();
        JavaClass class2 = method2.getOwningClass();
        return class1.getPackageName().equals(class2.getPackageName());
    }
}

