/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.checker;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeActivationEvent;
import oracle.ide.IdeActivationListener;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.java.locator.JarURLClassLocator;
import oracle.jdeveloper.java.provider.ProjectFileProvider;

public class JarChangesChecker
implements Controller,
IdeActivationListener {
    private static CheckJarChanges checkJarThread = null;

    public JarChangesChecker() {
        Ide.getMainWindow().addIdeActivationListener((IdeActivationListener)this);
        IdeAction reloadAction = IdeAction.find((int)72);
        if (reloadAction != null) {
            reloadAction.addController((Controller)this);
        }
    }

    public void activated(IdeActivationEvent e) {
        EnvironOptions envOpts = EnvironOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        if (envOpts.getAutoReloadExtMod()) {
            this.checkJarChanges();
        }
    }

    public void deactivated(IdeActivationEvent e) {
    }

    public boolean update(IdeAction action, Context context) {
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (action.getCommandId() == 72) {
            this.checkJarChanges();
        }
        return false;
    }

    private void checkJarChanges() {
        HashSet<Project> openedProjects = new HashSet<Project>();
        Iterator nodeIterator = NodeFactory.getOpenNodes();
        while (nodeIterator.hasNext()) {
            Node node = (Node)nodeIterator.next();
            if (!(node instanceof Project)) continue;
            openedProjects.add((Project)node);
        }
        if (checkJarThread == null && !openedProjects.isEmpty()) {
            checkJarThread = new CheckJarChanges(openedProjects);
            checkJarThread.start();
        }
    }

    private static class CheckJarChanges
    extends Thread {
        private Collection<Project> openedProjects;

        public CheckJarChanges(Collection<Project> list) {
            super("Check Jar Changes");
            this.setPriority(2);
            this.setDaemon(true);
            this.openedProjects = list;
        }

        @Override
        public void run() {
            long lastJarBuiltTime = JarURLClassLocator.getLastBuiltTime();
            if (lastJarBuiltTime > 0L) {
                for (Project project : this.openedProjects) {
                    ProjectFileProvider provider = ProjectFileProvider.getInstance((Project)project);
                    if (provider.lastCacheFlushed() >= lastJarBuiltTime) continue;
                    provider.flushCache();
                }
            }
            this.openedProjects.clear();
            checkJarThread = null;
        }
    }
}

