/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.java.JavaBraceProvider;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.Context2ParserHelper;
import oracle.jdevimpl.java.browse.JavaBrowseContext;

public class JavaBrowseContextImpl
extends Context2ParserHelper
implements JavaBrowseContext {
    private final CodeEditor _editor;
    private final Context _context;
    private TextNode _node;
    private int startOffset;
    private int endOffset;
    private SourceFile _sourceFile;
    private JavaBraceProvider _braceProvider;

    public static JavaBrowseContextImpl createContext(CodeEditor editor) {
        Context context = editor.getContext();
        Node node = context.getNode();
        if (!(node instanceof TextNode)) {
            return null;
        }
        TextNode textNode = (TextNode)node;
        return new JavaBrowseContextImpl(editor, context, textNode);
    }

    public static JavaBrowseContextImpl createContext(Context context, int offset) {
        Node node = context.getNode();
        if (!(node instanceof TextNode)) {
            return null;
        }
        TextNode textNode = (TextNode)node;
        return new JavaBrowseContextImpl(context, textNode, offset);
    }

    protected JavaBrowseContextImpl(CodeEditor editor, Context context, TextNode node) {
        this._editor = editor;
        this._context = context;
        this._node = node;
        this.startOffset = editor.getSelectionStart();
        this.endOffset = editor.getSelectionEnd();
    }

    protected JavaBrowseContextImpl(Context context, TextNode node, int offset) {
        this._editor = null;
        this._context = context;
        this._node = node;
        this.startOffset = offset;
        this.endOffset = offset;
    }

    @Override
    public int getSelectionStart() {
        return this.startOffset;
    }

    @Override
    public int getSelectionEnd() {
        return this.endOffset;
    }

    @Override
    public void setSelection(int start, int end) {
        this.startOffset = start;
        this.endOffset = end;
    }

    @Override
    public CodeEditor getCodeEditor() {
        return this._editor;
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    protected void finalize() {
        this.release();
    }

    @Override
    public void acquire() {
        this.acquireLock();
    }

    @Override
    public void release() {
        this.releaseLock();
    }

    protected JavaBraceProvider getBraceProviderImpl() {
        if (this._editor != null) {
            BasicDocument basicDocument = (BasicDocument)this._editor.getFocusedEditorPane().getDocument();
            LanguageSupport languageSupport = basicDocument.getLanguageSupport();
            return (JavaBraceProvider)languageSupport.getBraceProvider();
        }
        TextBuffer textBuffer = this.getTextBuffer();
        return new JavaBraceProvider(textBuffer);
    }

    @Override
    public final JavaBraceProvider getBraceProvider() {
        if (this._braceProvider == null) {
            this._braceProvider = this.getBraceProviderImpl();
        }
        return this._braceProvider;
    }

    protected SourceFile getSourceFileImpl() {
        SourceFile file = super.getSourceFile();
        if (file != null) {
            return file;
        }
        TextBuffer textBuffer = this.getTextBuffer();
        if (textBuffer == null) {
            return null;
        }
        JavaManager javaManager = this.getJavaManager();
        return javaManager.getSourceFile(textBuffer);
    }

    @Override
    public final SourceFile getSourceFile() {
        if (this._sourceFile == null) {
            this._sourceFile = this.getSourceFileImpl();
        }
        return this._sourceFile;
    }
}

