/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.awt.Point;
import oracle.ide.Context;
import oracle.ide.ceditor.AbstractBrowseClickPlugin;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Node;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.LexerDocumentRenderer;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdevimpl.java.browse.BrowseAddin;
import oracle.jdevimpl.java.browse.BrowseSupport;
import oracle.jdevimpl.java.browse.JavaBrowseSupport2;

public class JavaBrowseClickPlugin
extends AbstractBrowseClickPlugin {
    protected BrowseSupport getBrowseSupport() {
        Node ideNode;
        Context context;
        BrowseSupport support = null;
        BasicEditorPane editor = this.getEditorPane();
        if (editor != null && (context = CodeEditor.getContext((BasicEditorPane)editor)) != null && (ideNode = context.getNode()) != null) {
            support = BrowseAddin.getSupport(ideNode.getClass());
        }
        if (support == null) {
            support = this.getDefaultBrowseSupport();
        }
        return support;
    }

    protected BrowseSupport getDefaultBrowseSupport() {
        return new JavaBrowseSupport2();
    }

    protected void performDeclarationClick(Point point) {
        if (!this.performBraceDeclarationClick(point)) {
            this.performJavaDeclarationClick(point);
        }
    }

    protected boolean performJavaDeclarationClick(Point point) {
        BrowseSupport browseSupport;
        CodeEditor codeEditor;
        BasicEditorPane editor = this.getEditorPane();
        if (editor != null && (codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)editor)) != null && (browseSupport = this.getBrowseSupport()).canBrowseAtCursor(codeEditor)) {
            browseSupport.performBrowseSymbolAtCursor(codeEditor);
            return true;
        }
        return false;
    }

    protected boolean performBraceDeclarationClick(Point point) {
        LanguageSupport languageSupport;
        BraceProvider braceProvider;
        BasicEditorPane editor = this.getEditorPane();
        if (editor == null || this.getDocument() == null) {
            return false;
        }
        int offset = editor.viewToModel(point);
        if (offset >= 0 && (braceProvider = (languageSupport = this.getDocument().getLanguageSupport()).getBraceProvider()) != null) {
            NumberRange braceLocation = new NumberRange(offset, offset);
            NumberRange matchingLocation = new NumberRange(offset, offset);
            int tokenType = braceProvider.isPartOfBrace(offset, braceLocation);
            if (tokenType != -1) {
                braceProvider.findMatchingBrace(tokenType, braceLocation, matchingLocation);
                editor.setCaretPosition(matchingLocation.start);
                return true;
            }
        }
        return false;
    }

    protected NumberRange getIdentifierAtOffset(int offset) {
        NumberRange range = this.getBraceIdentifierAtOffset(offset);
        if (range == null) {
            range = JavaBrowseClickPlugin.getJavaIdentifierAtOffset(this.getEditorPane(), offset);
        }
        return range;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NumberRange getJavaIdentifierAtOffset(BasicEditorPane editor, int offset) {
        BasicDocument document = (BasicDocument)editor.getDocument();
        TextBuffer textBuffer = document.getTextBuffer();
        textBuffer.readLock();
        try {
            JavaLexer lexer = new JavaLexer();
            lexer.setSkipComments(true);
            lexer.setRecognizeSQLJ(true);
            LexerToken lexerToken = lexer.createLexerToken();
            LexerDocumentRenderer renderer = (LexerDocumentRenderer)document.getDocumentRenderer();
            LexerDocumentRenderer.LexerOffsetsCache cache = renderer.getOffsetsCache();
            int searchOffset = cache.findClosestOffset((Lexer)lexer, lexerToken, offset);
            lexer.setTextBuffer((ReadTextBuffer)textBuffer);
            lexer.setPosition(searchOffset);
            int currentOffset = searchOffset;
            int bufferEnd = textBuffer.getLength();
            while (currentOffset < bufferEnd) {
                int token = lexer.lex(lexerToken);
                if (token == 0) {
                } else {
                    int tokenStart = lexerToken.getStartOffset();
                    int tokenEnd = lexerToken.getEndOffset();
                    if (tokenStart <= offset && offset < tokenEnd) {
                        if (token == 4 || token == 136 || token == 133) {
                            NumberRange numberRange = new NumberRange(tokenStart, tokenEnd);
                            return numberRange;
                        }
                    } else if (offset >= tokenStart) continue;
                }
                break;
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return null;
    }

    protected NumberRange getBraceIdentifierAtOffset(int offset) {
        BasicEditorPane editor = this.getEditorPane();
        if (editor == null || this.getDocument() == null) {
            return null;
        }
        LanguageSupport languageSupport = this.getDocument().getLanguageSupport();
        BraceProvider braceProvider = languageSupport.getBraceProvider();
        if (braceProvider != null) {
            int tokenType;
            NumberRange braceLocation = new NumberRange(offset, offset);
            if (offset < editor.getDocument().getLength() && (tokenType = braceProvider.isPartOfBrace(offset, braceLocation)) != -1) {
                return braceLocation;
            }
        }
        return null;
    }
}

