/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.ide.model.Project;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.ui.search.SearchFieldBorder;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdevimpl.java.JavaArb;

class BrowseSymbolPanel
extends JPanel
implements ActionListener,
ClassPackageBrowserFilterV2 {
    private Project project;
    private JTextField field_browse;
    private JButton button_browse;
    private ActionListener browseAction;

    BrowseSymbolPanel(Project project, ActionListener browseAction) {
        this.project = project;
        this.browseAction = browseAction;
        this.initializeUI();
    }

    private void initializeUI() {
        PlainDocument browseDocument = new PlainDocument(){

            @Override
            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                String modStr = str.replace('/', '.').replace('\\', '.');
                super.insertString(offs, modStr, a);
            }
        };
        this.field_browse = new JTextField(browseDocument, "", 25);
        String buttonText = JavaArb.getString(10);
        this.button_browse = new JButton();
        ResourceUtils.resButton((AbstractButton)this.button_browse, (String)buttonText);
        this.button_browse.addActionListener(this);
        JPanel searchBorderPanel = new JPanel(new BorderLayout());
        SearchFieldBorder fieldBorder = new SearchFieldBorder();
        searchBorderPanel.setBorder((Border)fieldBorder);
        fieldBorder.setForeground(UIConstants.getColor((String)"ghost.panel.shadow", (UIConstants.Look)UIConstants.Look.DARK));
        this.field_browse.setBorder(null);
        searchBorderPanel.add(this.field_browse);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(searchBorderPanel);
        this.add(Box.createHorizontalStrut(5));
        this.add((Component)this.button_browse, "After");
    }

    String getBrowseText() {
        return this.field_browse.getText();
    }

    private void setBrowseText(String browseText) {
        this.field_browse.setText(browseText);
        this.selectBrowseText();
    }

    void selectBrowseText() {
        this.field_browse.selectAll();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String startText = this.getBrowseText();
        String[] result = ClassPackageBrowserV2.browseClassOrPackage((Component)this.button_browse, this.project, 3, false, this, startText);
        if (result != null && result.length > 0) {
            this.browseAction.actionPerformed(new ActionEvent(this, 1001, result[0]));
        }
    }

    @Override
    public boolean acceptPackage(String pkg) {
        return true;
    }

    @Override
    public boolean acceptClass(JavaClass cls) {
        return cls.isSourceElement() || cls.getSourceElement() != null || cls.getSourceElement() == null && cls.getName().indexOf(36) == -1;
    }

    JTextField getTextField() {
        return this.field_browse;
    }
}

