/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.jdeveloper.dialogs.BrowseHandler2;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.browse.BrowseSymbolPanel;

final class BrowseSymbolDialog {
    private BrowseSymbolPanel panel;
    private GhostPalette ghostPalette;
    private BrowseHandler2 browseHandler;

    private BrowseSymbolDialog(final Context context, final boolean gotoSource) {
        final Project project = context.getProject() != null ? context.getProject() : Ide.getDefaultProject();
        try {
            ActionListener browseAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    BrowseSymbolDialog.this.doit(context, project, gotoSource, event.getActionCommand());
                }
            };
            this.panel = new BrowseSymbolPanel(project, browseAction);
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.panel, "f1_idedbrowsesymbol_html");
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            this.browseHandler = BrowseHandler2.createClassPackageBrowserPopup(javaManager, this.panel.getTextField(), browseAction);
            this.ghostPalette = new GhostPalette((JComponent)Ide.getMainWindow().getContentPane());
            String title = gotoSource ? JavaArb.getString(3) : JavaArb.getString(2);
            this.ghostPalette.setTitle(title);
            this.ghostPalette.add((Component)this.panel);
            this.ghostPalette.setResizable(false);
            this.ghostPalette.pack();
            this.ghostPalette.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    BrowseSymbolDialog.this.browseHandler.dispose();
                    BrowseSymbolDialog.this.ghostPalette.removeAncestorListener((AncestorListener)this);
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }
            });
            this.ghostPalette.show(Ide.getMainWindow().getLayeredPane(), true, true);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    static void showDialog(Context context, boolean gotoSource) {
        new BrowseSymbolDialog(context, gotoSource);
    }

    void doit(Context context, Project project, boolean gotoSource, String className) {
        this.ghostPalette.hidePanel();
        if (className == null) {
            className = this.panel.getBrowseText();
        }
        if (!gotoSource) {
            if (className.length() > 0) {
                BrowseSymbolDialog.performBrowse(project, className);
            }
        } else {
            HelpInfo helpInfo = new HelpInfo(className, 1);
            helpInfo.setContext(context);
            HelpSystem.getHelpSystem().showHelp(helpInfo);
        }
    }

    private static boolean performBrowse(Project project, String symbol) {
        boolean result = false;
        URL url = BrowseSymbolDialog.findSymbol(project, symbol);
        if (url != null) {
            try {
                Node node = NodeFactory.findOrCreate((URL)url);
                final Context newContext = Context.newIdeContext((Node)node);
                Project definingProject = JavaManager.getDefiningProject((Context)newContext, (URL)url);
                if (definingProject != null) {
                    newContext.setProject(definingProject);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EditorManager editorManager = EditorManager.getEditorManager();
                        OpenEditorOptions openEditorOptions = new OpenEditorOptions(newContext);
                        openEditorOptions.setFlags(8, true);
                        editorManager.openEditor(openEditorOptions);
                    }
                });
                result = true;
            }
            catch (Exception e) {
                BrowseSymbolDialog.showUnableToOpenError(symbol);
            }
        } else {
            BrowseSymbolDialog.showNotFoundError(symbol);
        }
        return result;
    }

    private static void showUnableToOpenError(String symbol) {
        String message = JavaArb.format(5, symbol);
        BrowseSymbolDialog.showErrorDialog(message);
    }

    private static void showNotFoundError(String symbol) {
        String message = JavaArb.format(6, symbol);
        BrowseSymbolDialog.showErrorDialog(message);
    }

    static void showErrorDialog(String message) {
        String title = JavaArb.getString(4);
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)message, (String)title, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static URL findSymbol(Project project, String symbol) {
        URL outURL = null;
        if (project != null) {
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            CacheSupport cacheSupport = javaManager.getCacheSupport();
            cacheSupport.beginCacheUse();
            try {
                SourceClass sourceClass = javaManager.getSourceClass(symbol);
                if (sourceClass != null) {
                    URL sourceURL;
                    URL uRL = sourceURL = sourceClass.getURL();
                    return uRL;
                }
                JavaClass javaClass = javaManager.getClass(symbol);
                if (javaClass != null) {
                    URL javaURL;
                    URL uRL = javaURL = javaClass.getURL();
                    return uRL;
                }
            }
            finally {
                cacheSupport.endCacheUse();
            }
        }
        return outURL;
    }
}

