/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.jar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.editor.EditorManager;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarIndexEntry;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.util.SwingWorker;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.jdeveloper.resource.ViewersArb;
import oracle.jdevimpl.jar.JarFileTableModel;
import oracle.jdevimpl.jar.JarNode;

class JarViewerContentPanel
extends JPanel {
    private final JLabel _lblHeader = new JLabel();
    private final JarFileTableModel _model = new JarFileTableModel();
    private final NiceTable _table = new NiceTable((TableModel)this._model);
    private final JScrollPane _spTable = new JScrollPane((Component)this._table);
    private JarNode _jarNode = null;
    private static final NumberFormat TWO_DP_FORMAT = NumberFormat.getInstance();

    JarViewerContentPanel() {
        this._lblHeader.setHorizontalAlignment(0);
        this._lblHeader.setText(ViewersArb.getString((int)2));
        this._spTable.setBorder(null);
        this._table.setAutoResizeMode(0);
        this._table.setDefaultRenderer(Date.class, (TableCellRenderer)((Object)new DateRenderer()));
        this._table.setDefaultRenderer(Integer.class, (TableCellRenderer)((Object)new SizeRenderer()));
        this._table.setSorted(true);
        this._table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    URL jarFileURL = URLFactory.newFileURL((File)JarViewerContentPanel.this._jarNode.getFile());
                    String entryName = (String)JarViewerContentPanel.this._table.getModel().getValueAt(JarViewerContentPanel.this._table.getSelectedRow(), 0);
                    URL url = URLFactory.newJarURL((URL)jarFileURL, (String)entryName);
                    EditorManager.getEditorManager().openDefaultEditorInFrame(url);
                    e.consume();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this._lblHeader, "Center");
    }

    void setNode(JarNode jarNode) {
        if (this._jarNode != jarNode) {
            if (this._jarNode != null) {
                JarUtil.releaseJarIndex((URL)this._jarNode.getURL());
            }
            this._jarNode = jarNode;
            this.updateTable();
        }
    }

    private void updateTable() {
        final JarNode jarNode = this._jarNode;
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                return this.getTableData(jarNode);
            }

            public void finished() {
                JarViewerContentPanel panel = JarViewerContentPanel.this;
                ArrayList rows = (ArrayList)this.get();
                JarViewerContentPanel.this._model.setData(rows);
                JarViewerContentPanel.this._spTable.setSize(panel.getSize());
                JarViewerContentPanel.this._table.autoSizeColumnsToFit();
                JarViewerContentPanel.this.remove(JarViewerContentPanel.this._lblHeader);
                JarViewerContentPanel.this.add((Component)JarViewerContentPanel.this._spTable, "Center");
            }

            private ArrayList getTableData(JarNode jarNode2) {
                try {
                    final ArrayList rows = new ArrayList();
                    URL jarFileURL = URLFactory.newFileURL((File)jarNode2.getFile());
                    JarIndex jarIndex = JarUtil.getJarIndex((URL)jarFileURL);
                    jarIndex.visit(new JarIndex.Visitor(){

                        public boolean visit(JarIndexEntry entry) {
                            String entryName = entry.getName();
                            if (!entryName.endsWith("/")) {
                                ArrayList<Object> row = new ArrayList<Object>();
                                row.add(entryName);
                                row.add(entry.getTime());
                                row.add(new Integer(entry.getSize()));
                                row.add(new Integer(entry.getCompressedSize()));
                                rows.add(row);
                            }
                            return true;
                        }
                    });
                    return rows;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
        };
        worker.start();
    }

    private static String getDisplaySize(long bytes) {
        StringBuffer buffer = new StringBuffer();
        if (bytes < 1024L) {
            buffer.append(TWO_DP_FORMAT.format(bytes));
            buffer.append(" bytes");
        } else if (bytes >= 1024L && bytes < 0x100000L) {
            buffer.append(TWO_DP_FORMAT.format((double)bytes / 1024.0));
            buffer.append(" KB");
        } else if (bytes >= 0x100000L && bytes < 0x40000000L) {
            buffer.append(TWO_DP_FORMAT.format((double)bytes / 1048567.0));
            buffer.append(" MB");
        } else {
            buffer.append(TWO_DP_FORMAT.format((double)bytes / 1.073741824E9));
            buffer.append(" GB");
        }
        return buffer.toString();
    }

    static {
        TWO_DP_FORMAT.setMaximumFractionDigits(2);
        TWO_DP_FORMAT.setMinimumFractionDigits(2);
        TWO_DP_FORMAT.setParseIntegerOnly(false);
    }

    private class DateRenderer
    extends NiceTableCellRenderer {
        final SimpleDateFormat _sdf = new SimpleDateFormat();

        private DateRenderer() {
        }

        public Component getTableCellRendererComponent(JTable t, Object value, boolean selected, boolean focus, int column, int row) {
            Component c = super.getTableCellRendererComponent(t, value, selected, focus, column, row);
            if (value != null) {
                this.setText(this._sdf.format((Date)value));
            }
            return c;
        }
    }

    private class SizeRenderer
    extends NiceTableCellRenderer {
        NumberFormat _defaultFormat = NumberFormat.getInstance();

        private SizeRenderer() {
        }

        public Component getTableCellRendererComponent(JTable t, Object value, boolean selected, boolean focus, int column, int row) {
            Component c = super.getTableCellRendererComponent(t, value, selected, focus, column, row);
            int i = (Integer)value;
            if (i < 1024) {
                this.setText(this._defaultFormat.format(i));
            } else {
                this.setText(JarViewerContentPanel.getDisplaySize(((Integer)value).intValue()));
            }
            return c;
        }
    }
}

