/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.logging;

import java.awt.Window;
import java.io.File;
import java.net.URL;
import java.util.logging.ConsoleHandler;
import java.util.logging.LogRecord;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.log.Href;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.webbrowser.BrowserRunner;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdevimpl.deploy.logging.DeployLogPageFormatter;

public class DeployLogPageHandler
extends ConsoleHandler {
    protected LogPage logPage_ = null;

    private boolean isURLParameter(LogRecord record) {
        Object[] parameters = record.getParameters();
        return parameters != null && parameters.length == 1 && parameters[0] instanceof URL;
    }

    private void logMessage(Object message, LogPage logPage) {
        this.logMessage(new Object[]{message}, logPage);
    }

    private void logMessage(final Object[] message, final LogPage logPage) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LogPage logPage2 = logPage;
                synchronized (logPage2) {
                    for (Object messagePart : message) {
                        logPage.log(messagePart);
                    }
                }
            }
        });
    }

    private void publishURLParmRecord(LogRecord record, LogPage logPage) {
        File module;
        URL moduleURL = (URL)record.getParameters()[0];
        String protocol = moduleURL.getProtocol();
        Href moduleHref = protocol.equals("file") ? ((module = new File(moduleURL.getPath())).isDirectory() ? DeployLogPageHandler.toBrowserHref(module.getPath(), moduleURL) : DeployLogPageHandler.toCodeEditorHref(module.getPath(), moduleURL)) : DeployLogPageHandler.toBrowserHref(moduleURL.toString(), moduleURL);
        String prefix = record.getMessage();
        String suffix = "";
        if (prefix != null) {
            int parmPos = prefix.indexOf("{0}");
            if (parmPos != -1) {
                prefix = prefix.substring(0, parmPos);
                if (record.getMessage().length() > parmPos + 3) {
                    suffix = record.getMessage().substring(parmPos + 3);
                }
            }
            Object[] logMessages = new Object[]{((DeployLogPageFormatter)this.getFormatter()).getFormattedString(new LogRecord(record.getLevel(), prefix)), moduleHref, suffix + "\n"};
            this.logMessage(logMessages, logPage);
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        LogPage logPage = this.getLogPage();
        if (this.isURLParameter(record)) {
            this.publishURLParmRecord(record, logPage);
        } else {
            this.logMessage(((DeployLogPageFormatter)this.getFormatter()).getFormattedLine(record), logPage);
        }
    }

    static Href toCodeEditorHref(String text, final URL url) {
        return new Href(text, url){

            public void go() {
                try {
                    Node node = NodeFactory.findOrCreate((URL)url);
                    Context context = Context.newIdeContext((Node)node);
                    context.setWorkspace(Ide.getActiveWorkspace());
                    context.setProject(Ide.getActiveProject());
                    EditorManager editorManager = EditorManager.getEditorManager();
                    editorManager.openEditor(new OpenEditorOptions(context, CodeEditor.class));
                }
                catch (Exception ex) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ex);
                }
            }
        };
    }

    static Href toBrowserHref(String text, final URL url) {
        return new Href(text, url){

            public void go() {
                try {
                    BrowserRunner browserRunner = BrowserRunner.getBrowserRunner();
                    browserRunner.runBrowserOnURL(url, null, null);
                }
                catch (Exception ex) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ex);
                }
            }
        };
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    protected synchronized LogPage getLogPage() {
        if (this.logPage_ == null) {
            this.logPage_ = Deployment.getLogPage();
        }
        return this.logPage_;
    }
}

