/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.fwk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.jdeveloper.deploy.DeployEvent;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployerListener;
import oracle.jdeveloper.deploy.ListenerCondition;

public class ListenerSupport {
    private final List<ListenerHolder> allListeners_ = Collections.synchronizedList(new ArrayList());

    void addListener(ListenerCondition condition, DeployerListener listener, double priority) {
        this.allListeners_.add(new ListenerHolder(condition, priority, listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(DeployerListener listener) {
        List<ListenerHolder> list = this.allListeners_;
        synchronized (list) {
            Iterator<ListenerHolder> iter = this.allListeners_.iterator();
            while (iter.hasNext()) {
                if (iter.next().listener_ != listener) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeListener(DeployerListener listener, ListenerCondition condition) {
        int existing = 0;
        int removed = 0;
        List<ListenerHolder> list = this.allListeners_;
        synchronized (list) {
            Iterator<ListenerHolder> iter = this.allListeners_.iterator();
            while (iter.hasNext()) {
                ListenerHolder holder = iter.next();
                if (holder.condition_ != condition) continue;
                ++existing;
                if (holder.listener_ != listener) continue;
                iter.remove();
                ++removed;
            }
        }
        return existing == removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeployerListener[] getListeners(DeployEvent event) {
        List<ListenerHolder> list = this.allListeners_;
        synchronized (list) {
            ArrayList<ListenerHolder> sortedListeners = new ArrayList<ListenerHolder>();
            for (ListenerHolder holder : this.allListeners_) {
                if (!holder.condition_.shouldFire(event)) continue;
                sortedListeners.add(holder);
            }
            Collections.sort(sortedListeners, new Comparator<ListenerHolder>(){

                @Override
                public int compare(ListenerHolder lhs, ListenerHolder rhs) {
                    return lhs.priority_ > rhs.priority_ ? -1 : (lhs.priority_ == rhs.priority_ ? 0 : 1);
                }
            });
            DeployerListener[] listeners = new DeployerListener[sortedListeners.size()];
            int i = 0;
            for (ListenerHolder holder : sortedListeners) {
                listeners[i++] = holder.listener_;
            }
            return listeners;
        }
    }

    public void fireWillPrepare(DeployEvent event) throws DeployException {
        DeployerListener[] listeners;
        for (DeployerListener listener : listeners = this.getListeners(event)) {
            try {
                listener.willPrepare(event);
            }
            catch (DeployException e) {
                e.setSource(listener);
                throw e;
            }
        }
    }

    public void firePrepared(DeployEvent event) throws DeployException {
        DeployerListener[] listeners = this.getListeners(event);
        for (int i = listeners.length - 1; i >= 0; --i) {
            DeployerListener listener = listeners[i];
            try {
                listener.prepared(event);
                continue;
            }
            catch (DeployException e) {
                e.setSource(listener);
                throw e;
            }
        }
    }

    public void fireWillDeploy(DeployEvent event) throws DeployException {
        DeployerListener[] listeners;
        for (DeployerListener listener : listeners = this.getListeners(event)) {
            try {
                listener.willDeploy(event);
            }
            catch (DeployException e) {
                e.setSource(e);
                throw e;
            }
        }
    }

    public void fireDeployed(DeployEvent event) {
        DeployerListener[] listeners = this.getListeners(event);
        for (int i = listeners.length - 1; i >= 0; --i) {
            DeployerListener listener = listeners[i];
            listener.deployed(event);
        }
    }

    public void fireWillFinish(DeployEvent event) {
        DeployerListener[] listeners;
        for (DeployerListener listener : listeners = this.getListeners(event)) {
            listener.willFinish(event);
        }
    }

    public void fireFinished(DeployEvent event) {
        DeployerListener[] listeners = this.getListeners(event);
        for (int i = listeners.length - 1; i >= 0; --i) {
            DeployerListener listener = listeners[i];
            listener.finished(event);
        }
    }

    public void fireWillCancel(DeployEvent event) {
        DeployerListener[] listeners;
        for (DeployerListener listener : listeners = this.getListeners(event)) {
            listener.willCancel(event);
        }
    }

    public void fireCancelled(DeployEvent event) {
        DeployerListener[] listeners = this.getListeners(event);
        for (int i = listeners.length - 1; i >= 0; --i) {
            DeployerListener listener = listeners[i];
            listener.cancelled(event);
        }
    }

    private static class ListenerHolder {
        final ListenerCondition condition_;
        final double priority_;
        final DeployerListener listener_;

        ListenerHolder(ListenerCondition condition, double priority, DeployerListener listener) {
            this.condition_ = condition;
            this.listener_ = listener;
            this.priority_ = priority;
        }
    }
}

