/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.fwk;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DefaultDeployShellFactory;
import oracle.jdeveloper.deploy.DefaultDeployerListener;
import oracle.jdeveloper.deploy.DeployEvent;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployShellFactory;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeployerFactory;
import oracle.jdeveloper.deploy.DeployerListener;
import oracle.jdeveloper.deploy.DeploymentConstants;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.DeploymentModuleFactory;
import oracle.jdeveloper.deploy.ListenerCondition;
import oracle.jdeveloper.deploy.ModuleDeploymentListener;
import oracle.jdeveloper.deploy.PlatformDeployable;
import oracle.jdeveloper.deploy.common.BatchDeployer;
import oracle.jdeveloper.deploy.common.DynamicDeployer;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformRegistry;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdeveloper.deploy.res.DeployMessages;
import oracle.jdevimpl.deploy.fwk.DeployerFactoryStore;
import oracle.jdevimpl.deploy.fwk.ListenerSupport;
import oracle.jdevimpl.deploy.fwk.ModuleDeploymentListenerAdapter;
import oracle.jdevimpl.deploy.fwk.SuperDeployer;
import oracle.jdevimpl.deploy.fwk.WrappedDeployer;
import oracle.jdevimpl.deploy.res.DtArb;
import oracle.jdevimpl.deploy.res.FwkArb;
import oracle.jdevimpl.deploy.stripe.DeploymentModuleFactoryStore;

public class DeploymentManagerImpl
implements Addin {
    private Map<String, Integer> deploymentSequences = new HashMap<String, Integer>();
    private int lastSequenceId = 0;
    final ListenerSupport listenerSupport_ = new ListenerSupport();
    private Map<Class<?>, Class<? extends ModuleDeploymentListenerAdapter>> listenerAdapterClasses_ = new HashMap();
    Map<ModuleDeploymentListener, ModuleDeploymentListenerAdapter> listenerAdapters_ = new HashMap<ModuleDeploymentListener, ModuleDeploymentListenerAdapter>();
    final DeployerFactoryStore factoryStore_ = new DeployerFactoryStore();
    private final DeploymentModuleFactoryStore deployModuleFactoryStore_ = new DeploymentModuleFactoryStore();
    private final DefaultDeployShellFactory.Configurator shellConfigurator = new ShellConfigurator();

    public void initialize() {
        DeploymentManager.setDeploymentManager(this);
        DefaultDeployShellFactory.getInstance().registerConfigurator(this.shellConfigurator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDeploymentSequenceId(String sequence) {
        Integer number = this.deploymentSequences.get(sequence);
        if (number == null) {
            Map<String, Integer> map = this.deploymentSequences;
            synchronized (map) {
                number = new Integer(++this.lastSequenceId);
                this.deploymentSequences.put(sequence, this.lastSequenceId);
            }
        }
        return number;
    }

    public String getDeploymentSequenceName(int id) {
        String ret = null;
        for (Map.Entry<String, Integer> entry : this.deploymentSequences.entrySet()) {
            if (!entry.getValue().equals(id)) continue;
            ret = entry.getKey();
            break;
        }
        return ret;
    }

    public ListenerSupport getProfileListenerSupport() {
        return this.listenerSupport_;
    }

    public void addDeployerListener(ListenerCondition condition, DeployerListener listener, double priority) {
        this.listenerSupport_.addListener(condition, listener, priority);
    }

    public void removeDeployerListener(DeployerListener listener) {
        this.listenerSupport_.removeListener(listener);
    }

    public boolean removeDeployerListener(ListenerCondition condition, DeployerListener listener) {
        return this.listenerSupport_.removeListener(listener, condition);
    }

    public void registerModuleDeploymentListenerAdapter(Class<?> profileClass, Class<? extends ModuleDeploymentListenerAdapter> adapterClass) {
        this.listenerAdapterClasses_.put(profileClass, adapterClass);
    }

    public void addDeploymentListener(Class<? extends ArchiveProfile> profileClass, PlatformType type, ModuleDeploymentListener<? extends ArchiveProfile> listener, double priority) {
        Class<? extends ModuleDeploymentListenerAdapter> clazz = this.listenerAdapterClasses_.get(profileClass);
        try {
            ModuleDeploymentListenerAdapter adapter = clazz.newInstance();
            adapter.register(profileClass, type, listener, priority);
            this.listenerAdapters_.put(listener, adapter);
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException e) {
            // empty catch block
        }
    }

    public void removeDeploymentListener(ModuleDeploymentListener<? extends ArchiveProfile> listener) {
        ModuleDeploymentListenerAdapter adapter = this.listenerAdapters_.remove(listener);
        adapter.unregister(listener);
    }

    public DeployerFactoryStore getDeployerFactoryStore() {
        return this.factoryStore_;
    }

    public void deploy(int deploySequenceId, Context context) throws Exception {
        DeployShell shell = this.getDefaultDeployShell(deploySequenceId, context);
        this.deploy(deploySequenceId, shell);
    }

    public void deploy(int deploySequence, Context context, DeployShellFactory factory) throws Exception {
        DeployShell shell = this.createDeployShell(deploySequence, context, factory);
        this.deploy(deploySequence, shell);
    }

    public void deploy(int deploySequence, Context context, DeployShellFactory factory, Object lock) throws DeployException {
        DeployShell shell = this.createDeployShell(deploySequence, context, factory);
        this.deploy(deploySequence, shell, lock);
    }

    private DeployShell createDeployShell(int sequence, Context context, DeployShellFactory factory) throws DeployException {
        DeployShell defaultShell = this.getDefaultDeployShell(sequence, context);
        DeployShell shell = factory.create(sequence, context, defaultShell);
        return shell;
    }

    public void deploy(final int deploySequence, final DeployShell shell, Object obj) {
        final Object lock = obj == null ? shell.getContext() : obj;
        Thread t = new Thread("Deployment" + new Random().nextInt()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    try {
                        DeploymentManagerImpl.this.deploy(deploySequence, shell);
                    }
                    catch (Exception e) {
                        DeploymentManagerImpl.this.printUnwrappedExceptionMessage(e, shell.getLogger());
                    }
                    finally {
                        lock.notifyAll();
                    }
                }
            }
        };
        t.start();
    }

    private void printUnwrappedExceptionMessage(Throwable e, Logger logger) {
        Throwable t = e.getCause();
        if (t != null && t != e) {
            if (ModelUtil.hasLength((String)e.getMessage()) && !e.getMessage().equals(t.toString())) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.printUnwrappedExceptionMessage(t, logger);
        } else {
            Object o;
            StringBuffer s = new StringBuffer();
            if (e instanceof DeployException && (o = ((DeployException)e).getSource()) != null) {
                String name = null;
                try {
                    Method getName = o.getClass().getMethod("getName", null);
                    Object ret = getName.invoke(o, null);
                    if (ret != null) {
                        name = ret.toString();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                name = name == null ? o.getClass().getName() : name;
                s.append(" (");
                s.append(name);
                s.append(")");
            }
            logger.log(Level.SEVERE, e.getMessage() + s.toString(), e);
        }
    }

    public void deploy(int deploySequenceId, DeployShell shell) throws Exception {
        DeployShellFactory shellFactory = shell.getDeployShellFactory();
        Profile elementToDeploy = DeployUtil.getProfile(shell);
        if (elementToDeploy == null) {
            Element element = shell.getContext().getElement();
            if (element == null) {
                throw new DeployException("Nothing to deploy");
            }
            elementToDeploy = element;
        }
        Class<?> elementClass = elementToDeploy.getClass();
        Deployer deployer = this.resolveDeployer(deploySequenceId, new DynamicDeployer(deploySequenceId), elementClass, shell);
        if (deploySequenceId != DeploymentConstants.DEFAULT_SEQUENCE) {
            deployer = new WrappedDeployer(DeploymentConstants.DEPLOYMENT_SEQUENCE, deployer);
        }
        int stackLen = shell.getSequenceStack().getLength();
        try {
            deployer.prepare(deploySequenceId, shell);
            shell.put("Deployment.STATUS", (Object)DeployConsoleLogger.DEPLOYMENT_STATUS.PREPARED);
            deployer.deploy(deploySequenceId, shell);
            shell.put("Deployment.STATUS", (Object)DeployConsoleLogger.DEPLOYMENT_STATUS.DEPLOYED);
        }
        catch (DeployException e) {
            shell.setDeployException(e);
            deployer.cancel(deploySequenceId, shell);
            shell.put("Deployment.STATUS", (Object)DeployConsoleLogger.DEPLOYMENT_STATUS.CANCELLED);
            throw e;
        }
        finally {
            deployer.finish(deploySequenceId, shell);
            shell.put("Deployment.STATUS", (Object)DeployConsoleLogger.DEPLOYMENT_STATUS.FINISHED);
        }
    }

    private Deployer resolveDeployer(int deploySequence, Deployer deployer, Class current, DeployShell shell) throws Exception {
        if (deployer == null) {
            this.assertNotNullDeployer(deployer, deploySequence);
        }
        if (deployer instanceof SuperDeployer) {
            Class parent = this.factoryStore_.getParentClass(current);
            if (parent == null) {
                throw new MetadataException(FwkArb.format(4, this.getDeploymentSequenceName(deploySequence)));
            }
            int newSequence = ((SuperDeployer)deployer).getSequenceId();
            deployer = this.factoryStore_.findDeployer(parent, newSequence, shell);
            deployer = this.resolveDeployer(newSequence, deployer, parent, shell);
        } else if (deployer instanceof DynamicDeployer) {
            int newSequence = ((DynamicDeployer)deployer).getSequenceId();
            deployer = this.factoryStore_.findDeployer(current, newSequence, shell);
            deployer = this.resolveDeployer(newSequence, deployer, current, shell);
        } else if (deployer instanceof BatchDeployer) {
            int newSequence = ((BatchDeployer)deployer).getSequenceId();
            deployer = this.resolveBatchDeployer(newSequence, (BatchDeployer)deployer, current, shell);
        }
        if (!deployer.canDeploy(deploySequence)) {
            deployer = new WrappedDeployer(deploySequence, deployer);
        }
        return deployer;
    }

    private Deployer resolveBatchDeployer(int deploySequence, Deployer deployer, Class current, DeployShell shell) throws Exception {
        Deployer[] deployers = ((BatchDeployer)deployer).getDeployers();
        for (int i = 0; i < deployers.length; ++i) {
            if (deployers[i] instanceof SuperDeployer) {
                deployers[i] = this.resolveDeployer(deploySequence, deployers[i], current, shell);
                continue;
            }
            if (deployers[i] instanceof DynamicDeployer) {
                DynamicDeployer dyn = (DynamicDeployer)deployers[i];
                deployers[i] = this.resolveDeployer(dyn.getSequenceId(), dyn, current, shell);
                continue;
            }
            if (!(deployers[i] instanceof BatchDeployer)) continue;
            BatchDeployer batch = (BatchDeployer)deployers[i];
            deployers[i] = this.resolveBatchDeployer(batch.getSequenceId(), (BatchDeployer)deployers[i], current, shell);
        }
        if (!deployer.canDeploy(deploySequence)) {
            deployer = new WrappedDeployer(deploySequence, deployer);
        }
        return deployer;
    }

    private void assertNotNullDeployer(Deployer deployer, int sequenceId) throws MetadataException {
        if (deployer == null) {
            throw new MetadataException(FwkArb.format(5, this.getDeploymentSequenceName(sequenceId)));
        }
    }

    public DeployShell getDefaultDeployShell(int deploySequence, Context context) throws DeployException {
        return DefaultDeployShellFactory.getInstance().create(deploySequence, context, null);
    }

    public void registerDeployerFactory(Class clazz, Class parentClazz, DeployerFactory factory) throws MetadataException {
        this.factoryStore_.addFactory(clazz, parentClazz, factory);
    }

    public void upgradeDeployerFactory(Class clazz, DeployerFactory factory) throws MetadataException {
        this.factoryStore_.upgradeFactory(clazz, factory);
    }

    public void registerDeploymentModuleFactory(Class<?> elementClass, DeploymentModuleFactory factory) throws MetadataException {
        this.deployModuleFactoryStore_.addFactory(elementClass, factory);
    }

    public void upgradeDeploymentModuleFactory(Class<?> elementClass, DeploymentModuleFactory factory) throws MetadataException {
        this.deployModuleFactoryStore_.upgradeFactory(elementClass, factory);
    }

    private class ShellConfigurator
    implements DefaultDeployShellFactory.Configurator {
        private ShellConfigurator() {
        }

        @Override
        public void configure(DeployShell shell) throws DeployException {
            Platform platform;
            if (shell.getDeploymentModuleFactory() == null) {
                shell.setDeploymentModuleFactory(DeploymentManagerImpl.this.deployModuleFactoryStore_);
            }
            if ((platform = shell.getPlatform()) == null) {
                Context context = shell.getContext();
                platform = DeployUtil.getPlatform(context);
                if (platform == null) {
                    Element element = context.getElement();
                    if (element instanceof PlatformDeployable) {
                        platform = ((PlatformDeployable)element).getPlatform();
                        if (platform == null && (platform = PlatformRegistry.getDefaultPlatform()) == null) {
                            throw new DeployException("Could not determine a Platform");
                        }
                        shell.setPlatform(platform);
                    }
                } else {
                    shell.setPlatform(platform);
                }
            }
        }
    }

    public static class DeployConsoleLogger
    extends DefaultDeployerListener
    implements ListenerCondition {
        static final String DEPLOYMENT_STATUS_KEY = "Deployment.STATUS";
        long start_;

        @Override
        public void willPrepare(DeployEvent event) {
            this.start_ = System.currentTimeMillis();
            if (event.getShell().getPrintTimeMessages()) {
                event.getShell().getLog().println(DeployMessages.deploymentStarted());
                this.printTargetPlatform(event.getShell());
            }
        }

        @Override
        public void finished(DeployEvent event) {
            if (event.getShell().getPrintTimeMessages()) {
                if (DEPLOYMENT_STATUS.DEPLOYED.equals(event.getShell().get(DEPLOYMENT_STATUS_KEY))) {
                    long end = System.currentTimeMillis();
                    PrintWriter log = event.getShell().getLog();
                    log.println(DeployMessages.deploymentElapsed(end - this.start_));
                    log.println(DeployMessages.deploymentFinished());
                } else {
                    event.getShell().getLog().println(DeployMessages.deploymentIncomplete());
                }
            }
        }

        @Override
        public void cancelled(DeployEvent event) {
        }

        private void printTargetPlatform(DeployShell dsh) {
            Platform platform = DeployUtil.getPlatform(dsh);
            PrintWriter log = dsh.getLog();
            if (platform != null) {
                log.println(DtArb.format(113, "", platform.getLongLabel()));
                return;
            }
            log.println(DtArb.getString(114));
        }

        @Override
        public boolean shouldFire(DeployEvent event) {
            if (event.getCurrentSequence() == DeploymentConstants.DEPLOYMENT_SEQUENCE) {
                boolean suppress = event.getShell().findFlag("suppressDeploymentStartFinishMessage");
                return !suppress;
            }
            return false;
        }

        static enum DEPLOYMENT_STATUS {
            PREPARED,
            DEPLOYED,
            CANCELLED,
            FINISHED;

        }
    }
}

