/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.explorer;

import java.awt.Component;
import java.net.URL;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.Context;
import oracle.ide.explorer.Explorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.res.DeployArb;
import oracle.jdevimpl.deploy.res.J2eeArb;
import oracle.jdevimpl.deploy.res.JarArb;

public class DeploymentExplorer
extends Explorer
implements Observer {
    private DefaultMutableTreeNode _root;
    private JTree _tree;
    private JScrollPane _scrollPane;
    private Node _profileNode;
    private Object _profileObj;
    private Icon _icon;
    private boolean _observing = false;

    public Component getGUI() {
        if (this._tree == null) {
            this.createTree();
            this._scrollPane = new JScrollPane(this._tree);
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
        return this._scrollPane;
    }

    private void createTree() {
        this.buildTree();
        this._tree = new JTree(new DefaultTreeModel(this._root));
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        this._tree.setRootVisible(false);
        this._tree.setShowsRootHandles(true);
        this._tree.setCellRenderer(new TCR());
        int numRows = this._tree.getRowCount();
        IdeUtil.expandAllTreeRows((JTree)this._tree);
    }

    public Context getContext(EventObject event) {
        Context ctx = this._profileObj instanceof Element ? Context.newIdeContext((Element)((Element)this._profileObj)) : Context.newIdeContext();
        ctx.setView((View)this);
        return ctx;
    }

    public void setContext(Context context) {
        this._profileNode = context.getNode();
        this._profileObj = this._profileNode.getData();
        this._tree = null;
    }

    public void stateChanged(int state) {
        switch (state) {
            case 0: {
                if (this._profileObj == null) break;
                this.updateTree();
                this.startObserving();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.stopObserving();
            }
        }
    }

    public void update(Object observed, UpdateMessage change) {
        int messageID;
        if (this.isObserving() && this._profileNode != null && observed == this._profileNode && (messageID = change.getMessageID()) != UpdateMessage.CHILD_REMOVED && messageID != UpdateMessage.CHILD_ADDED && messageID != UpdateMessage.PROPERTY_SET && messageID != UpdateMessage.OBJECT_RENAMED && messageID != UpdateMessage.CHILD_RENAMED && messageID != UpdateMessage.OBJECT_OPENED && messageID != UpdateMessage.OBJECT_CLOSED && messageID != UpdateMessage.ATTRIBUTE_CHANGED) {
            this.updateTree();
        }
    }

    private void updateTree() {
        if (this._tree != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this._tree.getModel();
            this.buildTree();
            treeModel.setRoot(this._root);
            treeModel.reload();
        }
    }

    private void buildTree() {
        this._root = new DefaultMutableTreeNode(this._profileObj);
        this.buildTreeImpl(this._profileObj);
    }

    void setIcon(Icon icon) {
        this._icon = icon;
    }

    void buildTreeImpl(Object profileObj) {
        if (profileObj instanceof ArchiveProfile) {
            ArchiveProfile archiveProfile = (ArchiveProfile)profileObj;
            this.emitType(JarArb.getString(32));
            this.emitJarOutput(archiveProfile.getJarURL());
            this.setIcon(DeployArb.getIcon(2));
        }
    }

    void addTreeNode(String childLabel) {
        this._root.add(new DefaultMutableTreeNode(childLabel));
    }

    void emitType(String profileType) {
        this.addTreeNode(J2eeArb.format(116, profileType));
    }

    void emitURL(int labelIndex, URL url) {
        this.addTreeNode(J2eeArb.format(labelIndex, URLFileSystem.getPlatformPathName((URL)url)));
    }

    void emitJarOutput(URL jarURL) {
        this.emitURL(117, jarURL);
    }

    private boolean isObserving() {
        return this._observing;
    }

    private void startObserving() {
        if (!this._observing && this._profileNode != null) {
            this._profileNode.attach((Observer)this);
            this._observing = true;
        }
    }

    private void stopObserving() {
        if (this._observing && this._profileNode != null) {
            this._profileNode.detach((Observer)this);
            this._observing = false;
        }
    }

    private class TCR
    extends DefaultTreeCellRenderer {
        private TCR() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode tn = (DefaultMutableTreeNode)value;
                Object o = tn.getUserObject();
                if (o instanceof String) {
                    String cNode = o.toString();
                    this.setText(cNode);
                    this.setToolTipText(cNode);
                    this.setIcon(DeploymentExplorer.this._icon);
                } else {
                    this.setIcon(OracleIcons.getIcon((String)"properties.png"));
                }
            }
            return this;
        }
    }
}

