/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.dt.wizard.panels;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.FinishPanel;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.dt.wizard.spi.DeployCommandSummaryBuilder;
import oracle.jdeveloper.deploy.tk.ToolkitBuildException;
import oracle.jdeveloper.deploy.tk.ToolkitBuilder;
import oracle.jdeveloper.deploy.tk.ToolkitRegistry;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;
import oracle.jdevimpl.deploy.dt.wizard.res.Bundle;

public class DeploySummaryPanel
extends FinishPanel {
    final JLabel summaryLabel_ = new JLabel();
    final JTree summaryTree_ = this.createSummaryTree("");

    public DeploySummaryPanel() {
        ((JPanel)this.getFinishComponent()).add((Component)this.summaryLabel_, "North");
        ResourceUtils.resLabel((JLabel)this.summaryLabel_, (Component)this.summaryTree_, (String)this._s("DEPLOY_SUMMARY_DESCRIPTION"));
        this.summaryTree_.setShowsRootHandles(true);
        DefaultTreeCellRenderer cellRenderer = new DefaultTreeCellRenderer();
        cellRenderer.setOpenIcon(null);
        cellRenderer.setClosedIcon(null);
        cellRenderer.setLeafIcon(null);
        this.summaryTree_.setCellRenderer(cellRenderer);
        this.setHelpID("f1_deploysummary_html");
    }

    public void onEntry(TraversableContext tc) {
        super.onEntry(tc);
        this.createSummary(tc);
        this.expandTree();
    }

    protected void createSummary(TraversableContext tc) {
        DeployCommand dc = (DeployCommand)((Object)tc.get(DeployCommand.class));
        Context ctx = (Context)tc.get(Context.class);
        final ArrayList<TreeNode> summaryNodes = new ArrayList<TreeNode>();
        if (dc != null) {
            if (dc.getStatus() != DeployCommand.Status.READY) {
                summaryNodes.add(this.createIncompleteInformationNode());
            }
            ToolkitContext tkContext = (ToolkitContext)tc.get(ToolkitContext.class);
            assert (tkContext != null);
            ToolkitRegistry tkReg = tkContext.getMainToolkitRegistry();
            try {
                DeployCommandSummaryBuilder[] builders;
                ToolkitBuilder tkBuilder = tkReg.getBuilder(dc, ctx, DeployCommandSummaryBuilder.class);
                for (DeployCommandSummaryBuilder sb : builders = tkBuilder.narrowBuildToolkits(new DeployCommandSummaryBuilder[0])) {
                    summaryNodes.add(sb.buildSummary(dc, tc));
                }
            }
            catch (ToolkitBuildException e) {
                // empty catch block
            }
        }
        if (summaryNodes.size() == 0) {
            summaryNodes.add(this.createNoSummaryNode());
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root"){

            @Override
            public boolean isLeaf() {
                return false;
            }

            @Override
            public int getChildCount() {
                return summaryNodes.size();
            }

            @Override
            public TreeNode getChildAt(int index) {
                return (TreeNode)summaryNodes.get(index);
            }

            @Override
            public int getIndex(TreeNode aChild) {
                return summaryNodes.indexOf(aChild);
            }
        };
        this.summaryTree_.setModel(new DefaultTreeModel(root));
    }

    private TreeNode createNoSummaryNode() {
        return new DefaultMutableTreeNode(this._s("DEPLOY_SUMMARY_NO_SUMMARY_AVAILABLE_ERROR"));
    }

    private TreeNode createIncompleteInformationNode() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(this._s("DEPLOY_SUMMARY_INCOMPLETE_INFO_ERROR"));
        DefaultMutableTreeNode node2 = new DefaultMutableTreeNode(this._s("DEPLOY_SUMMARY_INCOMPLETE_INFO_HINT"));
        node.add(node2);
        return node;
    }

    private String _s(String key) {
        return Bundle.get(key);
    }

    private void expandTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.summaryTree_.getModel().getRoot();
        for (int i = root.getChildCount() - 1; i >= 0; --i) {
            this.summaryTree_.expandRow(i);
        }
    }
}

