/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.prf.ProfileBuilder;
import oracle.jdeveloper.deploy.prf.ProfileRecognizer;
import oracle.jdeveloper.deploy.tk.Toolkit;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdevimpl.deploy.common.AbstractDependentLibraryBuilder;
import oracle.jdevimpl.deploy.common.DependentLibrary;
import oracle.jdevimpl.deploy.common.DependentLibraryList;
import oracle.jdevimpl.deploy.common.LibraryIterator;
import oracle.jdevimpl.deploy.common.LibraryToolkit;

public class ProjectDependentLibraryBuilder
extends AbstractDependentLibraryBuilder {
    public ProjectDependentLibraryBuilder(Class<? extends Toolkit> tkClass, ToolkitContext tkContext) {
        super(tkClass, tkContext);
    }

    private DependentLibrary[] getProjectLibraries(Project project) {
        ArrayList<DependentLibrary> dependentLibraryList = new ArrayList<DependentLibrary>();
        LibraryIterator iter = new LibraryIterator(project);
        while (iter.hasNext()) {
            JLibrary lib = iter.next();
            if (lib == null) continue;
            DependentLibrary dependentLibrary = new DependentLibrary(lib);
            if (DeployUtil.isDirectoryLibrary(lib)) continue;
            dependentLibraryList.add(dependentLibrary);
        }
        return dependentLibraryList.toArray(new DependentLibrary[0]);
    }

    @Override
    protected LibraryToolkit buildImpl() {
        DependencyConfiguration dependencyConfiguration;
        List dependencies;
        DependentLibraryList toolkit = new DependentLibraryList(this.getElement());
        Project project = (Project)this.getIdeContext().getElement();
        Boolean traverseDependencies = (Boolean)this.getIdeContext().getProperty("traverseDependencies");
        toolkit.add(this.getProjectLibraries(project));
        if (traverseDependencies.booleanValue() && (dependencies = (dependencyConfiguration = DependencyConfiguration.getInstance((Project)project)).getDependencyList()) != null) {
            Dependable[] _depsArray;
            for (Dependable dependable : _depsArray = dependencies.toArray(new Dependable[dependencies.size()])) {
                if (dependable.getSource() instanceof Project) {
                    Profile[] profiles;
                    if (this.isProcessCancelled()) {
                        return toolkit;
                    }
                    Context context = new Context();
                    context.setElement(dependable.getSource());
                    ProfileRecognizer recognizer = ProfileRecognizer.getProfileRecognizer();
                    ProfileBuilder profileBuilder = recognizer.createBuilder(context);
                    for (Profile profile : profiles = profileBuilder.buildNarrowProfiles()) {
                        Context profileContext = new Context();
                        profileContext.setElement((Element)profile);
                        profileContext.setBoolean("ReportProfileAsLibrary", Boolean.FALSE.booleanValue());
                        LibraryToolkit[] toolkits = this.buildLibraryToolkits(profileContext);
                        toolkit.add(toolkits);
                    }
                    continue;
                }
                Context depContext = new Context();
                depContext.setElement(dependable.getSource());
                LibraryToolkit[] toolkits = this.buildLibraryToolkits(depContext);
                if (toolkits == null) continue;
                toolkit.add(toolkits);
            }
        }
        return toolkit;
    }
}

