/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.net.URL;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.model.ApplicationContent;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.deploy.CdaPacket;

public class ProjectCdaPackets {
    private final URLPath _path = new URLPath();

    public ProjectCdaPackets(DataContainer container) {
        if (container instanceof Project && container != null) {
            Project project = (Project)container;
            this._path.add(PathsConfiguration.getInstance((Project)project).getProjectSourcePath());
            this._path.add(PathsConfiguration.getInstance((Project)project).getRunClassPath());
            this._path.add(J2eeSettings.getInstance(project).getHtmlRootDirectory());
        } else if (container instanceof Workspace && container != null) {
            Workspace workspace = (Workspace)container;
            this._path.add(ApplicationContent.getInstance((Workspace)workspace).getSourceURL());
        }
    }

    public CdaPacket createCdaPacket(URL url) {
        String entryName = this._path.toRelativePath(url);
        if (entryName == null && (entryName = JarUtil.getJarEntry((URL)url)) == null) {
            char firstChar;
            entryName = url.getPath();
            if (entryName.startsWith("/")) {
                entryName = entryName.substring(1);
            }
            if (entryName.charAt(1) == ':' && entryName.charAt(2) == '/' && ((firstChar = entryName.charAt(0)) >= 'a' && firstChar <= 'z' || firstChar >= 'A' && firstChar <= 'Z')) {
                entryName = entryName.substring(3);
            }
        }
        return URLFileSystem.exists((URL)url) ? new CdaPacket(entryName, url) : new CdaPacket(entryName, null);
    }
}

